/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.mainpanel;

import java.util.Collection;
import java.util.HashMap;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.extension.ExtensionService;
import org.jd.gui.spi.PanelFactory;

public class PanelFactoryService {
    protected static final PanelFactoryService PANEL_FACTORY_SERVICE = new PanelFactoryService();
    protected HashMap<String, PanelFactory> mapProviders = new HashMap();

    public static PanelFactoryService getInstance() {
        return PANEL_FACTORY_SERVICE;
    }

    protected PanelFactoryService() {
        Collection<PanelFactory> providers = ExtensionService.getInstance().load(PanelFactory.class);
        for (PanelFactory provider : providers) {
            for (String type : provider.getTypes()) {
                this.mapProviders.put(type, provider);
            }
        }
    }

    public PanelFactory get(Container container) {
        PanelFactory factory = this.mapProviders.get(container.getType());
        return factory != null ? factory : this.mapProviders.get("default");
    }
}

