/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.preferencespanel;

import java.awt.Color;
import java.awt.GridLayout;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jd.gui.service.platform.PlatformService;
import org.jd.gui.spi.PreferencesPanel;

public class UISingleInstancePreferencesProvider
extends JPanel
implements PreferencesPanel {
    protected static final String SINGLE_INSTANCE = "UIMainWindowPreferencesProvider.singleInstance";
    protected JCheckBox singleInstanceTabsCheckBox = new JCheckBox("Single instance");

    public UISingleInstancePreferencesProvider() {
        super(new GridLayout(0, 1));
        this.add(this.singleInstanceTabsCheckBox);
    }

    @Override
    public String getPreferencesGroupTitle() {
        return "User Interface";
    }

    @Override
    public String getPreferencesPanelTitle() {
        return "Main window";
    }

    @Override
    public JComponent getPanel() {
        return this;
    }

    @Override
    public void init(Color errorBackgroundColor) {
    }

    @Override
    public boolean isActivated() {
        return !PlatformService.getInstance().isMac();
    }

    @Override
    public void loadPreferences(Map<String, String> preferences) {
        this.singleInstanceTabsCheckBox.setSelected("true".equals(preferences.get(SINGLE_INSTANCE)));
    }

    @Override
    public void savePreferences(Map<String, String> preferences) {
        preferences.put(SINGLE_INSTANCE, Boolean.toString(this.singleInstanceTabsCheckBox.isSelected()));
    }

    @Override
    public boolean arePreferencesValid() {
        return true;
    }

    @Override
    public void addPreferencesChangeListener(PreferencesPanel.PreferencesPanelChangeListener listener) {
    }
}

