/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.DirectoryTreeNodeFactoryProvider;
import org.jd.gui.spi.TreeNodeFactory;
import org.jd.gui.view.data.TreeNodeBean;

public class ZipFileTreeNodeFactoryProvider
extends DirectoryTreeNodeFactoryProvider {
    protected static final ImageIcon ICON = new ImageIcon(ZipFileTreeNodeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/zip_obj.png"));

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.zip", "*:file:*.aar");
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf("/");
        String label = entry.getPath().substring(lastSlashIndex + 1);
        String location = new File(entry.getUri()).getPath();
        TreeNode node = new TreeNode(entry, new TreeNodeBean(label, "Location: " + location, (Icon)ICON));
        node.add(new DefaultMutableTreeNode());
        return (T)node;
    }

    protected static class TreeNode
    extends DirectoryTreeNodeFactoryProvider.TreeNode {
        public TreeNode(Container.Entry entry, Object userObject) {
            super(entry, userObject);
        }

        @Override
        public void populateTreeNode(API api) {
            if (!this.initialized) {
                this.removeAllChildren();
                for (Container.Entry e : this.getChildren()) {
                    TreeNodeFactory factory = api.getTreeNodeFactory(e);
                    if (factory == null) continue;
                    this.add((MutableTreeNode)factory.make(api, e));
                }
                this.initialized = true;
            }
        }
    }
}

