/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.xml;

import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jd.gui.util.exception.ExceptionUtil;

public abstract class AbstractXmlPathFinder {
    protected HashMap<String, HashSet<String>> tagNameToPaths = new HashMap();
    protected StringBuilder sb = new StringBuilder(200);

    public AbstractXmlPathFinder(Collection<String> paths) {
        for (String path : paths) {
            int lastIndex;
            if (path == null || path.length() <= 0) continue;
            path = '/' + path;
            String lastTagName = path.substring((lastIndex = path.lastIndexOf(47)) + 1);
            HashSet<String> setOfPaths = this.tagNameToPaths.get(lastTagName);
            if (setOfPaths == null) {
                setOfPaths = new HashSet();
                this.tagNameToPaths.put(lastTagName, setOfPaths);
            }
            setOfPaths.add(path);
        }
    }

    public void find(String text) {
        block9: {
            this.sb.setLength(0);
            try {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(text));
                String tagName = "";
                int offset = 0;
                while (reader.hasNext()) {
                    reader.next();
                    switch (reader.getEventType()) {
                        case 1: {
                            tagName = reader.getLocalName();
                            this.sb.append('/').append(tagName);
                            offset = reader.getLocation().getCharacterOffset();
                            break;
                        }
                        case 2: {
                            this.sb.setLength(this.sb.length() - reader.getLocalName().length() - 1);
                            break;
                        }
                        case 4: {
                            String path;
                            HashSet<String> setOfPaths = this.tagNameToPaths.get(tagName);
                            if (setOfPaths == null || !setOfPaths.contains(path = this.sb.toString())) break;
                            while (offset > 0 && text.charAt(offset) != '>') {
                                --offset;
                            }
                            this.handle(path.substring(1), reader.getText(), offset + 1);
                        }
                    }
                }
            }
            catch (XMLStreamException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block9;
                throw new AssertionError();
            }
        }
    }

    public abstract void handle(String var1, String var2, int var3);
}

