/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.area;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jxls.area.Area;
import org.jxls.area.CommandData;
import org.jxls.command.Command;
import org.jxls.common.AreaListener;
import org.jxls.common.AreaRef;
import org.jxls.common.CellData;
import org.jxls.common.CellRange;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.Size;
import org.jxls.common.cellshift.AdjacentCellShiftStrategy;
import org.jxls.common.cellshift.CellShiftStrategy;
import org.jxls.common.cellshift.InnerCellShiftStrategy;
import org.jxls.formula.FormulaProcessor;
import org.jxls.formula.StandardFormulaProcessor;
import org.jxls.transform.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsArea
implements Area {
    private static Logger logger = LoggerFactory.getLogger(XlsArea.class);
    public static final XlsArea EMPTY_AREA = new XlsArea(new CellRef(null, 0, 0), Size.ZERO_SIZE);
    private List<CommandData> commandDataList = new ArrayList<CommandData>();
    private Transformer transformer;
    Command parentCommand;
    private CellRange cellRange;
    private CellRef startCellRef;
    private Size size;
    private List<AreaListener> areaListeners = new ArrayList<AreaListener>();
    private boolean cellsCleared = false;
    private FormulaProcessor formulaProcessor = new StandardFormulaProcessor();
    private CellShiftStrategy cellShiftStrategy = new InnerCellShiftStrategy();
    private final CellShiftStrategy innerCellShiftStrategy = new InnerCellShiftStrategy();
    private final CellShiftStrategy adjacentCellShiftStrategy = new AdjacentCellShiftStrategy();

    public XlsArea(AreaRef areaRef, Transformer transformer) {
        CellRef startCell = areaRef.getFirstCellRef();
        CellRef endCell = areaRef.getLastCellRef();
        this.startCellRef = startCell;
        this.size = new Size(endCell.getCol() - startCell.getCol() + 1, endCell.getRow() - startCell.getRow() + 1);
        this.transformer = transformer;
    }

    public XlsArea(String areaRef, Transformer transformer) {
        this(new AreaRef(areaRef), transformer);
    }

    public XlsArea(CellRef startCell, CellRef endCell, Transformer transformer) {
        this(new AreaRef(startCell, endCell), transformer);
    }

    public XlsArea(CellRef startCellRef, Size size, List<CommandData> commandDataList, Transformer transformer) {
        this.startCellRef = startCellRef;
        this.size = size;
        this.commandDataList = commandDataList != null ? commandDataList : new ArrayList();
        this.transformer = transformer;
    }

    public XlsArea(CellRef startCellRef, Size size) {
        this(startCellRef, size, null, null);
    }

    public XlsArea(CellRef startCellRef, Size size, Transformer transformer) {
        this(startCellRef, size, null, transformer);
    }

    @Override
    public Command getParentCommand() {
        return this.parentCommand;
    }

    @Override
    public void setParentCommand(Command command) {
        this.parentCommand = command;
    }

    @Override
    public CellShiftStrategy getCellShiftStrategy() {
        return this.cellShiftStrategy;
    }

    @Override
    public void setCellShiftStrategy(CellShiftStrategy cellShiftStrategy) {
        this.cellShiftStrategy = cellShiftStrategy;
    }

    @Override
    public FormulaProcessor getFormulaProcessor() {
        return this.formulaProcessor;
    }

    @Override
    public void setFormulaProcessor(FormulaProcessor formulaProcessor) {
        this.formulaProcessor = formulaProcessor;
    }

    @Override
    public void addCommand(AreaRef areaRef, Command command) {
        AreaRef thisAreaRef = new AreaRef(this.startCellRef, this.size);
        if (!thisAreaRef.contains(areaRef)) {
            throw new IllegalArgumentException("Cannot add command '" + command.getName() + "' to area " + thisAreaRef + " at " + areaRef);
        }
        this.commandDataList.add(new CommandData(areaRef, command));
    }

    public void addCommand(String areaRef, Command command) {
        this.commandDataList.add(new CommandData(areaRef, command));
    }

    @Override
    public List<CommandData> getCommandDataList() {
        return this.commandDataList;
    }

    @Override
    public Transformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    private void createCellRange() {
        this.cellRange = new CellRange(this.startCellRef, this.size.getWidth(), this.size.getHeight());
        for (CommandData commandData : this.commandDataList) {
            CellRef startCellRef = commandData.getSourceStartCellRef();
            Size size = commandData.getSourceSize();
            this.cellRange.excludeCells(startCellRef.getCol() - this.startCellRef.getCol(), startCellRef.getCol() - this.startCellRef.getCol() + size.getWidth() - 1, startCellRef.getRow() - this.startCellRef.getRow(), startCellRef.getRow() - this.startCellRef.getRow() + size.getHeight() - 1);
        }
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        if (this == EMPTY_AREA) {
            return Size.ZERO_SIZE;
        }
        logger.debug("Applying XlsArea at {}", (Object)cellRef);
        this.fireBeforeApplyEvent(cellRef, context);
        this.createCellRange();
        int topStaticAreaLastRow = this.transformTopStaticArea(cellRef, context);
        for (int i = 0; i < this.commandDataList.size(); ++i) {
            int initialEndCol;
            int initialStartCol;
            int initialEndRow;
            int initialStartRow;
            Size initialSize;
            CellRef initialStartCellRef;
            CellRef commandDataStartCellRef;
            Set<CommandData> commandsToShift;
            this.cellRange.resetChangeMatrix();
            CommandData commandData = this.commandDataList.get(i);
            String shiftMode = commandData.getCommand().getShiftMode();
            CellShiftStrategy commandCellShiftStrategy = this.detectCellShiftStrategy(shiftMode);
            this.cellRange.setCellShiftStrategy(commandCellShiftStrategy);
            CellRef commandStartCellRef = commandData.getStartCellRef();
            Size commandInitialSize = commandData.getSize();
            int startCol = commandStartCellRef.getCol() - this.startCellRef.getCol();
            int startRow = commandStartCellRef.getRow() - this.startCellRef.getRow();
            CellRef newCell = new CellRef(cellRef.getSheetName(), startRow + cellRef.getRow(), startCol + cellRef.getCol());
            Size commandNewSize = commandData.getCommand().applyAt(newCell, context);
            int widthChange = commandNewSize.getWidth() - commandInitialSize.getWidth();
            int heightChange = commandNewSize.getHeight() - commandInitialSize.getHeight();
            int endCol = startCol + commandInitialSize.getWidth() - 1;
            int endRow = startRow + commandInitialSize.getHeight() - 1;
            if (heightChange != 0) {
                this.cellRange.shiftCellsWithColBlock(startCol, endCol, endRow, heightChange, true);
                commandsToShift = this.findCommandsForVerticalShift(this.commandDataList.subList(i + 1, this.commandDataList.size()), startCol, endCol, endRow, heightChange);
                for (CommandData commandDataToShift : commandsToShift) {
                    commandDataStartCellRef = commandDataToShift.getStartCellRef();
                    int relativeRow = commandDataStartCellRef.getRow() - this.startCellRef.getRow();
                    int relativeStartCol = commandDataStartCellRef.getCol() - this.startCellRef.getCol();
                    int relativeEndCol = relativeStartCol + commandDataToShift.getSize().getWidth() - 1;
                    this.cellRange.shiftCellsWithColBlock(relativeStartCol, relativeEndCol, relativeRow + commandDataToShift.getSize().getHeight() - 1, heightChange, false);
                    commandDataToShift.setStartCellRef(new CellRef(commandStartCellRef.getSheetName(), commandDataStartCellRef.getRow() + heightChange, commandDataStartCellRef.getCol()));
                    if (heightChange >= 0) continue;
                    initialStartCellRef = commandDataToShift.getSourceStartCellRef();
                    initialSize = commandDataToShift.getSourceSize();
                    initialStartRow = initialStartCellRef.getRow() - this.startCellRef.getRow();
                    initialEndRow = initialStartRow + initialSize.getHeight() - 1;
                    initialStartCol = initialStartCellRef.getCol() - this.startCellRef.getCol();
                    initialEndCol = initialStartCol + initialSize.getWidth() - 1;
                    this.cellRange.clearCells(initialStartCol, initialEndCol, initialStartRow, initialEndRow);
                }
            }
            if (widthChange == 0) continue;
            this.cellRange.shiftCellsWithRowBlock(startRow, endRow, endCol, widthChange, true);
            commandsToShift = this.findCommandsForHorizontalShift(this.commandDataList.subList(i + 1, this.commandDataList.size()), startRow, endRow, endCol, widthChange);
            for (CommandData commandDataToShift : commandsToShift) {
                commandDataStartCellRef = commandDataToShift.getStartCellRef();
                int relativeCol = commandDataStartCellRef.getCol() - this.startCellRef.getCol();
                int relativeStartRow = commandDataStartCellRef.getRow() - this.startCellRef.getRow();
                int relativeEndRow = relativeStartRow + commandDataToShift.getSize().getHeight() - 1;
                this.cellRange.shiftCellsWithRowBlock(relativeStartRow, relativeEndRow, relativeCol + commandDataToShift.getSize().getWidth() - 1, widthChange, false);
                commandDataToShift.setStartCellRef(new CellRef(commandStartCellRef.getSheetName(), commandDataStartCellRef.getRow(), commandDataStartCellRef.getCol() + widthChange));
                if (widthChange >= 0) continue;
                initialStartCellRef = commandDataToShift.getSourceStartCellRef();
                initialSize = commandDataToShift.getSourceSize();
                initialStartRow = initialStartCellRef.getRow() - this.startCellRef.getRow();
                initialEndRow = initialStartRow + initialSize.getHeight() - 1;
                initialStartCol = initialStartCellRef.getCol() - this.startCellRef.getCol();
                initialEndCol = initialStartCellRef.getCol() + initialSize.getWidth() - 1;
                this.cellRange.clearCells(initialStartCol, initialEndCol, initialStartRow, initialEndRow);
            }
        }
        this.transformStaticCells(cellRef, context, topStaticAreaLastRow + 1);
        this.fireAfterApplyEvent(cellRef, context);
        Size finalSize = new Size(this.cellRange.calculateWidth(), this.cellRange.calculateHeight());
        AreaRef newAreaRef = new AreaRef(cellRef, finalSize);
        this.updateCellDataFinalAreaForFormulaCells(newAreaRef);
        for (CommandData commandData : this.commandDataList) {
            commandData.resetStartCellAndSize();
        }
        return finalSize;
    }

    private Set<CommandData> findCommandsForHorizontalShift(List<CommandData> commandList, int startRow, int endRow, int shiftingCol, int widthChange) {
        LinkedHashSet<CommandData> result = new LinkedHashSet<CommandData>(commandList.size());
        int commandListSize = commandList.size();
        for (int i = 0; i < commandListSize; ++i) {
            CommandData commandData = commandList.get(i);
            if (result.contains(commandData)) continue;
            CellRef commandDataStartCellRef = commandData.getStartCellRef();
            int relativeCol = commandDataStartCellRef.getCol() - this.startCellRef.getCol();
            int relativeStartRow = commandDataStartCellRef.getRow() - this.startCellRef.getRow();
            int relativeEndRow = relativeStartRow + commandData.getSize().getHeight() - 1;
            if (relativeCol <= shiftingCol) continue;
            boolean isShiftingNeeded = false;
            if (widthChange > 0) {
                if (relativeStartRow >= startRow && relativeStartRow <= endRow || relativeEndRow >= startRow && relativeEndRow <= endRow || startRow >= relativeStartRow && startRow <= relativeEndRow) {
                    isShiftingNeeded = true;
                }
            } else if (relativeStartRow >= startRow && relativeEndRow <= endRow && this.isNoHighCommandsInArea(commandList, shiftingCol + 1, relativeCol - 1, startRow, endRow)) {
                isShiftingNeeded = true;
            }
            if (!isShiftingNeeded) continue;
            result.add(commandData);
            Set<CommandData> dependentCommands = this.findCommandsForHorizontalShift(commandList.subList(i + 1, commandList.size()), relativeStartRow, relativeEndRow, relativeCol + commandData.getSize().getWidth() - 1, widthChange);
            result.addAll(dependentCommands);
        }
        return result;
    }

    private boolean isNoHighCommandsInArea(List<CommandData> commandList, int startCol, int endCol, int startRow, int endRow) {
        for (CommandData commandData : commandList) {
            CellRef commandDataStartCellRef = commandData.getStartCellRef();
            int relativeCol = commandDataStartCellRef.getCol() - this.startCellRef.getCol();
            int relativeEndCol = relativeCol + commandData.getSize().getWidth() - 1;
            int relativeStartRow = commandDataStartCellRef.getRow() - this.startCellRef.getRow();
            int relativeEndRow = relativeStartRow + commandData.getSize().getHeight() - 1;
            if (relativeCol < startCol || relativeEndCol > endCol || (relativeStartRow >= startRow || relativeEndRow < startRow) && (relativeEndRow <= endRow || relativeStartRow > endRow)) continue;
            return false;
        }
        return true;
    }

    private Set<CommandData> findCommandsForVerticalShift(List<CommandData> commandList, int startCol, int endCol, int shiftingRow, int heightChange) {
        LinkedHashSet<CommandData> result = new LinkedHashSet<CommandData>(commandList.size());
        int commandListSize = commandList.size();
        for (int i = 0; i < commandListSize; ++i) {
            CommandData commandData = commandList.get(i);
            if (result.contains(commandData)) continue;
            CellRef commandDataStartCellRef = commandData.getStartCellRef();
            int relativeRow = commandDataStartCellRef.getRow() - this.startCellRef.getRow();
            int relativeStartCol = commandDataStartCellRef.getCol() - this.startCellRef.getCol();
            int relativeEndCol = relativeStartCol + commandData.getSize().getWidth() - 1;
            if (relativeRow <= shiftingRow) continue;
            boolean isShiftingNeeded = false;
            if (heightChange > 0) {
                if (relativeStartCol >= startCol && relativeStartCol <= endCol || relativeEndCol >= startCol && relativeEndCol <= endCol || startCol >= relativeStartCol && startCol <= relativeEndCol) {
                    isShiftingNeeded = true;
                }
            } else if (relativeStartCol >= startCol && relativeEndCol <= endCol && this.isNoWideCommandsInArea(commandList, startCol, endCol, shiftingRow + 1, relativeRow - 1)) {
                isShiftingNeeded = true;
            }
            if (!isShiftingNeeded) continue;
            result.add(commandData);
            Set<CommandData> dependentCommands = this.findCommandsForVerticalShift(commandList.subList(i + 1, commandListSize), relativeStartCol, relativeEndCol, relativeRow + commandData.getSize().getHeight() - 1, heightChange);
            result.addAll(dependentCommands);
        }
        return result;
    }

    private boolean isNoWideCommandsInArea(List<CommandData> commandList, int startCol, int endCol, int startRow, int endRow) {
        for (CommandData commandData : commandList) {
            CellRef commandDataStartCellRef = commandData.getStartCellRef();
            int relativeRow = commandDataStartCellRef.getRow() - this.startCellRef.getRow();
            int relativeEndRow = relativeRow + commandData.getSize().getHeight() - 1;
            int relativeStartCol = commandDataStartCellRef.getCol() - this.startCellRef.getCol();
            int relativeEndCol = relativeStartCol + commandData.getSize().getWidth() - 1;
            if (relativeRow < startRow || relativeEndRow > endRow || (relativeStartCol >= startCol || relativeEndCol < startCol) && (relativeEndCol <= endCol || relativeStartCol > endCol)) continue;
            return false;
        }
        return true;
    }

    private CellShiftStrategy detectCellShiftStrategy(String shiftMode) {
        if (shiftMode != null && "adjacent".equalsIgnoreCase(shiftMode)) {
            return this.adjacentCellShiftStrategy;
        }
        return this.innerCellShiftStrategy;
    }

    private void updateCellDataFinalAreaForFormulaCells(AreaRef newAreaRef) {
        String sheetName = this.startCellRef.getSheetName();
        int offsetRow = this.startCellRef.getRow();
        int startCol = this.startCellRef.getCol();
        for (int col = 0; col < this.size.getWidth(); ++col) {
            for (int row = 0; row < this.size.getHeight(); ++row) {
                CellRef srcCell;
                CellData cellData;
                if (this.cellRange.isExcluded(row, col) || (cellData = this.transformer.getCellData(srcCell = new CellRef(sheetName, offsetRow + row, startCol + col))) == null || !cellData.isFormulaCell()) continue;
                cellData.addTargetParentAreaRef(newAreaRef);
            }
        }
    }

    private int transformTopStaticArea(CellRef cellRef, Context context) {
        String sheetName = this.startCellRef.getSheetName();
        int startRow = this.startCellRef.getRow();
        int startCol = this.startCellRef.getCol();
        int topStaticAreaLastRow = this.findRelativeTopCommandRow() - 1;
        for (int col = 0; col < this.size.getWidth(); ++col) {
            for (int row = 0; row <= topStaticAreaLastRow; ++row) {
                if (this.cellRange.isExcluded(row, col)) continue;
                CellRef relativeCell = this.cellRange.getCell(row, col);
                CellRef srcCell = new CellRef(sheetName, startRow + row, startCol + col);
                CellRef targetCell = new CellRef(cellRef.getSheetName(), relativeCell.getRow() + cellRef.getRow(), relativeCell.getCol() + cellRef.getCol());
                this.fireBeforeTransformCell(srcCell, targetCell, context);
                try {
                    this.updateCellDataArea(srcCell, targetCell, context);
                    boolean updateRowHeight = this.parentCommand != null;
                    this.transformer.transform(srcCell, targetCell, context, updateRowHeight);
                }
                catch (Exception e) {
                    logger.error("Failed to transform " + srcCell + " into " + targetCell, (Throwable)e);
                }
                this.fireAfterTransformCell(srcCell, targetCell, context);
            }
        }
        if (this.parentCommand == null) {
            this.updateRowHeights(cellRef, 0, topStaticAreaLastRow);
        }
        return topStaticAreaLastRow;
    }

    private void updateRowHeights(CellRef areaStartCellRef, int relativeStartRow, int relativeEndRow) {
        if (this.transformer == null) {
            return;
        }
        for (int relativeSrcRow = relativeStartRow; relativeSrcRow <= relativeEndRow; ++relativeSrcRow) {
            if (this.cellRange.containsCommandsInRow(relativeSrcRow)) continue;
            int relativeTargetRow = this.cellRange.findTargetRow(relativeSrcRow);
            int targetRow = areaStartCellRef.getRow() + relativeTargetRow;
            int srcRow = areaStartCellRef.getRow() + relativeSrcRow;
            try {
                this.transformer.updateRowHeight(this.startCellRef.getSheetName(), srcRow, areaStartCellRef.getSheetName(), targetRow);
                continue;
            }
            catch (Exception e) {
                logger.error("Failed to update row height for src row={} and target row={} ", new Object[]{relativeSrcRow, targetRow, e});
            }
        }
    }

    private int findRelativeTopCommandRow() {
        int topCommandRow = this.startCellRef.getRow() + this.size.getHeight();
        for (CommandData data : this.commandDataList) {
            topCommandRow = Math.min(data.getStartCellRef().getRow(), topCommandRow);
        }
        return topCommandRow - this.startCellRef.getRow();
    }

    private void fireBeforeApplyEvent(CellRef cellRef, Context context) {
        for (AreaListener areaListener : this.areaListeners) {
            areaListener.beforeApplyAtCell(cellRef, context);
        }
    }

    private void fireAfterApplyEvent(CellRef cellRef, Context context) {
        for (AreaListener areaListener : this.areaListeners) {
            areaListener.afterApplyAtCell(cellRef, context);
        }
    }

    public void clearCells() {
        if (this.cellsCleared) {
            return;
        }
        String sheetName = this.startCellRef.getSheetName();
        int startRow = this.startCellRef.getRow();
        int startCol = this.startCellRef.getCol();
        for (int row = 0; row < this.size.getHeight(); ++row) {
            for (int col = 0; col < this.size.getWidth(); ++col) {
                CellRef cellRef = new CellRef(sheetName, startRow + row, startCol + col);
                this.transformer.clearCell(cellRef);
            }
        }
        this.transformer.resetArea(this.getAreaRef());
        this.cellsCleared = true;
    }

    private void transformStaticCells(CellRef cellRef, Context context, int relativeStartRow) {
        String sheetName = this.startCellRef.getSheetName();
        int offsetRow = this.startCellRef.getRow();
        int startCol = this.startCellRef.getCol();
        int width = this.size.getWidth();
        int height = this.size.getHeight();
        for (int col = 0; col < width; ++col) {
            for (int row = relativeStartRow; row < height; ++row) {
                if (this.cellRange.isExcluded(row, col)) continue;
                CellRef relativeCell = this.cellRange.getCell(row, col);
                CellRef srcCell = new CellRef(sheetName, offsetRow + row, startCol + col);
                CellRef targetCell = new CellRef(cellRef.getSheetName(), relativeCell.getRow() + cellRef.getRow(), relativeCell.getCol() + cellRef.getCol());
                this.fireBeforeTransformCell(srcCell, targetCell, context);
                try {
                    this.updateCellDataArea(srcCell, targetCell, context);
                    boolean updateRowHeight = this.parentCommand != null;
                    this.transformer.transform(srcCell, targetCell, context, updateRowHeight);
                }
                catch (Exception e) {
                    logger.error("Failed to transform " + srcCell + " into " + targetCell, (Throwable)e);
                }
                this.fireAfterTransformCell(srcCell, targetCell, context);
            }
        }
        if (this.parentCommand == null) {
            this.updateRowHeights(cellRef, relativeStartRow, height - 1);
        }
    }

    private void updateCellDataArea(CellRef srcCell, CellRef targetCell, Context context) {
        Context.Config config = context.getConfig();
        if (!config.isFormulaProcessingRequired()) {
            return;
        }
        CellData cellData = this.transformer.getCellData(srcCell);
        if (cellData != null) {
            cellData.setArea(this);
            cellData.addTargetPos(targetCell);
        }
    }

    private void fireBeforeTransformCell(CellRef srcCell, CellRef targetCell, Context context) {
        for (AreaListener areaListener : this.areaListeners) {
            areaListener.beforeTransformCell(srcCell, targetCell, context);
        }
    }

    private void fireAfterTransformCell(CellRef srcCell, CellRef targetCell, Context context) {
        for (AreaListener areaListener : this.areaListeners) {
            areaListener.afterTransformCell(srcCell, targetCell, context);
        }
    }

    @Override
    public CellRef getStartCellRef() {
        return this.startCellRef;
    }

    @Override
    public Size getSize() {
        return this.size;
    }

    @Override
    public AreaRef getAreaRef() {
        return new AreaRef(this.startCellRef, this.size);
    }

    @Override
    public void processFormulas() {
        this.formulaProcessor.processAreaFormulas(this.transformer, this);
    }

    @Override
    public void addAreaListener(AreaListener listener) {
        this.areaListeners.add(listener);
    }

    @Override
    public List<AreaListener> getAreaListeners() {
        return this.areaListeners;
    }

    @Override
    public List<Command> findCommandByName(String name) {
        ArrayList<Command> commands = new ArrayList<Command>();
        for (CommandData commandData : this.commandDataList) {
            if (name == null || !name.equals(commandData.getCommand().getName())) continue;
            commands.add(commandData.getCommand());
        }
        return commands;
    }

    @Override
    public void reset() {
        for (CommandData commandData : this.commandDataList) {
            commandData.reset();
        }
        this.transformer.resetTargetCellRefs();
    }
}

