/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jxls.area.Area;
import org.jxls.command.AbstractCommand;
import org.jxls.command.CellRefGenerator;
import org.jxls.command.Command;
import org.jxls.command.SheetNameGenerator;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.common.GroupData;
import org.jxls.common.JxlsException;
import org.jxls.common.Size;
import org.jxls.expression.ExpressionEvaluator;
import org.jxls.util.JxlsHelper;
import org.jxls.util.UtilWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EachCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "each";
    static final String GROUP_DATA_KEY = "_group";
    private String var;
    private String items;
    private String select;
    private Area area;
    private Direction direction = Direction.DOWN;
    private CellRefGenerator cellRefGenerator;
    private String multisheet;
    private String groupBy;
    private String groupOrder;
    private UtilWrapper util = new UtilWrapper();
    private static Logger logger = LoggerFactory.getLogger(EachCommand.class);

    public EachCommand() {
    }

    public EachCommand(String var, String items, Direction direction) {
        this.var = var;
        this.items = items;
        this.direction = direction == null ? Direction.DOWN : direction;
    }

    public EachCommand(String items, Area area) {
        this(null, items, area);
    }

    public EachCommand(String var, String items, Area area) {
        this(var, items, area, Direction.DOWN);
    }

    public EachCommand(String var, String items, Area area, Direction direction) {
        this(var, items, direction);
        if (area != null) {
            this.area = area;
            this.addArea(this.area);
        }
    }

    public EachCommand(String var, String items, Area area, CellRefGenerator cellRefGenerator) {
        this(var, items, area, (Direction)null);
        this.cellRefGenerator = cellRefGenerator;
    }

    UtilWrapper getUtil() {
        return this.util;
    }

    void setUtil(UtilWrapper util) {
        this.util = util;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public void setDirection(String direction) {
        this.direction = Direction.valueOf(direction);
    }

    public CellRefGenerator getCellRefGenerator() {
        return this.cellRefGenerator;
    }

    public void setCellRefGenerator(CellRefGenerator cellRefGenerator) {
        this.cellRefGenerator = cellRefGenerator;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getItems() {
        return this.items;
    }

    public void setItems(String items) {
        this.items = items;
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String getMultisheet() {
        return this.multisheet;
    }

    public void setMultisheet(String multisheet) {
        this.multisheet = multisheet;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getGroupOrder() {
        return this.groupOrder;
    }

    public void setGroupOrder(String groupOrder) {
        this.groupOrder = groupOrder;
    }

    @Override
    public Command addArea(Area area) {
        if (area == null) {
            return this;
        }
        if (this.areaList.size() >= 1) {
            throw new IllegalArgumentException("You can add only a single area to 'each' command");
        }
        this.area = area;
        return super.addArea(area);
    }

    @Override
    public Size applyAt(CellRef cellRef, Context context) {
        List itemsCollection = null;
        try {
            itemsCollection = this.util.transformToIterableObject(this.getTransformationConfig().getExpressionEvaluator(), this.items, context);
        }
        catch (Exception e) {
            logger.warn("Failed to evaluate collection expression {}", (Object)this.items, (Object)e);
            itemsCollection = Collections.emptyList();
        }
        if (this.groupBy == null || this.groupBy.length() == 0) {
            return this.processCollection(context, itemsCollection, cellRef, this.var);
        }
        Collection<GroupData> groupedData = this.util.groupIterable(itemsCollection, this.groupBy, this.groupOrder);
        String groupVar = this.var != null ? this.var : GROUP_DATA_KEY;
        return this.processCollection(context, groupedData, cellRef, groupVar);
    }

    private Size processCollection(Context context, Iterable itemsCollection, CellRef cellRef, String varName) {
        int index = 0;
        int newWidth = 0;
        int newHeight = 0;
        CellRefGenerator cellRefGenerator = this.cellRefGenerator;
        if (cellRefGenerator == null && this.multisheet != null) {
            List<String> sheetNameList = this.extractSheetNameList(context);
            cellRefGenerator = new SheetNameGenerator(sheetNameList, cellRef);
        }
        CellRef currentCell = cellRefGenerator != null ? cellRefGenerator.generateCellRef(index, context) : cellRef;
        ExpressionEvaluator selectEvaluator = null;
        if (this.select != null) {
            selectEvaluator = JxlsHelper.getInstance().createExpressionEvaluator(this.select);
        }
        Object currentVarObject = context.getVar(varName);
        Iterator iterator = itemsCollection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            context.putVar(varName, obj);
            if (selectEvaluator != null && !this.util.isConditionTrue(selectEvaluator, context).booleanValue()) {
                context.removeVar(varName);
                continue;
            }
            Size size = this.area.applyAt(currentCell, context);
            ++index;
            if (cellRefGenerator != null) {
                newWidth = Math.max(newWidth, size.getWidth());
                newHeight = Math.max(newHeight, size.getHeight());
                if (!iterator.hasNext()) continue;
                currentCell = cellRefGenerator.generateCellRef(index, context);
                continue;
            }
            if (this.direction == Direction.DOWN) {
                currentCell = new CellRef(currentCell.getSheetName(), currentCell.getRow() + size.getHeight(), currentCell.getCol());
                newWidth = Math.max(newWidth, size.getWidth());
                newHeight += size.getHeight();
                continue;
            }
            currentCell = new CellRef(currentCell.getSheetName(), currentCell.getRow(), currentCell.getCol() + size.getWidth());
            newWidth += size.getWidth();
            newHeight = Math.max(newHeight, size.getHeight());
        }
        if (currentVarObject != null) {
            context.putVar(varName, currentVarObject);
        } else {
            context.removeVar(varName);
        }
        return new Size(newWidth, newHeight);
    }

    private List<String> extractSheetNameList(Context context) {
        try {
            return (List)context.getVar(this.multisheet);
        }
        catch (Exception e) {
            throw new JxlsException("Failed to get sheet names from " + this.multisheet, e);
        }
    }

    public static enum Direction {
        RIGHT,
        DOWN;

    }
}

