/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.license.LicenseCheckingSnapshotGenerator;
import com.datical.liquibase.ext.util.CachedQueryUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseServiceUtils;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.util.StringUtil;

public class SynonymSnapshotGenerator
extends LicenseCheckingSnapshotGenerator {
    public static final String ACTUAL_OBJECT_CATALOG_NAME = "_actualObjectCatalogName";
    private final Pattern MSSQL_NAME_AND_SCHEMA_PATTERN = Pattern.compile("\\[(.*)\\]\\.\\[(.*)\\]");
    private final Pattern MSSQL_NAME_ONLY_PATTERN = Pattern.compile("\\[([^\\[\\]]*)\\]");
    private Set<String> oracleSystemSchemas = new HashSet<String>(Arrays.asList("APPQOSSYS", "BI", "CTXSYS", "DBMS_PRIVILEGE_CAPTURE", "DBSNMP", "DIP", "DMSYS", "DVSYS", "EXFSYS", "FLOWS_FILES", "LBACSYS", "MDDATA", "MDSYS", "MGMT_VIEW", "ODM", "ODM_MTR", "OLAPSYS", "ORACLE_OCM", "ORDDATA", "ORDSYS", "OUTLN", "SYS", "SYSMAN", "SYSTEM", "WMSYS", "XDB"));

    public SynonymSnapshotGenerator() {
        super(Synonym.class, new Class[]{Schema.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (!LicenseServiceUtils.checkForValidLicense("Liquibase Pro")) {
            return -1;
        }
        if (database instanceof OracleDatabase || database instanceof AbstractDb2Database || database instanceof MSSQLDatabase) {
            return super.getPriority(clazz, database);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addTo(DatabaseObject databaseObject, DatabaseSnapshot object) {
        if (databaseObject instanceof Schema) {
            void var5_13;
            String string;
            Database database = ((DatabaseSnapshot)((Object)object)).getDatabase();
            Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database);
            String string2 = ((Schema)databaseObject).toCatalogAndSchema().customize(database).getSchemaName();
            boolean bl2 = false;
            if (database instanceof OracleDatabase) {
                string = (String)((DatabaseSnapshot)((Object)object)).getScratchData("DatabaseSnapshot.allCatalogsString");
                String object22 = "SELECT NULL AS SYNONYM_CATALOG_NAME, ALL_SYNONYMS.OWNER AS SYNONYM_SCHEMA_NAME, SYNONYM_NAME, NULL AS OBJECT_CATALOG_NAME, TABLE_OWNER AS OBJECT_SCHEMA_NAME, TABLE_NAME AS OBJECT_NAME, NULL AS OBJECT_TYPE FROM ALL_SYNONYMS ";
                if (string == null) {
                    String string3 = object22 + "WHERE (ALL_SYNONYMS.OWNER='" + string2 + "' OR (ALL_SYNONYMS.OWNER='PUBLIC' and ALL_SYNONYMS.TABLE_OWNER='" + string2 + "'))";
                } else {
                    String string4 = object22 + "WHERE (ALL_SYNONYMS.OWNER IN ('" + string2 + "', " + string + ") OR (ALL_SYNONYMS.OWNER='PUBLIC' and ALL_SYNONYMS.TABLE_OWNER IN ('" + string2 + "', " + string + ")))";
                    bl2 = true;
                }
            } else if (database instanceof DB2Database) {
                String string5 = "select a.TABSCHEMA AS SYNONYM_SCHEMA_NAME, a.TABNAME as SYNONYM_NAME, a.BASE_TABNAME as OBJECT_NAME, a.TABSCHEMA AS OBJECT_SCHEMA_NAME, decode(a.type, 'A', 'TABLE', 'q', 'SEQUENCE', 'u', 'MODULE') as OBJECT_TYPE from syscat.tables a where a.type in ('A', 'q', 'u') and (a.TABSCHEMA='" + string2 + "' OR a.TABSCHEMA='SYSPUBLIC') and (a.OWNER != 'SYSIBM' OR a.OWNER IS NULL)";
            } else if (database instanceof Db2zDatabase) {
                String string6 = "SELECT CREATOR AS SYNONYM_SCHEMA_NAME, NAME AS SYNONYM_NAME, TBNAME AS OBJECT_NAME, TBCREATOR AS OBJECT_SCHEMA_NAME FROM SYSIBM.SYSTABLES WHERE CREATOR ='" + string2 + "'AND TYPE='A'";
            } else if (database instanceof MSSQLDatabase) {
                String string7 = "SELECT NULL AS SYNONYM_CATALOG_NAME, SCHEMA_NAME(SCHEMA_ID) as SYNONYM_SCHEMA_NAME, name as SYNONYM_NAME, NULL AS OBJECT_CATALOG_NAME, NULL AS OBJECT_SCHEMA_NAME, PARSENAME(BASE_OBJECT_NAME,1) AS OBJECT_NAME, PARSENAME(BASE_OBJECT_NAME,2) AS OBJECT_SCHEMA_NAME, PARSENAME(BASE_OBJECT_NAME,3) AS OBJECT_CATALOG_NAME FROM sys.synonyms WHERE SCHEMA_NAME(SCHEMA_ID)='" + string2 + "' AND IS_MS_SHIPPED='false'";
            } else {
                throw new UnexpectedLiquibaseException("Unexpected database: " + database.getShortName());
            }
            for (Map<String, ?> map : CachedQueryUtil.queryIfNotCached(bl2, (String)var5_13, "SynonymSnapshotGenerator.allRows", (DatabaseSnapshot)((Object)object))) {
                boolean bl3;
                string = (String)map.get("SYNONYM_SCHEMA_NAME");
                if (!(database instanceof MSSQLDatabase) && (string.equals("PUBLIC") || string.equals("SYSPUBLIC"))) {
                    bl3 = false;
                    string = null;
                } else {
                    bl3 = true;
                }
                String string8 = (String)map.get("SYNONYM_CATALOG_NAME");
                if (database instanceof OracleDatabase && string8 == null) {
                    string8 = string;
                }
                Synonym synonym = new Synonym(string8, string, (String)map.get("SYNONYM_NAME"));
                String string9 = (String)map.get("OBJECT_CATALOG_NAME");
                String string10 = (String)map.get("OBJECT_SCHEMA_NAME");
                if (database instanceof MSSQLDatabase) {
                    if (string9 == null) {
                        string9 = string8;
                    }
                    if (string10 == null) {
                        string10 = string;
                    }
                } else if (string9 == null && string10 != null) {
                    string9 = string10;
                }
                synonym.setObjectSchema(string9, string10);
                synonym.setObjectName((String)map.get("OBJECT_NAME"));
                synonym.setPrivate(bl3);
                synonym.setObjectType((String)map.get("OBJECT_TYPE"));
                if (bl2 && !StringUtil.trimToEmpty(synonym.getSchema().getCatalogName()).equalsIgnoreCase(string2) && (bl3 || !StringUtil.trimToEmpty(string9).equalsIgnoreCase(string2))) continue;
                if (!this.isSystemObject(synonym, database)) {
                    ((Schema)databaseObject).addDatabaseObject(synonym);
                }
                if (!(database instanceof OracleDatabase)) continue;
                synonym.setAttribute("snapshotComplete", Boolean.TRUE);
            }
        }
    }

    protected boolean isSystemObject(Synonym synonym, Database database) {
        if (database instanceof OracleDatabase) {
            if (synonym.getObjectSchema() != null && (synonym.getObjectSchema().getName() != null || synonym.getObjectSchema().getCatalogName() != null)) {
                String string = synonym.getObjectSchema().getName() != null ? synonym.getObjectSchema().getName().toUpperCase() : synonym.getObjectSchema().getCatalogName().toUpperCase();
                if (this.oracleSystemSchemas.contains(string) || string.startsWith("APEX_") || string.startsWith("FLOWS_")) {
                    return true;
                }
            } else {
                synonym.setAttribute("missingSchema", Boolean.TRUE);
            }
            return synonym.getName().startsWith("/") || database.isSystemObject(synonym);
        }
        return false;
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject databaseObject, DatabaseSnapshot object) {
        Object object2;
        object = ((DatabaseSnapshot)object).getDatabase();
        Object object3 = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", (Database)object);
        if (((Synonym)databaseObject).isPrivate()) {
            object2 = databaseObject.getSchema().toCatalogAndSchema().customize((Database)object).getSchemaName();
        } else if (object instanceof OracleDatabase) {
            object2 = "PUBLIC";
        } else if (object instanceof AbstractDb2Database) {
            object2 = "SYSPUBLIC";
        } else {
            throw new UnexpectedLiquibaseException("Unknown public synonym schema for " + object.getShortName());
        }
        if (object instanceof OracleDatabase) {
            if (databaseObject.getAttribute("snapshotComplete", Boolean.FALSE).booleanValue()) {
                databaseObject.setAttribute("snapshotComplete", null);
                return databaseObject;
            }
            object2 = "SELECT NULL AS SYNONYM_CATALOG_NAME, OWNER AS SYNONYM_SCHEMA_NAME, SYNONYM_NAME, TABLE_OWNER AS OBJECT_CATALOG_NAME, NULL AS OBJECT_SCHEMA_NAME, TABLE_NAME AS OBJECT_NAME, NULL AS OBJECT_TYPE FROM ALL_SYNONYMS WHERE OWNER='" + (String)object2 + "' AND SYNONYM_NAME='" + databaseObject.getName() + "'";
        } else if (object instanceof DB2Database) {
            object2 = "select a.TABSCHEMA AS SYNONYM_SCHEMA_NAME, a.TABNAME as SYNONYM_NAME, a.BASE_TABNAME as OBJECT_NAME, a.TABSCHEMA AS OBJECT_SCHEMA_NAME, decode(a.type, 'A', 'TABLE', 'q', 'SEQUENCE', 'u', 'MODULE') as OBJECT_TYPE from syscat.tables a where a.type in ('A', 'q', 'u') and (a.TABSCHEMA='" + (String)object2 + "') and a.TABNAME='" + databaseObject.getName() + "'";
        } else if (object instanceof Db2zDatabase) {
            object2 = "SELECT CREATOR AS SYNONYM_SCHEMA_NAME, NAME AS SYNONYM_NAME, TBNAME AS OBJECT_NAME, TBCREATOR AS OBJECT_SCHEMA_NAME FROM SYSIBM.SYSTABLES WHERE CREATOR ='" + (String)object2 + "' AND NAME ='" + databaseObject.getName() + "' AND TYPE='A'";
        } else if (object instanceof MSSQLDatabase) {
            object2 = "SELECT NULL AS SYNONYM_CATALOG_NAME, SCHEMA_NAME(SCHEMA_ID) as SYNONYM_SCHEMA_NAME, name as SYNONYM_NAME, NULL AS OBJECT_CATALOG_NAME, NULL AS OBJECT_SCHEMA_NAME, PARSENAME(BASE_OBJECT_NAME,1) AS OBJECT_NAME, PARSENAME(BASE_OBJECT_NAME,2) AS OBJECT_SCHEMA_NAME, PARSENAME(BASE_OBJECT_NAME,3) AS OBJECT_CATALOG_NAME FROM SYS.SYNONYMS WHERE SCHEMA_NAME(SCHEMA_ID)='" + (String)object2 + "' AND name='" + databaseObject.getName() + "' AND IS_MS_SHIPPED='false'";
        } else {
            throw new UnexpectedLiquibaseException("Unexpected database: " + object.getShortName());
        }
        object3 = object3.queryForList(new RawSqlStatement((String)object2));
        if (object3.size() == 0) {
            return null;
        }
        if (object3.size() > 1) {
            throw new DatabaseException("Too many rows returned for ".concat(String.valueOf(databaseObject)));
        }
        object3 = (Map)object3.get(0);
        object2 = ((Synonym)databaseObject).isPrivate() ? (String)object3.get("SYNONYM_SCHEMA_NAME") : null;
        String string = (String)object3.get("SYNONYM_NAME");
        object2 = new Synonym((String)object3.get("SYNONYM_CATALOG_NAME"), (String)object2, string);
        if (object instanceof MSSQLDatabase) {
            ((Synonym)object2).setPrivate(true);
        } else {
            ((Synonym)object2).setPrivate(((Synonym)databaseObject).isPrivate());
        }
        string = (String)object3.get("OBJECT_NAME");
        String string2 = (String)object3.get("OBJECT_SCHEMA_NAME");
        ((Synonym)object2).setObjectName(string);
        string = (String)object3.get("OBJECT_CATALOG_NAME");
        if (object instanceof MSSQLDatabase) {
            if (string == null) {
                string = (String)object3.get("SYNONYM_CATALOG_NAME");
            }
            if (string2 == null) {
                string2 = (String)object3.get("SYNONYM_SCHEMA_NAME");
            }
            ((AbstractDatabaseObject)object2).setAttribute(ACTUAL_OBJECT_CATALOG_NAME, string);
        }
        ((Synonym)object2).setObjectSchema(string, string2);
        object = StringUtil.trimToNull((String)object3.get("OBJECT_TYPE"));
        ((Synonym)object2).setObjectType((String)object);
        ((AbstractDatabaseObject)object2).setAttribute("missingSchema", databaseObject.getAttribute("missingSchema", Boolean.class));
        return object2;
    }
}

