/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import liquibase.Scope;

public class LiquibaseUtil {
    private static Properties liquibaseBuildProperties;

    public static String getBuildVersion() {
        return LiquibaseUtil.getBuildInfo("build.version");
    }

    public static String getBuildTime() {
        return LiquibaseUtil.getBuildInfo("build.timestamp");
    }

    public static String getBuildNumber() {
        return LiquibaseUtil.getBuildInfo("build.number");
    }

    private static String getBuildInfo(String propertyId) {
        String value = "UNKNOWN";
        if (liquibaseBuildProperties == null) {
            try (InputStream buildProperties = Scope.getCurrentScope().getClassLoader().getResourceAsStream("liquibase.build.properties");){
                liquibaseBuildProperties = new Properties();
                if (buildProperties != null) {
                    liquibaseBuildProperties.load(buildProperties);
                }
            }
            catch (IOException e2) {
                Scope.getCurrentScope().getLog(LiquibaseUtil.class).severe("Cannot read liquibase.build.properties", e2);
            }
        }
        if (liquibaseBuildProperties != null) {
            value = liquibaseBuildProperties.getProperty(propertyId);
        }
        return value;
    }
}

