/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkProtectedApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XpathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SdkProtectedApi
public class DefaultErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log log = LogFactory.getLog(DefaultErrorResponseHandler.class);
    private List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList;

    public DefaultErrorResponseHandler(List<Unmarshaller<AmazonServiceException, Node>> unmarshallerList) {
        this.unmarshallerList = unmarshallerList;
    }

    @Override
    public AmazonServiceException handle(HttpResponse errorResponse) throws Exception {
        AmazonServiceException ase = this.createAse(errorResponse);
        if (ase == null) {
            throw new SdkClientException("Unable to unmarshall error response from service");
        }
        ase.setHttpHeaders(errorResponse.getHeaders());
        if (StringUtils.isNullOrEmpty(ase.getErrorCode())) {
            ase.setErrorCode(errorResponse.getStatusCode() + " " + errorResponse.getStatusText());
        }
        return ase;
    }

    private AmazonServiceException createAse(HttpResponse errorResponse) throws Exception {
        Document document = this.documentFromContent(errorResponse.getContent(), this.idString(errorResponse));
        for (Unmarshaller<AmazonServiceException, Node> unmarshaller : this.unmarshallerList) {
            AmazonServiceException ase = unmarshaller.unmarshall(document);
            if (ase == null) continue;
            ase.setStatusCode(errorResponse.getStatusCode());
            return ase;
        }
        return null;
    }

    private Document documentFromContent(InputStream content, String idString) throws ParserConfigurationException, SAXException, IOException {
        try {
            return this.parseXml(this.contentToString(content, idString), idString);
        }
        catch (Exception e) {
            return XpathUtils.documentFrom("<empty/>");
        }
    }

    private String contentToString(InputStream content, String idString) throws Exception {
        try {
            return IOUtils.toString(content);
        }
        catch (Exception e) {
            log.debug((Object)String.format("Unable to read input stream to string (%s)", idString), (Throwable)e);
            throw e;
        }
    }

    private Document parseXml(String xml, String idString) throws Exception {
        try {
            return XpathUtils.documentFrom(xml);
        }
        catch (Exception e) {
            log.debug((Object)String.format("Unable to parse HTTP response (%s) content to XML document '%s' ", idString, xml), (Throwable)e);
            throw e;
        }
    }

    private String idString(HttpResponse errorResponse) {
        StringBuilder idString = new StringBuilder();
        try {
            if (errorResponse.getRequest().getHeaders().containsKey("amz-sdk-invocation-id")) {
                idString.append("Invocation Id:").append(errorResponse.getRequest().getHeaders().get("amz-sdk-invocation-id"));
            }
            if (errorResponse.getHeaders().containsKey("x-amzn-RequestId")) {
                if (idString.length() > 0) {
                    idString.append(", ");
                }
                idString.append("Request Id:").append(errorResponse.getHeaders().get("x-amzn-RequestId"));
            }
        }
        catch (NullPointerException npe) {
            log.debug((Object)"Error getting Request or Invocation ID from response", (Throwable)npe);
        }
        return idString.length() > 0 ? idString.toString() : "Unknown";
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

