/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.DateBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class Avl301ProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 76;
    public static final int MSG_STATUS = 72;
    public static final int MSG_GPS_LBS_STATUS = 36;

    public Avl301ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String readImei(ByteBuf buf) {
        short b = buf.readUnsignedByte();
        StringBuilder imei = new StringBuilder();
        imei.append(b & 0xF);
        for (int i = 0; i < 7; ++i) {
            b = buf.readUnsignedByte();
            imei.append((b & 0xF0) >> 4);
            imei.append(b & 0xF);
        }
        return imei.toString();
    }

    private void sendResponse(Channel channel, int type) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer((int)5);
            response.writeByte(36);
            response.writeByte(type);
            response.writeByte(35);
            response.writeByte(13);
            response.writeByte(10);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(1);
        short type = buf.readUnsignedByte();
        buf.readUnsignedByte();
        if (type == 76) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, this.readImei(buf));
            if (deviceSession == null) {
                this.sendResponse(channel, type);
            }
        } else if (type == 72) {
            this.sendResponse(channel, type);
        } else if (type == 36) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            DateBuilder dateBuilder = new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
            position.setTime(dateBuilder.getDate());
            short gpsLength = buf.readUnsignedByte();
            position.set("sat", gpsLength & 0xF);
            position.set("satVisible", buf.readUnsignedByte());
            double latitude = (double)buf.readUnsignedInt() / 600000.0;
            double longitude = (double)buf.readUnsignedInt() / 600000.0;
            position.setSpeed(buf.readUnsignedByte());
            int union = buf.readUnsignedShort();
            position.setCourse(union & 0x3FF);
            position.setValid((union & 0x1000) != 0);
            if ((union & 0x400) != 0) {
                latitude = -latitude;
            }
            if ((union & 0x800) != 0) {
                longitude = -longitude;
            }
            position.setLatitude(latitude);
            position.setLongitude(longitude);
            if ((union & 0x4000) != 0) {
                position.set("acc", (union & 0x8000) != 0);
            }
            position.setNetwork(new Network(CellTower.fromLacCid(buf.readUnsignedShort(), buf.readUnsignedMedium())));
            position.set("alarm", "general");
            short flags = buf.readUnsignedByte();
            position.set("acc", (flags & 2) != 0);
            position.set("power", buf.readUnsignedByte());
            position.set("rssi", buf.readUnsignedByte());
            return position;
        }
        return null;
    }
}

