/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import java.util.Date;
import org.traccar.Context;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;

public class H02ProtocolEncoder
extends StringProtocolEncoder {
    private static final String MARKER = "HQ";

    public H02ProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    private Object formatCommand(Date time, String uniqueId, String type, String ... params) {
        StringBuilder result = new StringBuilder(String.format("*%s,%s,%s,%4$tH%4$tM%4$tS", MARKER, uniqueId, type, time));
        for (String param : params) {
            result.append(",").append(param);
        }
        result.append("#");
        return result.toString();
    }

    protected Object encodeCommand(Command command, Date time) {
        String uniqueId = this.getUniqueId(command.getDeviceId());
        switch (command.getType()) {
            case "alarmArm": {
                return this.formatCommand(time, uniqueId, "SCF", "0", "0");
            }
            case "alarmDisarm": {
                return this.formatCommand(time, uniqueId, "SCF", "1", "1");
            }
            case "engineStop": {
                return this.formatCommand(time, uniqueId, "S20", "1", "1");
            }
            case "engineResume": {
                return this.formatCommand(time, uniqueId, "S20", "1", "0");
            }
            case "positionPeriodic": {
                String frequency = command.getAttributes().get("frequency").toString();
                if (Context.getIdentityManager().lookupAttributeBoolean(command.getDeviceId(), this.getProtocolName() + ".alternative", false, false, true)) {
                    return this.formatCommand(time, uniqueId, "D1", frequency);
                }
                return this.formatCommand(time, uniqueId, "S71", "22", frequency);
            }
        }
        return null;
    }

    @Override
    protected Object encodeCommand(Command command) {
        return this.encodeCommand(command, new Date());
    }
}

