/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class SabertekProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text(",").number("(d+),").number("d,").groupBegin().number("d+,").number("d+,").expression("[^,]*,").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").groupEnd("?").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").compile();

    public SabertekProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        int events;
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(Unpooled.wrappedBuffer((byte[])new byte[]{(byte)(deviceSession != null ? 6 : 21)}), remoteAddress));
        }
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (parser.hasNext(6)) {
            position.setTime(parser.nextDateTime());
        } else {
            position.setTime(new Date());
        }
        position.set("batteryLevel", parser.nextInt());
        position.set("rssi", parser.nextInt());
        int state = parser.nextInt();
        position.set("ignition", BitUtil.check(state, 0));
        position.set("charge", BitUtil.check(state, 1));
        if (BitUtil.check(state, 2)) {
            position.set("alarm", "jamming");
        }
        if (BitUtil.check(state, 3)) {
            position.set("alarm", "tampering");
        }
        if (BitUtil.check(events = parser.nextInt().intValue(), 0)) {
            position.set("alarm", "hardBraking");
        }
        if (BitUtil.check(events, 1)) {
            position.set("alarm", "overspeed");
        }
        if (BitUtil.check(events, 2)) {
            position.set("alarm", "accident");
        }
        if (BitUtil.check(events, 3)) {
            position.set("alarm", "hardCornering");
        }
        position.setValid(parser.nextInt() == 1);
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.setCourse(parser.nextInt().intValue());
        position.setAltitude(parser.nextInt().intValue());
        position.set("sat", parser.nextInt());
        position.set("odometer", (long)parser.nextInt().intValue() * 1000L);
        return position;
    }
}

