/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.ObdDecoder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;

public class UlbotechProtocolDecoder
extends BaseProtocolDecoder {
    private static final short DATA_GPS = 1;
    private static final short DATA_LBS = 2;
    private static final short DATA_STATUS = 3;
    private static final short DATA_ODOMETER = 4;
    private static final short DATA_ADC = 5;
    private static final short DATA_GEOFENCE = 6;
    private static final short DATA_OBD2 = 7;
    private static final short DATA_FUEL = 8;
    private static final short DATA_OBD2_ALARM = 9;
    private static final short DATA_HARSH_DRIVER = 10;
    private static final short DATA_CANBUS = 11;
    private static final short DATA_J1708 = 12;
    private static final short DATA_VIN = 13;
    private static final short DATA_RFID = 14;
    private static final short DATA_EVENT = 16;
    private static final Pattern PATTERN = new PatternBuilder().text("*TS").number("dd,").number("(d{15}),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").expression("([^#]+)").text("#").compile();

    public UlbotechProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void decodeObd(Position position, ByteBuf buf, int length) {
        int end = buf.readerIndex() + length;
        while (buf.readerIndex() < end) {
            int parameterLength = buf.getUnsignedByte(buf.readerIndex()) >> 4;
            int mode = buf.readUnsignedByte() & 0xF;
            position.add(ObdDecoder.decode(mode, ByteBufUtil.hexDump((ByteBuf)buf.readSlice(parameterLength - 1))));
        }
    }

    private void decodeJ1708(Position position, ByteBuf buf, int length) {
        int end = buf.readerIndex() + length;
        while (buf.readerIndex() < end) {
            short mark = buf.readUnsignedByte();
            int len = BitUtil.between(mark, 0, 6);
            int type = BitUtil.between(mark, 6, 8);
            int id = buf.readUnsignedByte();
            if (type == 3) {
                id += 256;
            }
            String value = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(len - 1));
            if (type != 2 && type != 3) continue;
            position.set("pid" + id, value);
        }
    }

    private void decodeDriverBehavior(Position position, ByteBuf buf) {
        short value = buf.readUnsignedByte();
        if (BitUtil.check(value, 0)) {
            position.set("rapidAcceleration", true);
        }
        if (BitUtil.check(value, 1)) {
            position.set("roughBraking", true);
        }
        if (BitUtil.check(value, 2)) {
            position.set("harshCourse", true);
        }
        if (BitUtil.check(value, 3)) {
            position.set("noWarmUp", true);
        }
        if (BitUtil.check(value, 4)) {
            position.set("longIdle", true);
        }
        if (BitUtil.check(value, 5)) {
            position.set("fatigueDriving", true);
        }
        if (BitUtil.check(value, 6)) {
            position.set("roughTerrain", true);
        }
        if (BitUtil.check(value, 7)) {
            position.set("highRpm", true);
        }
    }

    private String decodeAlarm(int alarm) {
        if (BitUtil.check(alarm, 0)) {
            return "powerOff";
        }
        if (BitUtil.check(alarm, 1)) {
            return "movement";
        }
        if (BitUtil.check(alarm, 2)) {
            return "overspeed";
        }
        if (BitUtil.check(alarm, 4)) {
            return "geofence";
        }
        if (BitUtil.check(alarm, 10)) {
            return "sos";
        }
        return null;
    }

    private void decodeAdc(Position position, ByteBuf buf, int length) {
        block6: for (int i = 0; i < length / 2; ++i) {
            int value = buf.readUnsignedShort();
            int id = BitUtil.from(value, 12);
            value = BitUtil.to(value, 12);
            switch (id) {
                case 0: {
                    position.set("power", (double)(value * 110) / 4096.0 - 10.0);
                    continue block6;
                }
                case 1: {
                    position.set("temp1", (double)(value * 180) / 4096.0 - 55.0);
                    continue block6;
                }
                case 2: {
                    position.set("battery", (double)(value * 110) / 4096.0 - 10.0);
                    continue block6;
                }
                case 3: {
                    position.set("adc1", (double)(value * 110) / 4096.0 - 10.0);
                    continue block6;
                }
                default: {
                    position.set("io" + id, value);
                }
            }
        }
    }

    private Object decodeText(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0)).setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        this.getLastLocation(position, dateBuilder.getDate());
        position.set("result", parser.next());
        return position;
    }

    private Object decodeBinary(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        if (deviceSession.getTimeZone() == null) {
            deviceSession.setTimeZone(this.getTimeZone(deviceSession.getDeviceId()));
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        long seconds = buf.readUnsignedInt() & Integer.MAX_VALUE;
        seconds += 946684800L;
        Date time = new Date((seconds -= (long)(deviceSession.getTimeZone().getRawOffset() / 1000)) * 1000L);
        boolean hasLocation = false;
        block17: while (buf.readableBytes() > 3) {
            short type = buf.readUnsignedByte();
            int length = type == 11 ? buf.readUnsignedShort() : (int)buf.readUnsignedByte();
            switch (type) {
                case 1: {
                    hasLocation = true;
                    position.setLatitude((double)buf.readInt() / 1000000.0);
                    position.setLongitude((double)buf.readInt() / 1000000.0);
                    position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShort()));
                    position.setCourse(buf.readUnsignedShort());
                    int hdop = buf.readUnsignedShort();
                    position.setValid(hdop < 9999);
                    position.set("hdop", (double)hdop * 0.01);
                    continue block17;
                }
                case 2: {
                    if (length == 11) {
                        position.setNetwork(new Network(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedInt(), -buf.readUnsignedByte())));
                    } else {
                        position.setNetwork(new Network(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort(), -buf.readUnsignedByte())));
                    }
                    if (length <= 9 || length == 11) continue block17;
                    buf.skipBytes(length - 9);
                    continue block17;
                }
                case 3: {
                    int status = buf.readUnsignedShort();
                    position.set("ignition", BitUtil.check(status, 9));
                    position.set("status", status);
                    position.set("alarm", this.decodeAlarm(buf.readUnsignedShort()));
                    continue block17;
                }
                case 4: {
                    position.set("odometer", buf.readUnsignedInt());
                    continue block17;
                }
                case 5: {
                    this.decodeAdc(position, buf, length);
                    continue block17;
                }
                case 6: {
                    position.set("geofenceIn", buf.readUnsignedInt());
                    position.set("geofenceAlarm", buf.readUnsignedInt());
                    continue block17;
                }
                case 7: {
                    this.decodeObd(position, buf, length);
                    continue block17;
                }
                case 8: {
                    position.set("fuelConsumption", (double)buf.readUnsignedInt() / 10000.0);
                    continue block17;
                }
                case 9: {
                    this.decodeObd(position, buf, length);
                    continue block17;
                }
                case 10: {
                    this.decodeDriverBehavior(position, buf);
                    continue block17;
                }
                case 11: {
                    position.set("can", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(length)));
                    continue block17;
                }
                case 12: {
                    this.decodeJ1708(position, buf, length);
                    continue block17;
                }
                case 13: {
                    position.set("vin", buf.readSlice(length).toString(StandardCharsets.US_ASCII));
                    continue block17;
                }
                case 14: {
                    position.set("driverUniqueId", buf.readSlice(length - 1).toString(StandardCharsets.US_ASCII));
                    position.set("authorized", buf.readUnsignedByte() != 0);
                    continue block17;
                }
                case 16: {
                    position.set("event", buf.readUnsignedByte());
                    if (length <= 1) continue block17;
                    position.set("eventMask", buf.readUnsignedInt());
                    continue block17;
                }
            }
            buf.skipBytes(length);
        }
        if (!hasLocation) {
            this.getLastLocation(position, time);
        } else {
            position.setTime(time);
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getUnsignedByte(buf.readerIndex()) == 248) {
            if (channel != null) {
                ByteBuf response = Unpooled.buffer();
                response.writeByte(248);
                response.writeByte(1);
                response.writeByte(254);
                response.writeShort((int)buf.getShort(response.writerIndex() - 1 - 2));
                response.writeShort(Checksum.crc16(Checksum.CRC16_XMODEM, response.nioBuffer(1, 4)));
                response.writeByte(248);
                channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
            }
            return this.decodeBinary(channel, remoteAddress, buf);
        }
        if (channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage(Unpooled.copiedBuffer((CharSequence)String.format("*TS01,ACK:%04X#", Checksum.crc16(Checksum.CRC16_XMODEM, buf.nioBuffer(1, buf.writerIndex() - 2))), (Charset)StandardCharsets.US_ASCII), remoteAddress));
        }
        return this.decodeText(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII));
    }
}

