/*
 * Decompiled with CFR 0.152.
 */
package openlink.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import openlink.util.OPLMessage_u;

public class OPLHeapBlob
implements Blob,
Serializable {
    static final long serialVersionUID = -6793193829176495886L;
    private byte[] blobData = null;
    private long blobLength = 0L;
    private static final int buf_size = 32768;
    private Object lck = this;

    public OPLHeapBlob() {
        this.blobData = new byte[1];
    }

    public OPLHeapBlob(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public OPLHeapBlob(byte[] byArray, int n, int n2) {
        this.blobData = new byte[n2];
        System.arraycopy(byArray, n, this.blobData, 0, n2);
        this.blobLength = n2;
    }

    public OPLHeapBlob(InputStream inputStream) throws SQLException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32768);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 32768);
            byte[] byArray = new byte[32768];
            int n = bufferedInputStream.read(byArray, 0, 32768);
            while (n != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
                n = bufferedInputStream.read(byArray, 0, 32768);
            }
            this.blobData = byteArrayOutputStream.toByteArray();
            this.blobLength = this.blobData.length;
        }
        catch (IOException iOException) {
            throw OPLMessage_u.makeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            return this.blobLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            if (--l >= this.blobLength) {
                throw OPLMessage_u.makeException(2);
            }
            if ((long)n > this.blobLength - l) {
                n = (int)(this.blobLength - l);
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.blobData, (int)l, byArray, 0, n);
            return byArray;
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        this.ensureOpen();
        return new BlobInputStream(this.lck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(byte[] byArray, long l) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            if (l < 1L) {
                throw OPLMessage_u.makeException(2);
            }
            if (--l > this.blobLength) {
                return -1L;
            }
            int n = (int)l;
            while ((long)n < this.blobLength && (long)byArray.length <= this.blobLength - (long)n) {
                if (this.blobData[n] == byArray[0]) {
                    boolean bl = true;
                    for (int i = 1; i < byArray.length; ++i) {
                        if (this.blobData[n + i] == byArray[i]) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        return n + 1;
                    }
                }
                ++n;
            }
        }
        return -1L;
    }

    public long position(Blob blob, long l) throws SQLException {
        this.ensureOpen();
        if (l < 1L) {
            throw OPLMessage_u.makeException(2);
        }
        return this.position(blob.getBytes(0L, (int)blob.length()), l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        this.ensureOpen();
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            BlobOutputStream blobOutputStream = new BlobOutputStream(this.lck, l);
            try {
                ((OutputStream)blobOutputStream).write(byArray, n, n2);
            }
            catch (IOException iOException) {
                OPLMessage_u.makeException(iOException);
            }
        }
        return n2;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        this.ensureOpen();
        return new BlobOutputStream(this.lck, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long l) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            int n = (int)l;
            if (n < 0 || (long)n > this.blobLength) {
                throw OPLMessage_u.makeException(3);
            }
            if (n < this.blobData.length) {
                byte[] byArray = new byte[n];
                System.arraycopy(this.blobData, 0, byArray, 0, n);
                this.blobData = byArray;
            }
            this.blobLength = l;
        }
    }

    private void ensureOpen() throws SQLException {
        if (this.blobData == null) {
            throw OPLMessage_u.makeException(4);
        }
    }

    static /* synthetic */ byte[] access$102(OPLHeapBlob oPLHeapBlob, byte[] byArray) {
        oPLHeapBlob.blobData = byArray;
        return byArray;
    }

    protected class BlobOutputStream
    extends OutputStream {
        protected int count;
        private boolean isClosed = false;
        private Object lock;

        protected BlobOutputStream(Object object, long l) {
            this.lock = object;
            this.count = (int)l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int n) throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                int n2 = this.count + 1;
                if (n2 > OPLHeapBlob.this.blobData.length) {
                    byte[] byArray = new byte[Math.max(OPLHeapBlob.this.blobData.length + 32768, n2)];
                    System.arraycopy(OPLHeapBlob.this.blobData, 0, byArray, 0, this.count);
                    OPLHeapBlob.access$102(OPLHeapBlob.this, byArray);
                }
                ((OPLHeapBlob)OPLHeapBlob.this).blobData[this.count] = (byte)n;
                this.count = n2;
                OPLHeapBlob.this.blobLength += 1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (n2 == 0) {
                    return;
                }
                int n3 = this.count + n2;
                if (n3 > OPLHeapBlob.this.blobData.length) {
                    byte[] byArray2 = new byte[Math.max(OPLHeapBlob.this.blobData.length + 32768, n3)];
                    System.arraycopy(OPLHeapBlob.this.blobData, 0, byArray2, 0, this.count);
                    OPLHeapBlob.access$102(OPLHeapBlob.this, byArray2);
                }
                System.arraycopy(byArray, n, OPLHeapBlob.this.blobData, this.count, n2);
                this.count = n3;
                OPLHeapBlob.this.blobLength += n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.isClosed = true;
            }
        }

        private void ensureOpen() throws IOException {
            if (this.isClosed || OPLHeapBlob.this.blobData == null) {
                throw new IOException(OPLMessage_u.getMessage(1));
            }
        }
    }

    protected class BlobInputStream
    extends InputStream {
        private boolean isClosed = false;
        private int pos = 0;
        private long length;
        private Object lock;

        protected BlobInputStream(Object object) {
            this.lock = object;
            this.length = OPLHeapBlob.this.blobLength;
        }

        protected BlobInputStream(Object object, long l, long l2) {
            this.lock = object;
            this.pos = (int)l;
            this.length = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                return (long)this.pos < this.length ? OPLHeapBlob.this.blobData[this.pos++] & 0xFF : -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                if (byArray == null) {
                    throw new NullPointerException();
                }
                if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if ((long)this.pos >= this.length) {
                    return -1;
                }
                if ((long)(this.pos + n2) > this.length) {
                    n2 = (int)(this.length - (long)this.pos);
                }
                if (n2 <= 0) {
                    return 0;
                }
                System.arraycopy(OPLHeapBlob.this.blobData, this.pos, byArray, n, n2);
                this.pos += n2;
                return n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long skip(long l) throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                if ((long)this.pos + l > this.length) {
                    l = this.length - (long)this.pos;
                }
                if (l < 0L) {
                    return 0L;
                }
                this.pos = (int)((long)this.pos + l);
                return l;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.isClosed = true;
            }
        }

        private void ensureOpen() throws IOException {
            if (this.isClosed || OPLHeapBlob.this.blobData == null) {
                throw new IOException(OPLMessage_u.getMessage(1));
            }
        }
    }
}

