# NT status codes.
@load ./consts

module SMB;

redef SMB::statuses += {
	[0x00000001] = [$id="WAIT_1", $desc="The caller specified WaitAny for WaitType and one of the dispatcher objects in the Object array has been set to the signaled state."],
	[0x00000002] = [$id="WAIT_2", $desc="The caller specified WaitAny for WaitType and one of the dispatcher objects in the Object array has been set to the signaled state."],
	[0x00000003] = [$id="WAIT_3", $desc="The caller specified WaitAny for WaitType and one of the dispatcher objects in the Object array has been set to the signaled state."],
	[0x0000003F] = [$id="WAIT_63", $desc="The caller specified WaitAny for WaitType and one of the dispatcher objects in the Object array has been set to the signaled state."],
	[0x00000080] = [$id="ABANDONED", $desc="The caller attempted to wait for a mutex that has been abandoned."],
	[0x000000BF] = [$id="ABANDONED_WAIT_63", $desc="The caller attempted to wait for a mutex that has been abandoned."],
	[0x000000C0] = [$id="USER_APC", $desc="A user-mode APC was delivered before the given Interval expired."],
	[0x00000101] = [$id="ALERTED", $desc="The delay completed because the thread was alerted."],
	[0x00000102] = [$id="TIMEOUT", $desc="The given Timeout interval expired."],
	[0x00000103] = [$id="PENDING", $desc="The operation that was requested is pending completion."],
	[0x00000104] = [$id="REPARSE", $desc="A reparse should be performed by the Object Manager because the name of the file resulted in a symbolic link."],
	[0x00000105] = [$id="MORE_ENTRIES", $desc="Returned by enumeration APIs to indicate more information is available to successive calls."],
	[0x00000106] = [$id="NOT_ALL_ASSIGNED", $desc="Indicates not all privileges or groups that are referenced are assigned to the caller. This allows, for example, all privileges to be disabled without having to know exactly which privileges are assigned."],
	[0x00000107] = [$id="SOME_NOT_MAPPED", $desc="Some of the information to be translated has not been translated."],
	[0x00000108] = [$id="OPLOCK_BREAK_IN_PROGRESS", $desc="An open/create operation completed while an opportunistic lock (oplock) break is underway."],
	[0x00000109] = [$id="VOLUME_MOUNTED", $desc="A new volume has been mounted by a file system."],
	[0x0000010A] = [$id="RXACT_COMMITTED", $desc="This success level status indicates that the transaction state already exists for the registry subtree but that a transaction commit was previously aborted. The commit has now been completed."],
	[0x0000010B] = [$id="NOTIFY_CLEANUP", $desc="Indicates that a notify change request has been completed due to closing the handle that made the notify change request."],
	[0x0000010C] = [$id="NOTIFY_ENUM_DIR", $desc="Indicates that a notify change request is being completed and that the information is not being returned in the caller's buffer. The caller now needs to enumerate the files to find the changes."],
	[0x0000010D] = [$id="NO_QUOTAS_FOR_ACCOUNT", $desc="{No Quotas} No system quota limits are specifically set for this account."],
	[0x0000010E] = [$id="PRIMARY_TRANSPORT_CONNECT_FAILED", $desc="{Connect Failure on Primary Transport} An attempt was made to connect to the remote server %hs on the primary transport, but the connection failed. The computer WAS able to connect on a secondary transport."],
	[0x00000110] = [$id="PAGE_FAULT_TRANSITION", $desc="The page fault was a transition fault."],
	[0x00000111] = [$id="PAGE_FAULT_DEMAND_ZERO", $desc="The page fault was a demand zero fault."],
	[0x00000112] = [$id="PAGE_FAULT_COPY_ON_WRITE", $desc="The page fault was a demand zero fault."],
	[0x00000113] = [$id="PAGE_FAULT_GUARD_PAGE", $desc="The page fault was a demand zero fault."],
	[0x00000114] = [$id="PAGE_FAULT_PAGING_FILE", $desc="The page fault was satisfied by reading from a secondary storage device."],
	[0x00000115] = [$id="CACHE_PAGE_LOCKED", $desc="The cached page was locked during operation."],
	[0x00000116] = [$id="CRASH_DUMP", $desc="The crash dump exists in a paging file."],
	[0x00000117] = [$id="BUFFER_ALL_ZEROS", $desc="The specified buffer contains all zeros."],
	[0x00000118] = [$id="REPARSE_OBJECT", $desc="A reparse should be performed by the Object Manager because the name of the file resulted in a symbolic link."],
	[0x00000119] = [$id="RESOURCE_REQUIREMENTS_CHANGED", $desc="The device has succeeded a query-stop and its resource requirements have changed."],
	[0x00000120] = [$id="TRANSLATION_COMPLETE", $desc="The translator has translated these resources into the global space and no additional translations should be performed."],
	[0x00000121] = [$id="DS_MEMBERSHIP_EVALUATED_LOCALLY", $desc="The directory service evaluated group memberships locally, because it was unable to contact a global catalog server."],
	[0x00000122] = [$id="NOTHING_TO_TERMINATE", $desc="A process being terminated has no threads to terminate."],
	[0x00000123] = [$id="PROCESS_NOT_IN_JOB", $desc="The specified process is not part of a job."],
	[0x00000124] = [$id="PROCESS_IN_JOB", $desc="The specified process is part of a job."],
	[0x00000125] = [$id="VOLSNAP_HIBERNATE_READY", $desc="{Volume Shadow Copy Service} The system is now ready for hibernation."],
	[0x00000126] = [$id="FSFILTER_OP_COMPLETED_SUCCESSFULLY", $desc="A file system or file system filter driver has successfully completed an FsFilter operation."],
	[0x00000127] = [$id="INTERRUPT_VECTOR_ALREADY_CONNECTED", $desc="The specified interrupt vector was already connected."],
	[0x00000128] = [$id="INTERRUPT_STILL_CONNECTED", $desc="The specified interrupt vector is still connected."],
	[0x00000129] = [$id="PROCESS_CLONED", $desc="The current process is a cloned process."],
	[0x0000012A] = [$id="FILE_LOCKED_WITH_ONLY_READERS", $desc="The file was locked and all users of the file can only read."],
	[0x0000012B] = [$id="FILE_LOCKED_WITH_WRITERS", $desc="The file was locked and at least one user of the file can write."],
	[0x00000202] = [$id="RESOURCEMANAGER_READ_ONLY", $desc="The specified ResourceManager made no changes or updates to the resource under this transaction."],
	[0x00000367] = [$id="WAIT_FOR_OPLOCK", $desc="An operation is blocked and waiting for an oplock."],
	[0x00010001] = [$id="DBG_EXCEPTION_HANDLED", $desc="Debugger handled the exception."],
	[0x00010002] = [$id="DBG_CONTINUE", $desc="The debugger continued."],
	[0x001C0001] = [$id="FLT_IO_COMPLETE", $desc="The IO was completed by a filter."],
	[0xC0000467] = [$id="FILE_NOT_AVAILABLE", $desc="The file is temporarily unavailable."],
	[0xC0000721] = [$id="CALLBACK_RETURNED_THREAD_AFFINITY", $desc="A threadpool worker thread entered a callback at thread affinity %p and exited at affinity %p."],
	[0x40000000] = [$id="OBJECT_NAME_EXISTS", $desc="{Object Exists} An attempt was made to create an object but the object name already exists."],
	[0x40000001] = [$id="THREAD_WAS_SUSPENDED", $desc="{Thread Suspended} A thread termination occurred while the thread was suspended. The thread resumed, and termination proceeded."],
	[0x40000002] = [$id="WORKING_SET_LIMIT_RANGE", $desc="{Working Set Range Error} An attempt was made to set the working set minimum or maximum to values that are outside the allowable range."],
	[0x40000003] = [$id="IMAGE_NOT_AT_BASE", $desc="{Image Relocated} An image file could not be mapped at the address that is specified in the image file. Local fixes must be performed on this image."],
	[0x40000004] = [$id="RXACT_STATE_CREATED", $desc="This informational level status indicates that a specified registry subtree transaction state did not yet exist and had to be created."],
	[0x40000005] = [$id="SEGMENT_NOTIFICATION", $desc="{Segment Load} A virtual DOS machine (VDM) is loading, unloading, or moving an MS-DOS or Win16 program segment image. An exception is raised so that a debugger can load, unload, or track symbols and breakpoints within these 16-bit segments."],
	[0x40000006] = [$id="LOCAL_USER_SESSION_KEY", $desc="{Local Session Key} A user session key was requested for a local remote procedure call (RPC) connection. The session key that is returned is a constant value and not unique to this connection."],
	[0x40000007] = [$id="BAD_CURRENT_DIRECTORY", $desc="{Invalid Current Directory} The process cannot switch to the startup current directory %hs. Select OK to set the current directory to %hs, or select CANCEL to exit."],
	[0x40000008] = [$id="SERIAL_MORE_WRITES", $desc="{Serial IOCTL Complete} A serial I/O operation was completed by another write to a serial port. (The IOCTL_SERIAL_XOFF_COUNTER reached zero.)"],
	[0x40000009] = [$id="REGISTRY_RECOVERED", $desc="{Registry Recovery} One of the files that contains the system registry data had to be recovered by using a log or alternate copy. The recovery was successful."],
	[0x4000000A] = [$id="FT_READ_RECOVERY_FROM_BACKUP", $desc="{Redundant Read} To satisfy a read request, the Windows NT fault-tolerant file system successfully read the requested data from a redundant copy. This was done because the file system encountered a failure on a member of the fault-tolerant volume but was unable to reassign the failing area of the device."],
	[0x4000000B] = [$id="FT_WRITE_RECOVERY", $desc="{Redundant Write} To satisfy a write request, the Windows NT fault-tolerant file system successfully wrote a redundant copy of the information. This was done because the file system encountered a failure on a member of the fault-tolerant volume but was unable to reassign the failing area of the device."],
	[0x4000000C] = [$id="SERIAL_COUNTER_TIMEOUT", $desc="{Serial IOCTL Timeout} A serial I/O operation completed because the time-out period expired. (The IOCTL_SERIAL_XOFF_COUNTER had not reached zero.)"],
	[0x4000000D] = [$id="NULL_LM_PASSWORD", $desc="{Password Too Complex} The Windows password is too complex to be converted to a LAN Manager password. The LAN Manager password that returned is a NULL string."],
	[0x4000000E] = [$id="IMAGE_MACHINE_TYPE_MISMATCH", $desc="{Machine Type Mismatch} The image file %hs is valid but is for a machine type other than the current machine. Select OK to continue, or CANCEL to fail the DLL load."],
	[0x4000000F] = [$id="RECEIVE_PARTIAL", $desc="{Partial Data Received} The network transport returned partial data to its client. The remaining data will be sent later."],
	[0x40000010] = [$id="RECEIVE_EXPEDITED", $desc="{Expedited Data Received} The network transport returned data to its client that was marked as expedited by the remote system."],
	[0x40000011] = [$id="RECEIVE_PARTIAL_EXPEDITED", $desc="{Partial Expedited Data Received} The network transport returned partial data to its client and this data was marked as expedited by the remote system. The remaining data will be sent later."],
	[0x40000012] = [$id="EVENT_DONE", $desc="{TDI Event Done} The TDI indication has completed successfully."],
	[0x40000013] = [$id="EVENT_PENDING", $desc="{TDI Event Pending} The TDI indication has entered the pending state."],
	[0x40000014] = [$id="CHECKING_FILE_SYSTEM", $desc="Checking file system on %wZ."],
	[0x40000015] = [$id="FATAL_APP_EXIT", $desc="{Fatal Application Exit} %hs"],
	[0x40000016] = [$id="PREDEFINED_HANDLE", $desc="The specified registry key is referenced by a predefined handle."],
	[0x40000017] = [$id="WAS_UNLOCKED", $desc="{Page Unlocked} The page protection of a locked page was changed to 'No Access' and the page was unlocked from memory and from the process."],
	[0x40000018] = [$id="SERVICE_NOTIFICATION", $desc="%hs"],
	[0x40000019] = [$id="WAS_LOCKED", $desc="{Page Locked} One of the pages to lock was already locked."],
	[0x4000001A] = [$id="LOG_HARD_ERROR", $desc="Application popup: %1 : %2"],
	[0x4000001B] = [$id="ALREADY_WIN32", $desc="A Win32 process already exists."],
	[0x4000001C] = [$id="WX86_UNSIMULATE", $desc="An exception status code that is used by the Win32 x86 emulation subsystem."],
	[0x4000001D] = [$id="WX86_CONTINUE", $desc="An exception status code that is used by the Win32 x86 emulation subsystem."],
	[0x4000001E] = [$id="WX86_SINGLE_STEP", $desc="An exception status code that is used by the Win32 x86 emulation subsystem."],
	[0x4000001F] = [$id="WX86_BREAKPOINT", $desc="An exception status code that is used by the Win32 x86 emulation subsystem."],
	[0x40000020] = [$id="WX86_EXCEPTION_CONTINUE", $desc="An exception status code that is used by the Win32 x86 emulation subsystem."],
	[0x40000021] = [$id="WX86_EXCEPTION_LASTCHANCE", $desc="An exception status code that is used by the Win32 x86 emulation subsystem."],
	[0x40000022] = [$id="WX86_EXCEPTION_CHAIN", $desc="An exception status code that is used by the Win32 x86 emulation subsystem."],
	[0x40000023] = [$id="IMAGE_MACHINE_TYPE_MISMATCH_EXE", $desc="{Machine Type Mismatch} The image file %hs is valid but is for a machine type other than the current machine."],
	[0x40000024] = [$id="NO_YIELD_PERFORMED", $desc="A yield execution was performed and no thread was available to run."],
	[0x40000025] = [$id="TIMER_RESUME_IGNORED", $desc="The resume flag to a timer API was ignored."],
	[0x40000026] = [$id="ARBITRATION_UNHANDLED", $desc="The arbiter has deferred arbitration of these resources to its parent."],
	[0x40000027] = [$id="CARDBUS_NOT_SUPPORTED", $desc="The device has detected a CardBus card in its slot."],
	[0x40000028] = [$id="WX86_CREATEWX86TIB", $desc="An exception status code that is used by the Win32 x86 emulation subsystem."],
	[0x40000029] = [$id="MP_PROCESSOR_MISMATCH", $desc="The CPUs in this multiprocessor system are not all the same revision level. To use all processors, the operating system restricts itself to the features of the least capable processor in the system. If problems occur with this system, contact the CPU manufacturer to see if this mix of processors is supported."],
	[0x4000002A] = [$id="HIBERNATED", $desc="The system was put into hibernation."],
	[0x4000002B] = [$id="RESUME_HIBERNATION", $desc="The system was resumed from hibernation."],
	[0x4000002C] = [$id="FIRMWARE_UPDATED", $desc="0x4000002D<br />STATUS_DRIVERS_LEAKING_LOCKED_PAGES"],
	[0x4000002E] = [$id="MESSAGE_RETRIEVED", $desc="The ALPC message being canceled has already been retrieved from the queue on the other side."],
	[0x4000002F] = [$id="SYSTEM_POWERSTATE_TRANSITION", $desc="The system power state is transitioning from %2 to %3."],
	[0x40000030] = [$id="ALPC_CHECK_COMPLETION_LIST", $desc="The receive operation was successful. Check the ALPC completion list for the received message."],
	[0x40000031] = [$id="SYSTEM_POWERSTATE_COMPLEX_TRANSITION", $desc="The system power state is transitioning from %2 to %3 but could enter %4."],
	[0x40000032] = [$id="ACCESS_AUDIT_BY_POLICY", $desc="Access to %1 is monitored by policy rule %2."],
	[0x40000033] = [$id="ABANDON_HIBERFILE", $desc="A valid hibernation file has been invalidated and should be abandoned."],
	[0x40000034] = [$id="BIZRULES_NOT_ENABLED", $desc="Business rule scripts are disabled for the calling application."],
	[0x40000294] = [$id="WAKE_SYSTEM", $desc="The system has awoken."],
	[0x40000370] = [$id="DS_SHUTTING_DOWN", $desc="The directory service is shutting down."],
	[0x40010001] = [$id="DBG_REPLY_LATER", $desc="Debugger will reply later."],
	[0x40010002] = [$id="DBG_UNABLE_TO_PROVIDE_HANDLE", $desc="Debugger cannot provide a handle."],
	[0x40010003] = [$id="DBG_TERMINATE_THREAD", $desc="Debugger terminated the thread."],
	[0x40010004] = [$id="DBG_TERMINATE_PROCESS", $desc="Debugger terminated the process."],
	[0x40010005] = [$id="DBG_CONTROL_C", $desc="Debugger obtained control of C."],
	[0x40010006] = [$id="DBG_PRINTEXCEPTION_C", $desc="Debugger printed an exception on control C."],
	[0x40010007] = [$id="DBG_RIPEXCEPTION", $desc="Debugger received a RIP exception."],
	[0x40010008] = [$id="DBG_CONTROL_BREAK", $desc="Debugger received a control break."],
	[0x40010009] = [$id="DBG_COMMAND_EXCEPTION", $desc="Debugger command communication exception."],
	[0x40020056] = [$id="RPC_NT_UUID_LOCAL_ONLY", $desc="A UUID that is valid only on this computer has been allocated."],
	[0x400200AF] = [$id="RPC_NT_SEND_INCOMPLETE", $desc="Some data remains to be sent in the request buffer."],
	[0x400A0004] = [$id="CTX_CDM_CONNECT", $desc="The Client Drive Mapping Service has connected on Terminal Connection."],
	[0x400A0005] = [$id="CTX_CDM_DISCONNECT", $desc="The Client Drive Mapping Service has disconnected on Terminal Connection."],
	[0x4015000D] = [$id="SXS_RELEASE_ACTIVATION_CONTEXT", $desc="A kernel mode component is releasing a reference on an activation context."],
	[0x40190034] = [$id="RECOVERY_NOT_NEEDED", $desc="The transactional resource manager is already consistent. Recovery is not needed."],
	[0x40190035] = [$id="RM_ALREADY_STARTED", $desc="The transactional resource manager has already been started."],
	[0x401A000C] = [$id="LOG_NO_RESTART", $desc="The log service encountered a log stream with no restart area."],
	[0x401B00EC] = [$id="VIDEO_DRIVER_DEBUG_REPORT_REQUEST", $desc="{Display Driver Recovered From Failure} The %hs display driver has detected a failure and recovered from it. Some graphical operations may have failed. The next time you restart the machine, a dialog box appears, giving you an opportunity to upload data about this failure to Microsoft."],
	[0x401E000A] = [$id="GRAPHICS_PARTIAL_DATA_POPULATED", $desc="The specified buffer is not big enough to contain the entire requested dataset. Partial data is populated up to the size of the buffer."],
	[0x401E0117] = [$id="GRAPHICS_DRIVER_MISMATCH", $desc="The kernel driver detected a version mismatch between it and the user mode driver."],
	[0x401E0307] = [$id="GRAPHICS_MODE_NOT_PINNED", $desc="No mode is pinned on the specified VidPN source/target."],
	[0x401E031E] = [$id="GRAPHICS_NO_PREFERRED_MODE", $desc="The specified mode set does not specify a preference for one of its modes."],
	[0x401E034B] = [$id="GRAPHICS_DATASET_IS_EMPTY", $desc="The specified dataset (for example, mode set, frequency range set, descriptor set, or topology) is empty."],
	[0x401E034C] = [$id="GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET", $desc="The specified dataset (for example, mode set, frequency range set, descriptor set, or topology) does not contain any more elements."],
	[0x401E0351] = [$id="GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED", $desc="The specified content transformation is not pinned on the specified VidPN present path."],
	[0x401E042F] = [$id="GRAPHICS_UNKNOWN_CHILD_STATUS", $desc="The child device presence was not reliably detected."],
	[0x401E0437] = [$id="GRAPHICS_LEADLINK_START_DEFERRED", $desc="Starting the lead adapter in a linked configuration has been temporarily deferred."],
	[0x401E0439] = [$id="GRAPHICS_POLLING_TOO_FREQUENTLY", $desc="The display adapter is being polled for children too frequently at the same polling level."],
	[0x401E043A] = [$id="GRAPHICS_START_DEFERRED", $desc="Starting the adapter has been temporarily deferred."],
	[0x40230001] = [$id="NDIS_INDICATION_REQUIRED", $desc="The request will be completed later by an NDIS status indication."],
	[0x80000001] = [$id="GUARD_PAGE_VIOLATION", $desc="{EXCEPTION} Guard Page Exception A page of memory that marks the end of a data structure, such as a stack or an array, has been accessed."],
	[0x80000002] = [$id="DATATYPE_MISALIGNMENT", $desc="{EXCEPTION} Alignment Fault A data type misalignment was detected in a load or store instruction."],
	[0x80000003] = [$id="BREAKPOINT", $desc="{EXCEPTION} Breakpoint A breakpoint has been reached."],
	[0x80000004] = [$id="SINGLE_STEP", $desc="{EXCEPTION} Single Step A single step or trace operation has just been completed."],
	[0x80000005] = [$id="BUFFER_OVERFLOW", $desc="{Buffer Overflow} The data was too large to fit into the specified buffer."],
	[0x80000006] = [$id="NO_MORE_FILES", $desc="{No More Files} No more files were found which match the file specification."],
	[0x80000007] = [$id="WAKE_SYSTEM_DEBUGGER", $desc="{Kernel Debugger Awakened} The system debugger was awakened by an interrupt."],
	[0x8000000A] = [$id="HANDLES_CLOSED", $desc="{Handles Closed} Handles to objects have been automatically closed because of the requested operation."],
	[0x8000000B] = [$id="NO_INHERITANCE", $desc="{Non-Inheritable ACL} An access control list (ACL) contains no components that can be inherited."],
	[0x8000000C] = [$id="GUID_SUBSTITUTION_MADE", $desc="{GUID Substitution} During the translation of a globally unique identifier (GUID) to a Windows security ID (SID), no administratively defined GUID prefix was found. A substitute prefix was used, which will not compromise system security. However, this may provide a more restrictive access than intended."],
	[0x8000000D] = [$id="PARTIAL_COPY", $desc="Because of protection conflicts, not all the requested bytes could be copied."],
	[0x8000000E] = [$id="DEVICE_PAPER_EMPTY", $desc="{Out of Paper} The printer is out of paper."],
	[0x8000000F] = [$id="DEVICE_POWERED_OFF", $desc="{Device Power Is Off} The printer power has been turned off."],
	[0x80000010] = [$id="DEVICE_OFF_LINE", $desc="{Device Offline} The printer has been taken offline."],
	[0x80000011] = [$id="DEVICE_BUSY", $desc="{Device Busy} The device is currently busy."],
	[0x80000012] = [$id="NO_MORE_EAS", $desc="{No More EAs} No more extended attributes (EAs) were found for the file."],
	[0x80000013] = [$id="INVALID_EA_NAME", $desc="{Illegal EA} The specified extended attribute (EA) name contains at least one illegal character."],
	[0x80000014] = [$id="EA_LIST_INCONSISTENT", $desc="{Inconsistent EA List} The extended attribute (EA) list is inconsistent."],
	[0x80000015] = [$id="INVALID_EA_FLAG", $desc="{Invalid EA Flag} An invalid extended attribute (EA) flag was set."],
	[0x80000016] = [$id="VERIFY_REQUIRED", $desc="{Verifying Disk} The media has changed and a verify operation is in progress; therefore, no reads or writes may be performed to the device, except those that are used in the verify operation."],
	[0x80000017] = [$id="EXTRANEOUS_INFORMATION", $desc="{Too Much Information} The specified access control list (ACL) contained more information than was expected."],
	[0x80000018] = [$id="RXACT_COMMIT_NECESSARY", $desc="This warning level status indicates that the transaction state already exists for the registry subtree, but that a transaction commit was previously aborted. The commit has NOT been completed but has not been rolled back either; therefore, it may still be committed, if needed."],
	[0x8000001A] = [$id="NO_MORE_ENTRIES", $desc="{No More Entries} No more entries are available from an enumeration operation."],
	[0x8000001B] = [$id="FILEMARK_DETECTED", $desc="{Filemark Found} A filemark was detected."],
	[0x8000001C] = [$id="MEDIA_CHANGED", $desc="{Media Changed} The media may have changed."],
	[0x8000001D] = [$id="BUS_RESET", $desc="{I/O Bus Reset} An I/O bus reset was detected."],
	[0x8000001E] = [$id="END_OF_MEDIA", $desc="{End of Media} The end of the media was encountered."],
	[0x8000001F] = [$id="BEGINNING_OF_MEDIA", $desc="The beginning of a tape or partition has been detected."],
	[0x80000020] = [$id="MEDIA_CHECK", $desc="{Media Changed} The media may have changed."],
	[0x80000021] = [$id="SETMARK_DETECTED", $desc="A tape access reached a set mark."],
	[0x80000022] = [$id="NO_DATA_DETECTED", $desc="During a tape access, the end of the data written is reached."],
	[0x80000023] = [$id="REDIRECTOR_HAS_OPEN_HANDLES", $desc="The redirector is in use and cannot be unloaded."],
	[0x80000024] = [$id="SERVER_HAS_OPEN_HANDLES", $desc="The server is in use and cannot be unloaded."],
	[0x80000025] = [$id="ALREADY_DISCONNECTED", $desc="The specified connection has already been disconnected."],
	[0x80000026] = [$id="LONGJUMP", $desc="A long jump has been executed."],
	[0x80000027] = [$id="CLEANER_CARTRIDGE_INSTALLED", $desc="A cleaner cartridge is present in the tape library."],
	[0x80000028] = [$id="PLUGPLAY_QUERY_VETOED", $desc="The Plug and Play query operation was not successful."],
	[0x80000029] = [$id="UNWIND_CONSOLIDATE", $desc="A frame consolidation has been executed."],
	[0x8000002A] = [$id="REGISTRY_HIVE_RECOVERED", $desc="{Registry Hive Recovered} The registry hive (file): %hs was corrupted and it has been recovered. Some data might have been lost."],
	[0x8000002B] = [$id="DLL_MIGHT_BE_INSECURE", $desc="The application is attempting to run executable code from the module %hs. This may be insecure. An alternative, %hs, is available. Should the application use the secure module %hs?"],
	[0x8000002C] = [$id="DLL_MIGHT_BE_INCOMPATIBLE", $desc="The application is loading executable code from the module %hs. This is secure but may be incompatible with previous releases of the operating system. An alternative, %hs, is available. Should the application use the secure module %hs?"],
	[0x8000002D] = [$id="STOPPED_ON_SYMLINK", $desc="The create operation stopped after reaching a symbolic link."],
	[0x80000288] = [$id="DEVICE_REQUIRES_CLEANING", $desc="The device has indicated that cleaning is necessary."],
	[0x80000289] = [$id="DEVICE_DOOR_OPEN", $desc="The device has indicated that its door is open. Further operations require it closed and secured."],
	[0x80000803] = [$id="DATA_LOST_REPAIR", $desc="0x80010001<br />DBG_EXCEPTION_NOT_HANDLED"],
	[0x80130001] = [$id="CLUSTER_NODE_ALREADY_UP", $desc="The cluster node is already up."],
	[0x80130002] = [$id="CLUSTER_NODE_ALREADY_DOWN", $desc="The cluster node is already down."],
	[0x80130003] = [$id="CLUSTER_NETWORK_ALREADY_ONLINE", $desc="The cluster network is already online."],
	[0x80130004] = [$id="CLUSTER_NETWORK_ALREADY_OFFLINE", $desc="The cluster network is already offline."],
	[0x80130005] = [$id="CLUSTER_NODE_ALREADY_MEMBER", $desc="The cluster node is already a member of the cluster."],
	[0x80190009] = [$id="COULD_NOT_RESIZE_LOG", $desc="The log could not be set to the requested size."],
	[0x80190029] = [$id="NO_TXF_METADATA", $desc="There is no transaction metadata on the file."],
	[0x80190031] = [$id="CANT_RECOVER_WITH_HANDLE_OPEN", $desc="The file cannot be recovered because there is a handle still open on it."],
	[0x80190041] = [$id="TXF_METADATA_ALREADY_PRESENT", $desc="Transaction metadata is already present on this file and cannot be superseded."],
	[0x80190042] = [$id="TRANSACTION_SCOPE_CALLBACKS_NOT_SET", $desc="A transaction scope could not be entered because the scope handler has not been initialized."],
	[0x801B00EB] = [$id="VIDEO_HUNG_DISPLAY_DRIVER_THREAD_RECOVERED", $desc="{Display Driver Stopped Responding and recovered} The %hs display driver has stopped working normally. The recovery had been performed."],
	[0x801C0001] = [$id="FLT_BUFFER_TOO_SMALL", $desc="{Buffer too small} The buffer is too small to contain the entry. No information has been written to the buffer."],
	[0x80210001] = [$id="FVE_PARTIAL_METADATA", $desc="Volume metadata read or write is incomplete."],
	[0x80210002] = [$id="FVE_TRANSIENT_STATE", $desc="BitLocker encryption keys were ignored because the volume was in a transient state."],
	[0xC0000001] = [$id="UNSUCCESSFUL", $desc="{Operation Failed} The requested operation was unsuccessful."],
	[0xC0000002] = [$id="NOT_IMPLEMENTED", $desc="{Not Implemented} The requested operation is not implemented."],
	[0xC0000003] = [$id="INVALID_INFO_CLASS", $desc="{Invalid Parameter} The specified information class is not a valid information class for the specified object."],
	[0xC0000004] = [$id="INFO_LENGTH_MISMATCH", $desc="The specified information record length does not match the length that is required for the specified information class."],
	[0xC0000005] = [$id="ACCESS_VIOLATION", $desc="The instruction at 0x%08lx referenced memory at 0x%08lx. The memory could not be %s."],
	[0xC0000006] = [$id="IN_PAGE_ERROR", $desc="The instruction at 0x%08lx referenced memory at 0x%08lx. The required data was not placed into memory because of an I/O error status of 0x%08lx."],
	[0xC0000007] = [$id="PAGEFILE_QUOTA", $desc="The page file quota for the process has been exhausted."],
	[0xC0000008] = [$id="INVALID_HANDLE", $desc="An invalid HANDLE was specified."],
	[0xC0000009] = [$id="BAD_INITIAL_STACK", $desc="An invalid initial stack was specified in a call to NtCreateThread."],
	[0xC000000A] = [$id="BAD_INITIAL_PC", $desc="An invalid initial start address was specified in a call to NtCreateThread."],
	[0xC000000B] = [$id="INVALID_CID", $desc="An invalid client ID was specified."],
	[0xC000000C] = [$id="TIMER_NOT_CANCELED", $desc="An attempt was made to cancel or set a timer that has an associated APC and the specified thread is not the thread that originally set the timer with an associated APC routine."],
	[0xC000000D] = [$id="INVALID_PARAMETER", $desc="An invalid parameter was passed to a service or function."],
	[0xC000000E] = [$id="NO_SUCH_DEVICE", $desc="A device that does not exist was specified."],
	[0xC000000F] = [$id="NO_SUCH_FILE", $desc="{File Not Found} The file %hs does not exist."],
	[0xC0000010] = [$id="INVALID_DEVICE_REQUEST", $desc="The specified request is not a valid operation for the target device."],
	[0xC0000011] = [$id="END_OF_FILE", $desc="The end-of-file marker has been reached. There is no valid data in the file beyond this marker."],
	[0xC0000012] = [$id="WRONG_VOLUME", $desc="{Wrong Volume} The wrong volume is in the drive. Insert volume %hs into drive %hs."],
	[0xC0000013] = [$id="NO_MEDIA_IN_DEVICE", $desc="{No Disk} There is no disk in the drive. Insert a disk into drive %hs."],
	[0xC0000014] = [$id="UNRECOGNIZED_MEDIA", $desc="{Unknown Disk Format} The disk in drive %hs is not formatted properly. Check the disk, and reformat it, if needed."],
	[0xC0000015] = [$id="NONEXISTENT_SECTOR", $desc="{Sector Not Found} The specified sector does not exist."],
	[0xC0000016] = [$id="MORE_PROCESSING_REQUIRED", $desc="{Still Busy} The specified I/O request packet (IRP) cannot be disposed of because the I/O operation is not complete."],
	[0xC0000017] = [$id="NO_MEMORY", $desc="{Not Enough Quota} Not enough virtual memory or paging file quota is available to complete the specified operation."],
	[0xC0000018] = [$id="CONFLICTING_ADDRESSES", $desc="{Conflicting Address Range} The specified address range conflicts with the address space."],
	[0xC0000019] = [$id="NOT_MAPPED_VIEW", $desc="The address range to unmap is not a mapped view."],
	[0xC000001A] = [$id="UNABLE_TO_FREE_VM", $desc="The virtual memory cannot be freed."],
	[0xC000001B] = [$id="UNABLE_TO_DELETE_SECTION", $desc="The specified section cannot be deleted."],
	[0xC000001C] = [$id="INVALID_SYSTEM_SERVICE", $desc="An invalid system service was specified in a system service call."],
	[0xC000001D] = [$id="ILLEGAL_INSTRUCTION", $desc="{EXCEPTION} Illegal Instruction An attempt was made to execute an illegal instruction."],
	[0xC000001E] = [$id="INVALID_LOCK_SEQUENCE", $desc="{Invalid Lock Sequence} An attempt was made to execute an invalid lock sequence."],
	[0xC000001F] = [$id="INVALID_VIEW_SIZE", $desc="{Invalid Mapping} An attempt was made to create a view for a section that is bigger than the section."],
	[0xC0000020] = [$id="INVALID_FILE_FOR_SECTION", $desc="{Bad File} The attributes of the specified mapping file for a section of memory cannot be read."],
	[0xC0000021] = [$id="ALREADY_COMMITTED", $desc="{Already Committed} The specified address range is already committed."],
	[0xC0000022] = [$id="ACCESS_DENIED", $desc="{Access Denied} A process has requested access to an object but has not been granted those access rights."],
	[0xC0000023] = [$id="BUFFER_TOO_SMALL", $desc="{Buffer Too Small} The buffer is too small to contain the entry. No information has been written to the buffer."],
	[0xC0000024] = [$id="OBJECT_TYPE_MISMATCH", $desc="{Wrong Type} There is a mismatch between the type of object that is required by the requested operation and the type of object that is specified in the request."],
	[0xC0000025] = [$id="NONCONTINUABLE_EXCEPTION", $desc="{EXCEPTION} Cannot Continue Windows cannot continue from this exception."],
	[0xC0000026] = [$id="INVALID_DISPOSITION", $desc="An invalid exception disposition was returned by an exception handler."],
	[0xC0000027] = [$id="UNWIND", $desc="Unwind exception code."],
	[0xC0000028] = [$id="BAD_STACK", $desc="An invalid or unaligned stack was encountered during an unwind operation."],
	[0xC0000029] = [$id="INVALID_UNWIND_TARGET", $desc="An invalid unwind target was encountered during an unwind operation."],
	[0xC000002A] = [$id="NOT_LOCKED", $desc="An attempt was made to unlock a page of memory that was not locked."],
	[0xC000002B] = [$id="PARITY_ERROR", $desc="A device parity error on an I/O operation."],
	[0xC000002C] = [$id="UNABLE_TO_DECOMMIT_VM", $desc="An attempt was made to decommit uncommitted virtual memory."],
	[0xC000002D] = [$id="NOT_COMMITTED", $desc="An attempt was made to change the attributes on memory that has not been committed."],
	[0xC000002E] = [$id="INVALID_PORT_ATTRIBUTES", $desc="Invalid object attributes specified to NtCreatePort or invalid port attributes specified to NtConnectPort."],
	[0xC000002F] = [$id="PORT_MESSAGE_TOO_LONG", $desc="The length of the message that was passed to NtRequestPort or NtRequestWaitReplyPort is longer than the maximum message that is allowed by the port."],
	[0xC0000030] = [$id="INVALID_PARAMETER_MIX", $desc="An invalid combination of parameters was specified."],
	[0xC0000031] = [$id="INVALID_QUOTA_LOWER", $desc="An attempt was made to lower a quota limit below the current usage."],
	[0xC0000032] = [$id="DISK_CORRUPT_ERROR", $desc="{Corrupt Disk} The file system structure on the disk is corrupt and unusable. Run the Chkdsk utility on the volume %hs."],
	[0xC0000033] = [$id="OBJECT_NAME_INVALID", $desc="The object name is invalid."],
	[0xC0000034] = [$id="OBJECT_NAME_NOT_FOUND", $desc="The object name is not found."],
	[0xC0000035] = [$id="OBJECT_NAME_COLLISION", $desc="The object name already exists."],
	[0xC0000037] = [$id="PORT_DISCONNECTED", $desc="An attempt was made to send a message to a disconnected communication port."],
	[0xC0000038] = [$id="DEVICE_ALREADY_ATTACHED", $desc="An attempt was made to attach to a device that was already attached to another device."],
	[0xC0000039] = [$id="OBJECT_PATH_INVALID", $desc="The object path component was not a directory object."],
	[0xC000003A] = [$id="OBJECT_PATH_NOT_FOUND", $desc="{Path Not Found} The path %hs does not exist."],
	[0xC000003B] = [$id="OBJECT_PATH_SYNTAX_BAD", $desc="The object path component was not a directory object."],
	[0xC000003C] = [$id="DATA_OVERRUN", $desc="{Data Overrun} A data overrun error occurred."],
	[0xC000003D] = [$id="DATA_LATE_ERROR", $desc="{Data Late} A data late error occurred."],
	[0xC000003E] = [$id="DATA_ERROR", $desc="{Data Error} An error occurred in reading or writing data."],
	[0xC000003F] = [$id="CRC_ERROR", $desc="{Bad CRC} A cyclic redundancy check (CRC) checksum error occurred."],
	[0xC0000040] = [$id="SECTION_TOO_BIG", $desc="{Section Too Large} The specified section is too big to map the file."],
	[0xC0000041] = [$id="PORT_CONNECTION_REFUSED", $desc="The NtConnectPort request is refused."],
	[0xC0000042] = [$id="INVALID_PORT_HANDLE", $desc="The type of port handle is invalid for the operation that is requested."],
	[0xC0000043] = [$id="SHARING_VIOLATION", $desc="A file cannot be opened because the share access flags are incompatible."],
	[0xC0000044] = [$id="QUOTA_EXCEEDED", $desc="Insufficient quota exists to complete the operation."],
	[0xC0000045] = [$id="INVALID_PAGE_PROTECTION", $desc="The specified page protection was not valid."],
	[0xC0000046] = [$id="MUTANT_NOT_OWNED", $desc="An attempt to release a mutant object was made by a thread that was not the owner of the mutant object."],
	[0xC0000047] = [$id="SEMAPHORE_LIMIT_EXCEEDED", $desc="An attempt was made to release a semaphore such that its maximum count would have been exceeded."],
	[0xC0000048] = [$id="PORT_ALREADY_SET", $desc="An attempt was made to set the DebugPort or ExceptionPort of a process, but a port already exists in the process, or an attempt was made to set the CompletionPort of a file but a port was already set in the file, or an attempt was made to set the associated completion port of an ALPC port but it is already set."],
	[0xC0000049] = [$id="SECTION_NOT_IMAGE", $desc="An attempt was made to query image information on a section that does not map an image."],
	[0xC000004A] = [$id="SUSPEND_COUNT_EXCEEDED", $desc="An attempt was made to suspend a thread whose suspend count was at its maximum."],
	[0xC000004B] = [$id="THREAD_IS_TERMINATING", $desc="An attempt was made to suspend a thread that has begun termination."],
	[0xC000004C] = [$id="BAD_WORKING_SET_LIMIT", $desc="An attempt was made to set the working set limit to an invalid value (for example, the minimum greater than maximum)."],
	[0xC000004D] = [$id="INCOMPATIBLE_FILE_MAP", $desc="A section was created to map a file that is not compatible with an already existing section that maps the same file."],
	[0xC000004E] = [$id="SECTION_PROTECTION", $desc="A view to a section specifies a protection that is incompatible with the protection of the initial view."],
	[0xC000004F] = [$id="EAS_NOT_SUPPORTED", $desc="An operation involving EAs failed because the file system does not support EAs."],
	[0xC0000050] = [$id="EA_TOO_LARGE", $desc="An EA operation failed because the EA set is too large."],
	[0xC0000051] = [$id="NONEXISTENT_EA_ENTRY", $desc="An EA operation failed because the name or EA index is invalid."],
	[0xC0000052] = [$id="NO_EAS_ON_FILE", $desc="The file for which EAs were requested has no EAs."],
	[0xC0000053] = [$id="EA_CORRUPT_ERROR", $desc="The EA is corrupt and cannot be read."],
	[0xC0000054] = [$id="FILE_LOCK_CONFLICT", $desc="A requested read/write cannot be granted due to a conflicting file lock."],
	[0xC0000055] = [$id="LOCK_NOT_GRANTED", $desc="A requested file lock cannot be granted due to other existing locks."],
	[0xC0000056] = [$id="DELETE_PENDING", $desc="A non-close operation has been requested of a file object that has a delete pending."],
	[0xC0000057] = [$id="CTL_FILE_NOT_SUPPORTED", $desc="An attempt was made to set the control attribute on a file. This attribute is not supported in the destination file system."],
	[0xC0000058] = [$id="UNKNOWN_REVISION", $desc="Indicates a revision number that was encountered or specified is not one that is known by the service. It may be a more recent revision than the service is aware of."],
	[0xC0000059] = [$id="REVISION_MISMATCH", $desc="Indicates that two revision levels are incompatible."],
	[0xC000005A] = [$id="INVALID_OWNER", $desc="Indicates a particular security ID may not be assigned as the owner of an object."],
	[0xC000005B] = [$id="INVALID_PRIMARY_GROUP", $desc="Indicates a particular security ID may not be assigned as the primary group of an object."],
	[0xC000005C] = [$id="NO_IMPERSONATION_TOKEN", $desc="An attempt has been made to operate on an impersonation token by a thread that is not currently impersonating a client."],
	[0xC000005D] = [$id="CANT_DISABLE_MANDATORY", $desc="A mandatory group may not be disabled."],
	[0xC000005E] = [$id="NO_LOGON_SERVERS", $desc="No logon servers are currently available to service the logon request."],
	[0xC000005F] = [$id="NO_SUCH_LOGON_SESSION", $desc="A specified logon session does not exist. It may already have been terminated."],
	[0xC0000060] = [$id="NO_SUCH_PRIVILEGE", $desc="A specified privilege does not exist."],
	[0xC0000061] = [$id="PRIVILEGE_NOT_HELD", $desc="A required privilege is not held by the client."],
	[0xC0000062] = [$id="INVALID_ACCOUNT_NAME", $desc="The name provided is not a properly formed account name."],
	[0xC0000063] = [$id="USER_EXISTS", $desc="The specified account already exists."],
	[0xC0000064] = [$id="NO_SUCH_USER", $desc="The specified account does not exist."],
	[0xC0000065] = [$id="GROUP_EXISTS", $desc="The specified group already exists."],
	[0xC0000066] = [$id="NO_SUCH_GROUP", $desc="The specified group does not exist."],
	[0xC0000067] = [$id="MEMBER_IN_GROUP", $desc="The specified user account is already in the specified group account. Also used to indicate a group cannot be deleted because it contains a member."],
	[0xC0000068] = [$id="MEMBER_NOT_IN_GROUP", $desc="The specified user account is not a member of the specified group account."],
	[0xC0000069] = [$id="LAST_ADMIN", $desc="Indicates the requested operation would disable or delete the last remaining administration account. This is not allowed to prevent creating a situation in which the system cannot be administrated."],
	[0xC000006A] = [$id="WRONG_PASSWORD", $desc="When trying to update a password, this return status indicates that the value provided as the current password is not correct."],
	[0xC000006B] = [$id="ILL_FORMED_PASSWORD", $desc="When trying to update a password, this return status indicates that the value provided for the new password contains values that are not allowed in passwords."],
	[0xC000006C] = [$id="PASSWORD_RESTRICTION", $desc="When trying to update a password, this status indicates that some password update rule has been violated. For example, the password may not meet length criteria."],
	[0xC000006D] = [$id="LOGON_FAILURE", $desc="The attempted logon is invalid. This is either due to a bad username or authentication information."],
	[0xC000006E] = [$id="ACCOUNT_RESTRICTION", $desc="Indicates a referenced user name and authentication information are valid, but some user account restriction has prevented successful authentication (such as time-of-day restrictions)."],
	[0xC000006F] = [$id="INVALID_LOGON_HOURS", $desc="The user account has time restrictions and may not be logged onto at this time."],
	[0xC0000070] = [$id="INVALID_WORKSTATION", $desc="The user account is restricted so that it may not be used to log on from the source workstation."],
	[0xC0000071] = [$id="PASSWORD_EXPIRED", $desc="The user account password has expired."],
	[0xC0000072] = [$id="ACCOUNT_DISABLED", $desc="The referenced account is currently disabled and may not be logged on to."],
	[0xC0000073] = [$id="NONE_MAPPED", $desc="None of the information to be translated has been translated."],
	[0xC0000074] = [$id="TOO_MANY_LUIDS_REQUESTED", $desc="The number of LUIDs requested may not be allocated with a single allocation."],
	[0xC0000075] = [$id="LUIDS_EXHAUSTED", $desc="Indicates there are no more LUIDs to allocate."],
	[0xC0000076] = [$id="INVALID_SUB_AUTHORITY", $desc="Indicates the sub-authority value is invalid for the particular use."],
	[0xC0000077] = [$id="INVALID_ACL", $desc="Indicates the ACL structure is not valid."],
	[0xC0000078] = [$id="INVALID_SID", $desc="Indicates the SID structure is not valid."],
	[0xC0000079] = [$id="INVALID_SECURITY_DESCR", $desc="Indicates the SECURITY_DESCRIPTOR structure is not valid."],
	[0xC000007A] = [$id="PROCEDURE_NOT_FOUND", $desc="Indicates the specified procedure address cannot be found in the DLL."],
	[0xC000007B] = [$id="INVALID_IMAGE_FORMAT", $desc="{Bad Image} %hs is either not designed to run on Windows or it contains an error. Try installing the program again using the original installation media or contact your system administrator or the software vendor for support."],
	[0xC000007C] = [$id="NO_TOKEN", $desc="An attempt was made to reference a token that does not exist. This is typically done by referencing the token that is associated with a thread when the thread is not impersonating a client."],
	[0xC000007D] = [$id="BAD_INHERITANCE_ACL", $desc="Indicates that an attempt to build either an inherited ACL or ACE was not successful. This can be caused by a number of things. One of the more probable causes is the replacement of a CreatorId with a SID that did not fit into the ACE or ACL."],
	[0xC000007E] = [$id="RANGE_NOT_LOCKED", $desc="The range specified in NtUnlockFile was not locked."],
	[0xC000007F] = [$id="DISK_FULL", $desc="An operation failed because the disk was full."],
	[0xC0000080] = [$id="SERVER_DISABLED", $desc="The GUID allocation server is disabled at the moment."],
	[0xC0000081] = [$id="SERVER_NOT_DISABLED", $desc="The GUID allocation server is enabled at the moment."],
	[0xC0000082] = [$id="TOO_MANY_GUIDS_REQUESTED", $desc="Too many GUIDs were requested from the allocation server at once."],
	[0xC0000083] = [$id="GUIDS_EXHAUSTED", $desc="The GUIDs could not be allocated because the Authority Agent was exhausted."],
	[0xC0000084] = [$id="INVALID_ID_AUTHORITY", $desc="The value provided was an invalid value for an identifier authority."],
	[0xC0000085] = [$id="AGENTS_EXHAUSTED", $desc="No more authority agent values are available for the particular identifier authority value."],
	[0xC0000086] = [$id="INVALID_VOLUME_LABEL", $desc="An invalid volume label has been specified."],
	[0xC0000087] = [$id="SECTION_NOT_EXTENDED", $desc="A mapped section could not be extended."],
	[0xC0000088] = [$id="NOT_MAPPED_DATA", $desc="Specified section to flush does not map a data file."],
	[0xC0000089] = [$id="RESOURCE_DATA_NOT_FOUND", $desc="Indicates the specified image file did not contain a resource section."],
	[0xC000008A] = [$id="RESOURCE_TYPE_NOT_FOUND", $desc="Indicates the specified resource type cannot be found in the image file."],
	[0xC000008B] = [$id="RESOURCE_NAME_NOT_FOUND", $desc="Indicates the specified resource name cannot be found in the image file."],
	[0xC000008C] = [$id="ARRAY_BOUNDS_EXCEEDED", $desc="{EXCEPTION} Array bounds exceeded."],
	[0xC000008D] = [$id="FLOAT_DENORMAL_OPERAND", $desc="{EXCEPTION} Floating-point denormal operand."],
	[0xC000008E] = [$id="FLOAT_DIVIDE_BY_ZERO", $desc="{EXCEPTION} Floating-point division by zero."],
	[0xC000008F] = [$id="FLOAT_INEXACT_RESULT", $desc="{EXCEPTION} Floating-point inexact result."],
	[0xC0000090] = [$id="FLOAT_INVALID_OPERATION", $desc="{EXCEPTION} Floating-point invalid operation."],
	[0xC0000091] = [$id="FLOAT_OVERFLOW", $desc="{EXCEPTION} Floating-point overflow."],
	[0xC0000092] = [$id="FLOAT_STACK_CHECK", $desc="{EXCEPTION} Floating-point stack check."],
	[0xC0000093] = [$id="FLOAT_UNDERFLOW", $desc="{EXCEPTION} Floating-point underflow."],
	[0xC0000094] = [$id="INTEGER_DIVIDE_BY_ZERO", $desc="{EXCEPTION} Integer division by zero."],
	[0xC0000095] = [$id="INTEGER_OVERFLOW", $desc="{EXCEPTION} Integer overflow."],
	[0xC0000096] = [$id="PRIVILEGED_INSTRUCTION", $desc="{EXCEPTION} Privileged instruction."],
	[0xC0000097] = [$id="TOO_MANY_PAGING_FILES", $desc="An attempt was made to install more paging files than the system supports."],
	[0xC0000098] = [$id="FILE_INVALID", $desc="The volume for a file has been externally altered such that the opened file is no longer valid."],
	[0xC0000099] = [$id="ALLOTTED_SPACE_EXCEEDED", $desc="When a block of memory is allotted for future updates, such as the memory allocated to hold discretionary access control and primary group information, successive updates may exceed the amount of memory originally allotted. Because a quota may already have been charged to several processes that have handles to the object, it is not reasonable to alter the size of the allocated memory. Instead, a request that requires more memory than has been allotted must fail and the STATUS_ALLOTTED_SPACE_EXCEEDED error returned."],
	[0xC000009A] = [$id="INSUFFICIENT_RESOURCES", $desc="Insufficient system resources exist to complete the API."],
	[0xC000009B] = [$id="DFS_EXIT_PATH_FOUND", $desc="An attempt has been made to open a DFS exit path control file."],
	[0xC000009C] = [$id="DEVICE_DATA_ERROR", $desc="There are bad blocks (sectors) on the hard disk."],
	[0xC000009D] = [$id="DEVICE_NOT_CONNECTED", $desc="There is bad cabling, non-termination, or the controller is not able to obtain access to the hard disk."],
	[0xC000009F] = [$id="FREE_VM_NOT_AT_BASE", $desc="Virtual memory cannot be freed because the base address is not the base of the region and a region size of zero was specified."],
	[0xC00000A0] = [$id="MEMORY_NOT_ALLOCATED", $desc="An attempt was made to free virtual memory that is not allocated."],
	[0xC00000A1] = [$id="WORKING_SET_QUOTA", $desc="The working set is not big enough to allow the requested pages to be locked."],
	[0xC00000A2] = [$id="MEDIA_WRITE_PROTECTED", $desc="{Write Protect Error} The disk cannot be written to because it is write-protected. Remove the write protection from the volume %hs in drive %hs."],
	[0xC00000A3] = [$id="DEVICE_NOT_READY", $desc="{Drive Not Ready} The drive is not ready for use; its door may be open. Check drive %hs and make sure that a disk is inserted and that the drive door is closed."],
	[0xC00000A4] = [$id="INVALID_GROUP_ATTRIBUTES", $desc="The specified attributes are invalid or are incompatible with the attributes for the group as a whole."],
	[0xC00000A5] = [$id="BAD_IMPERSONATION_LEVEL", $desc="A specified impersonation level is invalid. Also used to indicate that a required impersonation level was not provided."],
	[0xC00000A6] = [$id="CANT_OPEN_ANONYMOUS", $desc="An attempt was made to open an anonymous-level token. Anonymous tokens may not be opened."],
	[0xC00000A7] = [$id="BAD_VALIDATION_CLASS", $desc="The validation information class requested was invalid."],
	[0xC00000A8] = [$id="BAD_TOKEN_TYPE", $desc="The type of a token object is inappropriate for its attempted use."],
	[0xC00000A9] = [$id="BAD_MASTER_BOOT_RECORD", $desc="The type of a token object is inappropriate for its attempted use."],
	[0xC00000AA] = [$id="INSTRUCTION_MISALIGNMENT", $desc="An attempt was made to execute an instruction at an unaligned address and the host system does not support unaligned instruction references."],
	[0xC00000AB] = [$id="INSTANCE_NOT_AVAILABLE", $desc="The maximum named pipe instance count has been reached."],
	[0xC00000AC] = [$id="PIPE_NOT_AVAILABLE", $desc="An instance of a named pipe cannot be found in the listening state."],
	[0xC00000AD] = [$id="INVALID_PIPE_STATE", $desc="The named pipe is not in the connected or closing state."],
	[0xC00000AE] = [$id="PIPE_BUSY", $desc="The specified pipe is set to complete operations and there are current I/O operations queued so that it cannot be changed to queue operations."],
	[0xC00000AF] = [$id="ILLEGAL_FUNCTION", $desc="The specified handle is not open to the server end of the named pipe."],
	[0xC00000B0] = [$id="PIPE_DISCONNECTED", $desc="The specified named pipe is in the disconnected state."],
	[0xC00000B1] = [$id="PIPE_CLOSING", $desc="The specified named pipe is in the closing state."],
	[0xC00000B2] = [$id="PIPE_CONNECTED", $desc="The specified named pipe is in the connected state."],
	[0xC00000B3] = [$id="PIPE_LISTENING", $desc="The specified named pipe is in the listening state."],
	[0xC00000B4] = [$id="INVALID_READ_MODE", $desc="The specified named pipe is not in message mode."],
	[0xC00000B5] = [$id="IO_TIMEOUT", $desc="{Device Timeout} The specified I/O operation on %hs was not completed before the time-out period expired."],
	[0xC00000B6] = [$id="FILE_FORCED_CLOSED", $desc="The specified file has been closed by another process."],
	[0xC00000B7] = [$id="PROFILING_NOT_STARTED", $desc="Profiling is not started."],
	[0xC00000B8] = [$id="PROFILING_NOT_STOPPED", $desc="Profiling is not stopped."],
	[0xC00000B9] = [$id="COULD_NOT_INTERPRET", $desc="The passed ACL did not contain the minimum required information."],
	[0xC00000BA] = [$id="FILE_IS_A_DIRECTORY", $desc="The file that was specified as a target is a directory, and the caller specified that it could be anything but a directory."],
	[0xC00000BB] = [$id="NOT_SUPPORTED", $desc="The request is not supported."],
	[0xC00000BC] = [$id="REMOTE_NOT_LISTENING", $desc="This remote computer is not listening."],
	[0xC00000BD] = [$id="DUPLICATE_NAME", $desc="A duplicate name exists on the network."],
	[0xC00000BE] = [$id="BAD_NETWORK_PATH", $desc="The network path cannot be located."],
	[0xC00000BF] = [$id="NETWORK_BUSY", $desc="The network is busy."],
	[0xC00000C0] = [$id="DEVICE_DOES_NOT_EXIST", $desc="This device does not exist."],
	[0xC00000C1] = [$id="TOO_MANY_COMMANDS", $desc="The network BIOS command limit has been reached."],
	[0xC00000C2] = [$id="ADAPTER_HARDWARE_ERROR", $desc="An I/O adapter hardware error has occurred."],
	[0xC00000C3] = [$id="INVALID_NETWORK_RESPONSE", $desc="The network responded incorrectly."],
	[0xC00000C4] = [$id="UNEXPECTED_NETWORK_ERROR", $desc="An unexpected network error occurred."],
	[0xC00000C5] = [$id="BAD_REMOTE_ADAPTER", $desc="The remote adapter is not compatible."],
	[0xC00000C6] = [$id="PRINT_QUEUE_FULL", $desc="The print queue is full."],
	[0xC00000C7] = [$id="NO_SPOOL_SPACE", $desc="Space to store the file that is waiting to be printed is not available on the server."],
	[0xC00000C8] = [$id="PRINT_CANCELLED", $desc="The requested print file has been canceled."],
	[0xC00000C9] = [$id="NETWORK_NAME_DELETED", $desc="The network name was deleted."],
	[0xC00000CA] = [$id="NETWORK_ACCESS_DENIED", $desc="Network access is denied."],
	[0xC00000CB] = [$id="BAD_DEVICE_TYPE", $desc="{Incorrect Network Resource Type} The specified device type (LPT, for example) conflicts with the actual device type on the remote resource."],
	[0xC00000CC] = [$id="BAD_NETWORK_NAME", $desc="{Network Name Not Found} The specified share name cannot be found on the remote server."],
	[0xC00000CD] = [$id="TOO_MANY_NAMES", $desc="The name limit for the network adapter card of the local computer was exceeded."],
	[0xC00000CE] = [$id="TOO_MANY_SESSIONS", $desc="The network BIOS session limit was exceeded."],
	[0xC00000CF] = [$id="SHARING_PAUSED", $desc="File sharing has been temporarily paused."],
	[0xC00000D0] = [$id="REQUEST_NOT_ACCEPTED", $desc="No more connections can be made to this remote computer at this time because the computer has already accepted the maximum number of connections."],
	[0xC00000D1] = [$id="REDIRECTOR_PAUSED", $desc="Print or disk redirection is temporarily paused."],
	[0xC00000D2] = [$id="NET_WRITE_FAULT", $desc="A network data fault occurred."],
	[0xC00000D3] = [$id="PROFILING_AT_LIMIT", $desc="The number of active profiling objects is at the maximum and no more may be started."],
	[0xC00000D4] = [$id="NOT_SAME_DEVICE", $desc="{Incorrect Volume} The destination file of a rename request is located on a different device than the source of the rename request."],
	[0xC00000D5] = [$id="FILE_RENAMED", $desc="The specified file has been renamed and thus cannot be modified."],
	[0xC00000D6] = [$id="VIRTUAL_CIRCUIT_CLOSED", $desc="{Network Request Timeout} The session with a remote server has been disconnected because the time-out interval for a request has expired."],
	[0xC00000D7] = [$id="NO_SECURITY_ON_OBJECT", $desc="Indicates an attempt was made to operate on the security of an object that does not have security associated with it."],
	[0xC00000D8] = [$id="CANT_WAIT", $desc="Used to indicate that an operation cannot continue without blocking for I/O."],
	[0xC00000D9] = [$id="PIPE_EMPTY", $desc="Used to indicate that a read operation was done on an empty pipe."],
	[0xC00000DA] = [$id="CANT_ACCESS_DOMAIN_INFO", $desc="Configuration information could not be read from the domain controller, either because the machine is unavailable or access has been denied."],
	[0xC00000DB] = [$id="CANT_TERMINATE_SELF", $desc="Indicates that a thread attempted to terminate itself by default (called NtTerminateThread with NULL) and it was the last thread in the current process."],
	[0xC00000DC] = [$id="INVALID_SERVER_STATE", $desc="Indicates the Sam Server was in the wrong state to perform the desired operation."],
	[0xC00000DD] = [$id="INVALID_DOMAIN_STATE", $desc="Indicates the domain was in the wrong state to perform the desired operation."],
	[0xC00000DE] = [$id="INVALID_DOMAIN_ROLE", $desc="This operation is only allowed for the primary domain controller of the domain."],
	[0xC00000DF] = [$id="NO_SUCH_DOMAIN", $desc="The specified domain did not exist."],
	[0xC00000E0] = [$id="DOMAIN_EXISTS", $desc="The specified domain already exists."],
	[0xC00000E1] = [$id="DOMAIN_LIMIT_EXCEEDED", $desc="An attempt was made to exceed the limit on the number of domains per server for this release."],
	[0xC00000E2] = [$id="OPLOCK_NOT_GRANTED", $desc="An error status returned when the opportunistic lock (oplock) request is denied."],
	[0xC00000E3] = [$id="INVALID_OPLOCK_PROTOCOL", $desc="An error status returned when an invalid opportunistic lock (oplock) acknowledgment is received by a file system."],
	[0xC00000E4] = [$id="INTERNAL_DB_CORRUPTION", $desc="This error indicates that the requested operation cannot be completed due to a catastrophic media failure or an on-disk data structure corruption."],
	[0xC00000E5] = [$id="INTERNAL_ERROR", $desc="An internal error occurred."],
	[0xC00000E6] = [$id="GENERIC_NOT_MAPPED", $desc="Indicates generic access types were contained in an access mask which should already be mapped to non-generic access types."],
	[0xC00000E7] = [$id="BAD_DESCRIPTOR_FORMAT", $desc="Indicates a security descriptor is not in the necessary format (absolute or self-relative)."],
	[0xC00000E8] = [$id="INVALID_USER_BUFFER", $desc="An access to a user buffer failed at an expected point in time. This code is defined because the caller does not want to accept STATUS_ACCESS_VIOLATION in its filter."],
	[0xC00000E9] = [$id="UNEXPECTED_IO_ERROR", $desc="If an I/O error that is not defined in the standard FsRtl filter is returned, it is converted to the following error, which is guaranteed to be in the filter. In this case, information is lost; however, the filter correctly handles the exception."],
	[0xC00000EA] = [$id="UNEXPECTED_MM_CREATE_ERR", $desc="If an MM error that is not defined in the standard FsRtl filter is returned, it is converted to one of the following errors, which are guaranteed to be in the filter. In this case, information is lost; however, the filter correctly handles the exception."],
	[0xC00000EB] = [$id="UNEXPECTED_MM_MAP_ERROR", $desc="If an MM error that is not defined in the standard FsRtl filter is returned, it is converted to one of the following errors, which are guaranteed to be in the filter. In this case, information is lost; however, the filter correctly handles the exception."],
	[0xC00000EC] = [$id="UNEXPECTED_MM_EXTEND_ERR", $desc="If an MM error that is not defined in the standard FsRtl filter is returned, it is converted to one of the following errors, which are guaranteed to be in the filter. In this case, information is lost; however, the filter correctly handles the exception."],
	[0xC00000ED] = [$id="NOT_LOGON_PROCESS", $desc="The requested action is restricted for use by logon processes only. The calling process has not registered as a logon process."],
	[0xC00000EE] = [$id="LOGON_SESSION_EXISTS", $desc="An attempt has been made to start a new session manager or LSA logon session by using an ID that is already in use."],
	[0xC00000EF] = [$id="INVALID_PARAMETER_1", $desc="An invalid parameter was passed to a service or function as the first argument."],
	[0xC00000F0] = [$id="INVALID_PARAMETER_2", $desc="An invalid parameter was passed to a service or function as the second argument."],
	[0xC00000F1] = [$id="INVALID_PARAMETER_3", $desc="An invalid parameter was passed to a service or function as the third argument."],
	[0xC00000F2] = [$id="INVALID_PARAMETER_4", $desc="An invalid parameter was passed to a service or function as the fourth argument."],
	[0xC00000F3] = [$id="INVALID_PARAMETER_5", $desc="An invalid parameter was passed to a service or function as the fifth argument."],
	[0xC00000F4] = [$id="INVALID_PARAMETER_6", $desc="An invalid parameter was passed to a service or function as the sixth argument."],
	[0xC00000F5] = [$id="INVALID_PARAMETER_7", $desc="An invalid parameter was passed to a service or function as the seventh argument."],
	[0xC00000F6] = [$id="INVALID_PARAMETER_8", $desc="An invalid parameter was passed to a service or function as the eighth argument."],
	[0xC00000F7] = [$id="INVALID_PARAMETER_9", $desc="An invalid parameter was passed to a service or function as the ninth argument."],
	[0xC00000F8] = [$id="INVALID_PARAMETER_10", $desc="An invalid parameter was passed to a service or function as the tenth argument."],
	[0xC00000F9] = [$id="INVALID_PARAMETER_11", $desc="An invalid parameter was passed to a service or function as the eleventh argument."],
	[0xC00000FA] = [$id="INVALID_PARAMETER_12", $desc="An invalid parameter was passed to a service or function as the twelfth argument."],
	[0xC00000FB] = [$id="REDIRECTOR_NOT_STARTED", $desc="An attempt was made to access a network file, but the network software was not yet started."],
	[0xC00000FC] = [$id="REDIRECTOR_STARTED", $desc="An attempt was made to start the redirector, but the redirector has already been started."],
	[0xC00000FD] = [$id="STACK_OVERFLOW", $desc="A new guard page for the stack cannot be created."],
	[0xC00000FE] = [$id="NO_SUCH_PACKAGE", $desc="A specified authentication package is unknown."],
	[0xC00000FF] = [$id="BAD_FUNCTION_TABLE", $desc="A malformed function table was encountered during an unwind operation."],
	[0xC0000100] = [$id="VARIABLE_NOT_FOUND", $desc="Indicates the specified environment variable name was not found in the specified environment block."],
	[0xC0000101] = [$id="DIRECTORY_NOT_EMPTY", $desc="Indicates that the directory trying to be deleted is not empty."],
	[0xC0000102] = [$id="FILE_CORRUPT_ERROR", $desc="{Corrupt File} The file or directory %hs is corrupt and unreadable. Run the Chkdsk utility."],
	[0xC0000103] = [$id="NOT_A_DIRECTORY", $desc="A requested opened file is not a directory."],
	[0xC0000104] = [$id="BAD_LOGON_SESSION_STATE", $desc="The logon session is not in a state that is consistent with the requested operation."],
	[0xC0000105] = [$id="LOGON_SESSION_COLLISION", $desc="An internal LSA error has occurred. An authentication package has requested the creation of a logon session but the ID of an already existing logon session has been specified."],
	[0xC0000106] = [$id="NAME_TOO_LONG", $desc="A specified name string is too long for its intended use."],
	[0xC0000107] = [$id="FILES_OPEN", $desc="The user attempted to force close the files on a redirected drive, but there were opened files on the drive, and the user did not specify a sufficient level of force."],
	[0xC0000108] = [$id="CONNECTION_IN_USE", $desc="The user attempted to force close the files on a redirected drive, but there were opened directories on the drive, and the user did not specify a sufficient level of force."],
	[0xC0000109] = [$id="MESSAGE_NOT_FOUND", $desc="RtlFindMessage could not locate the requested message ID in the message table resource."],
	[0xC000010A] = [$id="PROCESS_IS_TERMINATING", $desc="An attempt was made to duplicate an object handle into or out of an exiting process."],
	[0xC000010B] = [$id="INVALID_LOGON_TYPE", $desc="Indicates an invalid value has been provided for the LogonType requested."],
	[0xC000010C] = [$id="NO_GUID_TRANSLATION", $desc="Indicates that an attempt was made to assign protection to a file system file or directory and one of the SIDs in the security descriptor could not be translated into a GUID that could be stored by the file system. This causes the protection attempt to fail, which may cause a file creation attempt to fail."],
	[0xC000010D] = [$id="CANNOT_IMPERSONATE", $desc="Indicates that an attempt has been made to impersonate via a named pipe that has not yet been read from."],
	[0xC000010E] = [$id="IMAGE_ALREADY_LOADED", $desc="Indicates that the specified image is already loaded."],
	[0xC0000117] = [$id="NO_LDT", $desc="Indicates that an attempt was made to change the size of the LDT for a process that has no LDT."],
	[0xC0000118] = [$id="INVALID_LDT_SIZE", $desc="Indicates that an attempt was made to grow an LDT by setting its size, or that the size was not an even number of selectors."],
	[0xC0000119] = [$id="INVALID_LDT_OFFSET", $desc="Indicates that the starting value for the LDT information was not an integral multiple of the selector size."],
	[0xC000011A] = [$id="INVALID_LDT_DESCRIPTOR", $desc="Indicates that the user supplied an invalid descriptor when trying to set up LDT descriptors."],
	[0xC000011B] = [$id="INVALID_IMAGE_NE_FORMAT", $desc="The specified image file did not have the correct format. It appears to be NE format."],
	[0xC000011C] = [$id="RXACT_INVALID_STATE", $desc="Indicates that the transaction state of a registry subtree is incompatible with the requested operation. For example, a request has been made to start a new transaction with one already in progress, or a request has been made to apply a transaction when one is not currently in progress."],
	[0xC000011D] = [$id="RXACT_COMMIT_FAILURE", $desc="Indicates an error has occurred during a registry transaction commit. The database has been left in an unknown, but probably inconsistent, state. The state of the registry transaction is left as COMMITTING."],
	[0xC000011E] = [$id="MAPPED_FILE_SIZE_ZERO", $desc="An attempt was made to map a file of size zero with the maximum size specified as zero."],
	[0xC000011F] = [$id="TOO_MANY_OPENED_FILES", $desc="Too many files are opened on a remote server. This error should only be returned by the Windows redirector on a remote drive."],
	[0xC0000120] = [$id="CANCELLED", $desc="The I/O request was canceled."],
	[0xC0000121] = [$id="CANNOT_DELETE", $desc="An attempt has been made to remove a file or directory that cannot be deleted."],
	[0xC0000122] = [$id="INVALID_COMPUTER_NAME", $desc="Indicates a name that was specified as a remote computer name is syntactically invalid."],
	[0xC0000123] = [$id="FILE_DELETED", $desc="An I/O request other than close was performed on a file after it was deleted, which can only happen to a request that did not complete before the last handle was closed via NtClose."],
	[0xC0000124] = [$id="SPECIAL_ACCOUNT", $desc="Indicates an operation that is incompatible with built-in accounts has been attempted on a built-in (special) SAM account. For example, built-in accounts cannot be deleted."],
	[0xC0000125] = [$id="SPECIAL_GROUP", $desc="The operation requested may not be performed on the specified group because it is a built-in special group."],
	[0xC0000126] = [$id="SPECIAL_USER", $desc="The operation requested may not be performed on the specified user because it is a built-in special user."],
	[0xC0000127] = [$id="MEMBERS_PRIMARY_GROUP", $desc="Indicates a member cannot be removed from a group because the group is currently the member's primary group."],
	[0xC0000128] = [$id="FILE_CLOSED", $desc="An I/O request other than close and several other special case operations was attempted using a file object that had already been closed."],
	[0xC0000129] = [$id="TOO_MANY_THREADS", $desc="Indicates a process has too many threads to perform the requested action. For example, assignment of a primary token may only be performed when a process has zero or one threads."],
	[0xC000012A] = [$id="THREAD_NOT_IN_PROCESS", $desc="An attempt was made to operate on a thread within a specific process, but the specified thread is not in the specified process."],
	[0xC000012B] = [$id="TOKEN_ALREADY_IN_USE", $desc="An attempt was made to establish a token for use as a primary token but the token is already in use. A token can only be the primary token of one process at a time."],
	[0xC000012C] = [$id="PAGEFILE_QUOTA_EXCEEDED", $desc="The page file quota was exceeded."],
	[0xC000012D] = [$id="COMMITMENT_LIMIT", $desc="{Out of Virtual Memory} Your system is low on virtual memory. To ensure that Windows runs correctly, increase the size of your virtual memory paging file. For more information, see Help."],
	[0xC000012E] = [$id="INVALID_IMAGE_LE_FORMAT", $desc="The specified image file did not have the correct format: it appears to be LE format."],
	[0xC000012F] = [$id="INVALID_IMAGE_NOT_MZ", $desc="The specified image file did not have the correct format: it did not have an initial MZ."],
	[0xC0000130] = [$id="INVALID_IMAGE_PROTECT", $desc="The specified image file did not have the correct format: it did not have a proper e_lfarlc in the MZ header."],
	[0xC0000131] = [$id="INVALID_IMAGE_WIN_16", $desc="The specified image file did not have the correct format: it appears to be a 16-bit Windows image."],
	[0xC0000132] = [$id="LOGON_SERVER_CONFLICT", $desc="The Netlogon service cannot start because another Netlogon service running in the domain conflicts with the specified role."],
	[0xC0000133] = [$id="TIME_DIFFERENCE_AT_DC", $desc="The time at the primary domain controller is different from the time at the backup domain controller or member server by too large an amount."],
	[0xC0000134] = [$id="SYNCHRONIZATION_REQUIRED", $desc="The SAM database on a Windows Server is significantly out of synchronization with the copy on the domain controller. A complete synchronization is required."],
	[0xC0000135] = [$id="DLL_NOT_FOUND", $desc="{Unable To Locate Component} This application has failed to start because %hs was not found. Reinstalling the application may fix this problem."],
	[0xC0000136] = [$id="OPEN_FAILED", $desc="The NtCreateFile API failed. This error should never be returned to an application; it is a place holder for the Windows LAN Manager Redirector to use in its internal error-mapping routines."],
	[0xC0000137] = [$id="IO_PRIVILEGE_FAILED", $desc="{Privilege Failed} The I/O permissions for the process could not be changed."],
	[0xC0000138] = [$id="ORDINAL_NOT_FOUND", $desc="{Ordinal Not Found} The ordinal %ld could not be located in the dynamic link library %hs."],
	[0xC0000139] = [$id="ENTRYPOINT_NOT_FOUND", $desc="{Entry Point Not Found} The procedure entry point %hs could not be located in the dynamic link library %hs."],
	[0xC000013A] = [$id="CONTROL_C_EXIT", $desc="{Application Exit by CTRL+C} The application terminated as a result of a CTRL+C."],
	[0xC000013B] = [$id="LOCAL_DISCONNECT", $desc="{Virtual Circuit Closed} The network transport on your computer has closed a network connection. There may or may not be I/O requests outstanding."],
	[0xC000013C] = [$id="REMOTE_DISCONNECT", $desc="{Virtual Circuit Closed} The network transport on a remote computer has closed a network connection. There may or may not be I/O requests outstanding."],
	[0xC000013D] = [$id="REMOTE_RESOURCES", $desc="{Insufficient Resources on Remote Computer} The remote computer has insufficient resources to complete the network request. For example, the remote computer may not have enough available memory to carry out the request at this time."],
	[0xC000013E] = [$id="LINK_FAILED", $desc="{Virtual Circuit Closed} An existing connection (virtual circuit) has been broken at the remote computer. There is probably something wrong with the network software protocol or the network hardware on the remote computer."],
	[0xC000013F] = [$id="LINK_TIMEOUT", $desc="{Virtual Circuit Closed} The network transport on your computer has closed a network connection because it had to wait too long for a response from the remote computer."],
	[0xC0000140] = [$id="INVALID_CONNECTION", $desc="The connection handle that was given to the transport was invalid."],
	[0xC0000141] = [$id="INVALID_ADDRESS", $desc="The address handle that was given to the transport was invalid."],
	[0xC0000142] = [$id="DLL_INIT_FAILED", $desc="{DLL Initialization Failed} Initialization of the dynamic link library %hs failed. The process is terminating abnormally."],
	[0xC0000143] = [$id="MISSING_SYSTEMFILE", $desc="{Missing System File} The required system file %hs is bad or missing."],
	[0xC0000144] = [$id="UNHANDLED_EXCEPTION", $desc="{Application Error} The exception %s (0x%08lx) occurred in the application at location 0x%08lx."],
	[0xC0000145] = [$id="APP_INIT_FAILURE", $desc="{Application Error} The application failed to initialize properly (0x%lx). Click OK to terminate the application."],
	[0xC0000146] = [$id="PAGEFILE_CREATE_FAILED", $desc="{Unable to Create Paging File} The creation of the paging file %hs failed (%lx). The requested size was %ld."],
	[0xC0000147] = [$id="NO_PAGEFILE", $desc="{No Paging File Specified} No paging file was specified in the system configuration."],
	[0xC0000148] = [$id="INVALID_LEVEL", $desc="{Incorrect System Call Level} An invalid level was passed into the specified system call."],
	[0xC0000149] = [$id="WRONG_PASSWORD_CORE", $desc="{Incorrect Password to LAN Manager Server} You specified an incorrect password to a LAN Manager 2.x or MS-NET server."],
	[0xC000014A] = [$id="ILLEGAL_FLOAT_CONTEXT", $desc="{EXCEPTION} A real-mode application issued a floating-point instruction and floating-point hardware is not present."],
	[0xC000014B] = [$id="PIPE_BROKEN", $desc="The pipe operation has failed because the other end of the pipe has been closed."],
	[0xC000014C] = [$id="REGISTRY_CORRUPT", $desc="{The Registry Is Corrupt} The structure of one of the files that contains registry data is corrupt; the image of the file in memory is corrupt; or the file could not be recovered because the alternate copy or log was absent or corrupt."],
	[0xC000014D] = [$id="REGISTRY_IO_FAILED", $desc="An I/O operation initiated by the Registry failed and cannot be recovered. The registry could not read in, write out, or flush one of the files that contain the system's image of the registry."],
	[0xC000014E] = [$id="NO_EVENT_PAIR", $desc="An event pair synchronization operation was performed using the thread-specific client/server event pair object, but no event pair object was associated with the thread."],
	[0xC000014F] = [$id="UNRECOGNIZED_VOLUME", $desc="The volume does not contain a recognized file system. Be sure that all required file system drivers are loaded and that the volume is not corrupt."],
	[0xC0000150] = [$id="SERIAL_NO_DEVICE_INITED", $desc="No serial device was successfully initialized. The serial driver will unload."],
	[0xC0000151] = [$id="NO_SUCH_ALIAS", $desc="The specified local group does not exist."],
	[0xC0000152] = [$id="MEMBER_NOT_IN_ALIAS", $desc="The specified account name is not a member of the group."],
	[0xC0000153] = [$id="MEMBER_IN_ALIAS", $desc="The specified account name is already a member of the group."],
	[0xC0000154] = [$id="ALIAS_EXISTS", $desc="The specified local group already exists."],
	[0xC0000155] = [$id="LOGON_NOT_GRANTED", $desc="A requested type of logon (for example, interactive, network, and service) is not granted by the local security policy of the target system. Ask the system administrator to grant the necessary form of logon."],
	[0xC0000156] = [$id="TOO_MANY_SECRETS", $desc="The maximum number of secrets that may be stored in a single system was exceeded. The length and number of secrets is limited to satisfy U.S. State Department export restrictions."],
	[0xC0000157] = [$id="SECRET_TOO_LONG", $desc="The length of a secret exceeds the maximum allowable length. The length and number of secrets is limited to satisfy U.S. State Department export restrictions."],
	[0xC0000158] = [$id="INTERNAL_DB_ERROR", $desc="The local security authority (LSA) database contains an internal inconsistency."],
	[0xC0000159] = [$id="FULLSCREEN_MODE", $desc="The requested operation cannot be performed in full-screen mode."],
	[0xC000015A] = [$id="TOO_MANY_CONTEXT_IDS", $desc="During a logon attempt, the user's security context accumulated too many security IDs. This is a very unusual situation. Remove the user from some global or local groups to reduce the number of security IDs to incorporate into the security context."],
	[0xC000015B] = [$id="LOGON_TYPE_NOT_GRANTED", $desc="A user has requested a type of logon (for example, interactive or network) that has not been granted. An administrator has control over who may logon interactively and through the network."],
	[0xC000015C] = [$id="NOT_REGISTRY_FILE", $desc="The system has attempted to load or restore a file into the registry, and the specified file is not in the format of a registry file."],
	[0xC000015D] = [$id="NT_CROSS_ENCRYPTION_REQUIRED", $desc="An attempt was made to change a user password in the security account manager without providing the necessary Windows cross-encrypted password."],
	[0xC000015E] = [$id="DOMAIN_CTRLR_CONFIG_ERROR", $desc="A Windows Server has an incorrect configuration."],
	[0xC000015F] = [$id="FT_MISSING_MEMBER", $desc="An attempt was made to explicitly access the secondary copy of information via a device control to the fault tolerance driver and the secondary copy is not present in the system."],
	[0xC0000160] = [$id="ILL_FORMED_SERVICE_ENTRY", $desc="A configuration registry node that represents a driver service entry was ill-formed and did not contain the required value entries."],
	[0xC0000161] = [$id="ILLEGAL_CHARACTER", $desc="An illegal character was encountered. For a multibyte character set, this includes a lead byte without a succeeding trail byte. For the Unicode character set this includes the characters 0xFFFF and 0xFFFE."],
	[0xC0000162] = [$id="UNMAPPABLE_CHARACTER", $desc="No mapping for the Unicode character exists in the target multibyte code page."],
	[0xC0000163] = [$id="UNDEFINED_CHARACTER", $desc="The Unicode character is not defined in the Unicode character set that is installed on the system."],
	[0xC0000164] = [$id="FLOPPY_VOLUME", $desc="The paging file cannot be created on a floppy disk."],
	[0xC0000165] = [$id="FLOPPY_ID_MARK_NOT_FOUND", $desc="{Floppy Disk Error} While accessing a floppy disk, an ID address mark was not found."],
	[0xC0000166] = [$id="FLOPPY_WRONG_CYLINDER", $desc="{Floppy Disk Error} While accessing a floppy disk, the track address from the sector ID field was found to be different from the track address that is maintained by the controller."],
	[0xC0000167] = [$id="FLOPPY_UNKNOWN_ERROR", $desc="{Floppy Disk Error} The floppy disk controller reported an error that is not recognized by the floppy disk driver."],
	[0xC0000168] = [$id="FLOPPY_BAD_REGISTERS", $desc="{Floppy Disk Error} While accessing a floppy-disk, the controller returned inconsistent results via its registers."],
	[0xC0000169] = [$id="DISK_RECALIBRATE_FAILED", $desc="{Hard Disk Error} While accessing the hard disk, a recalibrate operation failed, even after retries."],
	[0xC000016A] = [$id="DISK_OPERATION_FAILED", $desc="{Hard Disk Error} While accessing the hard disk, a disk operation failed even after retries."],
	[0xC000016B] = [$id="DISK_RESET_FAILED", $desc="{Hard Disk Error} While accessing the hard disk, a disk controller reset was needed, but even that failed."],
	[0xC000016C] = [$id="SHARED_IRQ_BUSY", $desc="An attempt was made to open a device that was sharing an interrupt request (IRQ) with other devices. At least one other device that uses that IRQ was already opened. Two concurrent opens of devices that share an IRQ and only work via interrupts is not supported for the particular bus type that the devices use."],
	[0xC000016D] = [$id="FT_ORPHANING", $desc="{FT Orphaning} A disk that is part of a fault-tolerant volume can no longer be accessed."],
	[0xC000016E] = [$id="BIOS_FAILED_TO_CONNECT_INTERRUPT", $desc="The basic input/output system (BIOS) failed to connect a system interrupt to the device or bus for which the device is connected."],
	[0xC0000172] = [$id="PARTITION_FAILURE", $desc="The tape could not be partitioned."],
	[0xC0000173] = [$id="INVALID_BLOCK_LENGTH", $desc="When accessing a new tape of a multi-volume partition, the current blocksize is incorrect."],
	[0xC0000174] = [$id="DEVICE_NOT_PARTITIONED", $desc="The tape partition information could not be found when loading a tape."],
	[0xC0000175] = [$id="UNABLE_TO_LOCK_MEDIA", $desc="An attempt to lock the eject media mechanism failed."],
	[0xC0000176] = [$id="UNABLE_TO_UNLOAD_MEDIA", $desc="An attempt to unload media failed."],
	[0xC0000177] = [$id="EOM_OVERFLOW", $desc="The physical end of tape was detected."],
	[0xC0000178] = [$id="NO_MEDIA", $desc="{No Media} There is no media in the drive. Insert media into drive %hs."],
	[0xC000017A] = [$id="NO_SUCH_MEMBER", $desc="A member could not be added to or removed from the local group because the member does not exist."],
	[0xC000017B] = [$id="INVALID_MEMBER", $desc="A new member could not be added to a local group because the member has the wrong account type."],
	[0xC000017C] = [$id="KEY_DELETED", $desc="An illegal operation was attempted on a registry key that has been marked for deletion."],
	[0xC000017D] = [$id="NO_LOG_SPACE", $desc="The system could not allocate the required space in a registry log."],
	[0xC000017E] = [$id="TOO_MANY_SIDS", $desc="Too many SIDs have been specified."],
	[0xC000017F] = [$id="LM_CROSS_ENCRYPTION_REQUIRED", $desc="An attempt was made to change a user password in the security account manager without providing the necessary LM cross-encrypted password."],
	[0xC0000180] = [$id="KEY_HAS_CHILDREN", $desc="An attempt was made to create a symbolic link in a registry key that already has subkeys or values."],
	[0xC0000181] = [$id="CHILD_MUST_BE_VOLATILE", $desc="An attempt was made to create a stable subkey under a volatile parent key."],
	[0xC0000182] = [$id="DEVICE_CONFIGURATION_ERROR", $desc="The I/O device is configured incorrectly or the configuration parameters to the driver are incorrect."],
	[0xC0000183] = [$id="DRIVER_INTERNAL_ERROR", $desc="An error was detected between two drivers or within an I/O driver."],
	[0xC0000184] = [$id="INVALID_DEVICE_STATE", $desc="The device is not in a valid state to perform this request."],
	[0xC0000185] = [$id="IO_DEVICE_ERROR", $desc="The I/O device reported an I/O error."],
	[0xC0000186] = [$id="DEVICE_PROTOCOL_ERROR", $desc="A protocol error was detected between the driver and the device."],
	[0xC0000187] = [$id="BACKUP_CONTROLLER", $desc="This operation is only allowed for the primary domain controller of the domain."],
	[0xC0000188] = [$id="LOG_FILE_FULL", $desc="The log file space is insufficient to support this operation."],
	[0xC0000189] = [$id="TOO_LATE", $desc="A write operation was attempted to a volume after it was dismounted."],
	[0xC000018A] = [$id="NO_TRUST_LSA_SECRET", $desc="The workstation does not have a trust secret for the primary domain in the local LSA database."],
	[0xC000018B] = [$id="NO_TRUST_SAM_ACCOUNT", $desc="The SAM database on the Windows Server does not have a computer account for this workstation trust relationship."],
	[0xC000018C] = [$id="TRUSTED_DOMAIN_FAILURE", $desc="The logon request failed because the trust relationship between the primary domain and the trusted domain failed."],
	[0xC000018D] = [$id="TRUSTED_RELATIONSHIP_FAILURE", $desc="The logon request failed because the trust relationship between this workstation and the primary domain failed."],
	[0xC000018E] = [$id="EVENTLOG_FILE_CORRUPT", $desc="The Eventlog log file is corrupt."],
	[0xC000018F] = [$id="EVENTLOG_CANT_START", $desc="No Eventlog log file could be opened. The Eventlog service did not start."],
	[0xC0000190] = [$id="TRUST_FAILURE", $desc="The network logon failed. This may be because the validation authority cannot be reached."],
	[0xC0000191] = [$id="MUTANT_LIMIT_EXCEEDED", $desc="An attempt was made to acquire a mutant such that its maximum count would have been exceeded."],
	[0xC0000192] = [$id="NETLOGON_NOT_STARTED", $desc="An attempt was made to logon, but the NetLogon service was not started."],
	[0xC0000193] = [$id="ACCOUNT_EXPIRED", $desc="The user account has expired."],
	[0xC0000194] = [$id="POSSIBLE_DEADLOCK", $desc="{EXCEPTION} Possible deadlock condition."],
	[0xC0000195] = [$id="NETWORK_CREDENTIAL_CONFLICT", $desc="Multiple connections to a server or shared resource by the same user, using more than one user name, are not allowed. Disconnect all previous connections to the server or shared resource and try again."],
	[0xC0000196] = [$id="REMOTE_SESSION_LIMIT", $desc="An attempt was made to establish a session to a network server, but there are already too many sessions established to that server."],
	[0xC0000197] = [$id="EVENTLOG_FILE_CHANGED", $desc="The log file has changed between reads."],
	[0xC0000198] = [$id="NOLOGON_INTERDOMAIN_TRUST_ACCOUNT", $desc="The account used is an interdomain trust account. Use your global user account or local user account to access this server."],
	[0xC0000199] = [$id="NOLOGON_WORKSTATION_TRUST_ACCOUNT", $desc="The account used is a computer account. Use your global user account or local user account to access this server."],
	[0xC000019A] = [$id="NOLOGON_SERVER_TRUST_ACCOUNT", $desc="The account used is a server trust account. Use your global user account or local user account to access this server."],
	[0xC000019B] = [$id="DOMAIN_TRUST_INCONSISTENT", $desc="The name or SID of the specified domain is inconsistent with the trust information for that domain."],
	[0xC000019C] = [$id="FS_DRIVER_REQUIRED", $desc="A volume has been accessed for which a file system driver is required that has not yet been loaded."],
	[0xC000019D] = [$id="IMAGE_ALREADY_LOADED_AS_DLL", $desc="Indicates that the specified image is already loaded as a DLL."],
	[0xC000019E] = [$id="INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING", $desc="Short name settings may not be changed on this volume due to the global registry setting."],
	[0xC000019F] = [$id="SHORT_NAMES_NOT_ENABLED_ON_VOLUME", $desc="Short names are not enabled on this volume."],
	[0xC00001A0] = [$id="SECURITY_STREAM_IS_INCONSISTENT", $desc="The security stream for the given volume is in an inconsistent state. Please run CHKDSK on the volume."],
	[0xC00001A1] = [$id="INVALID_LOCK_RANGE", $desc="A requested file lock operation cannot be processed due to an invalid byte range."],
	[0xC00001A2] = [$id="INVALID_ACE_CONDITION", $desc="The specified access control entry (ACE) contains an invalid condition."],
	[0xC00001A3] = [$id="IMAGE_SUBSYSTEM_NOT_PRESENT", $desc="The subsystem needed to support the image type is not present."],
	[0xC00001A4] = [$id="NOTIFICATION_GUID_ALREADY_DEFINED", $desc="The specified file already has a notification GUID associated with it."],
	[0xC0000201] = [$id="NETWORK_OPEN_RESTRICTION", $desc="A remote open failed because the network open restrictions were not satisfied."],
	[0xC0000202] = [$id="NO_USER_SESSION_KEY", $desc="There is no user session key for the specified logon session."],
	[0xC0000203] = [$id="USER_SESSION_DELETED", $desc="The remote user session has been deleted."],
	[0xC0000204] = [$id="RESOURCE_LANG_NOT_FOUND", $desc="Indicates the specified resource language ID cannot be found in the image file."],
	[0xC0000205] = [$id="INSUFF_SERVER_RESOURCES", $desc="Insufficient server resources exist to complete the request."],
	[0xC0000206] = [$id="INVALID_BUFFER_SIZE", $desc="The size of the buffer is invalid for the specified operation."],
	[0xC0000207] = [$id="INVALID_ADDRESS_COMPONENT", $desc="The transport rejected the specified network address as invalid."],
	[0xC0000208] = [$id="INVALID_ADDRESS_WILDCARD", $desc="The transport rejected the specified network address due to invalid use of a wildcard."],
	[0xC0000209] = [$id="TOO_MANY_ADDRESSES", $desc="The transport address could not be opened because all the available addresses are in use."],
	[0xC000020A] = [$id="ADDRESS_ALREADY_EXISTS", $desc="The transport address could not be opened because it already exists."],
	[0xC000020B] = [$id="ADDRESS_CLOSED", $desc="The transport address is now closed."],
	[0xC000020C] = [$id="CONNECTION_DISCONNECTED", $desc="The transport connection is now disconnected."],
	[0xC000020D] = [$id="CONNECTION_RESET", $desc="The transport connection has been reset."],
	[0xC000020E] = [$id="TOO_MANY_NODES", $desc="The transport cannot dynamically acquire any more nodes."],
	[0xC000020F] = [$id="TRANSACTION_ABORTED", $desc="The transport aborted a pending transaction."],
	[0xC0000210] = [$id="TRANSACTION_TIMED_OUT", $desc="The transport timed out a request that is waiting for a response."],
	[0xC0000211] = [$id="TRANSACTION_NO_RELEASE", $desc="The transport did not receive a release for a pending response."],
	[0xC0000212] = [$id="TRANSACTION_NO_MATCH", $desc="The transport did not find a transaction that matches the specific token."],
	[0xC0000213] = [$id="TRANSACTION_RESPONDED", $desc="The transport had previously responded to a transaction request."],
	[0xC0000214] = [$id="TRANSACTION_INVALID_ID", $desc="The transport does not recognize the specified transaction request ID."],
	[0xC0000215] = [$id="TRANSACTION_INVALID_TYPE", $desc="The transport does not recognize the specified transaction request type."],
	[0xC0000216] = [$id="NOT_SERVER_SESSION", $desc="The transport can only process the specified request on the server side of a session."],
	[0xC0000217] = [$id="NOT_CLIENT_SESSION", $desc="The transport can only process the specified request on the client side of a session."],
	[0xC0000218] = [$id="CANNOT_LOAD_REGISTRY_FILE", $desc="{Registry File Failure} The registry cannot load the hive (file): %hs or its log or alternate. It is corrupt, absent, or not writable."],
	[0xC0000219] = [$id="DEBUG_ATTACH_FAILED", $desc="{Unexpected Failure in DebugActiveProcess} An unexpected failure occurred while processing a DebugActiveProcess API request. You may choose OK to terminate the process, or Cancel to ignore the error."],
	[0xC000021A] = [$id="SYSTEM_PROCESS_TERMINATED", $desc="{Fatal System Error} The %hs system process terminated unexpectedly with a status of 0x%08x (0x%08x 0x%08x). The system has been shut down."],
	[0xC000021B] = [$id="DATA_NOT_ACCEPTED", $desc="{Data Not Accepted} The TDI client could not handle the data received during an indication."],
	[0xC000021C] = [$id="NO_BROWSER_SERVERS_FOUND", $desc="{Unable to Retrieve Browser Server List} The list of servers for this workgroup is not currently available."],
	[0xC000021D] = [$id="VDM_HARD_ERROR", $desc="NTVDM encountered a hard error."],
	[0xC000021E] = [$id="DRIVER_CANCEL_TIMEOUT", $desc="{Cancel Timeout} The driver %hs failed to complete a canceled I/O request in the allotted time."],
	[0xC000021F] = [$id="REPLY_MESSAGE_MISMATCH", $desc="{Reply Message Mismatch} An attempt was made to reply to an LPC message, but the thread specified by the client ID in the message was not waiting on that message."],
	[0xC0000220] = [$id="MAPPED_ALIGNMENT", $desc="{Mapped View Alignment Incorrect} An attempt was made to map a view of a file, but either the specified base address or the offset into the file were not aligned on the proper allocation granularity."],
	[0xC0000221] = [$id="IMAGE_CHECKSUM_MISMATCH", $desc="{Bad Image Checksum} The image %hs is possibly corrupt. The header checksum does not match the computed checksum."],
	[0xC0000222] = [$id="LOST_WRITEBEHIND_DATA", $desc="{Delayed Write Failed} Windows was unable to save all the data for the file %hs. The data has been lost. This error may be caused by a failure of your computer hardware or network connection. Try to save this file elsewhere."],
	[0xC0000223] = [$id="CLIENT_SERVER_PARAMETERS_INVALID", $desc="The parameters passed to the server in the client/server shared memory window were invalid. Too much data may have been put in the shared memory window."],
	[0xC0000224] = [$id="PASSWORD_MUST_CHANGE", $desc="The user password must be changed before logging on the first time."],
	[0xC0000225] = [$id="NOT_FOUND", $desc="The object was not found."],
	[0xC0000226] = [$id="NOT_TINY_STREAM", $desc="The stream is not a tiny stream."],
	[0xC0000227] = [$id="RECOVERY_FAILURE", $desc="A transaction recovery failed."],
	[0xC0000228] = [$id="STACK_OVERFLOW_READ", $desc="The request must be handled by the stack overflow code."],
	[0xC0000229] = [$id="FAIL_CHECK", $desc="A consistency check failed."],
	[0xC000022A] = [$id="DUPLICATE_OBJECTID", $desc="The attempt to insert the ID in the index failed because the ID is already in the index."],
	[0xC000022B] = [$id="OBJECTID_EXISTS", $desc="The attempt to set the object ID failed because the object already has an ID."],
	[0xC000022C] = [$id="CONVERT_TO_LARGE", $desc="Internal OFS status codes indicating how an allocation operation is handled. Either it is retried after the containing oNode is moved or the extent stream is converted to a large stream."],
	[0xC000022D] = [$id="RETRY", $desc="The request needs to be retried."],
	[0xC000022E] = [$id="FOUND_OUT_OF_SCOPE", $desc="The attempt to find the object found an object on the volume that matches by ID; however, it is out of the scope of the handle that is used for the operation."],
	[0xC000022F] = [$id="ALLOCATE_BUCKET", $desc="The bucket array must be grown. Retry the transaction after doing so."],
	[0xC0000230] = [$id="PROPSET_NOT_FOUND", $desc="The specified property set does not exist on the object."],
	[0xC0000231] = [$id="MARSHALL_OVERFLOW", $desc="The user/kernel marshaling buffer has overflowed."],
	[0xC0000232] = [$id="INVALID_VARIANT", $desc="The supplied variant structure contains invalid data."],
	[0xC0000233] = [$id="DOMAIN_CONTROLLER_NOT_FOUND", $desc="A domain controller for this domain was not found."],
	[0xC0000234] = [$id="ACCOUNT_LOCKED_OUT", $desc="The user account has been automatically locked because too many invalid logon attempts or password change attempts have been requested."],
	[0xC0000235] = [$id="HANDLE_NOT_CLOSABLE", $desc="NtClose was called on a handle that was protected from close via NtSetInformationObject."],
	[0xC0000236] = [$id="CONNECTION_REFUSED", $desc="The transport-connection attempt was refused by the remote system."],
	[0xC0000237] = [$id="GRACEFUL_DISCONNECT", $desc="The transport connection was gracefully closed."],
	[0xC0000238] = [$id="ADDRESS_ALREADY_ASSOCIATED", $desc="The transport endpoint already has an address associated with it."],
	[0xC0000239] = [$id="ADDRESS_NOT_ASSOCIATED", $desc="An address has not yet been associated with the transport endpoint."],
	[0xC000023A] = [$id="CONNECTION_INVALID", $desc="An operation was attempted on a nonexistent transport connection."],
	[0xC000023B] = [$id="CONNECTION_ACTIVE", $desc="An invalid operation was attempted on an active transport connection."],
	[0xC000023C] = [$id="NETWORK_UNREACHABLE", $desc="The remote network is not reachable by the transport."],
	[0xC000023D] = [$id="HOST_UNREACHABLE", $desc="The remote system is not reachable by the transport."],
	[0xC000023E] = [$id="PROTOCOL_UNREACHABLE", $desc="The remote system does not support the transport protocol."],
	[0xC000023F] = [$id="PORT_UNREACHABLE", $desc="No service is operating at the destination port of the transport on the remote system."],
	[0xC0000240] = [$id="REQUEST_ABORTED", $desc="The request was aborted."],
	[0xC0000241] = [$id="CONNECTION_ABORTED", $desc="The transport connection was aborted by the local system."],
	[0xC0000242] = [$id="BAD_COMPRESSION_BUFFER", $desc="The specified buffer contains ill-formed data."],
	[0xC0000243] = [$id="USER_MAPPED_FILE", $desc="The requested operation cannot be performed on a file with a user mapped section open."],
	[0xC0000244] = [$id="AUDIT_FAILED", $desc="{Audit Failed} An attempt to generate a security audit failed."],
	[0xC0000245] = [$id="TIMER_RESOLUTION_NOT_SET", $desc="The timer resolution was not previously set by the current process."],
	[0xC0000246] = [$id="CONNECTION_COUNT_LIMIT", $desc="A connection to the server could not be made because the limit on the number of concurrent connections for this account has been reached."],
	[0xC0000247] = [$id="LOGIN_TIME_RESTRICTION", $desc="Attempting to log on during an unauthorized time of day for this account."],
	[0xC0000248] = [$id="LOGIN_WKSTA_RESTRICTION", $desc="The account is not authorized to log on from this station."],
	[0xC0000249] = [$id="IMAGE_MP_UP_MISMATCH", $desc="{UP/MP Image Mismatch} The image %hs has been modified for use on a uniprocessor system, but you are running it on a multiprocessor machine. Reinstall the image file."],
	[0xC0000250] = [$id="INSUFFICIENT_LOGON_INFO", $desc="There is insufficient account information to log you on."],
	[0xC0000251] = [$id="BAD_DLL_ENTRYPOINT", $desc="{Invalid DLL Entrypoint} The dynamic link library %hs is not written correctly. The stack pointer has been left in an inconsistent state. The entry point should be declared as WINAPI or STDCALL. Select YES to fail the DLL load. Select NO to continue execution. Selecting NO may cause the application to operate incorrectly."],
	[0xC0000252] = [$id="BAD_SERVICE_ENTRYPOINT", $desc="{Invalid Service Callback Entrypoint} The %hs service is not written correctly. The stack pointer has been left in an inconsistent state. The callback entry point should be declared as WINAPI or STDCALL. Selecting OK will cause the service to continue operation. However, the service process may operate incorrectly."],
	[0xC0000253] = [$id="LPC_REPLY_LOST", $desc="The server received the messages but did not send a reply."],
	[0xC0000254] = [$id="IP_ADDRESS_CONFLICT1", $desc="There is an IP address conflict with another system on the network."],
	[0xC0000255] = [$id="IP_ADDRESS_CONFLICT2", $desc="There is an IP address conflict with another system on the network."],
	[0xC0000256] = [$id="REGISTRY_QUOTA_LIMIT", $desc="{Low On Registry Space} The system has reached the maximum size that is allowed for the system part of the registry. Additional storage requests will be ignored."],
	[0xC0000257] = [$id="PATH_NOT_COVERED", $desc="The contacted server does not support the indicated part of the DFS namespace."],
	[0xC0000258] = [$id="NO_CALLBACK_ACTIVE", $desc="A callback return system service cannot be executed when no callback is active."],
	[0xC0000259] = [$id="LICENSE_QUOTA_EXCEEDED", $desc="The service being accessed is licensed for a particular number of connections. No more connections can be made to the service at this time because the service has already accepted the maximum number of connections."],
	[0xC000025A] = [$id="PWD_TOO_SHORT", $desc="The password provided is too short to meet the policy of your user account. Choose a longer password."],
	[0xC000025B] = [$id="PWD_TOO_RECENT", $desc="The policy of your user account does not allow you to change passwords too frequently. This is done to prevent users from changing back to a familiar, but potentially discovered, password. If you feel your password has been compromised, contact your administrator immediately to have a new one assigned."],
	[0xC000025C] = [$id="PWD_HISTORY_CONFLICT", $desc="You have attempted to change your password to one that you have used in the past. The policy of your user account does not allow this. Select a password that you have not previously used."],
	[0xC000025E] = [$id="PLUGPLAY_NO_DEVICE", $desc="You have attempted to load a legacy device driver while its device instance had been disabled."],
	[0xC000025F] = [$id="UNSUPPORTED_COMPRESSION", $desc="The specified compression format is unsupported."],
	[0xC0000260] = [$id="INVALID_HW_PROFILE", $desc="The specified hardware profile configuration is invalid."],
	[0xC0000261] = [$id="INVALID_PLUGPLAY_DEVICE_PATH", $desc="The specified Plug and Play registry device path is invalid."],
	[0xC0000262] = [$id="DRIVER_ORDINAL_NOT_FOUND", $desc="{Driver Entry Point Not Found} The %hs device driver could not locate the ordinal %ld in driver %hs."],
	[0xC0000263] = [$id="DRIVER_ENTRYPOINT_NOT_FOUND", $desc="{Driver Entry Point Not Found} The %hs device driver could not locate the entry point %hs in driver %hs."],
	[0xC0000264] = [$id="RESOURCE_NOT_OWNED", $desc="{Application Error} The application attempted to release a resource it did not own. Click OK to terminate the application."],
	[0xC0000265] = [$id="TOO_MANY_LINKS", $desc="An attempt was made to create more links on a file than the file system supports."],
	[0xC0000266] = [$id="QUOTA_LIST_INCONSISTENT", $desc="The specified quota list is internally inconsistent with its descriptor."],
	[0xC0000267] = [$id="FILE_IS_OFFLINE", $desc="The specified file has been relocated to offline storage."],
	[0xC0000268] = [$id="EVALUATION_EXPIRATION", $desc="{Windows Evaluation Notification} The evaluation period for this installation of Windows has expired. This system will shutdown in 1 hour. To restore access to this installation of Windows, upgrade this installation by using a licensed distribution of this product."],
	[0xC0000269] = [$id="ILLEGAL_DLL_RELOCATION", $desc="{Illegal System DLL Relocation} The system DLL %hs was relocated in memory. The application will not run properly. The relocation occurred because the DLL %hs occupied an address range that is reserved for Windows system DLLs. The vendor supplying the DLL should be contacted for a new DLL."],
	[0xC000026A] = [$id="LICENSE_VIOLATION", $desc="{License Violation} The system has detected tampering with your registered product type. This is a violation of your software license. Tampering with the product type is not permitted."],
	[0xC000026B] = [$id="DLL_INIT_FAILED_LOGOFF", $desc="{DLL Initialization Failed} The application failed to initialize because the window station is shutting down."],
	[0xC000026C] = [$id="DRIVER_UNABLE_TO_LOAD", $desc="{Unable to Load Device Driver} %hs device driver could not be loaded. Error Status was 0x%x."],
	[0xC000026D] = [$id="DFS_UNAVAILABLE", $desc="DFS is unavailable on the contacted server."],
	[0xC000026E] = [$id="VOLUME_DISMOUNTED", $desc="An operation was attempted to a volume after it was dismounted."],
	[0xC000026F] = [$id="WX86_INTERNAL_ERROR", $desc="An internal error occurred in the Win32 x86 emulation subsystem."],
	[0xC0000270] = [$id="WX86_FLOAT_STACK_CHECK", $desc="Win32 x86 emulation subsystem floating-point stack check."],
	[0xC0000271] = [$id="VALIDATE_CONTINUE", $desc="The validation process needs to continue on to the next step."],
	[0xC0000272] = [$id="NO_MATCH", $desc="There was no match for the specified key in the index."],
	[0xC0000273] = [$id="NO_MORE_MATCHES", $desc="There are no more matches for the current index enumeration."],
	[0xC0000275] = [$id="NOT_A_REPARSE_POINT", $desc="The NTFS file or directory is not a reparse point."],
	[0xC0000276] = [$id="IO_REPARSE_TAG_INVALID", $desc="The Windows I/O reparse tag passed for the NTFS reparse point is invalid."],
	[0xC0000277] = [$id="IO_REPARSE_TAG_MISMATCH", $desc="The Windows I/O reparse tag does not match the one that is in the NTFS reparse point."],
	[0xC0000278] = [$id="IO_REPARSE_DATA_INVALID", $desc="The user data passed for the NTFS reparse point is invalid."],
	[0xC0000279] = [$id="IO_REPARSE_TAG_NOT_HANDLED", $desc="The layered file system driver for this I/O tag did not handle it when needed."],
	[0xC0000280] = [$id="REPARSE_POINT_NOT_RESOLVED", $desc="The NTFS symbolic link could not be resolved even though the initial file name is valid."],
	[0xC0000281] = [$id="DIRECTORY_IS_A_REPARSE_POINT", $desc="The NTFS directory is a reparse point."],
	[0xC0000282] = [$id="RANGE_LIST_CONFLICT", $desc="The range could not be added to the range list because of a conflict."],
	[0xC0000283] = [$id="SOURCE_ELEMENT_EMPTY", $desc="The specified medium changer source element contains no media."],
	[0xC0000284] = [$id="DESTINATION_ELEMENT_FULL", $desc="The specified medium changer destination element already contains media."],
	[0xC0000285] = [$id="ILLEGAL_ELEMENT_ADDRESS", $desc="The specified medium changer element does not exist."],
	[0xC0000286] = [$id="MAGAZINE_NOT_PRESENT", $desc="The specified element is contained in a magazine that is no longer present."],
	[0xC0000287] = [$id="REINITIALIZATION_NEEDED", $desc="The device requires re-initialization due to hardware errors."],
	[0xC000028A] = [$id="ENCRYPTION_FAILED", $desc="The file encryption attempt failed."],
	[0xC000028B] = [$id="DECRYPTION_FAILED", $desc="The file decryption attempt failed."],
	[0xC000028C] = [$id="RANGE_NOT_FOUND", $desc="The specified range could not be found in the range list."],
	[0xC000028D] = [$id="NO_RECOVERY_POLICY", $desc="There is no encryption recovery policy configured for this system."],
	[0xC000028E] = [$id="NO_EFS", $desc="The required encryption driver is not loaded for this system."],
	[0xC000028F] = [$id="WRONG_EFS", $desc="The file was encrypted with a different encryption driver than is currently loaded."],
	[0xC0000290] = [$id="NO_USER_KEYS", $desc="There are no EFS keys defined for the user."],
	[0xC0000291] = [$id="FILE_NOT_ENCRYPTED", $desc="The specified file is not encrypted."],
	[0xC0000292] = [$id="NOT_EXPORT_FORMAT", $desc="The specified file is not in the defined EFS export format."],
	[0xC0000293] = [$id="FILE_ENCRYPTED", $desc="The specified file is encrypted and the user does not have the ability to decrypt it."],
	[0xC0000295] = [$id="WMI_GUID_NOT_FOUND", $desc="The GUID passed was not recognized as valid by a WMI data provider."],
	[0xC0000296] = [$id="WMI_INSTANCE_NOT_FOUND", $desc="The instance name passed was not recognized as valid by a WMI data provider."],
	[0xC0000297] = [$id="WMI_ITEMID_NOT_FOUND", $desc="The data item ID passed was not recognized as valid by a WMI data provider."],
	[0xC0000298] = [$id="WMI_TRY_AGAIN", $desc="The WMI request could not be completed and should be retried."],
	[0xC0000299] = [$id="SHARED_POLICY", $desc="The policy object is shared and can only be modified at the root."],
	[0xC000029A] = [$id="POLICY_OBJECT_NOT_FOUND", $desc="The policy object does not exist when it should."],
	[0xC000029B] = [$id="POLICY_ONLY_IN_DS", $desc="The requested policy information only lives in the Ds."],
	[0xC000029C] = [$id="VOLUME_NOT_UPGRADED", $desc="The volume must be upgraded to enable this feature."],
	[0xC000029D] = [$id="REMOTE_STORAGE_NOT_ACTIVE", $desc="The remote storage service is not operational at this time."],
	[0xC000029E] = [$id="REMOTE_STORAGE_MEDIA_ERROR", $desc="The remote storage service encountered a media error."],
	[0xC000029F] = [$id="NO_TRACKING_SERVICE", $desc="The tracking (workstation) service is not running."],
	[0xC00002A0] = [$id="SERVER_SID_MISMATCH", $desc="The server process is running under a SID that is different from the SID that is required by client."],
	[0xC00002A1] = [$id="DS_NO_ATTRIBUTE_OR_VALUE", $desc="The specified directory service attribute or value does not exist."],
	[0xC00002A2] = [$id="DS_INVALID_ATTRIBUTE_SYNTAX", $desc="The attribute syntax specified to the directory service is invalid."],
	[0xC00002A3] = [$id="DS_ATTRIBUTE_TYPE_UNDEFINED", $desc="The attribute type specified to the directory service is not defined."],
	[0xC00002A4] = [$id="DS_ATTRIBUTE_OR_VALUE_EXISTS", $desc="The specified directory service attribute or value already exists."],
	[0xC00002A5] = [$id="DS_BUSY", $desc="The directory service is busy."],
	[0xC00002A6] = [$id="DS_UNAVAILABLE", $desc="The directory service is unavailable."],
	[0xC00002A7] = [$id="DS_NO_RIDS_ALLOCATED", $desc="The directory service was unable to allocate a relative identifier."],
	[0xC00002A8] = [$id="DS_NO_MORE_RIDS", $desc="The directory service has exhausted the pool of relative identifiers."],
	[0xC00002A9] = [$id="DS_INCORRECT_ROLE_OWNER", $desc="The requested operation could not be performed because the directory service is not the master for that type of operation."],
	[0xC00002AA] = [$id="DS_RIDMGR_INIT_ERROR", $desc="The directory service was unable to initialize the subsystem that allocates relative identifiers."],
	[0xC00002AB] = [$id="DS_OBJ_CLASS_VIOLATION", $desc="The requested operation did not satisfy one or more constraints that are associated with the class of the object."],
	[0xC00002AC] = [$id="DS_CANT_ON_NON_LEAF", $desc="The directory service can perform the requested operation only on a leaf object."],
	[0xC00002AD] = [$id="DS_CANT_ON_RDN", $desc="The directory service cannot perform the requested operation on the Relatively Defined Name (RDN) attribute of an object."],
	[0xC00002AE] = [$id="DS_CANT_MOD_OBJ_CLASS", $desc="The directory service detected an attempt to modify the object class of an object."],
	[0xC00002AF] = [$id="DS_CROSS_DOM_MOVE_FAILED", $desc="An error occurred while performing a cross domain move operation."],
	[0xC00002B0] = [$id="DS_GC_NOT_AVAILABLE", $desc="Unable to contact the global catalog server."],
	[0xC00002B1] = [$id="DIRECTORY_SERVICE_REQUIRED", $desc="The requested operation requires a directory service, and none was available."],
	[0xC00002B2] = [$id="REPARSE_ATTRIBUTE_CONFLICT", $desc="The reparse attribute cannot be set because it is incompatible with an existing attribute."],
	[0xC00002B3] = [$id="CANT_ENABLE_DENY_ONLY", $desc="A group marked \"use for deny only\" cannot be enabled."],
	[0xC00002B4] = [$id="FLOAT_MULTIPLE_FAULTS", $desc="{EXCEPTION} Multiple floating-point faults."],
	[0xC00002B5] = [$id="FLOAT_MULTIPLE_TRAPS", $desc="{EXCEPTION} Multiple floating-point traps."],
	[0xC00002B6] = [$id="DEVICE_REMOVED", $desc="The device has been removed."],
	[0xC00002B7] = [$id="JOURNAL_DELETE_IN_PROGRESS", $desc="The volume change journal is being deleted."],
	[0xC00002B8] = [$id="JOURNAL_NOT_ACTIVE", $desc="The volume change journal is not active."],
	[0xC00002B9] = [$id="NOINTERFACE", $desc="The requested interface is not supported."],
	[0xC00002C1] = [$id="DS_ADMIN_LIMIT_EXCEEDED", $desc="A directory service resource limit has been exceeded."],
	[0xC00002C2] = [$id="DRIVER_FAILED_SLEEP", $desc="{System Standby Failed} The driver %hs does not support standby mode. Updating this driver may allow the system to go to standby mode."],
	[0xC00002C3] = [$id="MUTUAL_AUTHENTICATION_FAILED", $desc="Mutual Authentication failed. The server password is out of date at the domain controller."],
	[0xC00002C4] = [$id="CORRUPT_SYSTEM_FILE", $desc="The system file %1 has become corrupt and has been replaced."],
	[0xC00002C5] = [$id="DATATYPE_MISALIGNMENT_ERROR", $desc="{EXCEPTION} Alignment Error A data type misalignment error was detected in a load or store instruction."],
	[0xC00002C6] = [$id="WMI_READ_ONLY", $desc="The WMI data item or data block is read-only."],
	[0xC00002C7] = [$id="WMI_SET_FAILURE", $desc="The WMI data item or data block could not be changed."],
	[0xC00002C8] = [$id="COMMITMENT_MINIMUM", $desc="{Virtual Memory Minimum Too Low} Your system is low on virtual memory. Windows is increasing the size of your virtual memory paging file. During this process, memory requests for some applications may be denied. For more information, see Help."],
	[0xC00002C9] = [$id="REG_NAT_CONSUMPTION", $desc="{EXCEPTION} Register NaT consumption faults. A NaT value is consumed on a non-speculative instruction."],
	[0xC00002CA] = [$id="TRANSPORT_FULL", $desc="The transport element of the medium changer contains media, which is causing the operation to fail."],
	[0xC00002CB] = [$id="DS_SAM_INIT_FAILURE", $desc="Security Accounts Manager initialization failed because of the following error: %hs Error Status: 0x%x. Click OK to shut down this system and restart in Directory Services Restore Mode. Check the event log for more detailed information."],
	[0xC00002CC] = [$id="ONLY_IF_CONNECTED", $desc="This operation is supported only when you are connected to the server."],
	[0xC00002CD] = [$id="DS_SENSITIVE_GROUP_VIOLATION", $desc="Only an administrator can modify the membership list of an administrative group."],
	[0xC00002CE] = [$id="PNP_RESTART_ENUMERATION", $desc="A device was removed so enumeration must be restarted."],
	[0xC00002CF] = [$id="JOURNAL_ENTRY_DELETED", $desc="The journal entry has been deleted from the journal."],
	[0xC00002D0] = [$id="DS_CANT_MOD_PRIMARYGROUPID", $desc="Cannot change the primary group ID of a domain controller account."],
	[0xC00002D1] = [$id="SYSTEM_IMAGE_BAD_SIGNATURE", $desc="{Fatal System Error} The system image %s is not properly signed. The file has been replaced with the signed file. The system has been shut down."],
	[0xC00002D2] = [$id="PNP_REBOOT_REQUIRED", $desc="The device will not start without a reboot."],
	[0xC00002D3] = [$id="POWER_STATE_INVALID", $desc="The power state of the current device cannot support this request."],
	[0xC00002D4] = [$id="DS_INVALID_GROUP_TYPE", $desc="The specified group type is invalid."],
	[0xC00002D5] = [$id="DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN", $desc="In a mixed domain, no nesting of a global group if the group is security enabled."],
	[0xC00002D6] = [$id="DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN", $desc="In a mixed domain, cannot nest local groups with other local groups, if the group is security enabled."],
	[0xC00002D7] = [$id="DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER", $desc="A global group cannot have a local group as a member."],
	[0xC00002D8] = [$id="DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER", $desc="A global group cannot have a universal group as a member."],
	[0xC00002D9] = [$id="DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER", $desc="A universal group cannot have a local group as a member."],
	[0xC00002DA] = [$id="DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER", $desc="A global group cannot have a cross-domain member."],
	[0xC00002DB] = [$id="DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER", $desc="A local group cannot have another cross-domain local group as a member."],
	[0xC00002DC] = [$id="DS_HAVE_PRIMARY_MEMBERS", $desc="Cannot change to a security-disabled group because primary members are in this group."],
	[0xC00002DD] = [$id="WMI_NOT_SUPPORTED", $desc="The WMI operation is not supported by the data block or method."],
	[0xC00002DE] = [$id="INSUFFICIENT_POWER", $desc="There is not enough power to complete the requested operation."],
	[0xC00002DF] = [$id="SAM_NEED_BOOTKEY_PASSWORD", $desc="The Security Accounts Manager needs to get the boot password."],
	[0xC00002E0] = [$id="SAM_NEED_BOOTKEY_FLOPPY", $desc="The Security Accounts Manager needs to get the boot key from the floppy disk."],
	[0xC00002E1] = [$id="DS_CANT_START", $desc="The directory service cannot start."],
	[0xC00002E2] = [$id="DS_INIT_FAILURE", $desc="The directory service could not start because of the following error: %hs Error Status: 0x%x. Click OK to shut down this system and restart in Directory Services Restore Mode. Check the event log for more detailed information."],
	[0xC00002E3] = [$id="SAM_INIT_FAILURE", $desc="The Security Accounts Manager initialization failed because of the following error: %hs Error Status: 0x%x. Click OK to shut down this system and restart in Safe Mode. Check the event log for more detailed information."],
	[0xC00002E4] = [$id="DS_GC_REQUIRED", $desc="The requested operation can be performed only on a global catalog server."],
	[0xC00002E5] = [$id="DS_LOCAL_MEMBER_OF_LOCAL_ONLY", $desc="A local group can only be a member of other local groups in the same domain."],
	[0xC00002E6] = [$id="DS_NO_FPO_IN_UNIVERSAL_GROUPS", $desc="Foreign security principals cannot be members of universal groups."],
	[0xC00002E7] = [$id="DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED", $desc="Your computer could not be joined to the domain. You have exceeded the maximum number of computer accounts you are allowed to create in this domain. Contact your system administrator to have this limit reset or increased."],
	[0xC00002E9] = [$id="CURRENT_DOMAIN_NOT_ALLOWED", $desc="This operation cannot be performed on the current domain."],
	[0xC00002EA] = [$id="CANNOT_MAKE", $desc="The directory or file cannot be created."],
	[0xC00002EB] = [$id="SYSTEM_SHUTDOWN", $desc="The system is in the process of shutting down."],
	[0xC00002EC] = [$id="DS_INIT_FAILURE_CONSOLE", $desc="Directory Services could not start because of the following error: %hs Error Status: 0x%x. Click OK to shut down the system. You can use the recovery console to diagnose the system further."],
	[0xC00002ED] = [$id="DS_SAM_INIT_FAILURE_CONSOLE", $desc="Security Accounts Manager initialization failed because of the following error: %hs Error Status: 0x%x. Click OK to shut down the system. You can use the recovery console to diagnose the system further."],
	[0xC00002EE] = [$id="UNFINISHED_CONTEXT_DELETED", $desc="A security context was deleted before the context was completed. This is considered a logon failure."],
	[0xC00002EF] = [$id="NO_TGT_REPLY", $desc="The client is trying to negotiate a context and the server requires user-to-user but did not send a TGT reply."],
	[0xC00002F0] = [$id="OBJECTID_NOT_FOUND", $desc="An object ID was not found in the file."],
	[0xC00002F1] = [$id="NO_IP_ADDRESSES", $desc="Unable to accomplish the requested task because the local machine does not have any IP addresses."],
	[0xC00002F2] = [$id="WRONG_CREDENTIAL_HANDLE", $desc="The supplied credential handle does not match the credential that is associated with the security context."],
	[0xC00002F3] = [$id="CRYPTO_SYSTEM_INVALID", $desc="The crypto system or checksum function is invalid because a required function is unavailable."],
	[0xC00002F4] = [$id="MAX_REFERRALS_EXCEEDED", $desc="The number of maximum ticket referrals has been exceeded."],
	[0xC00002F5] = [$id="MUST_BE_KDC", $desc="The local machine must be a Kerberos KDC (domain controller) and it is not."],
	[0xC00002F6] = [$id="STRONG_CRYPTO_NOT_SUPPORTED", $desc="The other end of the security negotiation requires strong crypto but it is not supported on the local machine."],
	[0xC00002F7] = [$id="TOO_MANY_PRINCIPALS", $desc="The KDC reply contained more than one principal name."],
	[0xC00002F8] = [$id="NO_PA_DATA", $desc="Expected to find PA data for a hint of what etype to use, but it was not found."],
	[0xC00002F9] = [$id="PKINIT_NAME_MISMATCH", $desc="The client certificate does not contain a valid UPN, or does not match the client name in the logon request. Contact your administrator."],
	[0xC00002FA] = [$id="SMARTCARD_LOGON_REQUIRED", $desc="Smart card logon is required and was not used."],
	[0xC00002FB] = [$id="KDC_INVALID_REQUEST", $desc="An invalid request was sent to the KDC."],
	[0xC00002FC] = [$id="KDC_UNABLE_TO_REFER", $desc="The KDC was unable to generate a referral for the service requested."],
	[0xC00002FD] = [$id="KDC_UNKNOWN_ETYPE", $desc="The encryption type requested is not supported by the KDC."],
	[0xC00002FE] = [$id="SHUTDOWN_IN_PROGRESS", $desc="A system shutdown is in progress."],
	[0xC00002FF] = [$id="SERVER_SHUTDOWN_IN_PROGRESS", $desc="The server machine is shutting down."],
	[0xC0000300] = [$id="NOT_SUPPORTED_ON_SBS", $desc="This operation is not supported on a computer running Windows Server 2003 for Small Business Server."],
	[0xC0000301] = [$id="WMI_GUID_DISCONNECTED", $desc="The WMI GUID is no longer available."],
	[0xC0000302] = [$id="WMI_ALREADY_DISABLED", $desc="Collection or events for the WMI GUID is already disabled."],
	[0xC0000303] = [$id="WMI_ALREADY_ENABLED", $desc="Collection or events for the WMI GUID is already enabled."],
	[0xC0000304] = [$id="MFT_TOO_FRAGMENTED", $desc="The master file table on the volume is too fragmented to complete this operation."],
	[0xC0000305] = [$id="COPY_PROTECTION_FAILURE", $desc="Copy protection failure."],
	[0xC0000306] = [$id="CSS_AUTHENTICATION_FAILURE", $desc="Copy protection error-DVD CSS Authentication failed."],
	[0xC0000307] = [$id="CSS_KEY_NOT_PRESENT", $desc="Copy protection error-The specified sector does not contain a valid key."],
	[0xC0000308] = [$id="CSS_KEY_NOT_ESTABLISHED", $desc="Copy protection error-DVD session key not established."],
	[0xC0000309] = [$id="CSS_SCRAMBLED_SECTOR", $desc="Copy protection error-The read failed because the sector is encrypted."],
	[0xC000030A] = [$id="CSS_REGION_MISMATCH", $desc="Copy protection error-The region of the specified DVD does not correspond to the region setting of the drive."],
	[0xC000030B] = [$id="CSS_RESETS_EXHAUSTED", $desc="Copy protection error-The region setting of the drive may be permanent."],
	[0xC0000320] = [$id="PKINIT_FAILURE", $desc="The Kerberos protocol encountered an error while validating the KDC certificate during smart card logon. There is more information in the system event log."],
	[0xC0000321] = [$id="SMARTCARD_SUBSYSTEM_FAILURE", $desc="The Kerberos protocol encountered an error while attempting to use the smart card subsystem."],
	[0xC0000322] = [$id="NO_KERB_KEY", $desc="The target server does not have acceptable Kerberos credentials."],
	[0xC0000350] = [$id="HOST_DOWN", $desc="The transport determined that the remote system is down."],
	[0xC0000351] = [$id="UNSUPPORTED_PREAUTH", $desc="An unsupported pre-authentication mechanism was presented to the Kerberos package."],
	[0xC0000352] = [$id="EFS_ALG_BLOB_TOO_BIG", $desc="The encryption algorithm that is used on the source file needs a bigger key buffer than the one that is used on the destination file."],
	[0xC0000353] = [$id="PORT_NOT_SET", $desc="An attempt to remove a processes DebugPort was made, but a port was not already associated with the process."],
	[0xC0000354] = [$id="DEBUGGER_INACTIVE", $desc="An attempt to do an operation on a debug port failed because the port is in the process of being deleted."],
	[0xC0000355] = [$id="DS_VERSION_CHECK_FAILURE", $desc="This version of Windows is not compatible with the behavior version of the directory forest, domain, or domain controller."],
	[0xC0000356] = [$id="AUDITING_DISABLED", $desc="The specified event is currently not being audited."],
	[0xC0000357] = [$id="PRENT4_MACHINE_ACCOUNT", $desc="The machine account was created prior to Windows NT 4.0. The account needs to be recreated."],
	[0xC0000358] = [$id="DS_AG_CANT_HAVE_UNIVERSAL_MEMBER", $desc="An account group cannot have a universal group as a member."],
	[0xC0000359] = [$id="INVALID_IMAGE_WIN_32", $desc="The specified image file did not have the correct format; it appears to be a 32-bit Windows image."],
	[0xC000035A] = [$id="INVALID_IMAGE_WIN_64", $desc="The specified image file did not have the correct format; it appears to be a 64-bit Windows image."],
	[0xC000035B] = [$id="BAD_BINDINGS", $desc="The client's supplied SSPI channel bindings were incorrect."],
	[0xC000035C] = [$id="NETWORK_SESSION_EXPIRED", $desc="The client session has expired; so the client must re-authenticate to continue accessing the remote resources."],
	[0xC000035D] = [$id="APPHELP_BLOCK", $desc="The AppHelp dialog box canceled; thus preventing the application from starting."],
	[0xC000035E] = [$id="ALL_SIDS_FILTERED", $desc="The SID filtering operation removed all SIDs."],
	[0xC000035F] = [$id="NOT_SAFE_MODE_DRIVER", $desc="The driver was not loaded because the system is starting in safe mode."],
	[0xC0000361] = [$id="ACCESS_DISABLED_BY_POLICY_DEFAULT", $desc="Access to %1 has been restricted by your Administrator by the default software restriction policy level."],
	[0xC0000362] = [$id="ACCESS_DISABLED_BY_POLICY_PATH", $desc="Access to %1 has been restricted by your Administrator by location with policy rule %2 placed on path %3."],
	[0xC0000363] = [$id="ACCESS_DISABLED_BY_POLICY_PUBLISHER", $desc="Access to %1 has been restricted by your Administrator by software publisher policy."],
	[0xC0000364] = [$id="ACCESS_DISABLED_BY_POLICY_OTHER", $desc="Access to %1 has been restricted by your Administrator by policy rule %2."],
	[0xC0000365] = [$id="FAILED_DRIVER_ENTRY", $desc="The driver was not loaded because it failed its initialization call."],
	[0xC0000366] = [$id="DEVICE_ENUMERATION_ERROR", $desc="The device encountered an error while applying power or reading the device configuration. This may be caused by a failure of your hardware or by a poor connection."],
	[0xC0000368] = [$id="MOUNT_POINT_NOT_RESOLVED", $desc="The create operation failed because the name contained at least one mount point that resolves to a volume to which the specified device object is not attached."],
	[0xC0000369] = [$id="INVALID_DEVICE_OBJECT_PARAMETER", $desc="The device object parameter is either not a valid device object or is not attached to the volume that is specified by the file name."],
	[0xC000036A] = [$id="MCA_OCCURED", $desc="A machine check error has occurred. Check the system event log for additional information."],
	[0xC000036B] = [$id="DRIVER_BLOCKED_CRITICAL", $desc="Driver %2 has been blocked from loading."],
	[0xC000036C] = [$id="DRIVER_BLOCKED", $desc="Driver %2 has been blocked from loading."],
	[0xC000036D] = [$id="DRIVER_DATABASE_ERROR", $desc="There was error [%2] processing the driver database."],
	[0xC000036E] = [$id="SYSTEM_HIVE_TOO_LARGE", $desc="System hive size has exceeded its limit."],
	[0xC000036F] = [$id="INVALID_IMPORT_OF_NON_DLL", $desc="A dynamic link library (DLL) referenced a module that was neither a DLL nor the process's executable image."],
	[0xC0000371] = [$id="NO_SECRETS", $desc="The local account store does not contain secret material for the specified account."],
	[0xC0000372] = [$id="ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY", $desc="Access to %1 has been restricted by your Administrator by policy rule %2."],
	[0xC0000373] = [$id="FAILED_STACK_SWITCH", $desc="The system was not able to allocate enough memory to perform a stack switch."],
	[0xC0000374] = [$id="HEAP_CORRUPTION", $desc="A heap has been corrupted."],
	[0xC0000380] = [$id="SMARTCARD_WRONG_PIN", $desc="An incorrect PIN was presented to the smart card."],
	[0xC0000381] = [$id="SMARTCARD_CARD_BLOCKED", $desc="The smart card is blocked."],
	[0xC0000382] = [$id="SMARTCARD_CARD_NOT_AUTHENTICATED", $desc="No PIN was presented to the smart card."],
	[0xC0000383] = [$id="SMARTCARD_NO_CARD", $desc="No smart card is available."],
	[0xC0000384] = [$id="SMARTCARD_NO_KEY_CONTAINER", $desc="The requested key container does not exist on the smart card."],
	[0xC0000385] = [$id="SMARTCARD_NO_CERTIFICATE", $desc="The requested certificate does not exist on the smart card."],
	[0xC0000386] = [$id="SMARTCARD_NO_KEYSET", $desc="The requested keyset does not exist."],
	[0xC0000387] = [$id="SMARTCARD_IO_ERROR", $desc="A communication error with the smart card has been detected."],
	[0xC0000388] = [$id="DOWNGRADE_DETECTED", $desc="The system detected a possible attempt to compromise security. Ensure that you can contact the server that authenticated you."],
	[0xC0000389] = [$id="SMARTCARD_CERT_REVOKED", $desc="The smart card certificate used for authentication has been revoked. Contact your system administrator. There may be additional information in the event log."],
	[0xC000038A] = [$id="ISSUING_CA_UNTRUSTED", $desc="An untrusted certificate authority was detected while processing the smart card certificate that is used for authentication. Contact your system administrator."],
	[0xC000038B] = [$id="REVOCATION_OFFLINE_C", $desc="The revocation status of the smart card certificate that is used for authentication could not be determined. Contact your system administrator."],
	[0xC000038C] = [$id="PKINIT_CLIENT_FAILURE", $desc="The smart card certificate used for authentication was not trusted. Contact your system administrator."],
	[0xC000038D] = [$id="SMARTCARD_CERT_EXPIRED", $desc="The smart card certificate used for authentication has expired. Contact your system administrator."],
	[0xC000038E] = [$id="DRIVER_FAILED_PRIOR_UNLOAD", $desc="The driver could not be loaded because a previous version of the driver is still in memory."],
	[0xC000038F] = [$id="SMARTCARD_SILENT_CONTEXT", $desc="The smart card provider could not perform the action because the context was acquired as silent."],
	[0xC0000401] = [$id="PER_USER_TRUST_QUOTA_EXCEEDED", $desc="The delegated trust creation quota of the current user has been exceeded."],
	[0xC0000402] = [$id="ALL_USER_TRUST_QUOTA_EXCEEDED", $desc="The total delegated trust creation quota has been exceeded."],
	[0xC0000403] = [$id="USER_DELETE_TRUST_QUOTA_EXCEEDED", $desc="The delegated trust deletion quota of the current user has been exceeded."],
	[0xC0000404] = [$id="DS_NAME_NOT_UNIQUE", $desc="The requested name already exists as a unique identifier."],
	[0xC0000405] = [$id="DS_DUPLICATE_ID_FOUND", $desc="The requested object has a non-unique identifier and cannot be retrieved."],
	[0xC0000406] = [$id="DS_GROUP_CONVERSION_ERROR", $desc="The group cannot be converted due to attribute restrictions on the requested group type."],
	[0xC0000407] = [$id="VOLSNAP_PREPARE_HIBERNATE", $desc="{Volume Shadow Copy Service} Wait while the Volume Shadow Copy Service prepares volume %hs for hibernation."],
	[0xC0000408] = [$id="USER2USER_REQUIRED", $desc="Kerberos sub-protocol User2User is required."],
	[0xC0000409] = [$id="STACK_BUFFER_OVERRUN", $desc="The system detected an overrun of a stack-based buffer in this application. This overrun could potentially allow a malicious user to gain control of this application."],
	[0xC000040A] = [$id="NO_S4U_PROT_SUPPORT", $desc="The Kerberos subsystem encountered an error. A service for user protocol request was made against a domain controller which does not support service for user."],
	[0xC000040B] = [$id="CROSSREALM_DELEGATION_FAILURE", $desc="An attempt was made by this server to make a Kerberos constrained delegation request for a target that is outside the server realm. This action is not supported and the resulting error indicates a misconfiguration on the allowed-to-delegate-to list for this server. Contact your administrator."],
	[0xC000040C] = [$id="REVOCATION_OFFLINE_KDC", $desc="The revocation status of the domain controller certificate used for smart card authentication could not be determined. There is additional information in the system event log. Contact your system administrator."],
	[0xC000040D] = [$id="ISSUING_CA_UNTRUSTED_KDC", $desc="An untrusted certificate authority was detected while processing the domain controller certificate used for authentication. There is additional information in the system event log. Contact your system administrator."],
	[0xC000040E] = [$id="KDC_CERT_EXPIRED", $desc="The domain controller certificate used for smart card logon has expired. Contact your system administrator with the contents of your system event log."],
	[0xC000040F] = [$id="KDC_CERT_REVOKED", $desc="The domain controller certificate used for smart card logon has been revoked. Contact your system administrator with the contents of your system event log."],
	[0xC0000410] = [$id="PARAMETER_QUOTA_EXCEEDED", $desc="Data present in one of the parameters is more than the function can operate on."],
	[0xC0000411] = [$id="HIBERNATION_FAILURE", $desc="The system has failed to hibernate (The error code is %hs). Hibernation will be disabled until the system is restarted."],
	[0xC0000412] = [$id="DELAY_LOAD_FAILED", $desc="An attempt to delay-load a .dll or get a function address in a delay-loaded .dll failed."],
	[0xC0000413] = [$id="AUTHENTICATION_FIREWALL_FAILED", $desc="Logon Failure: The machine you are logging onto is protected by an authentication firewall. The specified account is not allowed to authenticate to the machine."],
	[0xC0000414] = [$id="VDM_DISALLOWED", $desc="%hs is a 16-bit application. You do not have permissions to execute 16-bit applications. Check your permissions with your system administrator."],
	[0xC0000415] = [$id="HUNG_DISPLAY_DRIVER_THREAD", $desc="{Display Driver Stopped Responding} The %hs display driver has stopped working normally. Save your work and reboot the system to restore full display functionality. The next time you reboot the machine a dialog will be displayed giving you a chance to report this failure to Microsoft."],
	[0xC0000416] = [$id="INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE", $desc="The Desktop heap encountered an error while allocating session memory. There is more information in the system event log."],
	[0xC0000417] = [$id="INVALID_CRUNTIME_PARAMETER", $desc="An invalid parameter was passed to a C runtime function."],
	[0xC0000418] = [$id="NTLM_BLOCKED", $desc="The authentication failed because NTLM was blocked."],
	[0xC0000419] = [$id="DS_SRC_SID_EXISTS_IN_FOREST", $desc="The source object's SID already exists in destination forest."],
	[0xC000041A] = [$id="DS_DOMAIN_NAME_EXISTS_IN_FOREST", $desc="The domain name of the trusted domain already exists in the forest."],
	[0xC000041B] = [$id="DS_FLAT_NAME_EXISTS_IN_FOREST", $desc="The flat name of the trusted domain already exists in the forest."],
	[0xC000041C] = [$id="INVALID_USER_PRINCIPAL_NAME", $desc="The User Principal Name (UPN) is invalid."],
	[0xC0000420] = [$id="ASSERTION_FAILURE", $desc="There has been an assertion failure."],
	[0xC0000421] = [$id="VERIFIER_STOP", $desc="Application verifier has found an error in the current process."],
	[0xC0000423] = [$id="CALLBACK_POP_STACK", $desc="A user mode unwind is in progress."],
	[0xC0000424] = [$id="INCOMPATIBLE_DRIVER_BLOCKED", $desc="%2 has been blocked from loading due to incompatibility with this system. Contact your software vendor for a compatible version of the driver."],
	[0xC0000425] = [$id="HIVE_UNLOADED", $desc="Illegal operation attempted on a registry key which has already been unloaded."],
	[0xC0000426] = [$id="COMPRESSION_DISABLED", $desc="Compression is disabled for this volume."],
	[0xC0000427] = [$id="FILE_SYSTEM_LIMITATION", $desc="The requested operation could not be completed due to a file system limitation."],
	[0xC0000428] = [$id="INVALID_IMAGE_HASH", $desc="The hash for image %hs cannot be found in the system catalogs. The image is likely corrupt or the victim of tampering."],
	[0xC0000429] = [$id="NOT_CAPABLE", $desc="The implementation is not capable of performing the request."],
	[0xC000042A] = [$id="REQUEST_OUT_OF_SEQUENCE", $desc="The requested operation is out of order with respect to other operations."],
	[0xC000042B] = [$id="IMPLEMENTATION_LIMIT", $desc="An operation attempted to exceed an implementation-defined limit."],
	[0xC000042C] = [$id="ELEVATION_REQUIRED", $desc="The requested operation requires elevation."],
	[0xC000042D] = [$id="NO_SECURITY_CONTEXT", $desc="The required security context does not exist."],
	[0xC000042E] = [$id="PKU2U_CERT_FAILURE", $desc="The PKU2U protocol encountered an error while attempting to utilize the associated certificates."],
	[0xC0000432] = [$id="BEYOND_VDL", $desc="The operation was attempted beyond the valid data length of the file."],
	[0xC0000433] = [$id="ENCOUNTERED_WRITE_IN_PROGRESS", $desc="The attempted write operation encountered a write already in progress for some portion of the range."],
	[0xC0000434] = [$id="PTE_CHANGED", $desc="The page fault mappings changed in the middle of processing a fault so the operation must be retried."],
	[0xC0000435] = [$id="PURGE_FAILED", $desc="The attempt to purge this file from memory failed to purge some or all the data from memory."],
	[0xC0000440] = [$id="CRED_REQUIRES_CONFIRMATION", $desc="The requested credential requires confirmation."],
	[0xC0000441] = [$id="CS_ENCRYPTION_INVALID_SERVER_RESPONSE", $desc="The remote server sent an invalid response for a file being opened with Client Side Encryption."],
	[0xC0000442] = [$id="CS_ENCRYPTION_UNSUPPORTED_SERVER", $desc="Client Side Encryption is not supported by the remote server even though it claims to support it."],
	[0xC0000443] = [$id="CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE", $desc="File is encrypted and should be opened in Client Side Encryption mode."],
	[0xC0000444] = [$id="CS_ENCRYPTION_NEW_ENCRYPTED_FILE", $desc="A new encrypted file is being created and a $EFS needs to be provided."],
	[0xC0000445] = [$id="CS_ENCRYPTION_FILE_NOT_CSE", $desc="The SMB client requested a CSE FSCTL on a non-CSE file."],
	[0xC0000446] = [$id="INVALID_LABEL", $desc="Indicates a particular Security ID may not be assigned as the label of an object."],
	[0xC0000450] = [$id="DRIVER_PROCESS_TERMINATED", $desc="The process hosting the driver for this device has terminated."],
	[0xC0000451] = [$id="AMBIGUOUS_SYSTEM_DEVICE", $desc="The requested system device cannot be identified due to multiple indistinguishable devices potentially matching the identification criteria."],
	[0xC0000452] = [$id="SYSTEM_DEVICE_NOT_FOUND", $desc="The requested system device cannot be found."],
	[0xC0000453] = [$id="RESTART_BOOT_APPLICATION", $desc="This boot application must be restarted."],
	[0xC0000454] = [$id="INSUFFICIENT_NVRAM_RESOURCES", $desc="Insufficient NVRAM resources exist to complete the API.  A reboot might be required."],
	[0xC0000460] = [$id="NO_RANGES_PROCESSED", $desc="No ranges for the specified operation were able to be processed."],
	[0xC0000463] = [$id="DEVICE_FEATURE_NOT_SUPPORTED", $desc="The storage device does not support Offload Write."],
	[0xC0000464] = [$id="DEVICE_UNREACHABLE", $desc="Data cannot be moved because the source device cannot communicate with the destination device."],
	[0xC0000465] = [$id="INVALID_TOKEN", $desc="The token representing the data is invalid or expired."],
	[0xC0000500] = [$id="INVALID_TASK_NAME", $desc="The specified task name is invalid."],
	[0xC0000501] = [$id="INVALID_TASK_INDEX", $desc="The specified task index is invalid."],
	[0xC0000502] = [$id="THREAD_ALREADY_IN_TASK", $desc="The specified thread is already joining a task."],
	[0xC0000503] = [$id="CALLBACK_BYPASS", $desc="A callback has requested to bypass native code."],
	[0xC0000602] = [$id="FAIL_FAST_EXCEPTION", $desc="A fail fast exception occurred. Exception handlers will not be invoked and the process will be terminated immediately."],
	[0xC0000603] = [$id="IMAGE_CERT_REVOKED", $desc="Windows cannot verify the digital signature for this file. The signing certificate for this file has been revoked."],
	[0xC0000700] = [$id="PORT_CLOSED", $desc="The ALPC port is closed."],
	[0xC0000701] = [$id="MESSAGE_LOST", $desc="The ALPC message requested is no longer available."],
	[0xC0000702] = [$id="INVALID_MESSAGE", $desc="The ALPC message supplied is invalid."],
	[0xC0000703] = [$id="REQUEST_CANCELED", $desc="The ALPC message has been canceled."],
	[0xC0000704] = [$id="RECURSIVE_DISPATCH", $desc="Invalid recursive dispatch attempt."],
	[0xC0000705] = [$id="LPC_RECEIVE_BUFFER_EXPECTED", $desc="No receive buffer has been supplied in a synchronous request."],
	[0xC0000706] = [$id="LPC_INVALID_CONNECTION_USAGE", $desc="The connection port is used in an invalid context."],
	[0xC0000707] = [$id="LPC_REQUESTS_NOT_ALLOWED", $desc="The ALPC port does not accept new request messages."],
	[0xC0000708] = [$id="RESOURCE_IN_USE", $desc="The resource requested is already in use."],
	[0xC0000709] = [$id="HARDWARE_MEMORY_ERROR", $desc="The hardware has reported an uncorrectable memory error."],
	[0xC000070A] = [$id="THREADPOOL_HANDLE_EXCEPTION", $desc="Status 0x%08x was returned, waiting on handle 0x%x for wait 0x%p, in waiter 0x%p."],
	[0xC000070B] = [$id="THREADPOOL_SET_EVENT_ON_COMPLETION_FAILED", $desc="After a callback to 0x%p(0x%p), a completion call to Set event(0x%p) failed with status 0x%08x."],
	[0xC000070C] = [$id="THREADPOOL_RELEASE_SEMAPHORE_ON_COMPLETION_FAILED", $desc="After a callback to 0x%p(0x%p), a completion call to ReleaseSemaphore(0x%p, %d) failed with status 0x%08x."],
	[0xC000070D] = [$id="THREADPOOL_RELEASE_MUTEX_ON_COMPLETION_FAILED", $desc="After a callback to 0x%p(0x%p), a completion call to ReleaseMutex(%p) failed with status 0x%08x."],
	[0xC000070E] = [$id="THREADPOOL_FREE_LIBRARY_ON_COMPLETION_FAILED", $desc="After a callback to 0x%p(0x%p), a completion call to FreeLibrary(%p) failed with status 0x%08x."],
	[0xC000070F] = [$id="THREADPOOL_RELEASED_DURING_OPERATION", $desc="The thread pool 0x%p was released while a thread was posting a callback to 0x%p(0x%p) to it."],
	[0xC0000710] = [$id="CALLBACK_RETURNED_WHILE_IMPERSONATING", $desc="A thread pool worker thread is impersonating a client, after a callback to 0x%p(0x%p). This is unexpected, indicating that the callback is missing a call to revert the impersonation."],
	[0xC0000711] = [$id="APC_RETURNED_WHILE_IMPERSONATING", $desc="A thread pool worker thread is impersonating a client, after executing an APC. This is unexpected, indicating that the APC is missing a call to revert the impersonation."],
	[0xC0000712] = [$id="PROCESS_IS_PROTECTED", $desc="Either the target process, or the target thread's containing process, is a protected process."],
	[0xC0000713] = [$id="MCA_EXCEPTION", $desc="A thread is getting dispatched with MCA EXCEPTION because of MCA."],
	[0xC0000714] = [$id="CERTIFICATE_MAPPING_NOT_UNIQUE", $desc="The client certificate account mapping is not unique."],
	[0xC0000715] = [$id="SYMLINK_CLASS_DISABLED", $desc="The symbolic link cannot be followed because its type is disabled."],
	[0xC0000716] = [$id="INVALID_IDN_NORMALIZATION", $desc="Indicates that the specified string is not valid for IDN normalization."],
	[0xC0000717] = [$id="NO_UNICODE_TRANSLATION", $desc="No mapping for the Unicode character exists in the target multi-byte code page."],
	[0xC0000718] = [$id="ALREADY_REGISTERED", $desc="The provided callback is already registered."],
	[0xC0000719] = [$id="CONTEXT_MISMATCH", $desc="The provided context did not match the target."],
	[0xC000071A] = [$id="PORT_ALREADY_HAS_COMPLETION_LIST", $desc="The specified port already has a completion list."],
	[0xC000071B] = [$id="CALLBACK_RETURNED_THREAD_PRIORITY", $desc="A threadpool worker thread entered a callback at thread base priority 0x%x and exited at priority 0x%x."],
	[0xC000071C] = [$id="INVALID_THREAD", $desc="An invalid thread, handle %p, is specified for this operation. Possibly, a threadpool worker thread was specified."],
	[0xC000071D] = [$id="CALLBACK_RETURNED_TRANSACTION", $desc="A threadpool worker thread entered a callback, which left transaction state."],
	[0xC000071E] = [$id="CALLBACK_RETURNED_LDR_LOCK", $desc="A threadpool worker thread entered a callback, which left the loader lock held."],
	[0xC000071F] = [$id="CALLBACK_RETURNED_LANG", $desc="A threadpool worker thread entered a callback, which left with preferred languages set."],
	[0xC0000720] = [$id="CALLBACK_RETURNED_PRI_BACK", $desc="A threadpool worker thread entered a callback, which left with background priorities set."],
	[0xC0000800] = [$id="DISK_REPAIR_DISABLED", $desc="The attempted operation required self healing to be enabled."],
	[0xC0000801] = [$id="DS_DOMAIN_RENAME_IN_PROGRESS", $desc="The directory service cannot perform the requested operation because a domain rename operation is in progress."],
	[0xC0000802] = [$id="DISK_QUOTA_EXCEEDED", $desc="An operation failed because the storage quota was exceeded."],
	[0xC0000804] = [$id="CONTENT_BLOCKED", $desc="An operation failed because the content was blocked."],
	[0xC0000805] = [$id="BAD_CLUSTERS", $desc="The operation could not be completed due to bad clusters on disk."],
	[0xC0000806] = [$id="VOLUME_DIRTY", $desc="The operation could not be completed because the volume is dirty. Please run the Chkdsk utility and try again. "],
	[0xC0000901] = [$id="FILE_CHECKED_OUT", $desc="This file is checked out or locked for editing by another user."],
	[0xC0000902] = [$id="CHECKOUT_REQUIRED", $desc="The file must be checked out before saving changes."],
	[0xC0000903] = [$id="BAD_FILE_TYPE", $desc="The file type being saved or retrieved has been blocked."],
	[0xC0000904] = [$id="FILE_TOO_LARGE", $desc="The file size exceeds the limit allowed and cannot be saved."],
	[0xC0000905] = [$id="FORMS_AUTH_REQUIRED", $desc="Access Denied. Before opening files in this location, you must first browse to the e.g. site and select the option to log on automatically."],
	[0xC0000906] = [$id="VIRUS_INFECTED", $desc="The operation did not complete successfully because the file contains a virus."],
	[0xC0000907] = [$id="VIRUS_DELETED", $desc="This file contains a virus and cannot be opened. Due to the nature of this virus, the file has been removed from this location."],
	[0xC0000908] = [$id="BAD_MCFG_TABLE", $desc="The resources required for this device conflict with the MCFG table."],
	[0xC0000909] = [$id="CANNOT_BREAK_OPLOCK", $desc="The operation did not complete successfully because it would cause an oplock to be broken. The caller has requested that existing oplocks not be broken."],
	[0xC0009898] = [$id="WOW_ASSERTION", $desc="WOW Assertion Error."],
	[0xC000A000] = [$id="INVALID_SIGNATURE", $desc="The cryptographic signature is invalid."],
	[0xC000A001] = [$id="HMAC_NOT_SUPPORTED", $desc="The cryptographic provider does not support HMAC."],
	[0xC000A010] = [$id="IPSEC_QUEUE_OVERFLOW", $desc="The IPsec queue overflowed."],
	[0xC000A011] = [$id="ND_QUEUE_OVERFLOW", $desc="The neighbor discovery queue overflowed."],
	[0xC000A012] = [$id="HOPLIMIT_EXCEEDED", $desc="An Internet Control Message Protocol (ICMP) hop limit exceeded error was received."],
	[0xC000A013] = [$id="PROTOCOL_NOT_SUPPORTED", $desc="The protocol is not installed on the local machine."],
	[0xC000A080] = [$id="LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED", $desc="{Delayed Write Failed} Windows was unable to save all the data for the file %hs; the data has been lost. This error may be caused by network connectivity issues. Try to save this file elsewhere."],
	[0xC000A081] = [$id="LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR", $desc="{Delayed Write Failed} Windows was unable to save all the data for the file %hs; the data has been lost. This error was returned by the server on which the file exists. Try to save this file elsewhere."],
	[0xC000A082] = [$id="LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR", $desc="{Delayed Write Failed} Windows was unable to save all the data for the file %hs; the data has been lost. This error may be caused if the device has been removed or the media is write-protected."],
	[0xC000A083] = [$id="XML_PARSE_ERROR", $desc="Windows was unable to parse the requested XML data."],
	[0xC000A084] = [$id="XMLDSIG_ERROR", $desc="An error was encountered while processing an XML digital signature."],
	[0xC000A085] = [$id="WRONG_COMPARTMENT", $desc="This indicates that the caller made the connection request in the wrong routing compartment."],
	[0xC000A086] = [$id="AUTHIP_FAILURE", $desc="This indicates that there was an AuthIP failure when attempting to connect to the remote host."],
	[0xC000A087] = [$id="DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS", $desc="OID mapped groups cannot have members."],
	[0xC000A088] = [$id="DS_OID_NOT_FOUND", $desc="The specified OID cannot be found."],
	[0xC000A100] = [$id="HASH_NOT_SUPPORTED", $desc="Hash generation for the specified version and hash type is not enabled on server."],
	[0xC000A101] = [$id="HASH_NOT_PRESENT", $desc="The hash requests is not present or not up to date with the current file contents."],
	[0xC000A2A1] = [$id="OFFLOAD_READ_FLT_NOT_SUPPORTED", $desc="A file system filter on the server has not opted in for Offload Read support."],
	[0xC000A2A2] = [$id="OFFLOAD_WRITE_FLT_NOT_SUPPORTED", $desc="A file system filter on the server has not opted in for Offload Write support."],
	[0xC000A2A3] = [$id="OFFLOAD_READ_FILE_NOT_SUPPORTED", $desc="Offload read operations cannot be performed on:"],
	[0xC000A2A4] = [$id="OFFLOAD_WRITE_FILE_NOT_SUPPORTED", $desc="Offload write operations cannot be performed on:"],
	[0xC0010001] = [$id="DBG_NO_STATE_CHANGE", $desc="The debugger did not perform a state change."],
	[0xC0010002] = [$id="DBG_APP_NOT_IDLE", $desc="The debugger found that the application is not idle."],
	[0xC0020001] = [$id="RPC_NT_INVALID_STRING_BINDING", $desc="The string binding is invalid."],
	[0xC0020002] = [$id="RPC_NT_WRONG_KIND_OF_BINDING", $desc="The binding handle is not the correct type."],
	[0xC0020003] = [$id="RPC_NT_INVALID_BINDING", $desc="The binding handle is invalid."],
	[0xC0020004] = [$id="RPC_NT_PROTSEQ_NOT_SUPPORTED", $desc="The RPC protocol sequence is not supported."],
	[0xC0020005] = [$id="RPC_NT_INVALID_RPC_PROTSEQ", $desc="The RPC protocol sequence is invalid."],
	[0xC0020006] = [$id="RPC_NT_INVALID_STRING_UUID", $desc="The string UUID is invalid."],
	[0xC0020007] = [$id="RPC_NT_INVALID_ENDPOINT_FORMAT", $desc="The endpoint format is invalid."],
	[0xC0020008] = [$id="RPC_NT_INVALID_NET_ADDR", $desc="The network address is invalid."],
	[0xC0020009] = [$id="RPC_NT_NO_ENDPOINT_FOUND", $desc="No endpoint was found."],
	[0xC002000A] = [$id="RPC_NT_INVALID_TIMEOUT", $desc="The time-out value is invalid."],
	[0xC002000B] = [$id="RPC_NT_OBJECT_NOT_FOUND", $desc="The object UUID was not found."],
	[0xC002000C] = [$id="RPC_NT_ALREADY_REGISTERED", $desc="The object UUID has already been registered."],
	[0xC002000D] = [$id="RPC_NT_TYPE_ALREADY_REGISTERED", $desc="The type UUID has already been registered."],
	[0xC002000E] = [$id="RPC_NT_ALREADY_LISTENING", $desc="The RPC server is already listening."],
	[0xC002000F] = [$id="RPC_NT_NO_PROTSEQS_REGISTERED", $desc="No protocol sequences have been registered."],
	[0xC0020010] = [$id="RPC_NT_NOT_LISTENING", $desc="The RPC server is not listening."],
	[0xC0020011] = [$id="RPC_NT_UNKNOWN_MGR_TYPE", $desc="The manager type is unknown."],
	[0xC0020012] = [$id="RPC_NT_UNKNOWN_IF", $desc="The interface is unknown."],
	[0xC0020013] = [$id="RPC_NT_NO_BINDINGS", $desc="There are no bindings."],
	[0xC0020014] = [$id="RPC_NT_NO_PROTSEQS", $desc="There are no protocol sequences."],
	[0xC0020015] = [$id="RPC_NT_CANT_CREATE_ENDPOINT", $desc="The endpoint cannot be created."],
	[0xC0020016] = [$id="RPC_NT_OUT_OF_RESOURCES", $desc="Insufficient resources are available to complete this operation."],
	[0xC0020017] = [$id="RPC_NT_SERVER_UNAVAILABLE", $desc="The RPC server is unavailable."],
	[0xC0020018] = [$id="RPC_NT_SERVER_TOO_BUSY", $desc="The RPC server is too busy to complete this operation."],
	[0xC0020019] = [$id="RPC_NT_INVALID_NETWORK_OPTIONS", $desc="The network options are invalid."],
	[0xC002001A] = [$id="RPC_NT_NO_CALL_ACTIVE", $desc="No RPCs are active on this thread."],
	[0xC002001B] = [$id="RPC_NT_CALL_FAILED", $desc="The RPC failed."],
	[0xC002001C] = [$id="RPC_NT_CALL_FAILED_DNE", $desc="The RPC failed and did not execute."],
	[0xC002001D] = [$id="RPC_NT_PROTOCOL_ERROR", $desc="An RPC protocol error occurred."],
	[0xC002001F] = [$id="RPC_NT_UNSUPPORTED_TRANS_SYN", $desc="The RPC server does not support the transfer syntax."],
	[0xC0020021] = [$id="RPC_NT_UNSUPPORTED_TYPE", $desc="The type UUID is not supported."],
	[0xC0020022] = [$id="RPC_NT_INVALID_TAG", $desc="The tag is invalid."],
	[0xC0020023] = [$id="RPC_NT_INVALID_BOUND", $desc="The array bounds are invalid."],
	[0xC0020024] = [$id="RPC_NT_NO_ENTRY_NAME", $desc="The binding does not contain an entry name."],
	[0xC0020025] = [$id="RPC_NT_INVALID_NAME_SYNTAX", $desc="The name syntax is invalid."],
	[0xC0020026] = [$id="RPC_NT_UNSUPPORTED_NAME_SYNTAX", $desc="The name syntax is not supported."],
	[0xC0020028] = [$id="RPC_NT_UUID_NO_ADDRESS", $desc="No network address is available to construct a UUID."],
	[0xC0020029] = [$id="RPC_NT_DUPLICATE_ENDPOINT", $desc="The endpoint is a duplicate."],
	[0xC002002A] = [$id="RPC_NT_UNKNOWN_AUTHN_TYPE", $desc="The authentication type is unknown."],
	[0xC002002B] = [$id="RPC_NT_MAX_CALLS_TOO_SMALL", $desc="The maximum number of calls is too small."],
	[0xC002002C] = [$id="RPC_NT_STRING_TOO_LONG", $desc="The string is too long."],
	[0xC002002D] = [$id="RPC_NT_PROTSEQ_NOT_FOUND", $desc="The RPC protocol sequence was not found."],
	[0xC002002E] = [$id="RPC_NT_PROCNUM_OUT_OF_RANGE", $desc="The procedure number is out of range."],
	[0xC002002F] = [$id="RPC_NT_BINDING_HAS_NO_AUTH", $desc="The binding does not contain any authentication information."],
	[0xC0020030] = [$id="RPC_NT_UNKNOWN_AUTHN_SERVICE", $desc="The authentication service is unknown."],
	[0xC0020031] = [$id="RPC_NT_UNKNOWN_AUTHN_LEVEL", $desc="The authentication level is unknown."],
	[0xC0020032] = [$id="RPC_NT_INVALID_AUTH_IDENTITY", $desc="The security context is invalid."],
	[0xC0020033] = [$id="RPC_NT_UNKNOWN_AUTHZ_SERVICE", $desc="The authorization service is unknown."],
	[0xC0020034] = [$id="EPT_NT_INVALID_ENTRY", $desc="The entry is invalid."],
	[0xC0020035] = [$id="EPT_NT_CANT_PERFORM_OP", $desc="The operation cannot be performed."],
	[0xC0020036] = [$id="EPT_NT_NOT_REGISTERED", $desc="No more endpoints are available from the endpoint mapper."],
	[0xC0020037] = [$id="RPC_NT_NOTHING_TO_EXPORT", $desc="No interfaces have been exported."],
	[0xC0020038] = [$id="RPC_NT_INCOMPLETE_NAME", $desc="The entry name is incomplete."],
	[0xC0020039] = [$id="RPC_NT_INVALID_VERS_OPTION", $desc="The version option is invalid."],
	[0xC002003A] = [$id="RPC_NT_NO_MORE_MEMBERS", $desc="There are no more members."],
	[0xC002003B] = [$id="RPC_NT_NOT_ALL_OBJS_UNEXPORTED", $desc="There is nothing to unexport."],
	[0xC002003C] = [$id="RPC_NT_INTERFACE_NOT_FOUND", $desc="The interface was not found."],
	[0xC002003D] = [$id="RPC_NT_ENTRY_ALREADY_EXISTS", $desc="The entry already exists."],
	[0xC002003E] = [$id="RPC_NT_ENTRY_NOT_FOUND", $desc="The entry was not found."],
	[0xC002003F] = [$id="RPC_NT_NAME_SERVICE_UNAVAILABLE", $desc="The name service is unavailable."],
	[0xC0020040] = [$id="RPC_NT_INVALID_NAF_ID", $desc="The network address family is invalid."],
	[0xC0020041] = [$id="RPC_NT_CANNOT_SUPPORT", $desc="The requested operation is not supported."],
	[0xC0020042] = [$id="RPC_NT_NO_CONTEXT_AVAILABLE", $desc="No security context is available to allow impersonation."],
	[0xC0020043] = [$id="RPC_NT_INTERNAL_ERROR", $desc="An internal error occurred in the RPC."],
	[0xC0020044] = [$id="RPC_NT_ZERO_DIVIDE", $desc="The RPC server attempted to divide an integer by zero."],
	[0xC0020045] = [$id="RPC_NT_ADDRESS_ERROR", $desc="An addressing error occurred in the RPC server."],
	[0xC0020046] = [$id="RPC_NT_FP_DIV_ZERO", $desc="A floating point operation at the RPC server caused a divide by zero."],
	[0xC0020047] = [$id="RPC_NT_FP_UNDERFLOW", $desc="A floating point underflow occurred at the RPC server."],
	[0xC0020048] = [$id="RPC_NT_FP_OVERFLOW", $desc="A floating point overflow occurred at the RPC server."],
	[0xC0020049] = [$id="RPC_NT_CALL_IN_PROGRESS", $desc="An RPC is already in progress for this thread."],
	[0xC002004A] = [$id="RPC_NT_NO_MORE_BINDINGS", $desc="There are no more bindings."],
	[0xC002004B] = [$id="RPC_NT_GROUP_MEMBER_NOT_FOUND", $desc="The group member was not found."],
	[0xC002004C] = [$id="EPT_NT_CANT_CREATE", $desc="The endpoint mapper database entry could not be created."],
	[0xC002004D] = [$id="RPC_NT_INVALID_OBJECT", $desc="The object UUID is the nil UUID."],
	[0xC002004F] = [$id="RPC_NT_NO_INTERFACES", $desc="No interfaces have been registered."],
	[0xC0020050] = [$id="RPC_NT_CALL_CANCELLED", $desc="The RPC was canceled."],
	[0xC0020051] = [$id="RPC_NT_BINDING_INCOMPLETE", $desc="The binding handle does not contain all the required information."],
	[0xC0020052] = [$id="RPC_NT_COMM_FAILURE", $desc="A communications failure occurred during an RPC."],
	[0xC0020053] = [$id="RPC_NT_UNSUPPORTED_AUTHN_LEVEL", $desc="The requested authentication level is not supported."],
	[0xC0020054] = [$id="RPC_NT_NO_PRINC_NAME", $desc="No principal name was registered."],
	[0xC0020055] = [$id="RPC_NT_NOT_RPC_ERROR", $desc="The error specified is not a valid Windows RPC error code."],
	[0xC0020057] = [$id="RPC_NT_SEC_PKG_ERROR", $desc="A security package-specific error occurred."],
	[0xC0020058] = [$id="RPC_NT_NOT_CANCELLED", $desc="The thread was not canceled."],
	[0xC0020062] = [$id="RPC_NT_INVALID_ASYNC_HANDLE", $desc="Invalid asynchronous RPC handle."],
	[0xC0020063] = [$id="RPC_NT_INVALID_ASYNC_CALL", $desc="Invalid asynchronous RPC call handle for this operation."],
	[0xC0020064] = [$id="RPC_NT_PROXY_ACCESS_DENIED", $desc="Access to the HTTP proxy is denied."],
	[0xC0030001] = [$id="RPC_NT_NO_MORE_ENTRIES", $desc="The list of RPC servers available for auto-handle binding has been exhausted."],
	[0xC0030002] = [$id="RPC_NT_SS_CHAR_TRANS_OPEN_FAIL", $desc="The file designated by DCERPCCHARTRANS cannot be opened."],
	[0xC0030003] = [$id="RPC_NT_SS_CHAR_TRANS_SHORT_FILE", $desc="The file containing the character translation table has fewer than 512 bytes."],
	[0xC0030004] = [$id="RPC_NT_SS_IN_NULL_CONTEXT", $desc="A null context handle is passed as an [in] parameter."],
	[0xC0030005] = [$id="RPC_NT_SS_CONTEXT_MISMATCH", $desc="The context handle does not match any known context handles."],
	[0xC0030006] = [$id="RPC_NT_SS_CONTEXT_DAMAGED", $desc="The context handle changed during a call."],
	[0xC0030007] = [$id="RPC_NT_SS_HANDLES_MISMATCH", $desc="The binding handles passed to an RPC do not match."],
	[0xC0030008] = [$id="RPC_NT_SS_CANNOT_GET_CALL_HANDLE", $desc="The stub is unable to get the call handle."],
	[0xC0030009] = [$id="RPC_NT_NULL_REF_POINTER", $desc="A null reference pointer was passed to the stub."],
	[0xC003000A] = [$id="RPC_NT_ENUM_VALUE_OUT_OF_RANGE", $desc="The enumeration value is out of range."],
	[0xC003000B] = [$id="RPC_NT_BYTE_COUNT_TOO_SMALL", $desc="The byte count is too small."],
	[0xC003000C] = [$id="RPC_NT_BAD_STUB_DATA", $desc="The stub received bad data."],
	[0xC0030059] = [$id="RPC_NT_INVALID_ES_ACTION", $desc="Invalid operation on the encoding/decoding handle."],
	[0xC003005A] = [$id="RPC_NT_WRONG_ES_VERSION", $desc="Incompatible version of the serializing package."],
	[0xC003005B] = [$id="RPC_NT_WRONG_STUB_VERSION", $desc="Incompatible version of the RPC stub."],
	[0xC003005C] = [$id="RPC_NT_INVALID_PIPE_OBJECT", $desc="The RPC pipe object is invalid or corrupt."],
	[0xC003005D] = [$id="RPC_NT_INVALID_PIPE_OPERATION", $desc="An invalid operation was attempted on an RPC pipe object."],
	[0xC003005E] = [$id="RPC_NT_WRONG_PIPE_VERSION", $desc="Unsupported RPC pipe version."],
	[0xC003005F] = [$id="RPC_NT_PIPE_CLOSED", $desc="The RPC pipe object has already been closed."],
	[0xC0030060] = [$id="RPC_NT_PIPE_DISCIPLINE_ERROR", $desc="The RPC call completed before all pipes were processed."],
	[0xC0030061] = [$id="RPC_NT_PIPE_EMPTY", $desc="No more data is available from the RPC pipe."],
	[0xC0040035] = [$id="PNP_BAD_MPS_TABLE", $desc="A device is missing in the system BIOS MPS table. This device will not be used. Contact your system vendor for a system BIOS update."],
	[0xC0040036] = [$id="PNP_TRANSLATION_FAILED", $desc="A translator failed to translate resources."],
	[0xC0040037] = [$id="PNP_IRQ_TRANSLATION_FAILED", $desc="An IRQ translator failed to translate resources."],
	[0xC0040038] = [$id="PNP_INVALID_ID", $desc="Driver %2 returned an invalid ID for a child device (%3)."],
	[0xC0040039] = [$id="IO_REISSUE_AS_CACHED", $desc="Reissue the given operation as a cached I/O operation"],
	[0xC00A0001] = [$id="CTX_WINSTATION_NAME_INVALID", $desc="Session name %1 is invalid."],
	[0xC00A0002] = [$id="CTX_INVALID_PD", $desc="The protocol driver %1 is invalid."],
	[0xC00A0003] = [$id="CTX_PD_NOT_FOUND", $desc="The protocol driver %1 was not found in the system path."],
	[0xC00A0006] = [$id="CTX_CLOSE_PENDING", $desc="A close operation is pending on the terminal connection."],
	[0xC00A0007] = [$id="CTX_NO_OUTBUF", $desc="No free output buffers are available."],
	[0xC00A0008] = [$id="CTX_MODEM_INF_NOT_FOUND", $desc="The MODEM.INF file was not found."],
	[0xC00A0009] = [$id="CTX_INVALID_MODEMNAME", $desc="The modem (%1) was not found in the MODEM.INF file."],
	[0xC00A000A] = [$id="CTX_RESPONSE_ERROR", $desc="The modem did not accept the command sent to it. Verify that the configured modem name matches the attached modem."],
	[0xC00A000B] = [$id="CTX_MODEM_RESPONSE_TIMEOUT", $desc="The modem did not respond to the command sent to it. Verify that the modem cable is properly attached and the modem is turned on."],
	[0xC00A000C] = [$id="CTX_MODEM_RESPONSE_NO_CARRIER", $desc="Carrier detection has failed or the carrier has been dropped due to disconnection."],
	[0xC00A000D] = [$id="CTX_MODEM_RESPONSE_NO_DIALTONE", $desc="A dial tone was not detected within the required time. Verify that the phone cable is properly attached and functional."],
	[0xC00A000E] = [$id="CTX_MODEM_RESPONSE_BUSY", $desc="A busy signal was detected at a remote site on callback."],
	[0xC00A000F] = [$id="CTX_MODEM_RESPONSE_VOICE", $desc="A voice was detected at a remote site on callback."],
	[0xC00A0010] = [$id="CTX_TD_ERROR", $desc="Transport driver error."],
	[0xC00A0012] = [$id="CTX_LICENSE_CLIENT_INVALID", $desc="The client you are using is not licensed to use this system. Your logon request is denied."],
	[0xC00A0013] = [$id="CTX_LICENSE_NOT_AVAILABLE", $desc="The system has reached its licensed logon limit. Try again later."],
	[0xC00A0014] = [$id="CTX_LICENSE_EXPIRED", $desc="The system license has expired. Your logon request is denied."],
	[0xC00A0015] = [$id="CTX_WINSTATION_NOT_FOUND", $desc="The specified session cannot be found."],
	[0xC00A0016] = [$id="CTX_WINSTATION_NAME_COLLISION", $desc="The specified session name is already in use."],
	[0xC00A0017] = [$id="CTX_WINSTATION_BUSY", $desc="The requested operation cannot be completed because the terminal connection is currently processing a connect, disconnect, reset, or delete operation."],
	[0xC00A0018] = [$id="CTX_BAD_VIDEO_MODE", $desc="An attempt has been made to connect to a session whose video mode is not supported by the current client."],
	[0xC00A0022] = [$id="CTX_GRAPHICS_INVALID", $desc="The application attempted to enable DOS graphics mode. DOS graphics mode is not supported."],
	[0xC00A0024] = [$id="CTX_NOT_CONSOLE", $desc="The requested operation can be performed only on the system console. This is most often the result of a driver or system DLL requiring direct console access."],
	[0xC00A0026] = [$id="CTX_CLIENT_QUERY_TIMEOUT", $desc="The client failed to respond to the server connect message."],
	[0xC00A0027] = [$id="CTX_CONSOLE_DISCONNECT", $desc="Disconnecting the console session is not supported."],
	[0xC00A0028] = [$id="CTX_CONSOLE_CONNECT", $desc="Reconnecting a disconnected session to the console is not supported."],
	[0xC00A002A] = [$id="CTX_SHADOW_DENIED", $desc="The request to control another session remotely was denied."],
	[0xC00A002B] = [$id="CTX_WINSTATION_ACCESS_DENIED", $desc="A process has requested access to a session, but has not been granted those access rights."],
	[0xC00A002E] = [$id="CTX_INVALID_WD", $desc="The terminal connection driver %1 is invalid."],
	[0xC00A002F] = [$id="CTX_WD_NOT_FOUND", $desc="The terminal connection driver %1 was not found in the system path."],
	[0xC00A0030] = [$id="CTX_SHADOW_INVALID", $desc="The requested session cannot be controlled remotely. You cannot control your own session, a session that is trying to control your session, a session that has no user logged on, or other sessions from the console."],
	[0xC00A0031] = [$id="CTX_SHADOW_DISABLED", $desc="The requested session is not configured to allow remote control."],
	[0xC00A0032] = [$id="RDP_PROTOCOL_ERROR", $desc="The RDP protocol component %2 detected an error in the protocol stream and has disconnected the client."],
	[0xC00A0033] = [$id="CTX_CLIENT_LICENSE_NOT_SET", $desc="Your request to connect to this terminal server has been rejected. Your terminal server client license number has not been entered for this copy of the terminal client. Contact your system administrator for help in entering a valid, unique license number for this terminal server client. Click OK to continue."],
	[0xC00A0034] = [$id="CTX_CLIENT_LICENSE_IN_USE", $desc="Your request to connect to this terminal server has been rejected. Your terminal server client license number is currently being used by another user. Contact your system administrator to obtain a new copy of the terminal server client with a valid, unique license number. Click OK to continue."],
	[0xC00A0035] = [$id="CTX_SHADOW_ENDED_BY_MODE_CHANGE", $desc="The remote control of the console was terminated because the display mode was changed. Changing the display mode in a remote control session is not supported."],
	[0xC00A0036] = [$id="CTX_SHADOW_NOT_RUNNING", $desc="Remote control could not be terminated because the specified session is not currently being remotely controlled."],
	[0xC00A0037] = [$id="CTX_LOGON_DISABLED", $desc="Your interactive logon privilege has been disabled. Contact your system administrator."],
	[0xC00A0038] = [$id="CTX_SECURITY_LAYER_ERROR", $desc="The terminal server security layer detected an error in the protocol stream and has disconnected the client."],
	[0xC00A0039] = [$id="TS_INCOMPATIBLE_SESSIONS", $desc="The target session is incompatible with the current session."],
	[0xC00B0001] = [$id="MUI_FILE_NOT_FOUND", $desc="The resource loader failed to find an MUI file."],
	[0xC00B0002] = [$id="MUI_INVALID_FILE", $desc="The resource loader failed to load an MUI file because the file failed to pass validation."],
	[0xC00B0003] = [$id="MUI_INVALID_RC_CONFIG", $desc="The RC manifest is corrupted with garbage data, is an unsupported version, or is missing a required item."],
	[0xC00B0004] = [$id="MUI_INVALID_LOCALE_NAME", $desc="The RC manifest has an invalid culture name."],
	[0xC00B0005] = [$id="MUI_INVALID_ULTIMATEFALLBACK_NAME", $desc="The RC manifest has and invalid ultimate fallback name."],
	[0xC00B0006] = [$id="MUI_FILE_NOT_LOADED", $desc="The resource loader cache does not have a loaded MUI entry."],
	[0xC00B0007] = [$id="RESOURCE_ENUM_USER_STOP", $desc="The user stopped resource enumeration."],
	[0xC0130001] = [$id="CLUSTER_INVALID_NODE", $desc="The cluster node is not valid."],
	[0xC0130002] = [$id="CLUSTER_NODE_EXISTS", $desc="The cluster node already exists."],
	[0xC0130003] = [$id="CLUSTER_JOIN_IN_PROGRESS", $desc="A node is in the process of joining the cluster."],
	[0xC0130004] = [$id="CLUSTER_NODE_NOT_FOUND", $desc="The cluster node was not found."],
	[0xC0130005] = [$id="CLUSTER_LOCAL_NODE_NOT_FOUND", $desc="The cluster local node information was not found."],
	[0xC0130006] = [$id="CLUSTER_NETWORK_EXISTS", $desc="The cluster network already exists."],
	[0xC0130007] = [$id="CLUSTER_NETWORK_NOT_FOUND", $desc="The cluster network was not found."],
	[0xC0130008] = [$id="CLUSTER_NETINTERFACE_EXISTS", $desc="The cluster network interface already exists."],
	[0xC0130009] = [$id="CLUSTER_NETINTERFACE_NOT_FOUND", $desc="The cluster network interface was not found."],
	[0xC013000A] = [$id="CLUSTER_INVALID_REQUEST", $desc="The cluster request is not valid for this object."],
	[0xC013000B] = [$id="CLUSTER_INVALID_NETWORK_PROVIDER", $desc="The cluster network provider is not valid."],
	[0xC013000C] = [$id="CLUSTER_NODE_DOWN", $desc="The cluster node is down."],
	[0xC013000D] = [$id="CLUSTER_NODE_UNREACHABLE", $desc="The cluster node is not reachable."],
	[0xC013000E] = [$id="CLUSTER_NODE_NOT_MEMBER", $desc="The cluster node is not a member of the cluster."],
	[0xC013000F] = [$id="CLUSTER_JOIN_NOT_IN_PROGRESS", $desc="A cluster join operation is not in progress."],
	[0xC0130010] = [$id="CLUSTER_INVALID_NETWORK", $desc="The cluster network is not valid."],
	[0xC0130011] = [$id="CLUSTER_NO_NET_ADAPTERS", $desc="No network adapters are available."],
	[0xC0130012] = [$id="CLUSTER_NODE_UP", $desc="The cluster node is up."],
	[0xC0130013] = [$id="CLUSTER_NODE_PAUSED", $desc="The cluster node is paused."],
	[0xC0130014] = [$id="CLUSTER_NODE_NOT_PAUSED", $desc="The cluster node is not paused."],
	[0xC0130015] = [$id="CLUSTER_NO_SECURITY_CONTEXT", $desc="No cluster security context is available."],
	[0xC0130016] = [$id="CLUSTER_NETWORK_NOT_INTERNAL", $desc="The cluster network is not configured for internal cluster communication."],
	[0xC0130017] = [$id="CLUSTER_POISONED", $desc="The cluster node has been poisoned."],
	[0xC0140001] = [$id="ACPI_INVALID_OPCODE", $desc="An attempt was made to run an invalid AML opcode."],
	[0xC0140002] = [$id="ACPI_STACK_OVERFLOW", $desc="The AML interpreter stack has overflowed."],
	[0xC0140003] = [$id="ACPI_ASSERT_FAILED", $desc="An inconsistent state has occurred."],
	[0xC0140004] = [$id="ACPI_INVALID_INDEX", $desc="An attempt was made to access an array outside its bounds."],
	[0xC0140005] = [$id="ACPI_INVALID_ARGUMENT", $desc="A required argument was not specified."],
	[0xC0140006] = [$id="ACPI_FATAL", $desc="A fatal error has occurred."],
	[0xC0140007] = [$id="ACPI_INVALID_SUPERNAME", $desc="An invalid SuperName was specified."],
	[0xC0140008] = [$id="ACPI_INVALID_ARGTYPE", $desc="An argument with an incorrect type was specified."],
	[0xC0140009] = [$id="ACPI_INVALID_OBJTYPE", $desc="An object with an incorrect type was specified."],
	[0xC014000A] = [$id="ACPI_INVALID_TARGETTYPE", $desc="A target with an incorrect type was specified."],
	[0xC014000B] = [$id="ACPI_INCORRECT_ARGUMENT_COUNT", $desc="An incorrect number of arguments was specified."],
	[0xC014000C] = [$id="ACPI_ADDRESS_NOT_MAPPED", $desc="An address failed to translate."],
	[0xC014000D] = [$id="ACPI_INVALID_EVENTTYPE", $desc="An incorrect event type was specified."],
	[0xC014000E] = [$id="ACPI_HANDLER_COLLISION", $desc="A handler for the target already exists."],
	[0xC014000F] = [$id="ACPI_INVALID_DATA", $desc="Invalid data for the target was specified."],
	[0xC0140010] = [$id="ACPI_INVALID_REGION", $desc="An invalid region for the target was specified."],
	[0xC0140011] = [$id="ACPI_INVALID_ACCESS_SIZE", $desc="An attempt was made to access a field outside the defined range."],
	[0xC0140012] = [$id="ACPI_ACQUIRE_GLOBAL_LOCK", $desc="The global system lock could not be acquired."],
	[0xC0140013] = [$id="ACPI_ALREADY_INITIALIZED", $desc="An attempt was made to reinitialize the ACPI subsystem."],
	[0xC0140014] = [$id="ACPI_NOT_INITIALIZED", $desc="The ACPI subsystem has not been initialized."],
	[0xC0140015] = [$id="ACPI_INVALID_MUTEX_LEVEL", $desc="An incorrect mutex was specified."],
	[0xC0140016] = [$id="ACPI_MUTEX_NOT_OWNED", $desc="The mutex is not currently owned."],
	[0xC0140017] = [$id="ACPI_MUTEX_NOT_OWNER", $desc="An attempt was made to access the mutex by a process that was not the owner."],
	[0xC0140018] = [$id="ACPI_RS_ACCESS", $desc="An error occurred during an access to region space."],
	[0xC0140019] = [$id="ACPI_INVALID_TABLE", $desc="An attempt was made to use an incorrect table."],
	[0xC0140020] = [$id="ACPI_REG_HANDLER_FAILED", $desc="The registration of an ACPI event failed."],
	[0xC0140021] = [$id="ACPI_POWER_REQUEST_FAILED", $desc="An ACPI power object failed to transition state."],
	[0xC0150001] = [$id="SXS_SECTION_NOT_FOUND", $desc="The requested section is not present in the activation context."],
	[0xC0150002] = [$id="SXS_CANT_GEN_ACTCTX", $desc="0xC0150003<br />STATUS_SXS_INVALID_ACTCTXDATA_FORMAT"],
	[0xC0150004] = [$id="SXS_ASSEMBLY_NOT_FOUND", $desc="The referenced assembly is not installed on the system."],
	[0xC0150005] = [$id="SXS_MANIFEST_FORMAT_ERROR", $desc="The manifest file does not begin with the required tag and format information."],
	[0xC0150006] = [$id="SXS_MANIFEST_PARSE_ERROR", $desc="The manifest file contains one or more syntax errors."],
	[0xC0150007] = [$id="SXS_ACTIVATION_CONTEXT_DISABLED", $desc="The application attempted to activate a disabled activation context."],
	[0xC0150008] = [$id="SXS_KEY_NOT_FOUND", $desc="The requested lookup key was not found in any active activation context."],
	[0xC0150009] = [$id="SXS_VERSION_CONFLICT", $desc="A component version required by the application conflicts with another component version that is already active."],
	[0xC015000A] = [$id="SXS_WRONG_SECTION_TYPE", $desc="The type requested activation context section does not match the query API used."],
	[0xC015000B] = [$id="SXS_THREAD_QUERIES_DISABLED", $desc="Lack of system resources has required isolated activation to be disabled for the current thread of execution."],
	[0xC015000C] = [$id="SXS_ASSEMBLY_MISSING", $desc="The referenced assembly could not be found."],
	[0xC015000E] = [$id="SXS_PROCESS_DEFAULT_ALREADY_SET", $desc="An attempt to set the process default activation context failed because the process default activation context was already set."],
	[0xC015000F] = [$id="SXS_EARLY_DEACTIVATION", $desc="The activation context being deactivated is not the most recently activated one."],
	[0xC0150010] = [$id="SXS_INVALID_DEACTIVATION", $desc="The activation context being deactivated is not active for the current thread of execution."],
	[0xC0150011] = [$id="SXS_MULTIPLE_DEACTIVATION", $desc="The activation context being deactivated has already been deactivated."],
	[0xC0150012] = [$id="SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY", $desc="The activation context of the system default assembly could not be generated."],
	[0xC0150013] = [$id="SXS_PROCESS_TERMINATION_REQUESTED", $desc="A component used by the isolation facility has requested that the process be terminated."],
	[0xC0150014] = [$id="SXS_CORRUPT_ACTIVATION_STACK", $desc="The activation context activation stack for the running thread of execution is corrupt."],
	[0xC0150015] = [$id="SXS_CORRUPTION", $desc="The application isolation metadata for this process or thread has become corrupt."],
	[0xC0150016] = [$id="SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE", $desc="The value of an attribute in an identity is not within the legal range."],
	[0xC0150017] = [$id="SXS_INVALID_IDENTITY_ATTRIBUTE_NAME", $desc="The name of an attribute in an identity is not within the legal range."],
	[0xC0150018] = [$id="SXS_IDENTITY_DUPLICATE_ATTRIBUTE", $desc="An identity contains two definitions for the same attribute."],
	[0xC0150019] = [$id="SXS_IDENTITY_PARSE_ERROR", $desc="The identity string is malformed. This may be due to a trailing comma, more than two unnamed attributes, a missing attribute name, or a missing attribute value."],
	[0xC015001A] = [$id="SXS_COMPONENT_STORE_CORRUPT", $desc="The component store has become corrupted."],
	[0xC015001B] = [$id="SXS_FILE_HASH_MISMATCH", $desc="A component's file does not match the verification information present in the component manifest."],
	[0xC015001C] = [$id="SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT", $desc="The identities of the manifests are identical, but their contents are different."],
	[0xC015001D] = [$id="SXS_IDENTITIES_DIFFERENT", $desc="The component identities are different."],
	[0xC015001E] = [$id="SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT", $desc="The assembly is not a deployment."],
	[0xC015001F] = [$id="SXS_FILE_NOT_PART_OF_ASSEMBLY", $desc="The file is not a part of the assembly."],
	[0xC0150020] = [$id="ADVANCED_INSTALLER_FAILED", $desc="An advanced installer failed during setup or servicing."],
	[0xC0150021] = [$id="XML_ENCODING_MISMATCH", $desc="The character encoding in the XML declaration did not match the encoding used in the document."],
	[0xC0150022] = [$id="SXS_MANIFEST_TOO_BIG", $desc="The size of the manifest exceeds the maximum allowed."],
	[0xC0150023] = [$id="SXS_SETTING_NOT_REGISTERED", $desc="The setting is not registered."],
	[0xC0150024] = [$id="SXS_TRANSACTION_CLOSURE_INCOMPLETE", $desc="One or more required transaction members are not present."],
	[0xC0150025] = [$id="SMI_PRIMITIVE_INSTALLER_FAILED", $desc="The SMI primitive installer failed during setup or servicing."],
	[0xC0150026] = [$id="GENERIC_COMMAND_FAILED", $desc="A generic command executable returned a result that indicates failure."],
	[0xC0150027] = [$id="SXS_FILE_HASH_MISSING", $desc="A component is missing file verification information in its manifest."],
	[0xC0190001] = [$id="TRANSACTIONAL_CONFLICT", $desc="The function attempted to use a name that is reserved for use by another transaction."],
	[0xC0190002] = [$id="INVALID_TRANSACTION", $desc="The transaction handle associated with this operation is invalid."],
	[0xC0190003] = [$id="TRANSACTION_NOT_ACTIVE", $desc="The requested operation was made in the context of a transaction that is no longer active."],
	[0xC0190004] = [$id="TM_INITIALIZATION_FAILED", $desc="The transaction manager was unable to be successfully initialized. Transacted operations are not supported."],
	[0xC0190005] = [$id="RM_NOT_ACTIVE", $desc="Transaction support within the specified file system resource manager was not started or was shut down due to an error."],
	[0xC0190006] = [$id="RM_METADATA_CORRUPT", $desc="The metadata of the resource manager has been corrupted. The resource manager will not function."],
	[0xC0190007] = [$id="TRANSACTION_NOT_JOINED", $desc="The resource manager attempted to prepare a transaction that it has not successfully joined."],
	[0xC0190008] = [$id="DIRECTORY_NOT_RM", $desc="The specified directory does not contain a file system resource manager."],
	[0xC019000A] = [$id="TRANSACTIONS_UNSUPPORTED_REMOTE", $desc="The remote server or share does not support transacted file operations."],
	[0xC019000B] = [$id="LOG_RESIZE_INVALID_SIZE", $desc="The requested log size for the file system resource manager is invalid."],
	[0xC019000C] = [$id="REMOTE_FILE_VERSION_MISMATCH", $desc="The remote server sent mismatching version number or Fid for a file opened with transactions."],
	[0xC019000F] = [$id="CRM_PROTOCOL_ALREADY_EXISTS", $desc="The resource manager tried to register a protocol that already exists."],
	[0xC0190010] = [$id="TRANSACTION_PROPAGATION_FAILED", $desc="The attempt to propagate the transaction failed."],
	[0xC0190011] = [$id="CRM_PROTOCOL_NOT_FOUND", $desc="The requested propagation protocol was not registered as a CRM."],
	[0xC0190012] = [$id="TRANSACTION_SUPERIOR_EXISTS", $desc="The transaction object already has a superior enlistment, and the caller attempted an operation that would have created a new superior. Only a single superior enlistment is allowed."],
	[0xC0190013] = [$id="TRANSACTION_REQUEST_NOT_VALID", $desc="The requested operation is not valid on the transaction object in its current state."],
	[0xC0190014] = [$id="TRANSACTION_NOT_REQUESTED", $desc="The caller has called a response API, but the response is not expected because the transaction manager did not issue the corresponding request to the caller."],
	[0xC0190015] = [$id="TRANSACTION_ALREADY_ABORTED", $desc="It is too late to perform the requested operation, because the transaction has already been aborted."],
	[0xC0190016] = [$id="TRANSACTION_ALREADY_COMMITTED", $desc="It is too late to perform the requested operation, because the transaction has already been committed."],
	[0xC0190017] = [$id="TRANSACTION_INVALID_MARSHALL_BUFFER", $desc="The buffer passed in to NtPushTransaction or NtPullTransaction is not in a valid format."],
	[0xC0190018] = [$id="CURRENT_TRANSACTION_NOT_VALID", $desc="The current transaction context associated with the thread is not a valid handle to a transaction object."],
	[0xC0190019] = [$id="LOG_GROWTH_FAILED", $desc="An attempt to create space in the transactional resource manager's log failed. The failure status has been recorded in the event log."],
	[0xC0190021] = [$id="OBJECT_NO_LONGER_EXISTS", $desc="The object (file, stream, or link) that corresponds to the handle has been deleted by a transaction savepoint rollback."],
	[0xC0190022] = [$id="STREAM_MINIVERSION_NOT_FOUND", $desc="The specified file miniversion was not found for this transacted file open."],
	[0xC0190023] = [$id="STREAM_MINIVERSION_NOT_VALID", $desc="The specified file miniversion was found but has been invalidated. The most likely cause is a transaction savepoint rollback."],
	[0xC0190024] = [$id="MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION", $desc="A miniversion may be opened only in the context of the transaction that created it."],
	[0xC0190025] = [$id="CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT", $desc="It is not possible to open a miniversion with modify access."],
	[0xC0190026] = [$id="CANT_CREATE_MORE_STREAM_MINIVERSIONS", $desc="It is not possible to create any more miniversions for this stream."],
	[0xC0190028] = [$id="HANDLE_NO_LONGER_VALID", $desc="The handle has been invalidated by a transaction. The most likely cause is the presence of memory mapping on a file or an open handle when the transaction ended or rolled back to savepoint."],
	[0xC0190030] = [$id="LOG_CORRUPTION_DETECTED", $desc="The log data is corrupt."],
	[0xC0190032] = [$id="RM_DISCONNECTED", $desc="The transaction outcome is unavailable because the resource manager responsible for it is disconnected."],
	[0xC0190033] = [$id="ENLISTMENT_NOT_SUPERIOR", $desc="The request was rejected because the enlistment in question is not a superior enlistment."],
	[0xC0190036] = [$id="FILE_IDENTITY_NOT_PERSISTENT", $desc="The file cannot be opened in a transaction because its identity depends on the outcome of an unresolved transaction."],
	[0xC0190037] = [$id="CANT_BREAK_TRANSACTIONAL_DEPENDENCY", $desc="The operation cannot be performed because another transaction is depending on this property not changing."],
	[0xC0190038] = [$id="CANT_CROSS_RM_BOUNDARY", $desc="The operation would involve a single file with two transactional resource managers and is, therefore, not allowed."],
	[0xC0190039] = [$id="TXF_DIR_NOT_EMPTY", $desc="The $Txf directory must be empty for this operation to succeed."],
	[0xC019003A] = [$id="INDOUBT_TRANSACTIONS_EXIST", $desc="The operation would leave a transactional resource manager in an inconsistent state and is therefore not allowed."],
	[0xC019003B] = [$id="TM_VOLATILE", $desc="The operation could not be completed because the transaction manager does not have a log."],
	[0xC019003C] = [$id="ROLLBACK_TIMER_EXPIRED", $desc="A rollback could not be scheduled because a previously scheduled rollback has already executed or been queued for execution."],
	[0xC019003D] = [$id="TXF_ATTRIBUTE_CORRUPT", $desc="The transactional metadata attribute on the file or directory %hs is corrupt and unreadable."],
	[0xC019003E] = [$id="EFS_NOT_ALLOWED_IN_TRANSACTION", $desc="The encryption operation could not be completed because a transaction is active."],
	[0xC019003F] = [$id="TRANSACTIONAL_OPEN_NOT_ALLOWED", $desc="This object is not allowed to be opened in a transaction."],
	[0xC0190040] = [$id="TRANSACTED_MAPPING_UNSUPPORTED_REMOTE", $desc="Memory mapping (creating a mapped section) a remote file under a transaction is not supported."],
	[0xC0190043] = [$id="TRANSACTION_REQUIRED_PROMOTION", $desc="Promotion was required to allow the resource manager to enlist, but the transaction was set to disallow it."],
	[0xC0190044] = [$id="CANNOT_EXECUTE_FILE_IN_TRANSACTION", $desc="This file is open for modification in an unresolved transaction and may be opened for execute only by a transacted reader."],
	[0xC0190045] = [$id="TRANSACTIONS_NOT_FROZEN", $desc="The request to thaw frozen transactions was ignored because transactions were not previously frozen."],
	[0xC0190046] = [$id="TRANSACTION_FREEZE_IN_PROGRESS", $desc="Transactions cannot be frozen because a freeze is already in progress."],
	[0xC0190047] = [$id="NOT_SNAPSHOT_VOLUME", $desc="The target volume is not a snapshot volume. This operation is valid only on a volume mounted as a snapshot."],
	[0xC0190048] = [$id="NO_SAVEPOINT_WITH_OPEN_FILES", $desc="The savepoint operation failed because files are open on the transaction, which is not permitted."],
	[0xC0190049] = [$id="SPARSE_NOT_ALLOWED_IN_TRANSACTION", $desc="The sparse operation could not be completed because a transaction is active on the file."],
	[0xC019004A] = [$id="TM_IDENTITY_MISMATCH", $desc="The call to create a transaction manager object failed because the Tm Identity that is stored in the log file does not match the Tm Identity that was passed in as an argument."],
	[0xC019004B] = [$id="FLOATED_SECTION", $desc="I/O was attempted on a section object that has been floated as a result of a transaction ending. There is no valid data."],
	[0xC019004C] = [$id="CANNOT_ACCEPT_TRANSACTED_WORK", $desc="The transactional resource manager cannot currently accept transacted work due to a transient condition, such as low resources."],
	[0xC019004D] = [$id="CANNOT_ABORT_TRANSACTIONS", $desc="The transactional resource manager had too many transactions outstanding that could not be aborted. The transactional resource manager has been shut down."],
	[0xC019004E] = [$id="TRANSACTION_NOT_FOUND", $desc="The specified transaction was unable to be opened because it was not found."],
	[0xC019004F] = [$id="RESOURCEMANAGER_NOT_FOUND", $desc="The specified resource manager was unable to be opened because it was not found."],
	[0xC0190050] = [$id="ENLISTMENT_NOT_FOUND", $desc="The specified enlistment was unable to be opened because it was not found."],
	[0xC0190051] = [$id="TRANSACTIONMANAGER_NOT_FOUND", $desc="The specified transaction manager was unable to be opened because it was not found."],
	[0xC0190052] = [$id="TRANSACTIONMANAGER_NOT_ONLINE", $desc="The specified resource manager was unable to create an enlistment because its associated transaction manager is not online."],
	[0xC0190053] = [$id="TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION", $desc="The specified transaction manager was unable to create the objects contained in its log file in the Ob namespace. Therefore, the transaction manager was unable to recover."],
	[0xC0190054] = [$id="TRANSACTION_NOT_ROOT", $desc="The call to create a superior enlistment on this transaction object could not be completed because the transaction object specified for the enlistment is a subordinate branch of the transaction. Only the root of the transaction can be enlisted as a superior."],
	[0xC0190055] = [$id="TRANSACTION_OBJECT_EXPIRED", $desc="Because the associated transaction manager or resource manager has been closed, the handle is no longer valid."],
	[0xC0190056] = [$id="COMPRESSION_NOT_ALLOWED_IN_TRANSACTION", $desc="The compression operation could not be completed because a transaction is active on the file."],
	[0xC0190057] = [$id="TRANSACTION_RESPONSE_NOT_ENLISTED", $desc="The specified operation could not be performed on this superior enlistment because the enlistment was not created with the corresponding completion response in the NotificationMask."],
	[0xC0190058] = [$id="TRANSACTION_RECORD_TOO_LONG", $desc="The specified operation could not be performed because the record to be logged was too long. This can occur because either there are too many enlistments on this transaction or the combined RecoveryInformation being logged on behalf of those enlistments is too long."],
	[0xC0190059] = [$id="NO_LINK_TRACKING_IN_TRANSACTION", $desc="The link-tracking operation could not be completed because a transaction is active."],
	[0xC019005A] = [$id="OPERATION_NOT_SUPPORTED_IN_TRANSACTION", $desc="This operation cannot be performed in a transaction."],
	[0xC019005B] = [$id="TRANSACTION_INTEGRITY_VIOLATED", $desc="The kernel transaction manager had to abort or forget the transaction because it blocked forward progress."],
	[0xC0190060] = [$id="EXPIRED_HANDLE", $desc="The handle is no longer properly associated with its transaction.  It may have been opened in a transactional resource manager that was subsequently forced to restart.  Please close the handle and open a new one."],
	[0xC0190061] = [$id="TRANSACTION_NOT_ENLISTED", $desc="The specified operation could not be performed because the resource manager is not enlisted in the transaction."],
	[0xC01A0001] = [$id="LOG_SECTOR_INVALID", $desc="The log service found an invalid log sector."],
	[0xC01A0002] = [$id="LOG_SECTOR_PARITY_INVALID", $desc="The log service encountered a log sector with invalid block parity."],
	[0xC01A0003] = [$id="LOG_SECTOR_REMAPPED", $desc="The log service encountered a remapped log sector."],
	[0xC01A0004] = [$id="LOG_BLOCK_INCOMPLETE", $desc="The log service encountered a partial or incomplete log block."],
	[0xC01A0005] = [$id="LOG_INVALID_RANGE", $desc="The log service encountered an attempt to access data outside the active log range."],
	[0xC01A0006] = [$id="LOG_BLOCKS_EXHAUSTED", $desc="The log service user-log marshaling buffers are exhausted."],
	[0xC01A0007] = [$id="LOG_READ_CONTEXT_INVALID", $desc="The log service encountered an attempt to read from a marshaling area with an invalid read context."],
	[0xC01A0008] = [$id="LOG_RESTART_INVALID", $desc="The log service encountered an invalid log restart area."],
	[0xC01A0009] = [$id="LOG_BLOCK_VERSION", $desc="The log service encountered an invalid log block version."],
	[0xC01A000A] = [$id="LOG_BLOCK_INVALID", $desc="The log service encountered an invalid log block."],
	[0xC01A000B] = [$id="LOG_READ_MODE_INVALID", $desc="The log service encountered an attempt to read the log with an invalid read mode."],
	[0xC01A000D] = [$id="LOG_METADATA_CORRUPT", $desc="The log service encountered a corrupted metadata file."],
	[0xC01A000E] = [$id="LOG_METADATA_INVALID", $desc="The log service encountered a metadata file that could not be created by the log file system."],
	[0xC01A000F] = [$id="LOG_METADATA_INCONSISTENT", $desc="The log service encountered a metadata file with inconsistent data."],
	[0xC01A0010] = [$id="LOG_RESERVATION_INVALID", $desc="The log service encountered an attempt to erroneously allocate or dispose reservation space."],
	[0xC01A0011] = [$id="LOG_CANT_DELETE", $desc="The log service cannot delete the log file or the file system container."],
	[0xC01A0012] = [$id="LOG_CONTAINER_LIMIT_EXCEEDED", $desc="The log service has reached the maximum allowable containers allocated to a log file."],
	[0xC01A0013] = [$id="LOG_START_OF_LOG", $desc="The log service has attempted to read or write backward past the start of the log."],
	[0xC01A0014] = [$id="LOG_POLICY_ALREADY_INSTALLED", $desc="The log policy could not be installed because a policy of the same type is already present."],
	[0xC01A0015] = [$id="LOG_POLICY_NOT_INSTALLED", $desc="The log policy in question was not installed at the time of the request."],
	[0xC01A0016] = [$id="LOG_POLICY_INVALID", $desc="The installed set of policies on the log is invalid."],
	[0xC01A0017] = [$id="LOG_POLICY_CONFLICT", $desc="A policy on the log in question prevented the operation from completing."],
	[0xC01A0018] = [$id="LOG_PINNED_ARCHIVE_TAIL", $desc="The log space cannot be reclaimed because the log is pinned by the archive tail."],
	[0xC01A0019] = [$id="LOG_RECORD_NONEXISTENT", $desc="The log record is not a record in the log file."],
	[0xC01A001A] = [$id="LOG_RECORDS_RESERVED_INVALID", $desc="The number of reserved log records or the adjustment of the number of reserved log records is invalid."],
	[0xC01A001B] = [$id="LOG_SPACE_RESERVED_INVALID", $desc="The reserved log space or the adjustment of the log space is invalid."],
	[0xC01A001C] = [$id="LOG_TAIL_INVALID", $desc="A new or existing archive tail or the base of the active log is invalid."],
	[0xC01A001D] = [$id="LOG_FULL", $desc="The log space is exhausted."],
	[0xC01A001E] = [$id="LOG_MULTIPLEXED", $desc="The log is multiplexed; no direct writes to the physical log are allowed."],
	[0xC01A001F] = [$id="LOG_DEDICATED", $desc="The operation failed because the log is dedicated."],
	[0xC01A0020] = [$id="LOG_ARCHIVE_NOT_IN_PROGRESS", $desc="The operation requires an archive context."],
	[0xC01A0021] = [$id="LOG_ARCHIVE_IN_PROGRESS", $desc="Log archival is in progress."],
	[0xC01A0022] = [$id="LOG_EPHEMERAL", $desc="The operation requires a nonephemeral log, but the log is ephemeral."],
	[0xC01A0023] = [$id="LOG_NOT_ENOUGH_CONTAINERS", $desc="The log must have at least two containers before it can be read from or written to."],
	[0xC01A0024] = [$id="LOG_CLIENT_ALREADY_REGISTERED", $desc="A log client has already registered on the stream."],
	[0xC01A0025] = [$id="LOG_CLIENT_NOT_REGISTERED", $desc="A log client has not been registered on the stream."],
	[0xC01A0026] = [$id="LOG_FULL_HANDLER_IN_PROGRESS", $desc="A request has already been made to handle the log full condition."],
	[0xC01A0027] = [$id="LOG_CONTAINER_READ_FAILED", $desc="The log service encountered an error when attempting to read from a log container."],
	[0xC01A0028] = [$id="LOG_CONTAINER_WRITE_FAILED", $desc="The log service encountered an error when attempting to write to a log container."],
	[0xC01A0029] = [$id="LOG_CONTAINER_OPEN_FAILED", $desc="The log service encountered an error when attempting to open a log container."],
	[0xC01A002A] = [$id="LOG_CONTAINER_STATE_INVALID", $desc="The log service encountered an invalid container state when attempting a requested action."],
	[0xC01A002B] = [$id="LOG_STATE_INVALID", $desc="The log service is not in the correct state to perform a requested action."],
	[0xC01A002C] = [$id="LOG_PINNED", $desc="The log space cannot be reclaimed because the log is pinned."],
	[0xC01A002D] = [$id="LOG_METADATA_FLUSH_FAILED", $desc="The log metadata flush failed."],
	[0xC01A002E] = [$id="LOG_INCONSISTENT_SECURITY", $desc="Security on the log and its containers is inconsistent."],
	[0xC01A002F] = [$id="LOG_APPENDED_FLUSH_FAILED", $desc="Records were appended to the log or reservation changes were made, but the log could not be flushed."],
	[0xC01A0030] = [$id="LOG_PINNED_RESERVATION", $desc="The log is pinned due to reservation consuming most of the log space. Free some reserved records to make space available."],
	[0xC01B00EA] = [$id="VIDEO_HUNG_DISPLAY_DRIVER_THREAD", $desc="{Display Driver Stopped Responding} The %hs display driver has stopped working normally. Save your work and reboot the system to restore full display functionality. The next time you reboot the computer, a dialog box will allow you to upload data about this failure to Microsoft."],
	[0xC01C0001] = [$id="FLT_NO_HANDLER_DEFINED", $desc="A handler was not defined by the filter for this operation."],
	[0xC01C0002] = [$id="FLT_CONTEXT_ALREADY_DEFINED", $desc="A context is already defined for this object."],
	[0xC01C0003] = [$id="FLT_INVALID_ASYNCHRONOUS_REQUEST", $desc="Asynchronous requests are not valid for this operation."],
	[0xC01C0004] = [$id="FLT_DISALLOW_FAST_IO", $desc="This is an internal error code used by the filter manager to determine if a fast I/O operation should be forced down the input/output request packet (IRP) path. Minifilters should never return this value."],
	[0xC01C0005] = [$id="FLT_INVALID_NAME_REQUEST", $desc="An invalid name request was made. The name requested cannot be retrieved at this time."],
	[0xC01C0006] = [$id="FLT_NOT_SAFE_TO_POST_OPERATION", $desc="Posting this operation to a worker thread for further processing is not safe at this time because it could lead to a system deadlock."],
	[0xC01C0007] = [$id="FLT_NOT_INITIALIZED", $desc="The Filter Manager was not initialized when a filter tried to register. Make sure that the Filter Manager is loaded as a driver."],
	[0xC01C0008] = [$id="FLT_FILTER_NOT_READY", $desc="The filter is not ready for attachment to volumes because it has not finished initializing (FltStartFiltering has not been called)."],
	[0xC01C0009] = [$id="FLT_POST_OPERATION_CLEANUP", $desc="The filter must clean up any operation-specific context at this time because it is being removed from the system before the operation is completed by the lower drivers."],
	[0xC01C000A] = [$id="FLT_INTERNAL_ERROR", $desc="The Filter Manager had an internal error from which it cannot recover; therefore, the operation has failed. This is usually the result of a filter returning an invalid value from a pre-operation callback."],
	[0xC01C000B] = [$id="FLT_DELETING_OBJECT", $desc="The object specified for this action is in the process of being deleted; therefore, the action requested cannot be completed at this time."],
	[0xC01C000C] = [$id="FLT_MUST_BE_NONPAGED_POOL", $desc="A nonpaged pool must be used for this type of context."],
	[0xC01C000D] = [$id="FLT_DUPLICATE_ENTRY", $desc="A duplicate handler definition has been provided for an operation."],
	[0xC01C000E] = [$id="FLT_CBDQ_DISABLED", $desc="The callback data queue has been disabled."],
	[0xC01C000F] = [$id="FLT_DO_NOT_ATTACH", $desc="Do not attach the filter to the volume at this time."],
	[0xC01C0010] = [$id="FLT_DO_NOT_DETACH", $desc="Do not detach the filter from the volume at this time."],
	[0xC01C0011] = [$id="FLT_INSTANCE_ALTITUDE_COLLISION", $desc="An instance already exists at this altitude on the volume specified."],
	[0xC01C0012] = [$id="FLT_INSTANCE_NAME_COLLISION", $desc="An instance already exists with this name on the volume specified."],
	[0xC01C0013] = [$id="FLT_FILTER_NOT_FOUND", $desc="The system could not find the filter specified."],
	[0xC01C0014] = [$id="FLT_VOLUME_NOT_FOUND", $desc="The system could not find the volume specified."],
	[0xC01C0015] = [$id="FLT_INSTANCE_NOT_FOUND", $desc="The system could not find the instance specified."],
	[0xC01C0016] = [$id="FLT_CONTEXT_ALLOCATION_NOT_FOUND", $desc="No registered context allocation definition was found for the given request."],
	[0xC01C0017] = [$id="FLT_INVALID_CONTEXT_REGISTRATION", $desc="An invalid parameter was specified during context registration."],
	[0xC01C0018] = [$id="FLT_NAME_CACHE_MISS", $desc="The name requested was not found in the Filter Manager name cache and could not be retrieved from the file system."],
	[0xC01C0019] = [$id="FLT_NO_DEVICE_OBJECT", $desc="The requested device object does not exist for the given volume."],
	[0xC01C001A] = [$id="FLT_VOLUME_ALREADY_MOUNTED", $desc="The specified volume is already mounted."],
	[0xC01C001B] = [$id="FLT_ALREADY_ENLISTED", $desc="The specified transaction context is already enlisted in a transaction."],
	[0xC01C001C] = [$id="FLT_CONTEXT_ALREADY_LINKED", $desc="The specified context is already attached to another object."],
	[0xC01C0020] = [$id="FLT_NO_WAITER_FOR_REPLY", $desc="No waiter is present for the filter's reply to this message."],
	[0xC01D0001] = [$id="MONITOR_NO_DESCRIPTOR", $desc="A monitor descriptor could not be obtained."],
	[0xC01D0002] = [$id="MONITOR_UNKNOWN_DESCRIPTOR_FORMAT", $desc="This release does not support the format of the obtained monitor descriptor."],
	[0xC01D0003] = [$id="MONITOR_INVALID_DESCRIPTOR_CHECKSUM", $desc="The checksum of the obtained monitor descriptor is invalid."],
	[0xC01D0004] = [$id="MONITOR_INVALID_STANDARD_TIMING_BLOCK", $desc="The monitor descriptor contains an invalid standard timing block."],
	[0xC01D0005] = [$id="MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED", $desc="WMI data-block registration failed for one of the MSMonitorClass WMI subclasses."],
	[0xC01D0006] = [$id="MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK", $desc="The provided monitor descriptor block is either corrupted or does not contain the monitor's detailed serial number."],
	[0xC01D0007] = [$id="MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK", $desc="The provided monitor descriptor block is either corrupted or does not contain the monitor's user-friendly name."],
	[0xC01D0008] = [$id="MONITOR_NO_MORE_DESCRIPTOR_DATA", $desc="There is no monitor descriptor data at the specified (offset or size) region."],
	[0xC01D0009] = [$id="MONITOR_INVALID_DETAILED_TIMING_BLOCK", $desc="The monitor descriptor contains an invalid detailed timing block."],
	[0xC01D000A] = [$id="MONITOR_INVALID_MANUFACTURE_DATE", $desc="Monitor descriptor contains invalid manufacture date."],
	[0xC01E0000] = [$id="GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER", $desc="Exclusive mode ownership is needed to create an unmanaged primary allocation."],
	[0xC01E0001] = [$id="GRAPHICS_INSUFFICIENT_DMA_BUFFER", $desc="The driver needs more DMA buffer space to complete the requested operation."],
	[0xC01E0002] = [$id="GRAPHICS_INVALID_DISPLAY_ADAPTER", $desc="The specified display adapter handle is invalid."],
	[0xC01E0003] = [$id="GRAPHICS_ADAPTER_WAS_RESET", $desc="The specified display adapter and all of its state have been reset."],
	[0xC01E0004] = [$id="GRAPHICS_INVALID_DRIVER_MODEL", $desc="The driver stack does not match the expected driver model."],
	[0xC01E0005] = [$id="GRAPHICS_PRESENT_MODE_CHANGED", $desc="Present happened but ended up into the changed desktop mode."],
	[0xC01E0006] = [$id="GRAPHICS_PRESENT_OCCLUDED", $desc="Nothing to present due to desktop occlusion."],
	[0xC01E0007] = [$id="GRAPHICS_PRESENT_DENIED", $desc="Not able to present due to denial of desktop access."],
	[0xC01E0008] = [$id="GRAPHICS_CANNOTCOLORCONVERT", $desc="Not able to present with color conversion."],
	[0xC01E000B] = [$id="GRAPHICS_PRESENT_REDIRECTION_DISABLED", $desc="Present redirection is disabled (desktop windowing management subsystem is off)."],
	[0xC01E000C] = [$id="GRAPHICS_PRESENT_UNOCCLUDED", $desc="Previous exclusive VidPn source owner has released its ownership"],
	[0xC01E0100] = [$id="GRAPHICS_NO_VIDEO_MEMORY", $desc="Not enough video memory is available to complete the operation."],
	[0xC01E0101] = [$id="GRAPHICS_CANT_LOCK_MEMORY", $desc="Could not probe and lock the underlying memory of an allocation."],
	[0xC01E0102] = [$id="GRAPHICS_ALLOCATION_BUSY", $desc="The allocation is currently busy."],
	[0xC01E0103] = [$id="GRAPHICS_TOO_MANY_REFERENCES", $desc="An object being referenced has already reached the maximum reference count and cannot be referenced further."],
	[0xC01E0104] = [$id="GRAPHICS_TRY_AGAIN_LATER", $desc="A problem could not be solved due to an existing condition. Try again later."],
	[0xC01E0105] = [$id="GRAPHICS_TRY_AGAIN_NOW", $desc="A problem could not be solved due to an existing condition. Try again now."],
	[0xC01E0106] = [$id="GRAPHICS_ALLOCATION_INVALID", $desc="The allocation is invalid."],
	[0xC01E0107] = [$id="GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE", $desc="No more unswizzling apertures are currently available."],
	[0xC01E0108] = [$id="GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED", $desc="The current allocation cannot be unswizzled by an aperture."],
	[0xC01E0109] = [$id="GRAPHICS_CANT_EVICT_PINNED_ALLOCATION", $desc="The request failed because a pinned allocation cannot be evicted."],
	[0xC01E0110] = [$id="GRAPHICS_INVALID_ALLOCATION_USAGE", $desc="The allocation cannot be used from its current segment location for the specified operation."],
	[0xC01E0111] = [$id="GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION", $desc="A locked allocation cannot be used in the current command buffer."],
	[0xC01E0112] = [$id="GRAPHICS_ALLOCATION_CLOSED", $desc="The allocation being referenced has been closed permanently."],
	[0xC01E0113] = [$id="GRAPHICS_INVALID_ALLOCATION_INSTANCE", $desc="An invalid allocation instance is being referenced."],
	[0xC01E0114] = [$id="GRAPHICS_INVALID_ALLOCATION_HANDLE", $desc="An invalid allocation handle is being referenced."],
	[0xC01E0115] = [$id="GRAPHICS_WRONG_ALLOCATION_DEVICE", $desc="The allocation being referenced does not belong to the current device."],
	[0xC01E0116] = [$id="GRAPHICS_ALLOCATION_CONTENT_LOST", $desc="The specified allocation lost its content."],
	[0xC01E0200] = [$id="GRAPHICS_GPU_EXCEPTION_ON_DEVICE", $desc="A GPU exception was detected on the given device. The device cannot be scheduled."],
	[0xC01E0300] = [$id="GRAPHICS_INVALID_VIDPN_TOPOLOGY", $desc="The specified VidPN topology is invalid."],
	[0xC01E0301] = [$id="GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED", $desc="The specified VidPN topology is valid but is not supported by this model of the display adapter."],
	[0xC01E0302] = [$id="GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED", $desc="The specified VidPN topology is valid but is not currently supported by the display adapter due to allocation of its resources."],
	[0xC01E0303] = [$id="GRAPHICS_INVALID_VIDPN", $desc="The specified VidPN handle is invalid."],
	[0xC01E0304] = [$id="GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE", $desc="The specified video present source is invalid."],
	[0xC01E0305] = [$id="GRAPHICS_INVALID_VIDEO_PRESENT_TARGET", $desc="The specified video present target is invalid."],
	[0xC01E0306] = [$id="GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED", $desc="The specified VidPN modality is not supported (for example, at least two of the pinned modes are not co-functional)."],
	[0xC01E0308] = [$id="GRAPHICS_INVALID_VIDPN_SOURCEMODESET", $desc="The specified VidPN source mode set is invalid."],
	[0xC01E0309] = [$id="GRAPHICS_INVALID_VIDPN_TARGETMODESET", $desc="The specified VidPN target mode set is invalid."],
	[0xC01E030A] = [$id="GRAPHICS_INVALID_FREQUENCY", $desc="The specified video signal frequency is invalid."],
	[0xC01E030B] = [$id="GRAPHICS_INVALID_ACTIVE_REGION", $desc="The specified video signal active region is invalid."],
	[0xC01E030C] = [$id="GRAPHICS_INVALID_TOTAL_REGION", $desc="The specified video signal total region is invalid."],
	[0xC01E0310] = [$id="GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE", $desc="The specified video present source mode is invalid."],
	[0xC01E0311] = [$id="GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE", $desc="The specified video present target mode is invalid."],
	[0xC01E0312] = [$id="GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET", $desc="The pinned mode must remain in the set on the VidPN's co-functional modality enumeration."],
	[0xC01E0313] = [$id="GRAPHICS_PATH_ALREADY_IN_TOPOLOGY", $desc="The specified video present path is already in the VidPN's topology."],
	[0xC01E0314] = [$id="GRAPHICS_MODE_ALREADY_IN_MODESET", $desc="The specified mode is already in the mode set."],
	[0xC01E0315] = [$id="GRAPHICS_INVALID_VIDEOPRESENTSOURCESET", $desc="The specified video present source set is invalid."],
	[0xC01E0316] = [$id="GRAPHICS_INVALID_VIDEOPRESENTTARGETSET", $desc="The specified video present target set is invalid."],
	[0xC01E0317] = [$id="GRAPHICS_SOURCE_ALREADY_IN_SET", $desc="The specified video present source is already in the video present source set."],
	[0xC01E0318] = [$id="GRAPHICS_TARGET_ALREADY_IN_SET", $desc="The specified video present target is already in the video present target set."],
	[0xC01E0319] = [$id="GRAPHICS_INVALID_VIDPN_PRESENT_PATH", $desc="The specified VidPN present path is invalid."],
	[0xC01E031A] = [$id="GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY", $desc="The miniport has no recommendation for augmenting the specified VidPN's topology."],
	[0xC01E031B] = [$id="GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET", $desc="The specified monitor frequency range set is invalid."],
	[0xC01E031C] = [$id="GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE", $desc="The specified monitor frequency range is invalid."],
	[0xC01E031D] = [$id="GRAPHICS_FREQUENCYRANGE_NOT_IN_SET", $desc="The specified frequency range is not in the specified monitor frequency range set."],
	[0xC01E031F] = [$id="GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET", $desc="The specified frequency range is already in the specified monitor frequency range set."],
	[0xC01E0320] = [$id="GRAPHICS_STALE_MODESET", $desc="The specified mode set is stale. Reacquire the new mode set."],
	[0xC01E0321] = [$id="GRAPHICS_INVALID_MONITOR_SOURCEMODESET", $desc="The specified monitor source mode set is invalid."],
	[0xC01E0322] = [$id="GRAPHICS_INVALID_MONITOR_SOURCE_MODE", $desc="The specified monitor source mode is invalid."],
	[0xC01E0323] = [$id="GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN", $desc="The miniport does not have a recommendation regarding the request to provide a functional VidPN given the current display adapter configuration."],
	[0xC01E0324] = [$id="GRAPHICS_MODE_ID_MUST_BE_UNIQUE", $desc="The ID of the specified mode is being used by another mode in the set."],
	[0xC01E0325] = [$id="GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION", $desc="The system failed to determine a mode that is supported by both the display adapter and the monitor connected to it."],
	[0xC01E0326] = [$id="GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES", $desc="The number of video present targets must be greater than or equal to the number of video present sources."],
	[0xC01E0327] = [$id="GRAPHICS_PATH_NOT_IN_TOPOLOGY", $desc="The specified present path is not in the VidPN's topology."],
	[0xC01E0328] = [$id="GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE", $desc="The display adapter must have at least one video present source."],
	[0xC01E0329] = [$id="GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET", $desc="The display adapter must have at least one video present target."],
	[0xC01E032A] = [$id="GRAPHICS_INVALID_MONITORDESCRIPTORSET", $desc="The specified monitor descriptor set is invalid."],
	[0xC01E032B] = [$id="GRAPHICS_INVALID_MONITORDESCRIPTOR", $desc="The specified monitor descriptor is invalid."],
	[0xC01E032C] = [$id="GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET", $desc="The specified descriptor is not in the specified monitor descriptor set."],
	[0xC01E032D] = [$id="GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET", $desc="The specified descriptor is already in the specified monitor descriptor set."],
	[0xC01E032E] = [$id="GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE", $desc="The ID of the specified monitor descriptor is being used by another descriptor in the set."],
	[0xC01E032F] = [$id="GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE", $desc="The specified video present target subset type is invalid."],
	[0xC01E0330] = [$id="GRAPHICS_RESOURCES_NOT_RELATED", $desc="Two or more of the specified resources are not related to each other, as defined by the interface semantics."],
	[0xC01E0331] = [$id="GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE", $desc="The ID of the specified video present source is being used by another source in the set."],
	[0xC01E0332] = [$id="GRAPHICS_TARGET_ID_MUST_BE_UNIQUE", $desc="The ID of the specified video present target is being used by another target in the set."],
	[0xC01E0333] = [$id="GRAPHICS_NO_AVAILABLE_VIDPN_TARGET", $desc="The specified VidPN source cannot be used because there is no available VidPN target to connect it to."],
	[0xC01E0334] = [$id="GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER", $desc="The newly arrived monitor could not be associated with a display adapter."],
	[0xC01E0335] = [$id="GRAPHICS_NO_VIDPNMGR", $desc="The particular display adapter does not have an associated VidPN manager."],
	[0xC01E0336] = [$id="GRAPHICS_NO_ACTIVE_VIDPN", $desc="The VidPN manager of the particular display adapter does not have an active VidPN."],
	[0xC01E0337] = [$id="GRAPHICS_STALE_VIDPN_TOPOLOGY", $desc="The specified VidPN topology is stale; obtain the new topology."],
	[0xC01E0338] = [$id="GRAPHICS_MONITOR_NOT_CONNECTED", $desc="No monitor is connected on the specified video present target."],
	[0xC01E0339] = [$id="GRAPHICS_SOURCE_NOT_IN_TOPOLOGY", $desc="The specified source is not part of the specified VidPN's topology."],
	[0xC01E033A] = [$id="GRAPHICS_INVALID_PRIMARYSURFACE_SIZE", $desc="The specified primary surface size is invalid."],
	[0xC01E033B] = [$id="GRAPHICS_INVALID_VISIBLEREGION_SIZE", $desc="The specified visible region size is invalid."],
	[0xC01E033C] = [$id="GRAPHICS_INVALID_STRIDE", $desc="The specified stride is invalid."],
	[0xC01E033D] = [$id="GRAPHICS_INVALID_PIXELFORMAT", $desc="The specified pixel format is invalid."],
	[0xC01E033E] = [$id="GRAPHICS_INVALID_COLORBASIS", $desc="The specified color basis is invalid."],
	[0xC01E033F] = [$id="GRAPHICS_INVALID_PIXELVALUEACCESSMODE", $desc="The specified pixel value access mode is invalid."],
	[0xC01E0340] = [$id="GRAPHICS_TARGET_NOT_IN_TOPOLOGY", $desc="The specified target is not part of the specified VidPN's topology."],
	[0xC01E0341] = [$id="GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT", $desc="Failed to acquire the display mode management interface."],
	[0xC01E0342] = [$id="GRAPHICS_VIDPN_SOURCE_IN_USE", $desc="The specified VidPN source is already owned by a DMM client and cannot be used until that client releases it."],
	[0xC01E0343] = [$id="GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN", $desc="The specified VidPN is active and cannot be accessed."],
	[0xC01E0344] = [$id="GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL", $desc="The specified VidPN's present path importance ordinal is invalid."],
	[0xC01E0345] = [$id="GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION", $desc="The specified VidPN's present path content geometry transformation is invalid."],
	[0xC01E0346] = [$id="GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED", $desc="The specified content geometry transformation is not supported on the respective VidPN present path."],
	[0xC01E0347] = [$id="GRAPHICS_INVALID_GAMMA_RAMP", $desc="The specified gamma ramp is invalid."],
	[0xC01E0348] = [$id="GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED", $desc="The specified gamma ramp is not supported on the respective VidPN present path."],
	[0xC01E0349] = [$id="GRAPHICS_MULTISAMPLING_NOT_SUPPORTED", $desc="Multisampling is not supported on the respective VidPN present path."],
	[0xC01E034A] = [$id="GRAPHICS_MODE_NOT_IN_MODESET", $desc="The specified mode is not in the specified mode set."],
	[0xC01E034D] = [$id="GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON", $desc="The specified VidPN topology recommendation reason is invalid."],
	[0xC01E034E] = [$id="GRAPHICS_INVALID_PATH_CONTENT_TYPE", $desc="The specified VidPN present path content type is invalid."],
	[0xC01E034F] = [$id="GRAPHICS_INVALID_COPYPROTECTION_TYPE", $desc="The specified VidPN present path copy protection type is invalid."],
	[0xC01E0350] = [$id="GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS", $desc="Only one unassigned mode set can exist at any one time for a particular VidPN source or target."],
	[0xC01E0352] = [$id="GRAPHICS_INVALID_SCANLINE_ORDERING", $desc="The specified scan line ordering type is invalid."],
	[0xC01E0353] = [$id="GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED", $desc="The topology changes are not allowed for the specified VidPN."],
	[0xC01E0354] = [$id="GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS", $desc="All available importance ordinals are being used in the specified topology."],
	[0xC01E0355] = [$id="GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT", $desc="The specified primary surface has a different private-format attribute than the current primary surface."],
	[0xC01E0356] = [$id="GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM", $desc="The specified mode-pruning algorithm is invalid."],
	[0xC01E0357] = [$id="GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN", $desc="The specified monitor-capability origin is invalid."],
	[0xC01E0358] = [$id="GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT", $desc="The specified monitor-frequency range constraint is invalid."],
	[0xC01E0359] = [$id="GRAPHICS_MAX_NUM_PATHS_REACHED", $desc="The maximum supported number of present paths has been reached."],
	[0xC01E035A] = [$id="GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION", $desc="The miniport requested that augmentation be canceled for the specified source of the specified VidPN's topology."],
	[0xC01E035B] = [$id="GRAPHICS_INVALID_CLIENT_TYPE", $desc="The specified client type was not recognized."],
	[0xC01E035C] = [$id="GRAPHICS_CLIENTVIDPN_NOT_SET", $desc="The client VidPN is not set on this adapter (for example, no user mode-initiated mode changes have taken place on this adapter)."],
	[0xC01E0400] = [$id="GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED", $desc="The specified display adapter child device already has an external device connected to it."],
	[0xC01E0401] = [$id="GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED", $desc="The display adapter child device does not support reporting a descriptor."],
	[0xC01E0430] = [$id="GRAPHICS_NOT_A_LINKED_ADAPTER", $desc="The display adapter is not linked to any other adapters."],
	[0xC01E0431] = [$id="GRAPHICS_LEADLINK_NOT_ENUMERATED", $desc="The lead adapter in a linked configuration was not enumerated yet."],
	[0xC01E0432] = [$id="GRAPHICS_CHAINLINKS_NOT_ENUMERATED", $desc="Some chain adapters in a linked configuration have not yet been enumerated."],
	[0xC01E0433] = [$id="GRAPHICS_ADAPTER_CHAIN_NOT_READY", $desc="The chain of linked adapters is not ready to start because of an unknown failure."],
	[0xC01E0434] = [$id="GRAPHICS_CHAINLINKS_NOT_STARTED", $desc="An attempt was made to start a lead link display adapter when the chain links had not yet started."],
	[0xC01E0435] = [$id="GRAPHICS_CHAINLINKS_NOT_POWERED_ON", $desc="An attempt was made to turn on a lead link display adapter when the chain links were turned off."],
	[0xC01E0436] = [$id="GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE", $desc="The adapter link was found in an inconsistent state. Not all adapters are in an expected PNP/power state."],
	[0xC01E0438] = [$id="GRAPHICS_NOT_POST_DEVICE_DRIVER", $desc="The driver trying to start is not the same as the driver for the posted display adapter."],
	[0xC01E043B] = [$id="GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED", $desc="An operation is being attempted that requires the display adapter to be in a quiescent state."],
	[0xC01E0500] = [$id="GRAPHICS_OPM_NOT_SUPPORTED", $desc="The driver does not support OPM."],
	[0xC01E0501] = [$id="GRAPHICS_COPP_NOT_SUPPORTED", $desc="The driver does not support COPP."],
	[0xC01E0502] = [$id="GRAPHICS_UAB_NOT_SUPPORTED", $desc="The driver does not support UAB."],
	[0xC01E0503] = [$id="GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS", $desc="The specified encrypted parameters are invalid."],
	[0xC01E0504] = [$id="GRAPHICS_OPM_PARAMETER_ARRAY_TOO_SMALL", $desc="An array passed to a function cannot hold all of the data that the function wants to put in it."],
	[0xC01E0505] = [$id="GRAPHICS_OPM_NO_PROTECTED_OUTPUTS_EXIST", $desc="The GDI display device passed to this function does not have any active protected outputs."],
	[0xC01E0506] = [$id="GRAPHICS_PVP_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME", $desc="The PVP cannot find an actual GDI display device that corresponds to the passed-in GDI display device name."],
	[0xC01E0507] = [$id="GRAPHICS_PVP_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP", $desc="This function failed because the GDI display device passed to it was not attached to the Windows desktop."],
	[0xC01E0508] = [$id="GRAPHICS_PVP_MIRRORING_DEVICES_NOT_SUPPORTED", $desc="The PVP does not support mirroring display devices because they do not have any protected outputs."],
	[0xC01E050A] = [$id="GRAPHICS_OPM_INVALID_POINTER", $desc="The function failed because an invalid pointer parameter was passed to it. A pointer parameter is invalid if it is null, is not correctly aligned, or it points to an invalid address or a kernel mode address."],
	[0xC01E050B] = [$id="GRAPHICS_OPM_INTERNAL_ERROR", $desc="An internal error caused an operation to fail."],
	[0xC01E050C] = [$id="GRAPHICS_OPM_INVALID_HANDLE", $desc="The function failed because the caller passed in an invalid OPM user-mode handle."],
	[0xC01E050D] = [$id="GRAPHICS_PVP_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE", $desc="This function failed because the GDI device passed to it did not have any monitors associated with it."],
	[0xC01E050E] = [$id="GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH", $desc="A certificate could not be returned because the certificate buffer passed to the function was too small."],
	[0xC01E050F] = [$id="GRAPHICS_OPM_SPANNING_MODE_ENABLED", $desc="DxgkDdiOpmCreateProtectedOutput() could not create a protected output because the video present yarget is in spanning mode."],
	[0xC01E0510] = [$id="GRAPHICS_OPM_THEATER_MODE_ENABLED", $desc="DxgkDdiOpmCreateProtectedOutput() could not create a protected output because the video present target is in theater mode."],
	[0xC01E0511] = [$id="GRAPHICS_PVP_HFS_FAILED", $desc="The function call failed because the display adapter's hardware functionality scan (HFS) failed to validate the graphics hardware."],
	[0xC01E0512] = [$id="GRAPHICS_OPM_INVALID_SRM", $desc="The HDCP SRM passed to this function did not comply with section 5 of the HDCP 1.1 specification."],
	[0xC01E0513] = [$id="GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP", $desc="The protected output cannot enable the HDCP system because it does not support it."],
	[0xC01E0514] = [$id="GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP", $desc="The protected output cannot enable analog copy protection because it does not support it."],
	[0xC01E0515] = [$id="GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA", $desc="The protected output cannot enable the CGMS-A protection technology because it does not support it."],
	[0xC01E0516] = [$id="GRAPHICS_OPM_HDCP_SRM_NEVER_SET", $desc="DxgkDdiOPMGetInformation() cannot return the version of the SRM being used because the application never successfully passed an SRM to the protected output."],
	[0xC01E0517] = [$id="GRAPHICS_OPM_RESOLUTION_TOO_HIGH", $desc="DxgkDdiOPMConfigureProtectedOutput() cannot enable the specified output protection technology because the output's screen resolution is too high."],
	[0xC01E0518] = [$id="GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE", $desc="DxgkDdiOPMConfigureProtectedOutput() cannot enable HDCP because other physical outputs are using the display adapter's HDCP hardware."],
	[0xC01E051A] = [$id="GRAPHICS_OPM_PROTECTED_OUTPUT_NO_LONGER_EXISTS", $desc="The operating system asynchronously destroyed this OPM-protected output because the operating system state changed. This error typically occurs because the monitor PDO associated with this protected output was removed or stopped, the protected output's session became a nonconsole session, or the protected output's desktop became inactive."],
	[0xC01E051B] = [$id="GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS", $desc="OPM functions cannot be called when a session is changing its type. Three types of sessions currently exist: console, disconnected, and remote (RDP or ICA)."],
	[0xC01E051C] = [$id="GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS", $desc="The DxgkDdiOPMGetCOPPCompatibleInformation, DxgkDdiOPMGetInformation, or DxgkDdiOPMConfigureProtectedOutput function failed. This error is returned only if a protected output has OPM semantics. "],
	[0xC01E051D] = [$id="GRAPHICS_OPM_INVALID_INFORMATION_REQUEST", $desc="The DxgkDdiOPMGetInformation and DxgkDdiOPMGetCOPPCompatibleInformation functions return this error code if the passed-in sequence number is not the expected sequence number or the passed-in OMAC value is invalid."],
	[0xC01E051E] = [$id="GRAPHICS_OPM_DRIVER_INTERNAL_ERROR", $desc="The function failed because an unexpected error occurred inside a display driver."],
	[0xC01E051F] = [$id="GRAPHICS_OPM_PROTECTED_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS", $desc="The DxgkDdiOPMGetCOPPCompatibleInformation, DxgkDdiOPMGetInformation, or DxgkDdiOPMConfigureProtectedOutput function failed. This error is returned only if a protected output has COPP semantics. "],
	[0xC01E0520] = [$id="GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED", $desc="The DxgkDdiOPMGetCOPPCompatibleInformation and DxgkDdiOPMConfigureProtectedOutput functions return this error if the display driver does not support the DXGKMDT_OPM_GET_ACP_AND_CGMSA_SIGNALING and DXGKMDT_OPM_SET_ACP_AND_CGMSA_SIGNALING GUIDs."],
	[0xC01E0521] = [$id="GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST", $desc="The DxgkDdiOPMConfigureProtectedOutput function returns this error code if the passed-in sequence number is not the expected sequence number or the passed-in OMAC value is invalid."],
	[0xC01E0580] = [$id="GRAPHICS_I2C_NOT_SUPPORTED", $desc="The monitor connected to the specified video output does not have an I2C bus."],
	[0xC01E0581] = [$id="GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST", $desc="No device on the I2C bus has the specified address."],
	[0xC01E0582] = [$id="GRAPHICS_I2C_ERROR_TRANSMITTING_DATA", $desc="An error occurred while transmitting data to the device on the I2C bus."],
	[0xC01E0583] = [$id="GRAPHICS_I2C_ERROR_RECEIVING_DATA", $desc="An error occurred while receiving data from the device on the I2C bus."],
	[0xC01E0584] = [$id="GRAPHICS_DDCCI_VCP_NOT_SUPPORTED", $desc="The monitor does not support the specified VCP code."],
	[0xC01E0585] = [$id="GRAPHICS_DDCCI_INVALID_DATA", $desc="The data received from the monitor is invalid."],
	[0xC01E0586] = [$id="GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE", $desc="A function call failed because a monitor returned an invalid timing status byte when the operating system used the DDC/CI get timing report and timing message command to get a timing report from a monitor."],
	[0xC01E0587] = [$id="GRAPHICS_DDCCI_INVALID_CAPABILITIES_STRING", $desc="A monitor returned a DDC/CI capabilities string that did not comply with the ACCESS.bus 3.0, DDC/CI 1.1, or MCCS 2 Revision 1 specification."],
	[0xC01E0588] = [$id="GRAPHICS_MCA_INTERNAL_ERROR", $desc="An internal error caused an operation to fail."],
	[0xC01E0589] = [$id="GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND", $desc="An operation failed because a DDC/CI message had an invalid value in its command field."],
	[0xC01E058A] = [$id="GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH", $desc="This error occurred because a DDC/CI message had an invalid value in its length field."],
	[0xC01E058B] = [$id="GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM", $desc="This error occurred because the value in a DDC/CI message's checksum field did not match the message's computed checksum value. This error implies that the data was corrupted while it was being transmitted from a monitor to a computer."],
	[0xC01E058C] = [$id="GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE", $desc="This function failed because an invalid monitor handle was passed to it."],
	[0xC01E058D] = [$id="GRAPHICS_MONITOR_NO_LONGER_EXISTS", $desc="The operating system asynchronously destroyed the monitor that corresponds to this handle because the operating system's state changed. This error typically occurs because the monitor PDO associated with this handle was removed or stopped, or a display mode change occurred. A display mode change occurs when Windows sends a WM_DISPLAYCHANGE message to applications."],
	[0xC01E05E0] = [$id="GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED", $desc="This function can be used only if a program is running in the local console session. It cannot be used if a program is running on a remote desktop session or on a terminal server session."],
	[0xC01E05E1] = [$id="GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME", $desc="This function cannot find an actual GDI display device that corresponds to the specified GDI display device name."],
	[0xC01E05E2] = [$id="GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP", $desc="The function failed because the specified GDI display device was not attached to the Windows desktop."],
	[0xC01E05E3] = [$id="GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED", $desc="This function does not support GDI mirroring display devices because GDI mirroring display devices do not have any physical monitors associated with them."],
	[0xC01E05E4] = [$id="GRAPHICS_INVALID_POINTER", $desc="The function failed because an invalid pointer parameter was passed to it. A pointer parameter is invalid if it is null, is not correctly aligned, or points to an invalid address or to a kernel mode address."],
	[0xC01E05E5] = [$id="GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE", $desc="This function failed because the GDI device passed to it did not have a monitor associated with it."],
	[0xC01E05E6] = [$id="GRAPHICS_PARAMETER_ARRAY_TOO_SMALL", $desc="An array passed to the function cannot hold all of the data that the function must copy into the array."],
	[0xC01E05E7] = [$id="GRAPHICS_INTERNAL_ERROR", $desc="An internal error caused an operation to fail."],
	[0xC01E05E8] = [$id="GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS", $desc="The function failed because the current session is changing its type. This function cannot be called when the current session is changing its type. Three types of sessions currently exist: console, disconnected, and remote (RDP or ICA)."],
	[0xC0210000] = [$id="FVE_LOCKED_VOLUME", $desc="The volume must be unlocked before it can be used."],
	[0xC0210001] = [$id="FVE_NOT_ENCRYPTED", $desc="The volume is fully decrypted and no key is available."],
	[0xC0210002] = [$id="FVE_BAD_INFORMATION", $desc="The control block for the encrypted volume is not valid."],
	[0xC0210003] = [$id="FVE_TOO_SMALL", $desc="Not enough free space remains on the volume to allow encryption."],
	[0xC0210004] = [$id="FVE_FAILED_WRONG_FS", $desc="The partition cannot be encrypted because the file system is not supported."],
	[0xC0210005] = [$id="FVE_FAILED_BAD_FS", $desc="The file system is inconsistent. Run the Check Disk utility."],
	[0xC0210006] = [$id="FVE_FS_NOT_EXTENDED", $desc="The file system does not extend to the end of the volume."],
	[0xC0210007] = [$id="FVE_FS_MOUNTED", $desc="This operation cannot be performed while a file system is mounted on the volume."],
	[0xC0210008] = [$id="FVE_NO_LICENSE", $desc="BitLocker Drive Encryption is not included with this version of Windows."],
	[0xC0210009] = [$id="FVE_ACTION_NOT_ALLOWED", $desc="The requested action was denied by the FVE control engine."],
	[0xC021000A] = [$id="FVE_BAD_DATA", $desc="The data supplied is malformed."],
	[0xC021000B] = [$id="FVE_VOLUME_NOT_BOUND", $desc="The volume is not bound to the system."],
	[0xC021000C] = [$id="FVE_NOT_DATA_VOLUME", $desc="The volume specified is not a data volume."],
	[0xC021000D] = [$id="FVE_CONV_READ_ERROR", $desc="A read operation failed while converting the volume."],
	[0xC021000E] = [$id="FVE_CONV_WRITE_ERROR", $desc="A write operation failed while converting the volume."],
	[0xC021000F] = [$id="FVE_OVERLAPPED_UPDATE", $desc="The control block for the encrypted volume was updated by another thread. Try again."],
	[0xC0210010] = [$id="FVE_FAILED_SECTOR_SIZE", $desc="The volume encryption algorithm cannot be used on this sector size."],
	[0xC0210011] = [$id="FVE_FAILED_AUTHENTICATION", $desc="BitLocker recovery authentication failed."],
	[0xC0210012] = [$id="FVE_NOT_OS_VOLUME", $desc="The volume specified is not the boot operating system volume."],
	[0xC0210013] = [$id="FVE_KEYFILE_NOT_FOUND", $desc="The BitLocker startup key or recovery password could not be read from external media."],
	[0xC0210014] = [$id="FVE_KEYFILE_INVALID", $desc="The BitLocker startup key or recovery password file is corrupt or invalid."],
	[0xC0210015] = [$id="FVE_KEYFILE_NO_VMK", $desc="The BitLocker encryption key could not be obtained from the startup key or the recovery password."],
	[0xC0210016] = [$id="FVE_TPM_DISABLED", $desc="The TPM is disabled."],
	[0xC0210017] = [$id="FVE_TPM_SRK_AUTH_NOT_ZERO", $desc="The authorization data for the SRK of the TPM is not zero."],
	[0xC0210018] = [$id="FVE_TPM_INVALID_PCR", $desc="The system boot information changed or the TPM locked out access to BitLocker encryption keys until the computer is restarted."],
	[0xC0210019] = [$id="FVE_TPM_NO_VMK", $desc="The BitLocker encryption key could not be obtained from the TPM."],
	[0xC021001A] = [$id="FVE_PIN_INVALID", $desc="The BitLocker encryption key could not be obtained from the TPM and PIN."],
	[0xC021001B] = [$id="FVE_AUTH_INVALID_APPLICATION", $desc="A boot application hash does not match the hash computed when BitLocker was turned on."],
	[0xC021001C] = [$id="FVE_AUTH_INVALID_CONFIG", $desc="The Boot Configuration Data (BCD) settings are not supported or have changed because BitLocker was enabled."],
	[0xC021001D] = [$id="FVE_DEBUGGER_ENABLED", $desc="Boot debugging is enabled. Run Windows Boot Configuration Data Store Editor (bcdedit.exe) to turn it off."],
	[0xC021001E] = [$id="FVE_DRY_RUN_FAILED", $desc="The BitLocker encryption key could not be obtained."],
	[0xC021001F] = [$id="FVE_BAD_METADATA_POINTER", $desc="The metadata disk region pointer is incorrect."],
	[0xC0210020] = [$id="FVE_OLD_METADATA_COPY", $desc="The backup copy of the metadata is out of date."],
	[0xC0210021] = [$id="FVE_REBOOT_REQUIRED", $desc="No action was taken because a system restart is required."],
	[0xC0210022] = [$id="FVE_RAW_ACCESS", $desc="No action was taken because BitLocker Drive Encryption is in RAW access mode."],
	[0xC0210023] = [$id="FVE_RAW_BLOCKED", $desc="BitLocker Drive Encryption cannot enter RAW access mode for this volume."],
	[0xC0210026] = [$id="FVE_NO_FEATURE_LICENSE", $desc="This feature of BitLocker Drive Encryption is not included with this version of Windows."],
	[0xC0210027] = [$id="FVE_POLICY_USER_DISABLE_RDV_NOT_ALLOWED", $desc="Group policy does not permit turning off BitLocker Drive Encryption on roaming data volumes."],
	[0xC0210028] = [$id="FVE_CONV_RECOVERY_FAILED", $desc="Bitlocker Drive Encryption failed to recover from aborted conversion. This could be due to either all conversion logs being corrupted or the media being write-protected."],
	[0xC0210029] = [$id="FVE_VIRTUALIZED_SPACE_TOO_BIG", $desc="The requested virtualization size is too big."],
	[0xC0210030] = [$id="FVE_VOLUME_TOO_SMALL", $desc="The drive is too small to be protected using BitLocker Drive Encryption."],
	[0xC0220001] = [$id="FWP_CALLOUT_NOT_FOUND", $desc="The callout does not exist."],
	[0xC0220002] = [$id="FWP_CONDITION_NOT_FOUND", $desc="The filter condition does not exist."],
	[0xC0220003] = [$id="FWP_FILTER_NOT_FOUND", $desc="The filter does not exist."],
	[0xC0220004] = [$id="FWP_LAYER_NOT_FOUND", $desc="The layer does not exist."],
	[0xC0220005] = [$id="FWP_PROVIDER_NOT_FOUND", $desc="The provider does not exist."],
	[0xC0220006] = [$id="FWP_PROVIDER_CONTEXT_NOT_FOUND", $desc="The provider context does not exist."],
	[0xC0220007] = [$id="FWP_SUBLAYER_NOT_FOUND", $desc="The sublayer does not exist."],
	[0xC0220008] = [$id="FWP_NOT_FOUND", $desc="The object does not exist."],
	[0xC0220009] = [$id="FWP_ALREADY_EXISTS", $desc="An object with that GUID or LUID already exists."],
	[0xC022000A] = [$id="FWP_IN_USE", $desc="The object is referenced by other objects and cannot be deleted."],
	[0xC022000B] = [$id="FWP_DYNAMIC_SESSION_IN_PROGRESS", $desc="The call is not allowed from within a dynamic session."],
	[0xC022000C] = [$id="FWP_WRONG_SESSION", $desc="The call was made from the wrong session and cannot be completed."],
	[0xC022000D] = [$id="FWP_NO_TXN_IN_PROGRESS", $desc="The call must be made from within an explicit transaction."],
	[0xC022000E] = [$id="FWP_TXN_IN_PROGRESS", $desc="The call is not allowed from within an explicit transaction."],
	[0xC022000F] = [$id="FWP_TXN_ABORTED", $desc="The explicit transaction has been forcibly canceled."],
	[0xC0220010] = [$id="FWP_SESSION_ABORTED", $desc="The session has been canceled."],
	[0xC0220011] = [$id="FWP_INCOMPATIBLE_TXN", $desc="The call is not allowed from within a read-only transaction."],
	[0xC0220012] = [$id="FWP_TIMEOUT", $desc="The call timed out while waiting to acquire the transaction lock."],
	[0xC0220013] = [$id="FWP_NET_EVENTS_DISABLED", $desc="The collection of network diagnostic events is disabled."],
	[0xC0220014] = [$id="FWP_INCOMPATIBLE_LAYER", $desc="The operation is not supported by the specified layer."],
	[0xC0220015] = [$id="FWP_KM_CLIENTS_ONLY", $desc="The call is allowed for kernel-mode callers only."],
	[0xC0220016] = [$id="FWP_LIFETIME_MISMATCH", $desc="The call tried to associate two objects with incompatible lifetimes."],
	[0xC0220017] = [$id="FWP_BUILTIN_OBJECT", $desc="The object is built-in and cannot be deleted."],
	[0xC0220018] = [$id="FWP_TOO_MANY_BOOTTIME_FILTERS", $desc="The maximum number of boot-time filters has been reached."],
	[0xC0220019] = [$id="FWP_NOTIFICATION_DROPPED", $desc="A notification could not be delivered because a message queue has reached maximum capacity."],
	[0xC022001A] = [$id="FWP_TRAFFIC_MISMATCH", $desc="The traffic parameters do not match those for the security association context."],
	[0xC022001B] = [$id="FWP_INCOMPATIBLE_SA_STATE", $desc="The call is not allowed for the current security association state."],
	[0xC022001C] = [$id="FWP_NULL_POINTER", $desc="A required pointer is null."],
	[0xC022001D] = [$id="FWP_INVALID_ENUMERATOR", $desc="An enumerator is not valid."],
	[0xC022001E] = [$id="FWP_INVALID_FLAGS", $desc="The flags field contains an invalid value."],
	[0xC022001F] = [$id="FWP_INVALID_NET_MASK", $desc="A network mask is not valid."],
	[0xC0220020] = [$id="FWP_INVALID_RANGE", $desc="An FWP_RANGE is not valid."],
	[0xC0220021] = [$id="FWP_INVALID_INTERVAL", $desc="The time interval is not valid."],
	[0xC0220022] = [$id="FWP_ZERO_LENGTH_ARRAY", $desc="An array that must contain at least one element has a zero length."],
	[0xC0220023] = [$id="FWP_NULL_DISPLAY_NAME", $desc="The displayData.name field cannot be null."],
	[0xC0220024] = [$id="FWP_INVALID_ACTION_TYPE", $desc="The action type is not one of the allowed action types for a filter."],
	[0xC0220025] = [$id="FWP_INVALID_WEIGHT", $desc="The filter weight is not valid."],
	[0xC0220026] = [$id="FWP_MATCH_TYPE_MISMATCH", $desc="A filter condition contains a match type that is not compatible with the operands."],
	[0xC0220027] = [$id="FWP_TYPE_MISMATCH", $desc="An FWP_VALUE or FWPM_CONDITION_VALUE is of the wrong type."],
	[0xC0220028] = [$id="FWP_OUT_OF_BOUNDS", $desc="An integer value is outside the allowed range."],
	[0xC0220029] = [$id="FWP_RESERVED", $desc="A reserved field is nonzero."],
	[0xC022002A] = [$id="FWP_DUPLICATE_CONDITION", $desc="A filter cannot contain multiple conditions operating on a single field."],
	[0xC022002B] = [$id="FWP_DUPLICATE_KEYMOD", $desc="A policy cannot contain the same keying module more than once."],
	[0xC022002C] = [$id="FWP_ACTION_INCOMPATIBLE_WITH_LAYER", $desc="The action type is not compatible with the layer."],
	[0xC022002D] = [$id="FWP_ACTION_INCOMPATIBLE_WITH_SUBLAYER", $desc="The action type is not compatible with the sublayer."],
	[0xC022002E] = [$id="FWP_CONTEXT_INCOMPATIBLE_WITH_LAYER", $desc="The raw context or the provider context is not compatible with the layer."],
	[0xC022002F] = [$id="FWP_CONTEXT_INCOMPATIBLE_WITH_CALLOUT", $desc="The raw context or the provider context is not compatible with the callout."],
	[0xC0220030] = [$id="FWP_INCOMPATIBLE_AUTH_METHOD", $desc="The authentication method is not compatible with the policy type."],
	[0xC0220031] = [$id="FWP_INCOMPATIBLE_DH_GROUP", $desc="The Diffie-Hellman group is not compatible with the policy type."],
	[0xC0220032] = [$id="FWP_EM_NOT_SUPPORTED", $desc="An IKE policy cannot contain an Extended Mode policy."],
	[0xC0220033] = [$id="FWP_NEVER_MATCH", $desc="The enumeration template or subscription will never match any objects."],
	[0xC0220034] = [$id="FWP_PROVIDER_CONTEXT_MISMATCH", $desc="The provider context is of the wrong type."],
	[0xC0220035] = [$id="FWP_INVALID_PARAMETER", $desc="The parameter is incorrect."],
	[0xC0220036] = [$id="FWP_TOO_MANY_SUBLAYERS", $desc="The maximum number of sublayers has been reached."],
	[0xC0220037] = [$id="FWP_CALLOUT_NOTIFICATION_FAILED", $desc="The notification function for a callout returned an error."],
	[0xC0220038] = [$id="FWP_INCOMPATIBLE_AUTH_CONFIG", $desc="The IPsec authentication configuration is not compatible with the authentication type."],
	[0xC0220039] = [$id="FWP_INCOMPATIBLE_CIPHER_CONFIG", $desc="The IPsec cipher configuration is not compatible with the cipher type."],
	[0xC022003C] = [$id="FWP_DUPLICATE_AUTH_METHOD", $desc="A policy cannot contain the same auth method more than once."],
	[0xC0220100] = [$id="FWP_TCPIP_NOT_READY", $desc="The TCP/IP stack is not ready."],
	[0xC0220101] = [$id="FWP_INJECT_HANDLE_CLOSING", $desc="The injection handle is being closed by another thread."],
	[0xC0220102] = [$id="FWP_INJECT_HANDLE_STALE", $desc="The injection handle is stale."],
	[0xC0220103] = [$id="FWP_CANNOT_PEND", $desc="The classify cannot be pended."],
	[0xC0230002] = [$id="NDIS_CLOSING", $desc="The binding to the network interface is being closed."],
	[0xC0230004] = [$id="NDIS_BAD_VERSION", $desc="An invalid version was specified."],
	[0xC0230005] = [$id="NDIS_BAD_CHARACTERISTICS", $desc="An invalid characteristics table was used."],
	[0xC0230006] = [$id="NDIS_ADAPTER_NOT_FOUND", $desc="Failed to find the network interface or the network interface is not ready."],
	[0xC0230007] = [$id="NDIS_OPEN_FAILED", $desc="Failed to open the network interface."],
	[0xC0230008] = [$id="NDIS_DEVICE_FAILED", $desc="The network interface has encountered an internal unrecoverable failure."],
	[0xC0230009] = [$id="NDIS_MULTICAST_FULL", $desc="The multicast list on the network interface is full."],
	[0xC023000A] = [$id="NDIS_MULTICAST_EXISTS", $desc="An attempt was made to add a duplicate multicast address to the list."],
	[0xC023000B] = [$id="NDIS_MULTICAST_NOT_FOUND", $desc="At attempt was made to remove a multicast address that was never added."],
	[0xC023000C] = [$id="NDIS_REQUEST_ABORTED", $desc="The network interface aborted the request."],
	[0xC023000D] = [$id="NDIS_RESET_IN_PROGRESS", $desc="The network interface cannot process the request because it is being reset."],
	[0xC023000F] = [$id="NDIS_INVALID_PACKET", $desc="An attempt was made to send an invalid packet on a network interface."],
	[0xC0230010] = [$id="NDIS_INVALID_DEVICE_REQUEST", $desc="The specified request is not a valid operation for the target device."],
	[0xC0230011] = [$id="NDIS_ADAPTER_NOT_READY", $desc="The network interface is not ready to complete this operation."],
	[0xC0230014] = [$id="NDIS_INVALID_LENGTH", $desc="The length of the buffer submitted for this operation is not valid."],
	[0xC0230015] = [$id="NDIS_INVALID_DATA", $desc="The data used for this operation is not valid."],
	[0xC0230016] = [$id="NDIS_BUFFER_TOO_SHORT", $desc="The length of the submitted buffer for this operation is too small."],
	[0xC0230017] = [$id="NDIS_INVALID_OID", $desc="The network interface does not support this object identifier."],
	[0xC0230018] = [$id="NDIS_ADAPTER_REMOVED", $desc="The network interface has been removed."],
	[0xC0230019] = [$id="NDIS_UNSUPPORTED_MEDIA", $desc="The network interface does not support this media type."],
	[0xC023001A] = [$id="NDIS_GROUP_ADDRESS_IN_USE", $desc="An attempt was made to remove a token ring group address that is in use by other components."],
	[0xC023001B] = [$id="NDIS_FILE_NOT_FOUND", $desc="An attempt was made to map a file that cannot be found."],
	[0xC023001C] = [$id="NDIS_ERROR_READING_FILE", $desc="An error occurred while NDIS tried to map the file."],
	[0xC023001D] = [$id="NDIS_ALREADY_MAPPED", $desc="An attempt was made to map a file that is already mapped."],
	[0xC023001E] = [$id="NDIS_RESOURCE_CONFLICT", $desc="An attempt to allocate a hardware resource failed because the resource is used by another component."],
	[0xC023001F] = [$id="NDIS_MEDIA_DISCONNECTED", $desc="The I/O operation failed because the network media is disconnected or the wireless access point is out of range."],
	[0xC0230022] = [$id="NDIS_INVALID_ADDRESS", $desc="The network address used in the request is invalid."],
	[0xC023002A] = [$id="NDIS_PAUSED", $desc="The offload operation on the network interface has been paused."],
	[0xC023002B] = [$id="NDIS_INTERFACE_NOT_FOUND", $desc="The network interface was not found."],
	[0xC023002C] = [$id="NDIS_UNSUPPORTED_REVISION", $desc="The revision number specified in the structure is not supported."],
	[0xC023002D] = [$id="NDIS_INVALID_PORT", $desc="The specified port does not exist on this network interface."],
	[0xC023002E] = [$id="NDIS_INVALID_PORT_STATE", $desc="The current state of the specified port on this network interface does not support the requested operation."],
	[0xC023002F] = [$id="NDIS_LOW_POWER_STATE", $desc="The miniport adapter is in a lower power state."],
	[0xC02300BB] = [$id="NDIS_NOT_SUPPORTED", $desc="The network interface does not support this request."],
	[0xC023100F] = [$id="NDIS_OFFLOAD_POLICY", $desc="The TCP connection is not offloadable because of a local policy setting."],
	[0xC0231012] = [$id="NDIS_OFFLOAD_CONNECTION_REJECTED", $desc="The TCP connection is not offloadable by the Chimney offload target."],
	[0xC0231013] = [$id="NDIS_OFFLOAD_PATH_REJECTED", $desc="The IP Path object is not in an offloadable state."],
	[0xC0232000] = [$id="NDIS_DOT11_AUTO_CONFIG_ENABLED", $desc="The wireless LAN interface is in auto-configuration mode and does not support the requested parameter change operation."],
	[0xC0232001] = [$id="NDIS_DOT11_MEDIA_IN_USE", $desc="The wireless LAN interface is busy and cannot perform the requested operation."],
	[0xC0232002] = [$id="NDIS_DOT11_POWER_STATE_INVALID", $desc="The wireless LAN interface is power down and does not support the requested operation."],
	[0xC0232003] = [$id="NDIS_PM_WOL_PATTERN_LIST_FULL", $desc="The list of wake on LAN patterns is full."],
	[0xC0232004] = [$id="NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL", $desc="The list of low power protocol offloads is full."],
	[0xC0360001] = [$id="IPSEC_BAD_SPI", $desc="The SPI in the packet does not match a valid IPsec SA."],
	[0xC0360002] = [$id="IPSEC_SA_LIFETIME_EXPIRED", $desc="The packet was received on an IPsec SA whose lifetime has expired."],
	[0xC0360003] = [$id="IPSEC_WRONG_SA", $desc="The packet was received on an IPsec SA that does not match the packet characteristics."],
	[0xC0360004] = [$id="IPSEC_REPLAY_CHECK_FAILED", $desc="The packet sequence number replay check failed."],
	[0xC0360005] = [$id="IPSEC_INVALID_PACKET", $desc="The IPsec header and/or trailer in the packet is invalid."],
	[0xC0360006] = [$id="IPSEC_INTEGRITY_CHECK_FAILED", $desc="The IPsec integrity check failed."],
	[0xC0360007] = [$id="IPSEC_CLEAR_TEXT_DROP", $desc="IPsec dropped a clear text packet."],
	[0xC0360008] = [$id="IPSEC_AUTH_FIREWALL_DROP", $desc="IPsec dropped an incoming ESP packet in authenticated firewall mode.  This drop is benign."],
	[0xC0360009] = [$id="IPSEC_THROTTLE_DROP", $desc="IPsec dropped a packet due to DOS throttle."],
	[0xC0368000] = [$id="IPSEC_DOSP_BLOCK", $desc="IPsec Dos Protection matched an explicit block rule."],
	[0xC0368001] = [$id="IPSEC_DOSP_RECEIVED_MULTICAST", $desc="IPsec Dos Protection received an IPsec specific multicast packet which is not allowed."],
	[0xC0368002] = [$id="IPSEC_DOSP_INVALID_PACKET", $desc="IPsec Dos Protection received an incorrectly formatted packet."],
	[0xC0368003] = [$id="IPSEC_DOSP_STATE_LOOKUP_FAILED", $desc="IPsec Dos Protection failed to lookup state."],
	[0xC0368004] = [$id="IPSEC_DOSP_MAX_ENTRIES", $desc="IPsec Dos Protection failed to create state because there are already maximum number of entries allowed by policy."],
	[0xC0368005] = [$id="IPSEC_DOSP_KEYMOD_NOT_ALLOWED", $desc="IPsec Dos Protection received an IPsec negotiation packet for a keying module which is not allowed by policy."],
	[0xC0368006] = [$id="IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES", $desc="IPsec Dos Protection failed to create per internal IP ratelimit queue because there is already maximum number of queues allowed by policy."],
	[0xC038005B] = [$id="VOLMGR_MIRROR_NOT_SUPPORTED", $desc="The system does not support mirrored volumes."],
	[0xC038005C] = [$id="VOLMGR_RAID5_NOT_SUPPORTED", $desc="The system does not support RAID-5 volumes."],
	[0xC03A0014] = [$id="VIRTDISK_PROVIDER_NOT_FOUND", $desc="A virtual disk support provider for the specified file was not found."],
	[0xC03A0015] = [$id="VIRTDISK_NOT_VIRTUAL_DISK", $desc="The specified disk is not a virtual disk."],
	[0xC03A0016] = [$id="VHD_PARENT_VHD_ACCESS_DENIED", $desc="The chain of virtual hard disks is inaccessible. The process has not been granted access rights to the parent virtual hard disk for the differencing disk."],
	[0xC03A0017] = [$id="VHD_CHILD_PARENT_SIZE_MISMATCH", $desc="The chain of virtual hard disks is corrupted. There is a mismatch in the virtual sizes of the parent virtual hard disk and differencing disk."],
	[0xC03A0018] = [$id="VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED", $desc="The chain of virtual hard disks is corrupted. A differencing disk is indicated in its own parent chain."],
	[0xC03A0019] = [$id="VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT", $desc="The chain of virtual hard disks is inaccessible. There was an error opening a virtual hard disk further up the chain."],
};
