<?php
/**
 * Test class for running unit tests related to the driver for holidays
 * in Japan
 *
 * PHP Versions 4 and 5
 *
 * @category Date
 * @package  Date_Holidays
 * @author   Hideyuki Shimooka <shimooka@doyouphp.jp>
 * @license  http://www.php.net/license/3_01.txt PHP License 3.0.1
 * @version  CVS: $Id$
 * @link     http://pear.php.net/package/Date_Holidays
 */

/** Set up the environment */
require_once dirname(__FILE__) . '/helper.inc';

/**
 * Test class for running unit tests related to the driver for holidays
 * in Japan
 *
 * @uses PHPUnit_Framework_TestCase
 * @category Date
 * @package  Date_Holidays
 * @author   Hideyuki Shimooka <shimooka@doyouphp.jp>
 * @license  http://www.php.net/license/3_01.txt PHP License 3.0.1
 * @version  CVS: $Id$
 * @link     http://pear.php.net/package/Date_Holidays
 */
class Date_Holidays_Driver_Japan_TestSuite extends PHPUnit_Framework_TestCase
{
    var $_holidays;
    protected $lang_dir;

    /**
     * setUp
     *
     * @access public
     * @return void
     */
    function setUp()
    {
        $this->lang_dir = helper_get_lang_dir('Date_Holidays_Japan');
        $this->_holidays = array(
            '1970-01-01' => true,
            '1970-01-15' => true,
            '1970-02-11' => true,
            '1970-03-21' => true,
            '1970-04-29' => true,
            '1970-05-03' => true,
            '1970-05-05' => true,
            '1970-09-15' => true,
            '1970-09-23' => true,
            '1970-10-10' => true,
            '1970-11-03' => true,
            '1970-11-23' => true,
            '1971-01-01' => true,
            '1971-01-15' => true,
            '1971-02-11' => true,
            '1971-03-21' => true,
            '1971-04-29' => true,
            '1971-05-03' => true,
            '1971-05-05' => true,
            '1971-09-15' => true,
            '1971-09-24' => true,
            '1971-10-10' => true,
            '1971-11-03' => true,
            '1971-11-23' => true,
            '1972-01-01' => true,
            '1972-01-15' => true,
            '1972-02-11' => true,
            '1972-03-20' => true,
            '1972-04-29' => true,
            '1972-05-03' => true,
            '1972-05-05' => true,
            '1972-09-15' => true,
            '1972-09-23' => true,
            '1972-10-10' => true,
            '1972-11-03' => true,
            '1972-11-23' => true,
            '1973-01-01' => true,
            '1973-01-15' => true,
            '1973-02-11' => true,
            '1973-03-21' => true,
            '1973-04-29' => true,
            '1973-04-30' => true,
            '1973-05-03' => true,
            '1973-05-05' => true,
            '1973-09-15' => true,
            '1973-09-23' => true,
            '1973-09-24' => true,
            '1973-10-10' => true,
            '1973-11-03' => true,
            '1973-11-23' => true,
            '1974-01-01' => true,
            '1974-01-15' => true,
            '1974-02-11' => true,
            '1974-03-21' => true,
            '1974-04-29' => true,
            '1974-05-03' => true,
            '1974-05-05' => true,
            '1974-05-06' => true,
            '1974-09-15' => true,
            '1974-09-16' => true,
            '1974-09-23' => true,
            '1974-10-10' => true,
            '1974-11-03' => true,
            '1974-11-04' => true,
            '1974-11-23' => true,
            '1975-01-01' => true,
            '1975-01-15' => true,
            '1975-02-11' => true,
            '1975-03-21' => true,
            '1975-04-29' => true,
            '1975-05-03' => true,
            '1975-05-05' => true,
            '1975-09-15' => true,
            '1975-09-24' => true,
            '1975-10-10' => true,
            '1975-11-03' => true,
            '1975-11-23' => true,
            '1975-11-24' => true,
            '1976-01-01' => true,
            '1976-01-15' => true,
            '1976-02-11' => true,
            '1976-03-20' => true,
            '1976-04-29' => true,
            '1976-05-03' => true,
            '1976-05-05' => true,
            '1976-09-15' => true,
            '1976-09-23' => true,
            '1976-10-10' => true,
            '1976-10-11' => true,
            '1976-11-03' => true,
            '1976-11-23' => true,
            '1977-01-01' => true,
            '1977-01-15' => true,
            '1977-02-11' => true,
            '1977-03-21' => true,
            '1977-04-29' => true,
            '1977-05-03' => true,
            '1977-05-05' => true,
            '1977-09-15' => true,
            '1977-09-23' => true,
            '1977-10-10' => true,
            '1977-11-03' => true,
            '1977-11-23' => true,
            '1978-01-01' => true,
            '1978-01-02' => true,
            '1978-01-15' => true,
            '1978-01-16' => true,
            '1978-02-11' => true,
            '1978-03-21' => true,
            '1978-04-29' => true,
            '1978-05-03' => true,
            '1978-05-05' => true,
            '1978-09-15' => true,
            '1978-09-23' => true,
            '1978-10-10' => true,
            '1978-11-03' => true,
            '1978-11-23' => true,
            '1979-01-01' => true,
            '1979-01-15' => true,
            '1979-02-11' => true,
            '1979-02-12' => true,
            '1979-03-21' => true,
            '1979-04-29' => true,
            '1979-04-30' => true,
            '1979-05-03' => true,
            '1979-05-05' => true,
            '1979-09-15' => true,
            '1979-09-24' => true,
            '1979-10-10' => true,
            '1979-11-03' => true,
            '1979-11-23' => true,
            '1980-01-01' => true,
            '1980-01-15' => true,
            '1980-02-11' => true,
            '1980-03-20' => true,
            '1980-04-29' => true,
            '1980-05-03' => true,
            '1980-05-05' => true,
            '1980-09-15' => true,
            '1980-09-23' => true,
            '1980-10-10' => true,
            '1980-11-03' => true,
            '1980-11-23' => true,
            '1980-11-24' => true,
            '1981-01-01' => true,
            '1981-01-15' => true,
            '1981-02-11' => true,
            '1981-03-21' => true,
            '1981-04-29' => true,
            '1981-05-03' => true,
            '1981-05-04' => true,
            '1981-05-05' => true,
            '1981-09-15' => true,
            '1981-09-23' => true,
            '1981-10-10' => true,
            '1981-11-03' => true,
            '1981-11-23' => true,
            '1982-01-01' => true,
            '1982-01-15' => true,
            '1982-02-11' => true,
            '1982-03-21' => true,
            '1982-03-22' => true,
            '1982-04-29' => true,
            '1982-05-03' => true,
            '1982-05-05' => true,
            '1982-09-15' => true,
            '1982-09-23' => true,
            '1982-10-10' => true,
            '1982-10-11' => true,
            '1982-11-03' => true,
            '1982-11-23' => true,
            '1983-01-01' => true,
            '1983-01-15' => true,
            '1983-02-11' => true,
            '1983-03-21' => true,
            '1983-04-29' => true,
            '1983-05-03' => true,
            '1983-05-05' => true,
            '1983-09-15' => true,
            '1983-09-23' => true,
            '1983-10-10' => true,
            '1983-11-03' => true,
            '1983-11-23' => true,
            '1984-01-01' => true,
            '1984-01-02' => true,
            '1984-01-15' => true,
            '1984-01-16' => true,
            '1984-02-11' => true,
            '1984-03-20' => true,
            '1984-04-29' => true,
            '1984-04-30' => true,
            '1984-05-03' => true,
            '1984-05-05' => true,
            '1984-09-15' => true,
            '1984-09-23' => true,
            '1984-09-24' => true,
            '1984-10-10' => true,
            '1984-11-03' => true,
            '1984-11-23' => true,
            '1985-01-01' => true,
            '1985-01-15' => true,
            '1985-02-11' => true,
            '1985-03-21' => true,
            '1985-04-29' => true,
            '1985-05-03' => true,
            '1985-05-05' => true,
            '1985-05-06' => true,
            '1985-09-15' => true,
            '1985-09-16' => true,
            '1985-09-23' => true,
            '1985-10-10' => true,
            '1985-11-03' => true,
            '1985-11-04' => true,
            '1985-11-23' => true,
            '1986-01-01' => true,
            '1986-01-15' => true,
            '1986-02-11' => true,
            '1986-03-21' => true,
            '1986-04-29' => true,
            '1986-05-03' => true,
            '1986-05-05' => true,
            '1986-09-15' => true,
            '1986-09-23' => true,
            '1986-10-10' => true,
            '1986-11-03' => true,
            '1986-11-23' => true,
            '1986-11-24' => true,
            '1987-01-01' => true,
            '1987-01-15' => true,
            '1987-02-11' => true,
            '1987-03-21' => true,
            '1987-04-29' => true,
            '1987-05-03' => true,
            '1987-05-04' => true,
            '1987-05-05' => true,
            '1987-09-15' => true,
            '1987-09-23' => true,
            '1987-10-10' => true,
            '1987-11-03' => true,
            '1987-11-23' => true,
            '1988-01-01' => true,
            '1988-01-15' => true,
            '1988-02-11' => true,
            '1988-03-20' => true,
            '1988-03-21' => true,
            '1988-04-29' => true,
            '1988-05-03' => true,
            '1988-05-04' => true,
            '1988-05-05' => true,
            '1988-09-15' => true,
            '1988-09-23' => true,
            '1988-10-10' => true,
            '1988-11-03' => true,
            '1988-11-23' => true,
            '1989-01-01' => true,
            '1989-01-02' => true,
            '1989-01-15' => true,
            '1989-01-16' => true,
            '1989-02-11' => true,
            '1989-02-24' => true,
            '1989-03-21' => true,
            '1989-04-29' => true,
            '1989-05-03' => true,
            '1989-05-04' => true,
            '1989-05-05' => true,
            '1989-09-15' => true,
            '1989-09-23' => true,
            '1989-10-10' => true,
            '1989-11-03' => true,
            '1989-11-23' => true,
            '1989-12-23' => true,
            '1990-01-01' => true,
            '1990-01-15' => true,
            '1990-02-11' => true,
            '1990-02-12' => true,
            '1990-03-21' => true,
            '1990-04-29' => true,
            '1990-04-30' => true,
            '1990-05-03' => true,
            '1990-05-04' => true,
            '1990-05-05' => true,
            '1990-09-15' => true,
            '1990-09-23' => true,
            '1990-09-24' => true,
            '1990-10-10' => true,
            '1990-11-03' => true,
            '1990-11-12' => true,
            '1990-11-23' => true,
            '1990-12-23' => true,
            '1990-12-24' => true,
            '1991-01-01' => true,
            '1991-01-15' => true,
            '1991-02-11' => true,
            '1991-03-21' => true,
            '1991-04-29' => true,
            '1991-05-03' => true,
            '1991-05-04' => true,
            '1991-05-05' => true,
            '1991-05-06' => true,
            '1991-09-15' => true,
            '1991-09-16' => true,
            '1991-09-23' => true,
            '1991-10-10' => true,
            '1991-11-03' => true,
            '1991-11-04' => true,
            '1991-11-23' => true,
            '1991-12-23' => true,
            '1992-01-01' => true,
            '1992-01-15' => true,
            '1992-02-11' => true,
            '1992-03-20' => true,
            '1992-04-29' => true,
            '1992-05-03' => true,
            '1992-05-04' => true,
            '1992-05-05' => true,
            '1992-09-15' => true,
            '1992-09-23' => true,
            '1992-10-10' => true,
            '1992-11-03' => true,
            '1992-11-23' => true,
            '1992-12-23' => true,
            '1993-01-01' => true,
            '1993-01-15' => true,
            '1993-02-11' => true,
            '1993-03-20' => true,
            '1993-04-29' => true,
            '1993-05-03' => true,
            '1993-05-04' => true,
            '1993-05-05' => true,
            '1993-06-09' => true,
            '1993-09-15' => true,
            '1993-09-23' => true,
            '1993-10-10' => true,
            '1993-10-11' => true,
            '1993-11-03' => true,
            '1993-11-23' => true,
            '1993-12-23' => true,
            '1994-01-01' => true,
            '1994-01-15' => true,
            '1994-02-11' => true,
            '1994-03-21' => true,
            '1994-04-29' => true,
            '1994-05-03' => true,
            '1994-05-04' => true,
            '1994-05-05' => true,
            '1994-09-15' => true,
            '1994-09-23' => true,
            '1994-10-10' => true,
            '1994-11-03' => true,
            '1994-11-23' => true,
            '1994-12-23' => true,
            '1995-01-01' => true,
            '1995-01-02' => true,
            '1995-01-15' => true,
            '1995-01-16' => true,
            '1995-02-11' => true,
            '1995-03-21' => true,
            '1995-04-29' => true,
            '1995-05-03' => true,
            '1995-05-04' => true,
            '1995-05-05' => true,
            '1995-09-15' => true,
            '1995-09-23' => true,
            '1995-10-10' => true,
            '1995-11-03' => true,
            '1995-11-23' => true,
            '1995-12-23' => true,
            '1996-01-01' => true,
            '1996-01-15' => true,
            '1996-02-11' => true,
            '1996-02-12' => true,
            '1996-03-20' => true,
            '1996-04-29' => true,
            '1996-05-03' => true,
            '1996-05-04' => true,
            '1996-05-05' => true,
            '1996-05-06' => true,
            '1996-07-20' => true,
            '1996-09-15' => true,
            '1996-09-16' => true,
            '1996-09-23' => true,
            '1996-10-10' => true,
            '1996-11-03' => true,
            '1996-11-04' => true,
            '1996-11-23' => true,
            '1996-12-23' => true,
            '1997-01-01' => true,
            '1997-01-15' => true,
            '1997-02-11' => true,
            '1997-03-20' => true,
            '1997-04-29' => true,
            '1997-05-03' => true,
            '1997-05-05' => true,
            '1997-07-20' => true,
            '1997-07-21' => true,
            '1997-09-15' => true,
            '1997-09-23' => true,
            '1997-10-10' => true,
            '1997-11-03' => true,
            '1997-11-23' => true,
            '1997-11-24' => true,
            '1997-12-23' => true,
            '1998-01-01' => true,
            '1998-01-15' => true,
            '1998-02-11' => true,
            '1998-03-21' => true,
            '1998-04-29' => true,
            '1998-05-03' => true,
            '1998-05-04' => true,
            '1998-05-05' => true,
            '1998-07-20' => true,
            '1998-09-15' => true,
            '1998-09-23' => true,
            '1998-10-10' => true,
            '1998-11-03' => true,
            '1998-11-23' => true,
            '1998-12-23' => true,
            '1999-01-01' => true,
            '1999-01-15' => true,
            '1999-02-11' => true,
            '1999-03-21' => true,
            '1999-03-22' => true,
            '1999-04-29' => true,
            '1999-05-03' => true,
            '1999-05-04' => true,
            '1999-05-05' => true,
            '1999-07-20' => true,
            '1999-09-15' => true,
            '1999-09-23' => true,
            '1999-10-10' => true,
            '1999-10-11' => true,
            '1999-11-03' => true,
            '1999-11-23' => true,
            '1999-12-23' => true,
            '2000-01-01' => true,
            '2000-01-10' => true,
            '2000-02-11' => true,
            '2000-03-20' => true,
            '2000-04-29' => true,
            '2000-05-03' => true,
            '2000-05-04' => true,
            '2000-05-05' => true,
            '2000-07-20' => true,
            '2000-09-15' => true,
            '2000-09-23' => true,
            '2000-10-09' => true,
            '2000-11-03' => true,
            '2000-11-23' => true,
            '2000-12-23' => true,
            '2001-01-01' => true,
            '2001-01-08' => true,
            '2001-02-11' => true,
            '2001-02-12' => true,
            '2001-03-20' => true,
            '2001-04-29' => true,
            '2001-04-30' => true,
            '2001-05-03' => true,
            '2001-05-04' => true,
            '2001-05-05' => true,
            '2001-07-20' => true,
            '2001-09-15' => true,
            '2001-09-23' => true,
            '2001-09-24' => true,
            '2001-10-08' => true,
            '2001-11-03' => true,
            '2001-11-23' => true,
            '2001-12-23' => true,
            '2001-12-24' => true,
            '2002-01-01' => true,
            '2002-01-14' => true,
            '2002-02-11' => true,
            '2002-03-21' => true,
            '2002-04-29' => true,
            '2002-05-03' => true,
            '2002-05-04' => true,
            '2002-05-05' => true,
            '2002-05-06' => true,
            '2002-07-20' => true,
            '2002-09-15' => true,
            '2002-09-16' => true,
            '2002-09-23' => true,
            '2002-10-14' => true,
            '2002-11-03' => true,
            '2002-11-04' => true,
            '2002-11-23' => true,
            '2002-12-23' => true,
            '2003-01-01' => true,
            '2003-01-13' => true,
            '2003-02-11' => true,
            '2003-03-21' => true,
            '2003-04-29' => true,
            '2003-05-03' => true,
            '2003-05-05' => true,
            '2003-07-21' => true,
            '2003-09-15' => true,
            '2003-09-23' => true,
            '2003-10-13' => true,
            '2003-11-03' => true,
            '2003-11-23' => true,
            '2003-11-24' => true,
            '2003-12-23' => true,
            '2004-01-01' => true,
            '2004-01-12' => true,
            '2004-02-11' => true,
            '2004-03-20' => true,
            '2004-04-29' => true,
            '2004-05-03' => true,
            '2004-05-04' => true,
            '2004-05-05' => true,
            '2004-07-19' => true,
            '2004-09-20' => true,
            '2004-09-23' => true,
            '2004-10-11' => true,
            '2004-11-03' => true,
            '2004-11-23' => true,
            '2004-12-23' => true,
            '2005-01-01' => true,
            '2005-01-10' => true,
            '2005-02-11' => true,
            '2005-03-20' => true,
            '2005-03-21' => true,
            '2005-04-29' => true,
            '2005-05-03' => true,
            '2005-05-04' => true,
            '2005-05-05' => true,
            '2005-07-18' => true,
            '2005-09-19' => true,
            '2005-09-23' => true,
            '2005-10-10' => true,
            '2005-11-03' => true,
            '2005-11-23' => true,
            '2005-12-23' => true,
            '2006-01-01' => true,
            '2006-01-02' => true,
            '2006-01-09' => true,
            '2006-02-11' => true,
            '2006-03-21' => true,
            '2006-04-29' => true,
            '2006-05-03' => true,
            '2006-05-04' => true,
            '2006-05-05' => true,
            '2006-07-17' => true,
            '2006-09-18' => true,
            '2006-09-23' => true,
            '2006-10-09' => true,
            '2006-11-03' => true,
            '2006-11-23' => true,
            '2006-12-23' => true,
            '2007-01-01' => true,
            '2007-01-08' => true,
            '2007-02-11' => true,
            '2007-02-12' => true,
            '2007-03-21' => true,
            '2007-04-29' => true,
            '2007-04-30' => true,
            '2007-05-03' => true,
            '2007-05-04' => true,
            '2007-05-05' => true,
            '2007-07-16' => true,
            '2007-09-17' => true,
            '2007-09-23' => true,
            '2007-09-24' => true,
            '2007-10-08' => true,
            '2007-11-03' => true,
            '2007-11-23' => true,
            '2007-12-23' => true,
            '2007-12-24' => true,
            '2008-01-01' => true,
            '2008-01-14' => true,
            '2008-02-11' => true,
            '2008-03-20' => true,
            '2008-04-29' => true,
            '2008-05-03' => true,
            '2008-05-04' => true,
            '2008-05-05' => true,
            '2008-05-06' => true,
            '2008-07-21' => true,
            '2008-09-15' => true,
            '2008-09-23' => true,
            '2008-10-13' => true,
            '2008-11-03' => true,
            '2008-11-23' => true,
            '2008-11-24' => true,
            '2008-12-23' => true,
            '2009-01-01' => true,
            '2009-01-12' => true,
            '2009-02-11' => true,
            '2009-03-20' => true,
            '2009-04-29' => true,
            '2009-05-03' => true,
            '2009-05-04' => true,
            '2009-05-05' => true,
            '2009-05-06' => true,
            '2009-07-20' => true,
            '2009-09-21' => true,
            '2009-09-22' => true,
            '2009-09-23' => true,
            '2009-10-12' => true,
            '2009-11-03' => true,
            '2009-11-23' => true,
            '2009-12-23' => true,
            '2010-01-01' => true,
            '2010-01-11' => true,
            '2010-02-11' => true,
            '2010-03-21' => true,
            '2010-03-22' => true,
            '2010-04-29' => true,
            '2010-05-03' => true,
            '2010-05-04' => true,
            '2010-05-05' => true,
            '2010-07-19' => true,
            '2010-09-20' => true,
            '2010-09-23' => true,
            '2010-10-11' => true,
            '2010-11-03' => true,
            '2010-11-23' => true,
            '2010-12-23' => true,
            '2011-01-01' => true,
            '2011-01-10' => true,
            '2011-02-11' => true,
            '2011-03-21' => true,
            '2011-04-29' => true,
            '2011-05-03' => true,
            '2011-05-04' => true,
            '2011-05-05' => true,
            '2011-07-18' => true,
            '2011-09-19' => true,
            '2011-09-23' => true,
            '2011-10-10' => true,
            '2011-11-03' => true,
            '2011-11-23' => true,
            '2011-12-23' => true,
            '2012-01-01' => true,
            '2012-01-02' => true,
            '2012-01-09' => true,
            '2012-02-11' => true,
            '2012-03-20' => true,
            '2012-04-29' => true,
            '2012-04-30' => true,
            '2012-05-03' => true,
            '2012-05-04' => true,
            '2012-05-05' => true,
            '2012-07-16' => true,
            '2012-09-17' => true,
            '2012-09-22' => true,
            '2012-10-08' => true,
            '2012-11-03' => true,
            '2012-11-23' => true,
            '2012-12-23' => true,
            '2012-12-24' => true,
            '2013-01-01' => true,
            '2013-01-14' => true,
            '2013-02-11' => true,
            '2013-03-20' => true,
            '2013-04-29' => true,
            '2013-05-03' => true,
            '2013-05-04' => true,
            '2013-05-05' => true,
            '2013-05-06' => true,
            '2013-07-15' => true,
            '2013-09-16' => true,
            '2013-09-23' => true,
            '2013-10-14' => true,
            '2013-11-03' => true,
            '2013-11-04' => true,
            '2013-11-23' => true,
            '2013-12-23' => true,
            '2014-01-01' => true,
            '2014-01-13' => true,
            '2014-02-11' => true,
            '2014-03-21' => true,
            '2014-04-29' => true,
            '2014-05-03' => true,
            '2014-05-04' => true,
            '2014-05-05' => true,
            '2014-05-06' => true,
            '2014-07-21' => true,
            '2014-09-15' => true,
            '2014-09-23' => true,
            '2014-10-13' => true,
            '2014-11-03' => true,
            '2014-11-23' => true,
            '2014-11-24' => true,
            '2014-12-23' => true,
            '2015-01-01' => true,
            '2015-01-12' => true,
            '2015-02-11' => true,
            '2015-03-21' => true,
            '2015-04-29' => true,
            '2015-05-03' => true,
            '2015-05-04' => true,
            '2015-05-05' => true,
            '2015-05-06' => true,
            '2015-07-20' => true,
            '2015-09-21' => true,
            '2015-09-22' => true,
            '2015-09-23' => true,
            '2015-10-12' => true,
            '2015-11-03' => true,
            '2015-11-23' => true,
            '2015-12-23' => true,
            '2016-01-01' => true,
            '2016-01-11' => true,
            '2016-02-11' => true,
            '2016-03-20' => true,
            '2016-03-21' => true,
            '2016-04-29' => true,
            '2016-05-03' => true,
            '2016-05-04' => true,
            '2016-05-05' => true,
            '2016-07-18' => true,
            '2016-08-11' => true,
            '2016-09-19' => true,
            '2016-09-22' => true,
            '2016-10-10' => true,
            '2016-11-03' => true,
            '2016-11-23' => true,
            '2016-12-23' => true,
            '2017-01-01' => true,
            '2017-01-02' => true,
            '2017-01-09' => true,
            '2017-02-11' => true,
            '2017-03-20' => true,
            '2017-04-29' => true,
            '2017-05-03' => true,
            '2017-05-04' => true,
            '2017-05-05' => true,
            '2017-07-17' => true,
            '2017-08-11' => true,
            '2017-09-18' => true,
            '2017-09-23' => true,
            '2017-10-09' => true,
            '2017-11-03' => true,
            '2017-11-23' => true,
            '2017-12-23' => true,
            '2018-01-01' => true,
            '2018-01-08' => true,
            '2018-02-11' => true,
            '2018-02-12' => true,
            '2018-03-21' => true,
            '2018-04-29' => true,
            '2018-04-30' => true,
            '2018-05-03' => true,
            '2018-05-04' => true,
            '2018-05-05' => true,
            '2018-07-16' => true,
            '2018-08-11' => true,
            '2018-09-17' => true,
            '2018-09-23' => true,
            '2018-09-24' => true,
            '2018-10-08' => true,
            '2018-11-03' => true,
            '2018-11-23' => true,
            '2018-12-23' => true,
            '2018-12-24' => true,
            '2019-01-01' => true,
            '2019-01-14' => true,
            '2019-02-11' => true,
            '2019-03-21' => true,
            '2019-04-29' => true,
            '2019-05-03' => true,
            '2019-05-04' => true,
            '2019-05-05' => true,
            '2019-05-06' => true,
            '2019-07-15' => true,
            '2019-08-11' => true,
            '2019-08-12' => true,
            '2019-09-16' => true,
            '2019-09-23' => true,
            '2019-10-14' => true,
            '2019-11-03' => true,
            '2019-11-04' => true,
            '2019-11-23' => true,
            '2019-12-23' => true,
            '2020-01-01' => true,
            '2020-01-13' => true,
            '2020-02-11' => true,
            '2020-03-20' => true,
            '2020-04-29' => true,
            '2020-05-03' => true,
            '2020-05-04' => true,
            '2020-05-05' => true,
            '2020-05-06' => true,
            '2020-07-20' => true,
            '2020-08-11' => true,
            '2020-09-21' => true,
            '2020-09-22' => true,
            '2020-10-12' => true,
            '2020-11-03' => true,
            '2020-11-23' => true,
            '2020-12-23' => true,
            '2021-01-01' => true,
            '2021-01-11' => true,
            '2021-02-11' => true,
            '2021-03-20' => true,
            '2021-04-29' => true,
            '2021-05-03' => true,
            '2021-05-04' => true,
            '2021-05-05' => true,
            '2021-07-19' => true,
            '2021-08-11' => true,
            '2021-09-20' => true,
            '2021-09-23' => true,
            '2021-10-11' => true,
            '2021-11-03' => true,
            '2021-11-23' => true,
            '2021-12-23' => true,
            '2022-01-01' => true,
            '2022-01-10' => true,
            '2022-02-11' => true,
            '2022-03-21' => true,
            '2022-04-29' => true,
            '2022-05-03' => true,
            '2022-05-04' => true,
            '2022-05-05' => true,
            '2022-07-18' => true,
            '2022-08-11' => true,
            '2022-09-19' => true,
            '2022-09-23' => true,
            '2022-10-10' => true,
            '2022-11-03' => true,
            '2022-11-23' => true,
            '2022-12-23' => true,
            '2023-01-01' => true,
            '2023-01-02' => true,
            '2023-01-09' => true,
            '2023-02-11' => true,
            '2023-03-21' => true,
            '2023-04-29' => true,
            '2023-05-03' => true,
            '2023-05-04' => true,
            '2023-05-05' => true,
            '2023-07-17' => true,
            '2023-08-11' => true,
            '2023-09-18' => true,
            '2023-09-23' => true,
            '2023-10-09' => true,
            '2023-11-03' => true,
            '2023-11-23' => true,
            '2023-12-23' => true,
            '2024-01-01' => true,
            '2024-01-08' => true,
            '2024-02-11' => true,
            '2024-02-12' => true,
            '2024-03-20' => true,
            '2024-04-29' => true,
            '2024-05-03' => true,
            '2024-05-04' => true,
            '2024-05-05' => true,
            '2024-05-06' => true,
            '2024-07-15' => true,
            '2024-08-11' => true,
            '2024-08-12' => true,
            '2024-09-16' => true,
            '2024-09-22' => true,
            '2024-09-23' => true,
            '2024-10-14' => true,
            '2024-11-03' => true,
            '2024-11-04' => true,
            '2024-11-23' => true,
            '2024-12-23' => true,
            '2025-01-01' => true,
            '2025-01-13' => true,
            '2025-02-11' => true,
            '2025-03-20' => true,
            '2025-04-29' => true,
            '2025-05-03' => true,
            '2025-05-04' => true,
            '2025-05-05' => true,
            '2025-05-06' => true,
            '2025-07-21' => true,
            '2025-08-11' => true,
            '2025-09-15' => true,
            '2025-09-23' => true,
            '2025-10-13' => true,
            '2025-11-03' => true,
            '2025-11-23' => true,
            '2025-11-24' => true,
            '2025-12-23' => true,
            '2026-01-01' => true,
            '2026-01-12' => true,
            '2026-02-11' => true,
            '2026-03-20' => true,
            '2026-04-29' => true,
            '2026-05-03' => true,
            '2026-05-04' => true,
            '2026-05-05' => true,
            '2026-05-06' => true,
            '2026-07-20' => true,
            '2026-08-11' => true,
            '2026-09-21' => true,
            '2026-09-22' => true,
            '2026-09-23' => true,
            '2026-10-12' => true,
            '2026-11-03' => true,
            '2026-11-23' => true,
            '2026-12-23' => true,
            '2027-01-01' => true,
            '2027-01-11' => true,
            '2027-02-11' => true,
            '2027-03-21' => true,
            '2027-03-22' => true,
            '2027-04-29' => true,
            '2027-05-03' => true,
            '2027-05-04' => true,
            '2027-05-05' => true,
            '2027-07-19' => true,
            '2027-08-11' => true,
            '2027-09-20' => true,
            '2027-09-23' => true,
            '2027-10-11' => true,
            '2027-11-03' => true,
            '2027-11-23' => true,
            '2027-12-23' => true,
            '2028-01-01' => true,
            '2028-01-10' => true,
            '2028-02-11' => true,
            '2028-03-20' => true,
            '2028-04-29' => true,
            '2028-05-03' => true,
            '2028-05-04' => true,
            '2028-05-05' => true,
            '2028-07-17' => true,
            '2028-08-11' => true,
            '2028-09-18' => true,
            '2028-09-22' => true,
            '2028-10-09' => true,
            '2028-11-03' => true,
            '2028-11-23' => true,
            '2028-12-23' => true,
            '2029-01-01' => true,
            '2029-01-08' => true,
            '2029-02-11' => true,
            '2029-02-12' => true,
            '2029-03-20' => true,
            '2029-04-29' => true,
            '2029-04-30' => true,
            '2029-05-03' => true,
            '2029-05-04' => true,
            '2029-05-05' => true,
            '2029-07-16' => true,
            '2029-08-11' => true,
            '2029-09-17' => true,
            '2029-09-23' => true,
            '2029-09-24' => true,
            '2029-10-08' => true,
            '2029-11-03' => true,
            '2029-11-23' => true,
            '2029-12-23' => true,
            '2029-12-24' => true,
            '2030-01-01' => true,
            '2030-01-14' => true,
            '2030-02-11' => true,
            '2030-03-20' => true,
            '2030-04-29' => true,
            '2030-05-03' => true,
            '2030-05-04' => true,
            '2030-05-05' => true,
            '2030-05-06' => true,
            '2030-07-15' => true,
            '2030-08-11' => true,
            '2030-08-12' => true,
            '2030-09-16' => true,
            '2030-09-23' => true,
            '2030-10-14' => true,
            '2030-11-03' => true,
            '2030-11-04' => true,
            '2030-11-23' => true,
            '2030-12-23' => true,
            '2031-01-01' => true,
            '2031-01-13' => true,
            '2031-02-11' => true,
            '2031-03-21' => true,
            '2031-04-29' => true,
            '2031-05-03' => true,
            '2031-05-04' => true,
            '2031-05-05' => true,
            '2031-05-06' => true,
            '2031-07-21' => true,
            '2031-08-11' => true,
            '2031-09-15' => true,
            '2031-09-23' => true,
            '2031-10-13' => true,
            '2031-11-03' => true,
            '2031-11-23' => true,
            '2031-11-24' => true,
            '2031-12-23' => true,
            '2032-01-01' => true,
            '2032-01-12' => true,
            '2032-02-11' => true,
            '2032-03-20' => true,
            '2032-04-29' => true,
            '2032-05-03' => true,
            '2032-05-04' => true,
            '2032-05-05' => true,
            '2032-07-19' => true,
            '2032-08-11' => true,
            '2032-09-20' => true,
            '2032-09-21' => true,
            '2032-09-22' => true,
            '2032-10-11' => true,
            '2032-11-03' => true,
            '2032-11-23' => true,
            '2032-12-23' => true,
            '2033-01-01' => true,
            '2033-01-10' => true,
            '2033-02-11' => true,
            '2033-03-20' => true,
            '2033-03-21' => true,
            '2033-04-29' => true,
            '2033-05-03' => true,
            '2033-05-04' => true,
            '2033-05-05' => true,
            '2033-07-18' => true,
            '2033-08-11' => true,
            '2033-09-19' => true,
            '2033-09-23' => true,
            '2033-10-10' => true,
            '2033-11-03' => true,
            '2033-11-23' => true,
            '2033-12-23' => true,
            '2034-01-01' => true,
            '2034-01-02' => true,
            '2034-01-09' => true,
            '2034-02-11' => true,
            '2034-03-20' => true,
            '2034-04-29' => true,
            '2034-05-03' => true,
            '2034-05-04' => true,
            '2034-05-05' => true,
            '2034-07-17' => true,
            '2034-08-11' => true,
            '2034-09-18' => true,
            '2034-09-23' => true,
            '2034-10-09' => true,
            '2034-11-03' => true,
            '2034-11-23' => true,
            '2034-12-23' => true,
            '2035-01-01' => true,
            '2035-01-08' => true,
            '2035-02-11' => true,
            '2035-02-12' => true,
            '2035-03-21' => true,
            '2035-04-29' => true,
            '2035-04-30' => true,
            '2035-05-03' => true,
            '2035-05-04' => true,
            '2035-05-05' => true,
            '2035-07-16' => true,
            '2035-08-11' => true,
            '2035-09-17' => true,
            '2035-09-23' => true,
            '2035-09-24' => true,
            '2035-10-08' => true,
            '2035-11-03' => true,
            '2035-11-23' => true,
            '2035-12-23' => true,
            '2035-12-24' => true,
            '2036-01-01' => true,
            '2036-01-14' => true,
            '2036-02-11' => true,
            '2036-03-20' => true,
            '2036-04-29' => true,
            '2036-05-03' => true,
            '2036-05-04' => true,
            '2036-05-05' => true,
            '2036-05-06' => true,
            '2036-07-21' => true,
            '2036-08-11' => true,
            '2036-09-15' => true,
            '2036-09-22' => true,
            '2036-10-13' => true,
            '2036-11-03' => true,
            '2036-11-23' => true,
            '2036-11-24' => true,
            '2036-12-23' => true,
            '2037-01-01' => true,
            '2037-01-12' => true,
            '2037-02-11' => true,
            '2037-03-20' => true,
            '2037-04-29' => true,
            '2037-05-03' => true,
            '2037-05-04' => true,
            '2037-05-05' => true,
            '2037-05-06' => true,
            '2037-07-20' => true,
            '2037-08-11' => true,
            '2037-09-21' => true,
            '2037-09-22' => true,
            '2037-09-23' => true,
            '2037-10-12' => true,
            '2037-11-03' => true,
            '2037-11-23' => true,
            '2037-12-23' => true,
            '2038-01-01' => true,
            '2038-01-11' => true,
            '2038-02-11' => true,
            '2038-03-20' => true,
            '2038-04-29' => true,
            '2038-05-03' => true,
            '2038-05-04' => true,
            '2038-05-05' => true,
            '2038-07-19' => true,
            '2038-08-11' => true,
            '2038-09-20' => true,
            '2038-09-23' => true,
            '2038-10-11' => true,
            '2038-11-03' => true,
            '2038-11-23' => true,
            '2038-12-23' => true,
            '2039-01-01' => true,
            '2039-01-10' => true,
            '2039-02-11' => true,
            '2039-03-21' => true,
            '2039-04-29' => true,
            '2039-05-03' => true,
            '2039-05-04' => true,
            '2039-05-05' => true,
            '2039-07-18' => true,
            '2039-08-11' => true,
            '2039-09-19' => true,
            '2039-09-23' => true,
            '2039-10-10' => true,
            '2039-11-03' => true,
            '2039-11-23' => true,
            '2039-12-23' => true,
            '2040-01-01' => true,
            '2040-01-02' => true,
            '2040-01-09' => true,
            '2040-02-11' => true,
            '2040-03-20' => true,
            '2040-04-29' => true,
            '2040-04-30' => true,
            '2040-05-03' => true,
            '2040-05-04' => true,
            '2040-05-05' => true,
            '2040-07-16' => true,
            '2040-08-11' => true,
            '2040-09-17' => true,
            '2040-09-22' => true,
            '2040-10-08' => true,
            '2040-11-03' => true,
            '2040-11-23' => true,
            '2040-12-23' => true,
            '2040-12-24' => true,
            '2041-01-01' => true,
            '2041-01-14' => true,
            '2041-02-11' => true,
            '2041-03-20' => true,
            '2041-04-29' => true,
            '2041-05-03' => true,
            '2041-05-04' => true,
            '2041-05-05' => true,
            '2041-05-06' => true,
            '2041-07-15' => true,
            '2041-08-11' => true,
            '2041-08-12' => true,
            '2041-09-16' => true,
            '2041-09-23' => true,
            '2041-10-14' => true,
            '2041-11-03' => true,
            '2041-11-04' => true,
            '2041-11-23' => true,
            '2041-12-23' => true,
            '2042-01-01' => true,
            '2042-01-13' => true,
            '2042-02-11' => true,
            '2042-03-20' => true,
            '2042-04-29' => true,
            '2042-05-03' => true,
            '2042-05-04' => true,
            '2042-05-05' => true,
            '2042-05-06' => true,
            '2042-07-21' => true,
            '2042-08-11' => true,
            '2042-09-15' => true,
            '2042-09-23' => true,
            '2042-10-13' => true,
            '2042-11-03' => true,
            '2042-11-23' => true,
            '2042-11-24' => true,
            '2042-12-23' => true,
            '2043-01-01' => true,
            '2043-01-12' => true,
            '2043-02-11' => true,
            '2043-03-21' => true,
            '2043-04-29' => true,
            '2043-05-03' => true,
            '2043-05-04' => true,
            '2043-05-05' => true,
            '2043-05-06' => true,
            '2043-07-20' => true,
            '2043-08-11' => true,
            '2043-09-21' => true,
            '2043-09-22' => true,
            '2043-09-23' => true,
            '2043-10-12' => true,
            '2043-11-03' => true,
            '2043-11-23' => true,
            '2043-12-23' => true,
            '2044-01-01' => true,
            '2044-01-11' => true,
            '2044-02-11' => true,
            '2044-03-20' => true,
            '2044-03-21' => true,
            '2044-04-29' => true,
            '2044-05-03' => true,
            '2044-05-04' => true,
            '2044-05-05' => true,
            '2044-07-18' => true,
            '2044-08-11' => true,
            '2044-09-19' => true,
            '2044-09-22' => true,
            '2044-10-10' => true,
            '2044-11-03' => true,
            '2044-11-23' => true,
            '2044-12-23' => true,
            '2045-01-01' => true,
            '2045-01-02' => true,
            '2045-01-09' => true,
            '2045-02-11' => true,
            '2045-03-20' => true,
            '2045-04-29' => true,
            '2045-05-03' => true,
            '2045-05-04' => true,
            '2045-05-05' => true,
            '2045-07-17' => true,
            '2045-08-11' => true,
            '2045-09-18' => true,
            '2045-09-22' => true,
            '2045-10-09' => true,
            '2045-11-03' => true,
            '2045-11-23' => true,
            '2045-12-23' => true,
            '2046-01-01' => true,
            '2046-01-08' => true,
            '2046-02-11' => true,
            '2046-02-12' => true,
            '2046-03-20' => true,
            '2046-04-29' => true,
            '2046-04-30' => true,
            '2046-05-03' => true,
            '2046-05-04' => true,
            '2046-05-05' => true,
            '2046-07-16' => true,
            '2046-08-11' => true,
            '2046-09-17' => true,
            '2046-09-23' => true,
            '2046-09-24' => true,
            '2046-10-08' => true,
            '2046-11-03' => true,
            '2046-11-23' => true,
            '2046-12-23' => true,
            '2046-12-24' => true,
            '2047-01-01' => true,
            '2047-01-14' => true,
            '2047-02-11' => true,
            '2047-03-21' => true,
            '2047-04-29' => true,
            '2047-05-03' => true,
            '2047-05-04' => true,
            '2047-05-05' => true,
            '2047-05-06' => true,
            '2047-07-15' => true,
            '2047-08-11' => true,
            '2047-08-12' => true,
            '2047-09-16' => true,
            '2047-09-23' => true,
            '2047-10-14' => true,
            '2047-11-03' => true,
            '2047-11-04' => true,
            '2047-11-23' => true,
            '2047-12-23' => true,
            '2048-01-01' => true,
            '2048-01-13' => true,
            '2048-02-11' => true,
            '2048-03-20' => true,
            '2048-04-29' => true,
            '2048-05-03' => true,
            '2048-05-04' => true,
            '2048-05-05' => true,
            '2048-05-06' => true,
            '2048-07-20' => true,
            '2048-08-11' => true,
            '2048-09-21' => true,
            '2048-09-22' => true,
            '2048-10-12' => true,
            '2048-11-03' => true,
            '2048-11-23' => true,
            '2048-12-23' => true,
            '2049-01-01' => true,
            '2049-01-11' => true,
            '2049-02-11' => true,
            '2049-03-20' => true,
            '2049-04-29' => true,
            '2049-05-03' => true,
            '2049-05-04' => true,
            '2049-05-05' => true,
            '2049-07-19' => true,
            '2049-08-11' => true,
            '2049-09-20' => true,
            '2049-09-21' => true,
            '2049-09-22' => true,
            '2049-10-11' => true,
            '2049-11-03' => true,
            '2049-11-23' => true,
            '2049-12-23' => true,
            '2050-01-01' => true,
            '2050-01-10' => true,
            '2050-02-11' => true,
            '2050-03-20' => true,
            '2050-03-21' => true,
            '2050-04-29' => true,
            '2050-05-03' => true,
            '2050-05-04' => true,
            '2050-05-05' => true,
            '2050-07-18' => true,
            '2050-08-11' => true,
            '2050-09-19' => true,
            '2050-09-23' => true,
            '2050-10-10' => true,
            '2050-11-03' => true,
            '2050-11-23' => true,
            '2050-12-23' => true
        );
    }

    /**
     * tests for holidays from 1970 to 2050
     *
     * @access public
     * @return void
     */
    function testHolidaysFrom1970to2050()
    {
        for ($year = 1970; $year < 2051; $year++) {
            $obj =& Date_Holidays::factory('Japan', $year);
            if (Date_Holidays::isError($obj)) {
                $this->fail(helper_get_error_message($obj));
            }

            $invalid_holidays = array();
            foreach ($obj->getHolidayDates() as $holiday) {
                $dt = substr($holiday->getDate(), 0, 10);
                if (array_key_exists($dt, $this->_holidays)) {
                    unset($this->_holidays[$dt]);
                } else {
                    $invalid_holidays[] = $holiday->getDate();
                }
            }
        }
        // if all holidays was calculated or not
        $this->assertEquals(0, count($this->_holidays));

        // if no invalid holidays was calculated or not
        $this->assertEquals(0, count($invalid_holidays));
    }

    /**
     * test holidays from 1970 to 2050
     *
     * @access public
     * @return void
     */
    function testSubstituteHolidaysInMay2008()
    {
        $obj = Date_Holidays::factory('Japan', 2008);
        if (Date_Holidays::isError($obj)) {
            $this->fail(helper_get_error_message($obj));
        }
        // calculate substitute holiday for Children's Day (1st time)
        $this->assertTrue($obj->isHoliday(new Date('2008-05-06')), '1st time');

        // calculate substitute holiday for Children's Day (2nd time)
        // because re-calculated holidays internaly
        $this->assertTrue($obj->isHoliday(new Date('2008-05-06')), '2nd time');

        // in 2007, this day is not substitute holiday
        $this->assertFalse($obj->isHoliday(new Date('2007-05-07')), 'in 2007');
    }

    /**
     * test setYear with a xml translation file
     *
     * @access public
     * @return void
     */
    function testSetYearWithXmlTranslationFile()
    {
        // with ja_JP.xml
        $obj = Date_Holidays::factory('Japan', 2008);
        if (Date_Holidays::isError($obj)) {
            $this->fail(helper_get_error_message($obj));
        }
        $obj->addTranslationFile($this->lang_dir . '/Japan/ja_JP.xml', 'ja_JP');
        if (Date_Holidays::isError($obj)) {
            $this->fail('fail to add translation file');
        }

        $this->assertEquals('振替休日', $obj->getHolidayForDate(new Date('2008-05-06'), 'ja_JP')->getTitle(), '2008');

        $obj->setYear(2009);
        $this->assertEquals('振替休日', $obj->getHolidayForDate(new Date('2009-05-06'), 'ja_JP')->getTitle(), '2009');

        $obj->setYear(2010);
        $this->assertNull($obj->getHolidayForDate(new Date('2010-05-06'), 'ja_JP'), '2010');
    }

    /**
     * test setYear with a .ser translation file
     *
     * @access public
     * @return void
     */
    function testSetYearWithCompiledTranslationFile()
    {
        // with ja_JP.ser
        $obj = Date_Holidays::factory('Japan', 2008);
        if (Date_Holidays::isError($obj)) {
            $this->fail(helper_get_error_message($obj));
        }
        $obj->addCompiledTranslationFile($this->lang_dir . '/Japan/ja_JP.ser', 'ja_JP');
        if (Date_Holidays::isError($obj)) {
            $this->fail('fail to add translation file');
        }

        $this->assertEquals('振替休日', $obj->getHolidayForDate(new Date('2008-05-06'), 'ja_JP')->getTitle(), '2008');

        $obj->setYear(2009);
        $this->assertEquals('振替休日', $obj->getHolidayForDate(new Date('2009-05-06'), 'ja_JP')->getTitle(), '2009');

        $obj->setYear(2010);
        $this->assertNull($obj->getHolidayForDate(new Date('2010-05-06'), 'ja_JP'), '2010');

    }

    /**
     * tests for holidays from 1970 to 2050 with setYear()
     *
     * @access public
     * @return void
     */
    function testHolidaysFrom1970to2050WithSetYear()
    {
        $obj =& Date_Holidays::factory('Japan');
        if (Date_Holidays::isError($obj)) {
            $this->fail(helper_get_error_message($obj));
        }
        for ($year = 1970; $year < 2051; $year++) {
            $obj->setYear($year);
            $invalid_holidays = array();
            foreach ($obj->getHolidayDates() as $holiday) {
                $dt = substr($holiday->getDate(), 0, 10);
                if (array_key_exists($dt, $this->_holidays)) {
                    unset($this->_holidays[$dt]);
                } else {
                    $invalid_holidays[] = $holiday->getDate();
                }
            }
        }
        // if all holidays was calculated or not
        $this->assertEquals(0, count($this->_holidays));

        // if no invalid holidays was calculated or not
        $this->assertEquals(0, count($invalid_holidays));
    }

    /**
     * tests showa day with .xml file (YYYY-MM-DD = YYYY-04-29)
     *
     * @access public
     * @return void
     */
    function testShowaDay()
    {
        // with ja_JP.xml
        $obj = Date_Holidays::factory('Japan', 1949);
        if (Date_Holidays::isError($obj)) {
            $this->fail(helper_get_error_message($obj));
        }
        $obj->addTranslationFile($this->lang_dir . '/Japan/ja_JP.xml', 'ja_JP');
        if (Date_Holidays::isError($obj)) {
            $this->fail('fail to add translation file');
        }

        $this->assertEquals('天皇誕生日', $obj->getHolidayForDate('1949-04-29', 'ja_JP')->getTitle(), 'showa day in 1949');

        $obj->setYear(1989);
        $this->assertEquals('みどりの日', $obj->getHolidayForDate('1989-04-29', 'ja_JP')->getTitle(), 'showa day in 1989');

        $obj->setYear(2007);
        $this->assertEquals('昭和の日', $obj->getHolidayForDate('2007-04-29', 'ja_JP')->getTitle(), 'showa day in 2007');
    }

    /**
     * tests showa day with .xml file (YYYY-MM-DD = YYYY-04-29)
     *
     * @access public
     * @return void
     */
    function testShowaDayWithCompiledTranslationFile()
    {
        // with ja_JP.ser
        $obj = Date_Holidays::factory('Japan', 1949);
        if (Date_Holidays::isError($obj)) {
            $this->fail(helper_get_error_message($obj));
        }
        $obj->addCompiledTranslationFile($this->lang_dir . '/Japan/ja_JP.ser', 'ja_JP');
        if (Date_Holidays::isError($obj)) {
            $this->fail('fail to add translation file');
        }

        $this->assertEquals('天皇誕生日', $obj->getHolidayForDate('1949-04-29', 'ja_JP')->getTitle(), 'showa day in 1949');

        $obj->setYear(1989);
        $this->assertEquals('みどりの日', $obj->getHolidayForDate('1989-04-29', 'ja_JP')->getTitle(), 'showa day in 1989');

        $obj->setYear(2007);
        $this->assertEquals('昭和の日', $obj->getHolidayForDate('2007-04-29', 'ja_JP')->getTitle(), 'showa day in 2007');
    }

    /**
     * tests greeney day with .xml file (YYYY-MM-DD = YYYY-05-04)
     *
     * @access public
     * @return void
     */
    function testGreeneyDay()
    {
        // with ja_JP.xml
        $obj = Date_Holidays::factory('Japan', 1986);
        if (Date_Holidays::isError($obj)) {
            $this->fail(helper_get_error_message($obj));
        }
        $obj->addTranslationFile($this->lang_dir . '/Japan/ja_JP.xml', 'ja_JP');
        if (Date_Holidays::isError($obj)) {
            $this->fail('fail to add translation file');
        }

        // the day of week on 1986-05-04 is 0 (sunday)
        $this->assertNull($obj->getHolidayForDate('1986-05-04'));

        $obj->setYear(1987);
        $this->assertEquals('国民の休日', $obj->getHolidayForDate('1987-05-04', 'ja_JP')->getTitle(), 'showa day in 1987');

        $obj->setYear(2007);
        $this->assertEquals('みどりの日', $obj->getHolidayForDate('2007-05-04', 'ja_JP')->getTitle(), 'showa day in 2007');
    }

    /**
     * tests greeney day with .ser file (YYYY-MM-DD = YYYY-05-04)
     *
     * @access public
     * @return void
     */
    function testGreeneyDayWithCompiledTranslationFile()
    {
        // with ja_JP.ser
        $obj = Date_Holidays::factory('Japan', 1986);
        if (Date_Holidays::isError($obj)) {
            $this->fail(helper_get_error_message($obj));
        }
        $obj->addCompiledTranslationFile($this->lang_dir . '/Japan/ja_JP.ser', 'ja_JP');
        if (Date_Holidays::isError($obj)) {
            $this->fail('fail to add translation file');
        }

        // the day of week on 1986-05-04 is 0 (sunday)
        $this->assertNull($obj->getHolidayForDate('1986-05-04'));

        $obj->setYear(1987);
        $this->assertEquals('国民の休日', $obj->getHolidayForDate('1987-05-04', 'ja_JP')->getTitle(), 'showa day in 1987');

        $obj->setYear(2007);
        $this->assertEquals('みどりの日', $obj->getHolidayForDate('2007-05-04', 'ja_JP')->getTitle(), 'showa day in 2007');
    }

    /**
     * bug #16338
     *
     * @access public
     * @return void
     */
    function test16338()
    {
        for ($year = 1900; $year < date('Y'); $year++) {
            $obj = Date_Holidays::factory('Japan', $year, 'ja_JP');
            if (Date_Holidays::isError($obj)) {
                $this->fail(helper_get_error_message($obj));
            }
            $res = $obj->addTranslationFile($this->lang_dir . '/Japan/ja_JP.xml', 'ja_JP');
            if (Date_Holidays::isError($res)) {
                $this->fail(helper_get_error_message($res));
            }
            $holidays = array();
            foreach ($obj->getHolidays() as $h) {
                if (PEAR::isError($h)) {
                    $this->fail(helper_get_error_message($h));
                }
                $holidays[$h->getDate()->format('%Y-%m-%d')] = $h->getTitle();
            }
        }
    }
}

?>
