/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.PoolableStatementClosingConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.ServletContext;

public class DBConnection {
    private DBConnection() {
    }

    public static String readINIFile(ServletContext servletContext, String match_db_name, StringBuffer db_url, StringBuffer db_class, ArrayList db_names) {
        return "Available databases are no longer specified by this method.";
    }

    public static boolean isOracle(Connection con) {
        String url = "";
        try {
            DatabaseMetaData dmd = con.getMetaData();
            url = dmd.getURL();
        }
        catch (SQLException e) {
            System.out.println("problem in DBConnection.isOracle: " + e.getMessage());
        }
        return url.toUpperCase().indexOf("ORACLE") != -1;
    }

    public static boolean isPostgres(Connection con) {
        try {
            DatabaseMetaData dmd = con.getMetaData();
            return dmd.getDatabaseProductName().indexOf("PostgreSQL") >= 0;
        }
        catch (SQLException e) {
            System.out.println("problem in DBConnection.isPostgres: " + e.getMessage());
            return false;
        }
    }

    public static boolean isSQLServer(Connection con) {
        try {
            DatabaseMetaData dmd = con.getMetaData();
            return dmd.getDatabaseProductName().indexOf("Microsoft SQL Server") >= 0;
        }
        catch (SQLException e) {
            System.out.println("problem in DBConnection.isSQLServer: " + e.getMessage());
            return false;
        }
    }

    public static boolean isDB2(Connection con) {
        try {
            DatabaseMetaData dmd = con.getMetaData();
            return dmd.getDatabaseProductName().indexOf("DB2") >= 0;
        }
        catch (SQLException e) {
            System.out.println("problem in DBConnection.isDB2: " + e.getMessage());
            return false;
        }
    }

    public static String getSystemDate(Connection con) {
        String systemDate = "";
        systemDate = DBConnection.isOracle(con) ? "SYSDATE" : (DBConnection.isPostgres(con) ? "now()" : "{fn NOW()}");
        return systemDate;
    }

    public static String getUser(Connection con) throws SQLException {
        String user = null;
        if (con instanceof PoolableStatementClosingConnection) {
            user = ((PoolableStatementClosingConnection)((Object)con)).getPlUsername();
        }
        if (user != null) {
            return user;
        }
        DatabaseMetaData dmd = con.getMetaData();
        user = dmd.getUserName();
        return user;
    }

    public static String ifNull(String valueString, String ifNullString) {
        String newValueString = valueString == null || valueString.equals("") ? ifNullString : valueString;
        return newValueString;
    }
}

