/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import net.sourceforge.jnlp.Node;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.nanoxml.XMLElement;

class XMLParser {
    XMLParser() {
    }

    public Node getRootNode(InputStream input) throws ParseException {
        try {
            BufferedInputStream bs = new BufferedInputStream(input);
            XMLElement xml = new XMLElement();
            PipedInputStream pin = new PipedInputStream();
            final PipedOutputStream pout = new PipedOutputStream(pin);
            final InputStreamReader isr = new InputStreamReader((InputStream)bs, XMLParser.getEncoding(bs));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    new XMLElement().sanitizeInput(isr, pout);
                    try {
                        pout.close();
                    }
                    catch (IOException ioe) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ioe);
                    }
                }
            }).start();
            xml.parseFromReader(new InputStreamReader(pin));
            Node jnlpNode = new Node(xml);
            return jnlpNode;
        }
        catch (Exception ex) {
            throw new ParseException(Translator.R("PBadXML"), ex);
        }
    }

    private static String getEncoding(InputStream input) throws IOException {
        int[] s = new int[4];
        String encoding = "UTF-8";
        input.mark(4);
        for (int i = 0; i < 4; ++i) {
            s[i] = input.read();
        }
        input.reset();
        if (s[0] == 255) {
            if (s[1] == 254) {
                encoding = s[2] != 0 || s[3] != 0 ? "UnicodeLittle" : "X-UTF-32LE-BOM";
            }
        } else if (s[0] == 254 && s[1] == 255 && (s[2] != 0 || s[3] != 0)) {
            encoding = "UTF-16";
        } else if (s[0] == 0 && s[1] == 0 && s[2] == 254 && s[3] == 255) {
            encoding = "X-UTF-32BE-BOM";
        } else if (s[0] == 0 && s[1] == 0 && s[2] == 0 && s[3] == 60) {
            encoding = "UTF-32BE";
        } else if (s[0] == 60 && s[1] == 0 && s[2] == 0 && s[3] == 0) {
            encoding = "UTF-32LE";
        } else if (s[0] == 0 && s[1] == 60 && s[2] == 0 && s[3] == 63) {
            encoding = "UTF-16BE";
        } else if (s[0] == 60 && s[1] == 0 && s[2] == 63 && s[3] == 0) {
            encoding = "UTF-16LE";
        }
        return encoding;
    }
}

