/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.controlpanel.CacheViewer;
import net.sourceforge.jnlp.controlpanel.ComboItem;
import net.sourceforge.jnlp.controlpanel.NamedBorderPanel;
import net.sourceforge.jnlp.runtime.Translator;

public class TemporaryInternetFilesPanel
extends NamedBorderPanel {
    private static final Long CACHE_UNLIMITED_SIZE = -1L;
    private static final Long CACHE_MIN_SIZE = 0L;
    private static final Long CACHE_MAX_SIZE = Integer.MAX_VALUE;
    private static final Long SPINNER_STEP_SIZE = 10L;
    private final JSpinner cacheSizeSpinner;
    private static final long BYTES_TO_MEGABYTES = 0x100000L;
    private final JCheckBox limitCacheSizeCheckBox;
    private final JLabel cacheSizeWarningLabel;
    private final DeploymentConfiguration config;
    private final JComboBox<ComboItem> cbCompression;
    private final JButton bLocation;
    private final JButton resetLocation;
    private final JTextField location;
    private final JLabel locationDescription;
    private final JLabel lCompression;
    private final JLabel lCacheSize;
    private final JButton bViewFiles;
    private final JPanel diskSpacePanel;

    public TemporaryInternetFilesPanel(DeploymentConfiguration config) {
        super(Translator.R("CPHeadTempInternetFiles"));
        this.config = config;
        this.setLayout(new BorderLayout());
        this.cacheSizeSpinner = new JSpinner();
        this.limitCacheSizeCheckBox = new JCheckBox(Translator.R("TIFPLimitCacheSize"));
        this.cacheSizeWarningLabel = new JLabel();
        this.lCacheSize = new JLabel(Translator.R("TIFPCacheSize") + ":");
        ComboItem[] compressionOptions = new ComboItem[]{new ComboItem(Translator.R("TIFPNone"), "0"), new ComboItem("1", "1"), new ComboItem("2", "2"), new ComboItem("3", "3"), new ComboItem("4", "4"), new ComboItem("5", "5"), new ComboItem("6", "6"), new ComboItem("7", "7"), new ComboItem("8", "8"), new ComboItem(Translator.R("TIFPMax"), "9")};
        this.cbCompression = new JComboBox<ComboItem>(compressionOptions);
        this.lCompression = new JLabel(Translator.R("TIFPCompressionLevel") + ":");
        this.bLocation = new JButton(Translator.R("TIFPChange") + "...");
        this.resetLocation = new JButton(Translator.R("CPFilesLogsDestDirResert"));
        this.location = new JTextField(PathsAndFiles.CACHE_DIR.getFullPath(config));
        this.locationDescription = new JLabel(Translator.R("TIFPLocationLabel") + ":");
        this.bViewFiles = new JButton(Translator.R("TIFPViewFiles"));
        this.diskSpacePanel = new JPanel();
        this.diskSpacePanel.setLayout(new GridBagLayout());
        this.addComponents();
        if (this.limitCacheSizeCheckBox.isSelected()) {
            this.showCacheSizeSpinnerGUIElements(true);
            if (Long.parseLong(this.cacheSizeSpinner.getValue().toString()) == 0L) {
                this.showCompressionAndLocationGUIElements(false);
            } else {
                this.showCompressionAndLocationGUIElements(true);
            }
        } else {
            this.showCacheSizeSpinnerGUIElements(false);
            this.showCompressionAndLocationGUIElements(true);
        }
    }

    private void addComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        JLabel description = new JLabel(Translator.R("CPTempInternetFilesDescription"));
        this.cbCompression.setSelectedIndex(Integer.parseInt(this.config.getProperty("deployment.cache.jarcompression")));
        this.cbCompression.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TemporaryInternetFilesPanel.this.config.setProperty("deployment.cache.jarcompression", ((ComboItem)e.getItem()).getValue());
            }
        });
        Long configCacheSize = Long.parseLong(this.config.getProperty("deployment.cache.max.size"));
        Long initialCacheSize = configCacheSize < CACHE_MIN_SIZE ? CACHE_MIN_SIZE : configCacheSize;
        PowerOfSpinnerNumberModel snmCacheSize = new PowerOfSpinnerNumberModel(initialCacheSize, CACHE_MIN_SIZE, CACHE_MAX_SIZE, SPINNER_STEP_SIZE);
        this.cacheSizeSpinner.setModel(snmCacheSize);
        final SpinnerChangeListener listener = new SpinnerChangeListener();
        this.cacheSizeSpinner.addChangeListener(listener);
        this.cacheSizeSpinner.setToolTipText(Translator.R("TIFPCacheSizeSpinnerTooltip", CACHE_MIN_SIZE, CACHE_MAX_SIZE));
        this.limitCacheSizeCheckBox.setSelected(configCacheSize >= CACHE_MIN_SIZE);
        this.limitCacheSizeCheckBox.addItemListener(new CheckboxItemListener());
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridy = 0;
        this.diskSpacePanel.add((Component)this.limitCacheSizeCheckBox, c);
        c.gridy = 1;
        this.diskSpacePanel.add((Component)this.lCacheSize, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.diskSpacePanel.add((Component)this.cacheSizeSpinner, c);
        c.gridwidth = 1;
        c.gridy = 2;
        c.gridx = 0;
        this.diskSpacePanel.add((Component)this.cacheSizeWarningLabel, c);
        c.gridx = 0;
        c.gridy = 3;
        this.diskSpacePanel.add((Component)this.lCompression, c);
        c.gridx = 1;
        c.gridwidth = 2;
        this.diskSpacePanel.add(this.cbCompression, c);
        this.resetLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemporaryInternetFilesPanel.this.location.setText(PathsAndFiles.CACHE_DIR.getDefaultFullPath());
                PathsAndFiles.CACHE_DIR.setValue(PathsAndFiles.CACHE_DIR.getDefaultFullPath(), TemporaryInternetFilesPanel.this.config);
                TemporaryInternetFilesPanel.this.showCacheSizeSpinnerGUIElements(TemporaryInternetFilesPanel.this.limitCacheSizeCheckBox.isSelected());
            }
        });
        this.location.setEditable(false);
        this.bLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser(TemporaryInternetFilesPanel.this.location.getText());
                fileChooser.setFileSelectionMode(1);
                fileChooser.setFileHidingEnabled(false);
                fileChooser.setAcceptAllFileFilterUsed(false);
                fileChooser.setDialogTitle(Translator.R("TIFPLocationLabel"));
                if (fileChooser.showDialog(null, Translator.R("TIFPFileChooserChooseButton")) == 0) {
                    File dirLocation;
                    String result = fileChooser.getSelectedFile().getAbsolutePath();
                    boolean canWrite = dirLocation.canWrite();
                    for (dirLocation = new File(result); !canWrite && dirLocation != null; dirLocation = dirLocation.getParentFile()) {
                        if (dirLocation.exists()) {
                            JOptionPane.showMessageDialog(null, "No permission to write to this location.");
                            return;
                        }
                        canWrite = dirLocation.canWrite();
                    }
                    if (canWrite) {
                        TemporaryInternetFilesPanel.this.location.setText(result);
                        PathsAndFiles.CACHE_DIR.setValue(result, TemporaryInternetFilesPanel.this.config);
                        TemporaryInternetFilesPanel.this.showCacheSizeSpinnerGUIElements(TemporaryInternetFilesPanel.this.limitCacheSizeCheckBox.isSelected());
                    }
                }
            }
        });
        this.bViewFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CacheViewer.showCacheDialog(TemporaryInternetFilesPanel.this.config);
            }
        });
        c.gridy = 4;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.diskSpacePanel.add((Component)this.locationDescription, c);
        c.gridy = 5;
        c.gridwidth = 1;
        this.diskSpacePanel.add((Component)this.location, c);
        c.gridx = 1;
        c.weightx = 0.5;
        this.diskSpacePanel.add((Component)this.resetLocation, c);
        c.gridx = 2;
        c.weightx = 0.5;
        this.diskSpacePanel.add((Component)this.bLocation, c);
        c.gridx = 3;
        this.diskSpacePanel.add((Component)this.bViewFiles, c);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)description, "North");
        panel.add((Component)this.diskSpacePanel, "Center");
        this.add((Component)panel, "Center");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                listener.stateChanged(null);
            }
        });
    }

    private long getCurrentUsableSpace() {
        long usableDiskSpace = new File(PathsAndFiles.CACHE_DIR.getFullPath(this.config)).getUsableSpace() / 0x100000L;
        return usableDiskSpace;
    }

    private void showCompressionAndLocationGUIElements(boolean bool) {
        this.cbCompression.setEnabled(bool);
        this.lCompression.setEnabled(bool);
        this.resetLocation.setEnabled(bool);
        this.bLocation.setEnabled(bool);
        this.location.setEnabled(bool);
        this.locationDescription.setEnabled(bool);
        this.bViewFiles.setEnabled(bool);
    }

    private void showCacheSizeSpinnerGUIElements(boolean bool) {
        this.lCacheSize.setEnabled(bool);
        this.cacheSizeSpinner.setEnabled(bool);
        this.cacheSizeWarningLabel.setEnabled(bool);
        long usableDiskSpace = this.getCurrentUsableSpace();
        if (!bool) {
            this.cacheSizeSpinner.setToolTipText(null);
            this.cacheSizeWarningLabel.setText(Translator.R("TIFPCacheSizeSpinnerLargeValueWarning", usableDiskSpace));
        } else {
            this.cacheSizeSpinner.setToolTipText(Translator.R("TIFPCacheSizeSpinnerTooltip", CACHE_MIN_SIZE, CACHE_MAX_SIZE));
            long cacheSizeSpinnerValue = (Long)this.cacheSizeSpinner.getValue();
            if (cacheSizeSpinnerValue > usableDiskSpace) {
                this.cacheSizeWarningLabel.setText(Translator.R("TIFPCacheSizeSpinnerValueTooLargeWarning", usableDiskSpace));
            } else if (cacheSizeSpinnerValue == 0L) {
                this.cacheSizeWarningLabel.setText(Translator.R("TIFPCacheSizeSetToNoCaching"));
            }
        }
    }

    private class CheckboxItemListener
    implements ItemListener {
        private CheckboxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            boolean selected = e.getStateChange() == 1;
            TemporaryInternetFilesPanel.this.showCacheSizeSpinnerGUIElements(selected);
            if (Long.parseLong(TemporaryInternetFilesPanel.this.cacheSizeSpinner.getValue().toString()) == 0L && selected) {
                TemporaryInternetFilesPanel.this.showCompressionAndLocationGUIElements(false);
            } else {
                TemporaryInternetFilesPanel.this.showCompressionAndLocationGUIElements(true);
            }
            if (selected) {
                TemporaryInternetFilesPanel.this.config.setProperty("deployment.cache.max.size", TemporaryInternetFilesPanel.this.cacheSizeSpinner.getValue().toString());
            } else {
                TemporaryInternetFilesPanel.this.config.setProperty("deployment.cache.max.size", Long.toString(CACHE_UNLIMITED_SIZE));
            }
            TemporaryInternetFilesPanel.this.config.setProperty("deployment.javapi.cache.enabled", String.valueOf(!selected));
        }
    }

    private class SpinnerChangeListener
    implements ChangeListener {
        private SpinnerChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            long usableDiskSpace = TemporaryInternetFilesPanel.this.getCurrentUsableSpace();
            long cacheSizeSpinnerValue = (Long)TemporaryInternetFilesPanel.this.cacheSizeSpinner.getValue();
            if (TemporaryInternetFilesPanel.this.limitCacheSizeCheckBox.isSelected()) {
                TemporaryInternetFilesPanel.this.showCompressionAndLocationGUIElements(true);
                if (cacheSizeSpinnerValue > usableDiskSpace) {
                    TemporaryInternetFilesPanel.this.cacheSizeWarningLabel.setText(Translator.R("TIFPCacheSizeSpinnerValueTooLargeWarning", usableDiskSpace));
                } else if (cacheSizeSpinnerValue == 0L) {
                    TemporaryInternetFilesPanel.this.cacheSizeWarningLabel.setText(Translator.R("TIFPCacheSizeSetToNoCaching"));
                    TemporaryInternetFilesPanel.this.showCompressionAndLocationGUIElements(false);
                } else {
                    TemporaryInternetFilesPanel.this.cacheSizeWarningLabel.setText(Translator.R("TIFPCacheSizeSpinnerLargeValueWarning", usableDiskSpace));
                }
                TemporaryInternetFilesPanel.this.config.setProperty("deployment.cache.max.size", Long.valueOf(cacheSizeSpinnerValue).toString());
            } else {
                TemporaryInternetFilesPanel.this.showCacheSizeSpinnerGUIElements(false);
                TemporaryInternetFilesPanel.this.showCompressionAndLocationGUIElements(true);
            }
        }
    }

    private static class PowerOfSpinnerNumberModel
    extends SpinnerNumberModel {
        private final List<Long> powersOf = new ArrayList<Long>();

        public PowerOfSpinnerNumberModel(Long initialCacheSize, Long cacheMinSize, Long cacheMaxSize, Long spinnerStepSize) {
            super(initialCacheSize, cacheMinSize, cacheMaxSize, spinnerStepSize);
            int powersListSize = (int)Math.floor(Math.log(cacheMaxSize.longValue()) / Math.log(spinnerStepSize.longValue()) + 1.0);
            for (int i = 0; i < powersListSize; ++i) {
                long powerOfTen = (long)Math.pow(spinnerStepSize.longValue(), i);
                this.powersOf.add(powerOfTen);
            }
        }

        @Override
        public Long getNextValue() {
            Number raw = (Number)super.getValue();
            if (super.getNextValue() == null) {
                return (Long)this.getMaximum();
            }
            Long original = raw.longValue();
            Long result = original - original % this.powersOf.get(String.valueOf(original).length() - 1) + this.powersOf.get(String.valueOf(original).length() - 1);
            if (result < (Long)this.getMaximum()) {
                return result;
            }
            return (Long)this.getMaximum();
        }

        @Override
        public Long getPreviousValue() {
            Number raw = (Number)super.getValue();
            Long original = raw.longValue();
            if (super.getPreviousValue() == null) {
                if (original > 0L) {
                    return original - 1L;
                }
                return (Long)this.getMinimum();
            }
            if (this.powersOf.contains(original)) {
                Long result = original - this.powersOf.get(String.valueOf(original).length() - 2);
                return result;
            }
            Long result = original % this.powersOf.get(String.valueOf(original).length() - 1) == 0L ? Long.valueOf(original - this.powersOf.get(String.valueOf(original).length() - 1)) : Long.valueOf(original - original % this.powersOf.get(String.valueOf(original).length() - 1));
            if (result > Long.valueOf(0L)) {
                return result;
            }
            return 0L;
        }
    }
}

