/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jnlp.security.policyeditor.CustomPermission;
import net.sourceforge.jnlp.security.policyeditor.InvalidPolicyException;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorPermissions;
import net.sourceforge.jnlp.security.policyeditor.PolicyEntry;
import net.sourceforge.jnlp.security.policyeditor.PolicyFileModel;
import net.sourceforge.jnlp.util.logging.OutputController;

public class PolicyEditorController {
    public final PolicyFileModel policyFile = new PolicyFileModel();
    private volatile boolean changesMade = false;
    private volatile boolean performingIO = false;

    boolean changesMade() {
        return this.changesMade;
    }

    void setChangesMade(boolean b) {
        this.changesMade = b;
    }

    boolean performingIO() {
        return this.performingIO;
    }

    void setPerformingIO(boolean b) {
        this.performingIO = b;
    }

    public void setFile(File file) {
        this.setChangesMade(true);
        this.policyFile.setFile(file);
    }

    public File getFile() {
        return this.policyFile.getFile();
    }

    public boolean fileHasChanged() throws FileNotFoundException, IOException {
        return this.policyFile.hasChanged();
    }

    public boolean addCodebase(String codebase) {
        boolean existed = this.policyFile.addCodebase(codebase);
        if (!existed) {
            this.setChangesMade(true);
        }
        return existed;
    }

    public void removeCodebase(String codebase) {
        this.setChangesMade(true);
        this.policyFile.removeCodebase(codebase);
    }

    public Set<String> getCodebases() {
        return new HashSet<String>(this.policyFile.getCodebases());
    }

    public Map<String, Map<PolicyEditorPermissions, Boolean>> getCopyOfPermissions() {
        return this.policyFile.getCopyOfPermissions();
    }

    public void setPermission(String codebase, PolicyEditorPermissions permission, boolean state) {
        if (this.getPermission(codebase, permission) != state) {
            this.setChangesMade(true);
        }
        this.policyFile.setPermission(codebase, permission, state);
    }

    public boolean getPermission(String codebase, PolicyEditorPermissions permission) {
        return this.policyFile.getPermission(codebase, permission);
    }

    public Map<PolicyEditorPermissions, Boolean> getPermissions(String codebase) {
        this.policyFile.addCodebase(codebase);
        return new HashMap<PolicyEditorPermissions, Boolean>(this.policyFile.getCopyOfPermissions().get(codebase));
    }

    public void clearPermissions() {
        this.setChangesMade(true);
        this.policyFile.clearPermissions();
    }

    public void addCustomPermissions(String codebase, Collection<CustomPermission> permissions) {
        if (!this.policyFile.getCopyOfCustomPermissions().equals(permissions)) {
            this.setChangesMade(true);
        }
        this.policyFile.addCustomPermissions(codebase, permissions);
    }

    public void addCustomPermission(String codebase, CustomPermission permission) {
        Map<String, Set<CustomPermission>> customs = this.policyFile.getCopyOfCustomPermissions();
        if (customs == null || !customs.containsKey(codebase) || customs.containsKey(codebase) && !customs.get(codebase).contains(permission)) {
            this.setChangesMade(true);
        }
        this.addCustomPermissions(codebase, Arrays.asList(permission));
    }

    public Set<CustomPermission> getCustomPermissions(String codebase) {
        this.policyFile.addCodebase(codebase);
        return new HashSet<CustomPermission>((Collection)this.policyFile.getCopyOfCustomPermissions().get(codebase));
    }

    public void addPolicyEntry(PolicyEntry policyEntry) {
        this.addCodebase(policyEntry.getCodebase());
        for (PolicyEditorPermissions permission : policyEntry.getPermissions()) {
            this.setPermission(policyEntry.getCodebase(), permission, true);
        }
        this.addCustomPermissions(policyEntry.getCodebase(), policyEntry.getCustomPermissions());
    }

    public void clearCustomPermissions() {
        this.setChangesMade(true);
        this.policyFile.clearCustomPermissions();
    }

    public void clearCustomCodebase(String codebase) {
        this.setChangesMade(true);
        this.policyFile.clearCustomCodebase(codebase);
    }

    public void openAndParsePolicyFile() throws IOException, InvalidPolicyException {
        try {
            this.policyFile.getFile().createNewFile();
        }
        catch (IOException e) {
            OutputController.getLogger().log(e);
        }
        this.setPerformingIO(true);
        this.policyFile.openAndParsePolicyFile();
        this.setChangesMade(false);
        this.setPerformingIO(false);
    }

    public void savePolicyFile() throws FileNotFoundException, IOException {
        this.setPerformingIO(true);
        this.policyFile.savePolicyFile();
        this.setChangesMade(false);
        this.setPerformingIO(false);
    }

    public void copyCodebaseToClipboard(String codebase) {
        Map<PolicyEditorPermissions, Boolean> standardPermissions = this.policyFile.getCopyOfPermissions().get(codebase);
        Set<CustomPermission> customPermissions = this.policyFile.getCopyOfCustomPermissions().get(codebase);
        HashSet<PolicyEditorPermissions> enabledPermissions = new HashSet<PolicyEditorPermissions>();
        for (Map.Entry<PolicyEditorPermissions, Boolean> entry : standardPermissions.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            enabledPermissions.add(entry.getKey());
        }
        PolicyEntry entry = new PolicyEntry(codebase, enabledPermissions, customPermissions);
        StringSelection clipboardSelection = new StringSelection(entry.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(clipboardSelection, clipboardSelection);
    }

    private static String getClipboardContentsAsString() throws IOException, UnsupportedFlavorException {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        return (String)transferable.getTransferData(DataFlavor.stringFlavor);
    }

    public static PolicyEntry getPolicyEntryFromClipboard() throws IOException, UnsupportedFlavorException, InvalidPolicyException {
        return PolicyEntry.fromString(PolicyEditorController.getClipboardContentsAsString());
    }

    public String getCodebaseFromClipboard() throws IOException, UnsupportedFlavorException, InvalidPolicyException {
        return PolicyEditorController.getPolicyEntryFromClipboard().getCodebase();
    }

    public Map<PolicyEditorPermissions, Boolean> getPermissionsFromClipboard() throws IOException, UnsupportedFlavorException, InvalidPolicyException {
        HashMap<PolicyEditorPermissions, Boolean> ret = new HashMap<PolicyEditorPermissions, Boolean>();
        Set<PolicyEditorPermissions> enabledPermissions = PolicyEditorController.getPolicyEntryFromClipboard().getPermissions();
        for (PolicyEditorPermissions permission : PolicyEditorPermissions.values()) {
            ret.put(permission, enabledPermissions.contains((Object)permission));
        }
        return ret;
    }

    public Set<CustomPermission> getCustomPermissionsFromClipboard() throws IOException, UnsupportedFlavorException, InvalidPolicyException {
        return PolicyEditorController.getPolicyEntryFromClipboard().getCustomPermissions();
    }
}

