/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.forceduser;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JToggleButton;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.zaproxy.zap.extension.forceduser.ContextForcedUserPanel;
import org.zaproxy.zap.extension.forceduser.ForcedUserAPI;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ContextDataFactory;
import org.zaproxy.zap.network.HttpSenderListener;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.Enableable;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.ContextPanelFactory;
import org.zaproxy.zap.view.ZapToggleButton;

public class ExtensionForcedUser
extends ExtensionAdaptor
implements ContextPanelFactory,
HttpSenderListener,
ContextDataFactory {
    private static final List<Class<? extends Extension>> EXTENSION_DEPENDENCIES;
    private static final String FORCED_USER_MODE_OFF_ICON_RESOURCE = "/resource/icon/16/forcedUserOff.png";
    private static final String FORCED_USER_MODE_ON_ICON_RESOURCE = "/resource/icon/16/forcedUserOn.png";
    private static final String BUTTON_LABEL_ON;
    private static final String BUTTON_LABEL_OFF;
    private static final String BUTTON_LABEL_DISABLED;
    private static final String MENU_ITEM_LABEL;
    public static final String NAME = "ExtensionForcedUser";
    private static final Logger log;
    private Map<Integer, ContextForcedUserPanel> contextPanelsMap = new HashMap<Integer, ContextForcedUserPanel>();
    private Map<Integer, User> contextForcedUsersMap = new HashMap<Integer, User>();
    private ExtensionUserManagement extensionUserManagement;
    private boolean forcedUserModeEnabled = false;
    private ZapToggleButton forcedUserModeButton;
    private JCheckBoxMenuItem forcedUserModeMenuItem;
    private ForcedUserAPI api;

    public ExtensionForcedUser() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(202);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("forcedUser.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addContextDataFactory(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addContextPanelFactory(this);
            extensionHook.getHookView().addMainToolBarComponent(this.getForcedUserModeToggleButton());
            extensionHook.getHookMenu().addEditMenuItem(extensionHook.getHookMenu().getMenuSeparator());
            extensionHook.getHookMenu().addEditMenuItem(this.getForcedUserModeMenuItem());
        }
        extensionHook.addHttpSenderListener(this);
        this.api = new ForcedUserAPI(this);
        extensionHook.addApiImplementor(this.api);
    }

    private void updateForcedUserModeToggleButtonEnabledState() {
        if (this.getView() != null) {
            this.forcedUserModeButton.setSelected(this.forcedUserModeEnabled);
            this.forcedUserModeMenuItem.setSelected(this.forcedUserModeEnabled);
            this.forcedUserModeMenuItem.setToolTipText(this.forcedUserModeEnabled ? BUTTON_LABEL_ON : BUTTON_LABEL_OFF);
        }
    }

    protected void setForcedUserModeEnabled(boolean forcedUserModeEnabled) {
        this.forcedUserModeEnabled = forcedUserModeEnabled;
        this.updateForcedUserModeToggleButtonEnabledState();
    }

    private void setForcedUserModeToggleButtonState(boolean enabled) {
        if (enabled) {
            this.updateForcedUserModeToggleButtonEnabledState();
            this.getForcedUserModeToggleButton().setEnabled(true);
            this.getForcedUserModeMenuItem().setEnabled(true);
        } else {
            this.forcedUserModeEnabled = false;
            this.getForcedUserModeToggleButton().setSelected(false);
            this.getForcedUserModeToggleButton().setEnabled(false);
            this.getForcedUserModeMenuItem().setSelected(false);
            this.getForcedUserModeMenuItem().setEnabled(false);
            this.getForcedUserModeMenuItem().setToolTipText(BUTTON_LABEL_DISABLED);
        }
    }

    private void updateForcedUserModeToggleButtonState() {
        if (this.contextForcedUsersMap.isEmpty()) {
            if (this.getForcedUserModeToggleButton().isEnabled()) {
                this.setForcedUserModeToggleButtonState(false);
            }
        } else if (!this.getForcedUserModeToggleButton().isEnabled()) {
            this.setForcedUserModeToggleButtonState(true);
        }
    }

    private JToggleButton getForcedUserModeToggleButton() {
        if (this.forcedUserModeButton == null) {
            this.forcedUserModeButton = new ZapToggleButton();
            this.forcedUserModeButton.setIcon(new ImageIcon(ExtensionForcedUser.class.getResource(FORCED_USER_MODE_OFF_ICON_RESOURCE)));
            this.forcedUserModeButton.setSelectedIcon(new ImageIcon(ExtensionForcedUser.class.getResource(FORCED_USER_MODE_ON_ICON_RESOURCE)));
            this.forcedUserModeButton.setToolTipText(BUTTON_LABEL_OFF);
            this.forcedUserModeButton.setSelectedToolTipText(BUTTON_LABEL_ON);
            this.forcedUserModeButton.setDisabledToolTipText(BUTTON_LABEL_DISABLED);
            this.forcedUserModeButton.setEnabled(false);
            this.forcedUserModeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExtensionForcedUser.this.setForcedUserModeEnabled(ExtensionForcedUser.this.getForcedUserModeToggleButton().isSelected());
                }
            });
        }
        return this.forcedUserModeButton;
    }

    private JCheckBoxMenuItem getForcedUserModeMenuItem() {
        if (this.forcedUserModeMenuItem == null) {
            this.forcedUserModeMenuItem = new JCheckBoxMenuItem(MENU_ITEM_LABEL);
            this.forcedUserModeMenuItem.setToolTipText(BUTTON_LABEL_DISABLED);
            this.forcedUserModeMenuItem.setEnabled(false);
            this.forcedUserModeMenuItem.addActionListener(e -> this.setForcedUserModeEnabled(this.forcedUserModeMenuItem.isSelected()));
        }
        return this.forcedUserModeMenuItem;
    }

    protected ExtensionUserManagement getUserManagementExtension() {
        if (this.extensionUserManagement == null) {
            this.extensionUserManagement = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
        }
        return this.extensionUserManagement;
    }

    public boolean isForcedUserModeEnabled() {
        return this.forcedUserModeEnabled;
    }

    public void setForcedUser(int contextId, User user) {
        if (user != null) {
            this.contextForcedUsersMap.put(contextId, user);
        } else {
            this.contextForcedUsersMap.remove(contextId);
        }
        this.updateForcedUserModeToggleButtonState();
    }

    public void setForcedUser(int contextId, int userId) throws IllegalStateException {
        User user = this.getUserManagementExtension().getContextUserAuthManager(contextId).getUserById(userId);
        if (user == null) {
            throw new IllegalStateException("No user matching the provided id was found.");
        }
        this.setForcedUser(contextId, user);
    }

    public User getForcedUser(int contextId) {
        return this.contextForcedUsersMap.get(contextId);
    }

    @Override
    public List<Class<? extends Extension>> getDependencies() {
        return EXTENSION_DEPENDENCIES;
    }

    @Override
    public AbstractContextPropertiesPanel getContextPanel(Context context) {
        ContextForcedUserPanel panel = this.contextPanelsMap.get(context.getId());
        if (panel == null) {
            panel = new ContextForcedUserPanel(this, context.getId());
            this.contextPanelsMap.put(context.getId(), panel);
        }
        return panel;
    }

    @Override
    public int getOrder() {
        return 67;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public void discardContexts() {
        this.contextForcedUsersMap.clear();
        this.contextPanelsMap.clear();
        this.updateForcedUserModeToggleButtonState();
    }

    @Override
    public void discardContext(Context ctx) {
        this.contextForcedUsersMap.remove(ctx.getId());
        this.contextPanelsMap.remove(ctx.getId());
        this.updateForcedUserModeToggleButtonState();
    }

    @Override
    public int getListenerOrder() {
        return 9998;
    }

    @Override
    public void onHttpRequestSend(HttpMessage msg, int initiator, HttpSender sender) {
        if (!this.forcedUserModeEnabled || msg.getRequestHeader().isImage() || initiator == 5 || initiator == 7) {
            return;
        }
        if (msg.getRequestingUser() != null) {
            return;
        }
        List<Context> contexts = Model.getSingleton().getSession().getContexts();
        Enableable requestingUser = null;
        for (Context context : contexts) {
            if (!context.isInContext(msg.getRequestHeader().getURI().toString()) || !this.contextForcedUsersMap.containsKey(context.getId())) continue;
            requestingUser = this.contextForcedUsersMap.get(context.getId());
            break;
        }
        if (requestingUser == null || !requestingUser.isEnabled()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Modifying request message (" + msg.getRequestHeader().getURI() + ") to match user: " + requestingUser));
        }
        msg.setRequestingUser((User)requestingUser);
    }

    @Override
    public void onHttpResponseReceive(HttpMessage msg, int initiator, HttpSender sender) {
    }

    @Override
    public void loadContextData(Session session, Context context) {
        try {
            List<String> forcedUserS = session.getContextDataStrings(context.getId(), 310);
            if (forcedUserS != null && forcedUserS.size() > 0) {
                int forcedUserId = Integer.parseInt(forcedUserS.get(0));
                this.setForcedUser(context.getId(), forcedUserId);
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to load forced user.", (Throwable)e);
        }
    }

    @Override
    public void persistContextData(Session session, Context context) {
        try {
            if (this.getForcedUser(context.getId()) != null) {
                session.setContextData(context.getId(), 310, Integer.toString(this.getForcedUser(context.getId()).getId()));
            } else {
                session.clearContextDataForType(context.getId(), 310);
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to persist forced user.", (Throwable)e);
        }
    }

    @Override
    public void exportContextData(Context ctx, Configuration config) {
        User user = this.getForcedUser(ctx.getId());
        if (user != null) {
            config.setProperty("context.forceduser", (Object)user.getId());
        } else {
            config.setProperty("context.forceduser", (Object)-1);
        }
    }

    @Override
    public void importContextData(Context ctx, Configuration config) {
        int id = config.getInt("context.forceduser");
        if (id >= 0) {
            this.setForcedUser(ctx.getId(), id);
        }
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    static {
        ArrayList<Class<ExtensionUserManagement>> dependencies = new ArrayList<Class<ExtensionUserManagement>>(1);
        dependencies.add(ExtensionUserManagement.class);
        EXTENSION_DEPENDENCIES = Collections.unmodifiableList(dependencies);
        BUTTON_LABEL_ON = Constant.messages.getString("forceduser.toolbar.button.on");
        BUTTON_LABEL_OFF = Constant.messages.getString("forceduser.toolbar.button.off");
        BUTTON_LABEL_DISABLED = Constant.messages.getString("forceduser.toolbar.button.disabled");
        MENU_ITEM_LABEL = Constant.messages.getString("forceduser.menuitem.label");
        log = Logger.getLogger(ExtensionForcedUser.class);
    }
}

