/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.LineNumberReader;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.map.ValuePool;

public class LineGroupReader {
    private static final String[] defaultContinuations = new String[]{" ", "*"};
    private static final String[] defaultIgnoredStarts = new String[]{"--"};
    static final String LS = System.getProperty("line.separator", "\n");
    LineNumberReader reader;
    String nextStartLine = null;
    int startLineNumber = 0;
    int nextStartLineNumber = 0;
    final String[] sectionContinuations;
    final String[] sectionStarts;
    final String[] ignoredStarts;

    public LineGroupReader(LineNumberReader lineNumberReader) {
        this.sectionContinuations = defaultContinuations;
        this.sectionStarts = ValuePool.emptyStringArray;
        this.ignoredStarts = defaultIgnoredStarts;
        this.reader = lineNumberReader;
        try {
            this.getSection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LineGroupReader(LineNumberReader lineNumberReader, String[] stringArray) {
        this.sectionStarts = stringArray;
        this.sectionContinuations = ValuePool.emptyStringArray;
        this.ignoredStarts = ValuePool.emptyStringArray;
        this.reader = lineNumberReader;
        try {
            this.getSection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HsqlArrayList getSection() {
        HsqlArrayList hsqlArrayList = new HsqlArrayList(new String[8], 0);
        if (this.nextStartLine != null) {
            hsqlArrayList.add(this.nextStartLine);
            this.startLineNumber = this.nextStartLineNumber;
        }
        while (true) {
            boolean bl = false;
            String string = null;
            try {
                string = this.reader.readLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null) {
                this.nextStartLine = null;
                return hsqlArrayList;
            }
            if ((string = string.substring(0, StringUtil.rightTrimSize(string))).length() == 0 || this.isIgnoredLine(string)) continue;
            if (this.isNewSectionLine(string)) {
                bl = true;
            }
            if (bl) {
                this.nextStartLine = string;
                this.nextStartLineNumber = this.reader.getLineNumber();
                return hsqlArrayList;
            }
            hsqlArrayList.add(string);
        }
    }

    public HashMappedList getAsMap() {
        HsqlArrayList hsqlArrayList;
        HashMappedList hashMappedList = new HashMappedList();
        while ((hsqlArrayList = this.getSection()).size() >= 1) {
            String string = (String)hsqlArrayList.get(0);
            String string2 = LineGroupReader.convertToString(hsqlArrayList, 1);
            hashMappedList.put(string, string2);
        }
        return hashMappedList;
    }

    private boolean isNewSectionLine(String string) {
        if (this.sectionStarts.length == 0) {
            for (int i = 0; i < this.sectionContinuations.length; ++i) {
                if (!string.startsWith(this.sectionContinuations[i])) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.sectionStarts.length; ++i) {
            if (!string.startsWith(this.sectionStarts[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isIgnoredLine(String string) {
        for (int i = 0; i < this.ignoredStarts.length; ++i) {
            if (!string.startsWith(this.ignoredStarts[i])) continue;
            return true;
        }
        return false;
    }

    public int getStartLineNumber() {
        return this.startLineNumber;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String convertToString(HsqlArrayList hsqlArrayList, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < hsqlArrayList.size(); ++i) {
            stringBuilder.append(hsqlArrayList.get(i)).append(LS);
        }
        return stringBuilder.toString();
    }
}

