/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.conf;

import com.mysql.cj.api.conf.PropertyDefinition;
import com.mysql.cj.api.conf.RuntimeProperty;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import java.io.Serializable;
import java.util.Properties;
import javax.naming.RefAddr;
import javax.naming.Reference;

public abstract class AbstractRuntimeProperty<T>
implements RuntimeProperty<T>,
Serializable {
    private static final long serialVersionUID = -3424722534876438236L;
    private PropertyDefinition<T> propertyDefinition;
    protected T valueAsObject;
    protected T initialValueAsObject;
    protected boolean wasExplicitlySet = false;

    public AbstractRuntimeProperty() {
    }

    protected AbstractRuntimeProperty(PropertyDefinition<T> propertyDefinition) {
        this.propertyDefinition = propertyDefinition;
        this.valueAsObject = this.getPropertyDefinition().getDefaultValue();
    }

    @Override
    public PropertyDefinition<T> getPropertyDefinition() {
        return this.propertyDefinition;
    }

    @Override
    public void initializeFrom(Properties extractFrom, ExceptionInterceptor exceptionInterceptor) {
        String extractedValue = extractFrom.getProperty(this.getPropertyDefinition().getName());
        extractFrom.remove(this.getPropertyDefinition().getName());
        this.initializeFrom(extractedValue, exceptionInterceptor);
    }

    @Override
    public void initializeFrom(Reference ref, ExceptionInterceptor exceptionInterceptor) {
        RefAddr refAddr = ref.get(this.getPropertyDefinition().getName());
        if (refAddr != null) {
            String refContentAsString = (String)refAddr.getContent();
            this.initializeFrom(refContentAsString, exceptionInterceptor);
        }
    }

    protected void initializeFrom(String extractedValue, ExceptionInterceptor exceptionInterceptor) {
        if (extractedValue != null) {
            this.setFromString(extractedValue, exceptionInterceptor);
        }
    }

    public void setFromString(String value, ExceptionInterceptor exceptionInterceptor) {
        this.valueAsObject = this.getPropertyDefinition().parseObject(value, exceptionInterceptor);
        this.wasExplicitlySet = true;
    }

    @Override
    public void resetValue() {
    }

    @Override
    public boolean isExplicitlySet() {
        return this.wasExplicitlySet;
    }
}

