/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIOtxen;
import oracle.jdbc.driver.T4CTTIOtxse;
import oracle.jdbc.driver.T4CTTIk2rpc;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;
import oracle.jdbc.xa.client.OracleXADataSource;
import oracle.jdbc.xa.client.OracleXAResource;

class T4CXAResource
extends OracleXAResource {
    T4CConnection physicalConn;
    int[] applicationValueArr = new int[1];
    boolean isTransLoose = false;
    byte[] context;
    int errorNumber;
    private String password;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    T4CXAResource(T4CConnection t4CConnection, OracleXAConnection oracleXAConnection, boolean bl) throws XAException {
        super(t4CConnection, oracleXAConnection);
        this.physicalConn = t4CConnection;
        this.isTransLoose = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doStart(Xid xid, int n2) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n3;
            block15: {
                int n4;
                n3 = -1;
                if (this.isTransLoose) {
                    n2 |= 0x10000;
                }
                if ((n4 = n2 & 0x8200000) == 0x8000000 && OracleXid.isLocalTransaction(xid)) {
                    return 0;
                }
                this.applicationValueArr[0] = 0;
                try {
                    try {
                        T4CTTIOtxse t4CTTIOtxse = this.physicalConn.otxse;
                        byte[] byArray = null;
                        byte[] byArray2 = xid.getGlobalTransactionId();
                        byte[] byArray3 = xid.getBranchQualifier();
                        int n5 = 0;
                        int n6 = 0;
                        if (byArray2 != null && byArray3 != null) {
                            n5 = Math.min(byArray2.length, 64);
                            n6 = Math.min(byArray3.length, 64);
                            byArray = new byte[128];
                            System.arraycopy(byArray2, 0, byArray, 0, n5);
                            System.arraycopy(byArray3, 0, byArray, n5, n6);
                        }
                        int n7 = 0;
                        n7 = (n2 & 0x200000) != 0 || (n2 & 0x8000000) != 0 ? (n7 |= 4) : (n7 |= 1);
                        if ((n2 & 0x100) != 0) {
                            n7 |= 0x100;
                        }
                        if ((n2 & 0x200) != 0) {
                            n7 |= 0x200;
                        }
                        if ((n2 & 0x400) != 0) {
                            n7 |= 0x400;
                        }
                        if ((n2 & 0x10000) != 0) {
                            n7 |= 0x10000;
                        }
                        this.physicalConn.needLine();
                        this.physicalConn.sendPiggyBackedMessages();
                        t4CTTIOtxse.doOTXSE(1, null, byArray, xid.getFormatId(), n5, n6, this.timeout, n7, this.applicationValueArr);
                        this.applicationValueArr[0] = t4CTTIOtxse.getApplicationValue();
                        byte[] byArray4 = t4CTTIOtxse.getContext();
                        if (byArray4 != null) {
                            this.context = byArray4;
                        }
                        n3 = 0;
                    }
                    catch (IOException iOException) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
                catch (SQLException sQLException) {
                    n3 = sQLException.getErrorCode();
                    if (n3 != 0) break block15;
                    throw new XAException(-6);
                }
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doEnd(Xid xid, int n2, boolean bl) throws XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n3;
            block13: {
                n3 = -1;
                try {
                    try {
                        T4CTTIOtxse t4CTTIOtxse = this.physicalConn.otxse;
                        byte[] byArray = null;
                        byte[] byArray2 = xid.getGlobalTransactionId();
                        byte[] byArray3 = xid.getBranchQualifier();
                        int n4 = 0;
                        int n5 = 0;
                        if (byArray2 != null && byArray3 != null) {
                            n4 = Math.min(byArray2.length, 64);
                            n5 = Math.min(byArray3.length, 64);
                            byArray = new byte[128];
                            System.arraycopy(byArray2, 0, byArray, 0, n4);
                            System.arraycopy(byArray3, 0, byArray, n4, n5);
                        }
                        if (this.context == null && (n3 = this.doStart(xid, 0x8000000)) != 0) {
                            return n3;
                        }
                        byte[] byArray4 = this.context;
                        int n6 = 0;
                        if ((n2 & 2) == 2) {
                            n6 = 0x100000;
                        } else if ((n2 & 0x2000000) == 0x2000000 && (n2 & 0x100000) != 0x100000) {
                            n6 = 0x100000;
                        }
                        this.applicationValueArr[0] = this.applicationValueArr[0] >> 16;
                        this.physicalConn.needLine();
                        this.physicalConn.sendPiggyBackedMessages();
                        t4CTTIOtxse.doOTXSE(2, byArray4, byArray, xid.getFormatId(), n4, n5, this.timeout, n6, this.applicationValueArr);
                        this.applicationValueArr[0] = t4CTTIOtxse.getApplicationValue();
                        byte[] byArray5 = t4CTTIOtxse.getContext();
                        if (byArray5 != null) {
                            this.context = byArray5;
                        }
                        n3 = 0;
                    }
                    catch (IOException iOException) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
                catch (SQLException sQLException) {
                    n3 = sQLException.getErrorCode();
                    if (n3 != 0) break block13;
                    throw new XAException(-6);
                }
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCommit(Xid xid, boolean bl) throws SQLException, XAException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n2 = bl ? 4 : 2;
            try {
                int n3 = this.doTransaction(xid, 1, n2);
                if ((!bl || n3 != 2 && n3 != 4) && (bl || n3 != 5)) {
                    if (n3 == 8) {
                        throw new XAException(106);
                    }
                    throw new XAException(-6);
                }
            }
            catch (SQLException sQLException) {
                int n4 = sQLException.getErrorCode();
                if (n4 == 24756) {
                    this.kputxrec(xid, 1, this.timeout + 120, sQLException);
                }
                if (n4 == 24780) {
                    OracleXADataSource oracleXADataSource = null;
                    PooledConnection pooledConnection = null;
                    try {
                        oracleXADataSource = new OracleXADataSource();
                        oracleXADataSource.setURL(this.physicalConn.url);
                        oracleXADataSource.setUser(this.physicalConn.userName);
                        this.physicalConn.getPasswordInternal(this);
                        oracleXADataSource.setPassword(this.password);
                        pooledConnection = oracleXADataSource.getXAConnection();
                        XAResource xAResource = pooledConnection.getXAResource();
                        xAResource.commit(xid, bl);
                    }
                    catch (SQLException sQLException2) {
                        XAException xAException = new XAException(-6);
                        xAException.initCause(sQLException2);
                        throw xAException;
                    }
                    finally {
                        try {
                            if (pooledConnection != null) {
                                pooledConnection.close();
                            }
                            if (oracleXADataSource != null) {
                                oracleXADataSource.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
                throw sQLException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doPrepare(Xid xid) throws XAException, SQLException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n2;
            block10: {
                n2 = -1;
                try {
                    int n3 = this.doTransaction(xid, 3, 0);
                    if (n3 == 8) {
                        throw new XAException(106);
                    }
                    if (n3 == 4) {
                        n2 = 3;
                        break block10;
                    }
                    if (n3 == 1) {
                        n2 = 0;
                        break block10;
                    }
                    if (n3 == 3) {
                        throw new XAException(100);
                    }
                    throw new XAException(-6);
                }
                catch (SQLException sQLException) {
                    int n4 = sQLException.getErrorCode();
                    if (n4 == 25351) {
                        XAException xAException = new XAException(-6);
                        xAException.initCause(sQLException);
                        throw xAException;
                    }
                    throw sQLException;
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doForget(Xid xid) throws XAException, SQLException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            int n2 = 0;
            if (OracleXid.isLocalTransaction(xid)) {
                return 24771;
            }
            int n3 = this.doStart(xid, 0x8000000);
            if (n3 != 24756) {
                if (n3 == 0) {
                    try {
                        this.doEnd(xid, 0, false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (n3 == 0 || n3 == 2079 || n3 == 24754 || n3 == 24761 || n3 == 24774 || n3 == 24776 || n3 == 25351) {
                    return 24769;
                }
                if (n3 == 24752) {
                    return 24771;
                }
                return n3;
            }
            this.kputxrec(xid, 4, 1, null);
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRollback(Xid xid) throws XAException, SQLException {
        T4CConnection t4CConnection = this.physicalConn;
        synchronized (t4CConnection) {
            block20: {
                try {
                    int n2 = this.doTransaction(xid, 2, 3);
                    if (n2 == 8) {
                        throw new XAException(106);
                    }
                    if (n2 != 3) {
                        throw new XAException(-6);
                    }
                }
                catch (SQLException sQLException) {
                    int n3 = sQLException.getErrorCode();
                    if (n3 == 24756) {
                        this.kputxrec(xid, 2, this.timeout + 120, sQLException);
                    }
                    if (n3 == 24780) {
                        OracleXADataSource oracleXADataSource = null;
                        PooledConnection pooledConnection = null;
                        try {
                            oracleXADataSource = new OracleXADataSource();
                            oracleXADataSource.setURL(this.physicalConn.url);
                            oracleXADataSource.setUser(this.physicalConn.userName);
                            this.physicalConn.getPasswordInternal(this);
                            oracleXADataSource.setPassword(this.password);
                            pooledConnection = oracleXADataSource.getXAConnection();
                            XAResource xAResource = pooledConnection.getXAResource();
                            xAResource.rollback(xid);
                        }
                        catch (SQLException sQLException2) {
                            XAException xAException = new XAException(-6);
                            xAException.initCause(sQLException2);
                            throw xAException;
                        }
                        finally {
                            try {
                                if (pooledConnection != null) {
                                    pooledConnection.close();
                                }
                                if (oracleXADataSource != null) {
                                    oracleXADataSource.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (n3 == 25402) break block20;
                    throw sQLException;
                }
            }
        }
    }

    int doTransaction(Xid xid, int n2, int n3) throws SQLException {
        int n4 = -1;
        try {
            T4CTTIOtxen t4CTTIOtxen = this.physicalConn.otxen;
            byte[] byArray = null;
            byte[] byArray2 = xid.getGlobalTransactionId();
            byte[] byArray3 = xid.getBranchQualifier();
            int n5 = 0;
            int n6 = 0;
            if (byArray2 != null && byArray3 != null) {
                n5 = Math.min(byArray2.length, 64);
                n6 = Math.min(byArray3.length, 64);
                byArray = new byte[128];
                System.arraycopy(byArray2, 0, byArray, 0, n5);
                System.arraycopy(byArray3, 0, byArray, n5, n6);
            }
            byte[] byArray4 = this.context;
            this.physicalConn.needLine();
            this.physicalConn.sendPiggyBackedMessages();
            t4CTTIOtxen.doOTXEN(n2, byArray4, byArray, xid.getFormatId(), n5, n6, this.timeout, n3, 0);
            n4 = t4CTTIOtxen.getOutStateFromServer();
        }
        catch (IOException iOException) {
            this.physicalConn.handleIOException(iOException);
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return n4;
    }

    protected void kputxrec(Xid xid, int n2, int n3, SQLException sQLException) throws XAException, SQLException {
        int n4;
        int n5;
        switch (n2) {
            case 1: {
                n5 = 3;
                break;
            }
            case 4: {
                n5 = 2;
                break;
            }
            default: {
                n5 = 0;
            }
        }
        int n6 = 0;
        while (n3-- > 0 && (n6 = this.doTransaction(xid, 5, n5)) == 7) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (n6 == 7) {
            throw new XAException(-6);
        }
        int n7 = -1;
        switch (n6) {
            case 3: {
                if (n2 == 1) {
                    n4 = 7;
                    break;
                }
                n4 = 8;
                n7 = -3;
                break;
            }
            case 0: {
                if (n2 == 4) {
                    n4 = 8;
                    n7 = -3;
                    break;
                }
                n4 = 7;
                if (n2 != 1) break;
                n7 = -4;
                break;
            }
            case 2: {
                if (n2 == 4) {
                    n4 = 8;
                    n7 = -6;
                    break;
                }
            }
            case 5: {
                if (n2 == 4) {
                    n4 = 7;
                    break;
                }
                n7 = 7;
                n4 = 8;
                break;
            }
            case 4: {
                if (n2 == 4) {
                    n4 = 7;
                    break;
                }
                n7 = 6;
                n4 = 8;
                break;
            }
            case 6: {
                if (n2 == 4) {
                    n4 = 7;
                    break;
                }
                n7 = 5;
                n4 = 8;
                break;
            }
            default: {
                n7 = -3;
                n4 = 8;
            }
        }
        T4CTTIk2rpc t4CTTIk2rpc = this.physicalConn.k2rpc;
        try {
            t4CTTIk2rpc.doOK2RPC(3, n4);
        }
        catch (IOException iOException) {
            XAException xAException = new XAException(-7);
            xAException.initCause(iOException);
            throw xAException;
        }
        catch (SQLException sQLException2) {
            XAException xAException = new XAException(-6);
            xAException.initCause(sQLException2);
            throw xAException;
        }
        if (n7 != -1) {
            OracleXAException oracleXAException = null;
            if (sQLException != null) {
                oracleXAException = new OracleXAException(sQLException.getErrorCode(), n7);
                oracleXAException.initCause(sQLException);
            } else {
                oracleXAException = new OracleXAException(0, n7);
            }
            throw oracleXAException;
        }
    }

    final void setPasswordInternal(String string) {
        this.password = string;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.physicalConn;
    }
}

