/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.CoreUserSettings;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContext;
import ca.sqlpower.architect.swingui.FormLayout;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.SPSUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class PreferencesPanel
extends JPanel
implements DataEntryPanel {
    private CoreUserSettings us;
    private JTextField plIniName;
    private JButton plIniButton;
    private JTextField etlLogFileName;
    private JButton etlLogFileButton;
    private JTextField ddlLogFileName;
    private JButton ddlLogFileButton;
    private JRadioButton playPenAntialiasOn;
    private JRadioButton playPenAntialiasOff;
    private JRadioButton exceptionReportOn;
    private JRadioButton exceptionReportOff;
    private JRadioButton showWelcomeOn;
    private JRadioButton showWelcomeOff;
    private JRadioButton updateCheckOn;
    private JRadioButton updateCheckOff;
    private final ArchitectSwingSessionContext context;

    public PreferencesPanel(ArchitectSwingSessionContext context) {
        this.context = context;
        this.us = context.getUserSettings();
        this.setup();
        this.revertToUserSettings();
    }

    public void setup() {
        this.setLayout(new FormLayout(5, 5));
        this.add(new JLabel(Messages.getString("PreferencesPanel.plDotIniFileLabel")));
        JPanel plIniPanel = new JPanel();
        plIniPanel.setLayout(new BorderLayout());
        this.plIniName = new JTextField("", 35);
        plIniPanel.add((Component)this.plIniName, "West");
        this.plIniButton = new JButton();
        plIniPanel.add((Component)this.plIniButton, "East");
        this.plIniButton.setAction(new ChooseFileAction(this.plIniName, SPSUtils.INI_FILE_FILTER, Messages.getString("PreferencesPanel.browseButton")));
        this.add(plIniPanel);
        this.add(new JLabel(Messages.getString("PreferencesPanel.etlLogFileLabel")));
        JPanel etlLogFilePanel = new JPanel();
        etlLogFilePanel.setLayout(new BorderLayout());
        this.etlLogFileName = new JTextField("", 35);
        etlLogFilePanel.add((Component)this.etlLogFileName, "West");
        this.etlLogFileButton = new JButton();
        etlLogFilePanel.add((Component)this.etlLogFileButton, "East");
        this.etlLogFileButton.setAction(new ChooseFileAction(this.etlLogFileName, SPSUtils.LOG_FILE_FILTER, Messages.getString("PreferencesPanel.browseButton")));
        this.add(etlLogFilePanel);
        this.add(new JLabel(Messages.getString("PreferencesPanel.forwardEngineeringLogFileLabel")));
        JPanel ddlLogFilePanel = new JPanel();
        ddlLogFilePanel.setLayout(new BorderLayout());
        this.ddlLogFileName = new JTextField("", 35);
        ddlLogFilePanel.add((Component)this.ddlLogFileName, "West");
        this.ddlLogFileButton = new JButton();
        ddlLogFilePanel.add((Component)this.ddlLogFileButton, "East");
        this.ddlLogFileButton.setAction(new ChooseFileAction(this.ddlLogFileName, SPSUtils.LOG_FILE_FILTER, Messages.getString("PreferencesPanel.browseButton")));
        this.add(ddlLogFilePanel);
        this.add(new JLabel(Messages.getString("PreferencesPanel.playpenAntialiasingLabel")));
        JPanel playPenAntialiasPanel = new JPanel();
        playPenAntialiasPanel.setLayout(new FlowLayout());
        ButtonGroup playPenAntialiasGroup = new ButtonGroup();
        this.playPenAntialiasOn = new JRadioButton(Messages.getString("PreferencesPanel.onOption"));
        playPenAntialiasGroup.add(this.playPenAntialiasOn);
        this.playPenAntialiasOff = new JRadioButton(Messages.getString("PreferencesPanel.offOption"));
        playPenAntialiasGroup.add(this.playPenAntialiasOff);
        playPenAntialiasPanel.add(this.playPenAntialiasOn);
        playPenAntialiasPanel.add(this.playPenAntialiasOff);
        this.add(playPenAntialiasPanel);
        this.add(new JLabel(Messages.getString("PreferencesPanel.errorReportingLabel")));
        JPanel exceptionReportPanel = new JPanel();
        exceptionReportPanel.setLayout(new FlowLayout());
        ButtonGroup exceptionReportGroup = new ButtonGroup();
        this.exceptionReportOn = new JRadioButton(Messages.getString("PreferencesPanel.onOption"));
        exceptionReportGroup.add(this.exceptionReportOn);
        this.exceptionReportOff = new JRadioButton(Messages.getString("PreferencesPanel.offOption"));
        exceptionReportGroup.add(this.exceptionReportOff);
        exceptionReportPanel.add(this.exceptionReportOn);
        exceptionReportPanel.add(this.exceptionReportOff);
        this.add(exceptionReportPanel);
        this.add(new JLabel(Messages.getString("PreferencesPanel.showWelcomScreenLabel")));
        JPanel showWelcomePanel = new JPanel();
        showWelcomePanel.setLayout(new FlowLayout());
        ButtonGroup showWelcomeGroup = new ButtonGroup();
        this.showWelcomeOn = new JRadioButton(Messages.getString("PreferencesPanel.yesOption"));
        showWelcomeGroup.add(this.showWelcomeOn);
        this.showWelcomeOff = new JRadioButton(Messages.getString("PreferencesPanel.noOption"));
        showWelcomeGroup.add(this.showWelcomeOff);
        showWelcomePanel.add(this.showWelcomeOn);
        showWelcomePanel.add(this.showWelcomeOff);
        this.add(showWelcomePanel);
        this.add(new JLabel(Messages.getString("PreferencesPanel.checkForUpdates")));
        JPanel checkUpdatesPanel = new JPanel();
        checkUpdatesPanel.setLayout(new FlowLayout());
        ButtonGroup checkUpdatesGroup = new ButtonGroup();
        this.updateCheckOn = new JRadioButton(Messages.getString("PreferencesPanel.onOption"));
        checkUpdatesGroup.add(this.updateCheckOn);
        this.updateCheckOff = new JRadioButton(Messages.getString("PreferencesPanel.offOption"));
        checkUpdatesGroup.add(this.updateCheckOff);
        checkUpdatesPanel.add(this.updateCheckOn);
        checkUpdatesPanel.add(this.updateCheckOff);
        this.add(checkUpdatesPanel);
    }

    protected void revertToUserSettings() {
        this.plIniName.setText(this.context.getPlDotIniPath());
        this.etlLogFileName.setText(this.us.getETLUserSettings().getString("ETLUserSettings.PROP_ETL_LOG_PATH", ""));
        this.ddlLogFileName.setText(this.us.getDDLUserSettings().getString("DDLUserSettings.PROP_DDL_LOG_PATH", ""));
        if (this.us.getSwingSettings().getBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", false)) {
            this.playPenAntialiasOn.setSelected(true);
        } else {
            this.playPenAntialiasOff.setSelected(true);
        }
        if (this.us.getSwingSettings().getBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", true)) {
            this.showWelcomeOn.setSelected(true);
        } else {
            this.showWelcomeOff.setSelected(true);
        }
        if (this.us.getQfaUserSettings().getBoolean("QFAUserSettings.EXCEPTION_REPORTING", true)) {
            this.exceptionReportOn.setSelected(true);
        } else {
            this.exceptionReportOff.setSelected(true);
        }
        if (this.us.getUpdateCheckSettings().getBoolean("UpdateCheckSettings.AUTO_UPDATE_CHECK", true)) {
            this.updateCheckOn.setSelected(true);
        } else {
            this.updateCheckOff.setSelected(true);
        }
    }

    public boolean applyChanges() {
        this.context.setPlDotIniPath(this.plIniName.getText());
        this.us.getETLUserSettings().setString("ETLUserSettings.PROP_ETL_LOG_PATH", this.etlLogFileName.getText());
        this.us.getDDLUserSettings().setString("DDLUserSettings.PROP_DDL_LOG_PATH", this.ddlLogFileName.getText());
        this.us.getSwingSettings().setBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", this.playPenAntialiasOn.isSelected());
        this.us.getSwingSettings().setBoolean("SwingUserSettings.SHOW_WELCOMESCREEN", this.showWelcomeOn.isSelected());
        this.us.getQfaUserSettings().setBoolean("QFAUserSettings.EXCEPTION_REPORTING", this.exceptionReportOn.isSelected());
        this.us.getUpdateCheckSettings().setBoolean("UpdateCheckSettings.AUTO_UPDATE_CHECK", this.updateCheckOn.isSelected());
        for (ArchitectSession session : this.context.getSessions()) {
            ((ArchitectSwingSession)session).getPlayPen().setRenderingAntialiased(this.playPenAntialiasOn.isSelected());
        }
        return true;
    }

    public void discardChanges() {
        this.revertToUserSettings();
    }

    public JPanel getPanel() {
        return this;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    protected class ChooseFileAction
    extends AbstractAction {
        JTextField fileName;
        FileFilter filter;

        public ChooseFileAction(JTextField fileName, FileFilter filter, String buttonText) {
            super(buttonText);
            this.fileName = fileName;
            this.filter = filter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File initialLocation;
            JFileChooser fc = new JFileChooser();
            if (this.fileName.getText() != null && this.fileName.getText().length() > 0 && (initialLocation = new File(this.fileName.getText())).exists()) {
                fc.setCurrentDirectory(initialLocation);
            }
            fc.addChoosableFileFilter(this.filter);
            int returnVal = fc.showOpenDialog(PreferencesPanel.this);
            if (returnVal == 0) {
                this.fileName.setText(fc.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

