/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLStatement;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.ProgressWatcher;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.SPSwingWorker;
import ca.sqlpower.swingui.SwingWorkerRegistry;
import ca.sqlpower.util.Monitorable;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.apache.log4j.Logger;

public class SQLScriptDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(SQLScriptDialog.class);
    private List<DDLStatement> statements;
    private JProgressBar progressBar = new JProgressBar();
    private Component parent;
    private String header;
    private JLabel statusLabel;
    private JDBCDataSource targetDataSource;
    private JTextPane sqlScriptArea;
    private AbstractDocument sqlDoc;
    private boolean closeParent;
    private ArchitectSwingSession session;
    private SPSwingWorker executeTask;
    private JButton executeButton;

    public SQLScriptDialog(Dialog owner, String title, String header, boolean modal, DDLGenerator gen, JDBCDataSource targetDataSource, boolean closeParent, ArchitectSwingSession session) throws HeadlessException {
        super(owner, title, modal);
        if (modal && owner == null) {
            JOptionPane.showMessageDialog(null, "Debug: This action tried to create a null-parented modal dialog");
        }
        this.statusLabel = new JLabel();
        this.parent = owner;
        this.header = header;
        this.statements = gen.getDdlStatements();
        this.targetDataSource = targetDataSource;
        this.closeParent = closeParent;
        this.session = session;
        this.executeTask = new ExecuteSQLScriptWorker(session);
        logger.info((Object)("The list size is :" + this.statements.size()));
        this.add(this.buildPanel());
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    private JPanel buildPanel() {
        FormLayout sqlLayout = new FormLayout("4dlu, min:grow, 4dlu", "pref, 4dlu, pref, 6dlu, fill:300dlu:grow,6dlu, pref, 6dlu, pref");
        CellConstraints cc = new CellConstraints();
        this.sqlDoc = new DefaultStyledDocument();
        SimpleAttributeSet att = new SimpleAttributeSet();
        StyleConstants.setForeground(att, Color.black);
        for (DDLStatement ddl : this.statements) {
            try {
                this.sqlDoc.insertString(this.sqlDoc.getLength(), ddl.getSQLText() + ddl.getSqlTerminator(), att);
            }
            catch (BadLocationException e) {
                ASUtils.showExceptionDialogNoReport(this.parent, Messages.getString("SQLScriptDialog.couldNotCreateDocument"), e);
                logger.error((Object)"Could not create document for results", (Throwable)e);
            }
        }
        this.sqlScriptArea = new JTextPane();
        this.sqlScriptArea.setMargin(new Insets(6, 10, 4, 6));
        this.sqlScriptArea.setDocument(this.sqlDoc);
        this.sqlScriptArea.setEditable(false);
        this.sqlScriptArea.setAutoscrolls(true);
        JScrollPane sp = new JScrollPane(this.sqlScriptArea);
        CopyAction copy = new CopyAction(this.sqlDoc);
        AbstractAction execute = null;
        execute = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SQLScriptDialog.this.targetDataSource.get("UID") != null) {
                    new Thread((Runnable)SQLScriptDialog.this.executeTask).start();
                    ProgressWatcher.watchProgress((JProgressBar)SQLScriptDialog.this.progressBar, (Monitorable)SQLScriptDialog.this.executeTask, (JLabel)SQLScriptDialog.this.statusLabel);
                } else {
                    JOptionPane.showMessageDialog(SQLScriptDialog.this, Messages.getString("SQLScriptDialog.noTargetDb"), Messages.getString("SQLScriptDialog.couldNotExecuteDialogTitle"), 0);
                }
            }
        };
        AbstractAction save = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logger.info((Object)("SQL_FILE_FILTER:" + ((SPSUtils.FileExtensionFilter)SPSUtils.SQL_FILE_FILTER).toString()));
                SPSUtils.saveDocument((Component)SQLScriptDialog.this.parent, (Document)SQLScriptDialog.this.sqlDoc, (SPSUtils.FileExtensionFilter)((SPSUtils.FileExtensionFilter)SPSUtils.SQL_FILE_FILTER));
            }
        };
        CloseAction close = new CloseAction();
        close.setWhatToClose(this);
        SPSUtils.makeJDialogCancellable((Window)this, (Action)close);
        ButtonBarBuilder barBuilder = new ButtonBarBuilder();
        JButton copyButton = new JButton(copy);
        copyButton.setText(Messages.getString("SQLScriptDialog.copyOption"));
        barBuilder.addGridded((JComponent)copyButton);
        barBuilder.addRelatedGap();
        barBuilder.addGlue();
        this.executeButton = new JButton(execute);
        this.executeButton.setText(Messages.getString("SQLScriptDialog.executeOption"));
        barBuilder.addGridded((JComponent)this.executeButton);
        barBuilder.addRelatedGap();
        barBuilder.addGlue();
        JButton saveButton = new JButton(save);
        saveButton.setText(Messages.getString("SQLScriptDialog.saveOption"));
        barBuilder.addGridded((JComponent)saveButton);
        barBuilder.addRelatedGap();
        barBuilder.addGlue();
        this.addWindowListener(new CloseWindowAction());
        JButton closeButton = new JButton(close);
        closeButton.setText(Messages.getString("SQLScriptDialog.closeOption"));
        barBuilder.addGridded((JComponent)closeButton);
        this.getRootPane().setDefaultButton(this.executeButton);
        Object panel = logger.isDebugEnabled() ? new FormDebugPanel(sqlLayout) : new JPanel((LayoutManager)sqlLayout);
        PanelBuilder pb = new PanelBuilder(sqlLayout, (JPanel)panel);
        pb.setDefaultDialogBorder();
        pb.add((Component)new JLabel(this.header), cc.xy(2, 1));
        if (this.targetDataSource != null && this.targetDataSource.get("UID") != null) {
            pb.add((Component)new JLabel(Messages.getString("SQLScriptDialog.yourTargetDbIs") + this.targetDataSource.getName()), cc.xy(2, 3));
            this.executeButton.setEnabled(true);
        } else {
            pb.add((Component)new JLabel(Messages.getString("SQLScriptDialog.yourTargetDbIsNotConfigured")), cc.xy(2, 3));
            this.executeButton.setEnabled(false);
        }
        pb.add((Component)sp, cc.xy(2, 5));
        pb.add((Component)barBuilder.getPanel(), cc.xy(2, 7, "c,c"));
        pb.add((Component)this.progressBar, cc.xy(2, 9));
        return pb.getPanel();
    }

    public SPSwingWorker getExecuteTask() {
        return this.executeTask;
    }

    public void setExecuteTask(SPSwingWorker v) {
        this.executeTask = v;
    }

    private class ExecuteSQLScriptWorker
    extends SPSwingWorker {
        private int stmtsCompleted;

        public ExecuteSQLScriptWorker(ArchitectSwingSession session) {
            super((SwingWorkerRegistry)session);
            this.stmtsCompleted = 0;
            this.setMessage(null);
            if (SQLScriptDialog.this.statements != null) {
                this.setJobSize(new Integer(SQLScriptDialog.this.statements.size()));
            } else {
                this.setJobSize(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void doStuff() {
            block35: {
                Statement stmt;
                Connection con;
                this.setCancelled(false);
                if (this.isCancelled() || this.isFinished()) {
                    return;
                }
                SQLDatabase target = new SQLDatabase(SQLScriptDialog.this.targetDataSource);
                SQLScriptDialog.this.statusLabel.setText(Messages.getString("SQLScriptDialog.creatingObjectsInTargetDb") + target.getDataSource());
                this.setProgress(0);
                this.stmtsCompleted = 0;
                logger.debug((Object)("the Target Database is: " + target.getDataSource()));
                try {
                    con = target.getConnection();
                }
                catch (SQLObjectException ex) {
                    this.setFinished(true);
                    throw new RuntimeException(Messages.getString("SQLScriptDialog.couldNotConnectToTargetDb", ex.getMessage()), ex);
                }
                catch (Exception ex) {
                    this.setFinished(true);
                    logger.error((Object)"Unexpected exception in DDL generation", (Throwable)ex);
                    throw new RuntimeException(Messages.getString("SQLScriptDialog.specifyATargetDb"));
                }
                try {
                    logger.debug((Object)("the connection thinks it is: " + con.getMetaData().getURL()));
                    stmt = con.createStatement();
                }
                catch (SQLException ex) {
                    this.setFinished(true);
                    throw new RuntimeException(Messages.getString("SQLScriptDialog.couldNotGenerateDDL", ex.getMessage()));
                }
                logger.info((Object)("Starting DDL Generation at " + new Date(System.currentTimeMillis())));
                logger.info((Object)("Database Target: " + target.getDataSource()));
                logger.info((Object)("Playpen Dump: " + target.getDataSource()));
                SQLScriptDialog.this.executeButton.setEnabled(false);
                Iterator it = SQLScriptDialog.this.statements.iterator();
                while (it.hasNext() && !this.isFinished() && !this.isCancelled()) {
                    DDLStatement ddlStmt = (DDLStatement)((Object)it.next());
                    try {
                        this.increaseProgress();
                        logger.info((Object)("executing: " + ddlStmt.getSQLText()));
                        stmt.executeUpdate(ddlStmt.getSQLText());
                        ++this.stmtsCompleted;
                    }
                    catch (SQLException ex) {
                        final String fsql = ddlStmt.getSQLText() == null ? null : ddlStmt.getSQLText().trim();
                        logger.info((Object)("sql statement failed: " + ex.getMessage()));
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    JTextArea jta = new JTextArea(fsql);
                                    jta.setOpaque(false);
                                    jta.setEditable(false);
                                    JPanel jp = new JPanel(new BorderLayout(0, 10));
                                    jp.add((Component)new JLabel(Messages.getString("SQLScriptDialog.sqlStatementFailed", ex.getMessage())), "North");
                                    jp.add((Component)jta, "Center");
                                    jp.add((Component)new JLabel(Messages.getString("SQLScriptDialog.continuePrompt")), "South");
                                    int decision = JOptionPane.showConfirmDialog(SQLScriptDialog.this, jp, Messages.getString("SQLScriptDialog.sqlFailure"), 0);
                                    if (decision == 1) {
                                        logger.info((Object)"Export cancelled by user.");
                                        ExecuteSQLScriptWorker.this.cancelJob();
                                    }
                                }
                            });
                        }
                        catch (InterruptedException ex2) {
                            logger.warn((Object)"DDL Worker was interrupted during InvokeAndWait", (Throwable)ex2);
                        }
                        catch (InvocationTargetException ex2) {
                            throw new RuntimeException(ex2);
                        }
                        if (!this.isCancelled()) continue;
                        this.setFinished(true);
                    }
                }
                String resultsMessage = this.stmtsCompleted == 0 ? Messages.getString("SQLScriptDialog.didNotExecute", String.valueOf(this.getProgress())) : Messages.getString("SQLScriptDialog.successfullyExecuted", String.valueOf(this.stmtsCompleted), String.valueOf(this.getProgress()));
                logger.info((Object)resultsMessage);
                JOptionPane.showMessageDialog(SQLScriptDialog.this, resultsMessage);
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"SQLException while closing statement", (Throwable)ex);
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)"Couldn't close connection", (Throwable)ex);
                }
                SQLScriptDialog.this.executeButton.setEnabled(true);
                break block35;
                catch (Exception exc) {
                    try {
                        logger.info((Object)("Caught Unexpected Exception " + exc));
                        ASUtils.showExceptionDialog(SQLScriptDialog.this.session, Messages.getString("SQLScriptDialog.couldNotFinishSQL"), exc);
                        resultsMessage = this.stmtsCompleted == 0 ? Messages.getString("SQLScriptDialog.didNotExecute", String.valueOf(this.getProgress())) : Messages.getString("SQLScriptDialog.successfullyExecuted", String.valueOf(this.stmtsCompleted), String.valueOf(this.getProgress()));
                    }
                    catch (Throwable throwable) {
                        String resultsMessage2 = this.stmtsCompleted == 0 ? Messages.getString("SQLScriptDialog.didNotExecute", String.valueOf(this.getProgress())) : Messages.getString("SQLScriptDialog.successfullyExecuted", String.valueOf(this.stmtsCompleted), String.valueOf(this.getProgress()));
                        logger.info((Object)resultsMessage2);
                        JOptionPane.showMessageDialog(SQLScriptDialog.this, resultsMessage2);
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (SQLException ex) {
                            logger.error((Object)"SQLException while closing statement", (Throwable)ex);
                        }
                        try {
                            if (con != null) {
                                con.close();
                            }
                        }
                        catch (SQLException ex) {
                            logger.error((Object)"Couldn't close connection", (Throwable)ex);
                        }
                        SQLScriptDialog.this.executeButton.setEnabled(true);
                        throw throwable;
                    }
                    logger.info((Object)resultsMessage);
                    JOptionPane.showMessageDialog(SQLScriptDialog.this, resultsMessage);
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"SQLException while closing statement", (Throwable)ex);
                    }
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (SQLException ex) {
                        logger.error((Object)"Couldn't close connection", (Throwable)ex);
                    }
                    SQLScriptDialog.this.executeButton.setEnabled(true);
                }
            }
        }

        public void cleanup() {
        }

        public void cancelJob() {
            this.setCancelled(true);
            this.setFinished(true);
        }
    }

    private class CloseAction
    extends AbstractAction {
        Component c;

        private CloseAction() {
        }

        public void setWhatToClose(Component c) {
            this.c = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.c.setVisible(false);
            if (SQLScriptDialog.this.closeParent) {
                SQLScriptDialog.this.parent.setVisible(false);
            }
        }
    }

    private class CloseWindowAction
    extends WindowAdapter {
        private CloseWindowAction() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (SQLScriptDialog.this.closeParent) {
                SQLScriptDialog.this.parent.setVisible(false);
            }
        }
    }

    private class CopyAction
    extends AbstractAction {
        AbstractDocument doc;

        public CopyAction(AbstractDocument doc) {
            this.doc = doc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                StringSelection selection = new StringSelection(this.doc.getText(0, this.doc.getLength()));
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
            }
            catch (BadLocationException e1) {
                logger.debug((Object)("Unable to get the text for copying" + e1));
            }
        }
    }
}

