/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.sound;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class OggVorbisDecoderFactory {
    public AudioInputStream getOggStream(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        return new OggVorbisAudioInputStream(new OggStream(fis));
    }

    private static class OggVorbisAudioInputStream
    extends AudioInputStream {
        private OggStream os = null;

        public OggVorbisAudioInputStream(OggStream os) throws IOException {
            super(os, os.getFormat(), -1L);
            this.os = os;
        }

        @Override
        public AudioFormat getFormat() {
            return this.os.getFormat();
        }

        @Override
        public int available() {
            return this.os.available();
        }

        @Override
        public int read() throws IOException {
            return this.os.read();
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.os.read(buf);
        }

        public int read(byte[] buf, int n) throws IOException {
            return this.os.read(buf, n);
        }

        @Override
        public void close() {
            this.os.close();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.os.skip(n);
        }

        @Override
        public void mark(int readLimit) {
            this.os.mark(readLimit);
        }

        @Override
        public boolean markSupported() {
            return this.os.markSupported();
        }

        @Override
        public void reset() {
            this.os.reset();
        }
    }

    private static class OggStream
    extends InputStream {
        private static final String EOS = "End-of-stream";
        private static final int BUFSIZ = 4096;
        private final Packet oggPacket = new Packet();
        private final Page oggPage = new Page();
        private final StreamState oggStreamState = new StreamState();
        private final SyncState oggSyncState = new SyncState();
        private final DspState orbisDspState = new DspState();
        private final Block orbisBlock = new Block(this.orbisDspState);
        private final Comment orbisComment = new Comment();
        private final Info orbisInfo = new Info();
        private final AudioFormat audioFormat;
        private final byte[] convBuf = new byte[4096];
        private int bufCount = 0;
        private int offset = 0;
        private int[] pcmi;
        private float[][][] pcmData;
        private InputStream inputStream = null;

        public OggStream(InputStream inputStream) throws IOException {
            this.inputStream = inputStream;
            String err = this.getHeader();
            if (err != null) {
                throw new IOException(err);
            }
            this.audioFormat = new AudioFormat(this.orbisInfo.rate, 16, this.orbisInfo.channels, true, false);
            this.bufCount = 0;
            this.offset = 0;
        }

        @Override
        public void close() {
            this.oggSyncState.clear();
            this.oggStreamState.clear();
            this.orbisBlock.clear();
            this.orbisDspState.clear();
        }

        public AudioFormat getFormat() {
            return this.audioFormat;
        }

        @Override
        public int available() {
            return this.bufCount;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b) > 0 ? b[0] : -1;
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, buf.length);
        }

        public int read(byte[] buf, int n) throws IOException {
            int wr = 0;
            int wrOffset = 0;
            while (n > 0) {
                if (this.bufCount <= 0) {
                    int ret = this.getBody(this.inputStream);
                    if (ret < 0) {
                        throw new IOException("Ogg decoding error");
                    }
                    if (ret == 0) break;
                    this.bufCount = ret;
                    this.offset = 0;
                }
                int rd = this.bufCount < n ? this.bufCount : n;
                System.arraycopy(this.convBuf, this.offset, buf, wrOffset, rd);
                this.bufCount -= rd;
                this.offset += rd;
                wr += rd;
                wrOffset += rd;
                n -= rd;
            }
            return wr <= 0 ? -1 : wr;
        }

        @Override
        public long skip(long n) throws IOException {
            long wr = 0L;
            while (n > 0L) {
                if (this.bufCount <= 0) {
                    int ret = this.getBody(this.inputStream);
                    if (ret < 0) {
                        throw new IOException("Ogg decoding error");
                    }
                    if (ret == 0) break;
                    this.bufCount = ret;
                    this.offset = 0;
                }
                long rd = (long)this.bufCount < n ? (long)this.bufCount : n;
                this.bufCount = (int)((long)this.bufCount - rd);
                this.offset = (int)((long)this.offset + rd);
                wr += rd;
                n -= rd;
            }
            return wr;
        }

        @Override
        public void reset() {
        }

        private String getHeader() {
            String input;
            int packet = 0;
            this.oggSyncState.init();
            block8: while (packet < 1) {
                switch (this.oggSyncState.pageout(this.oggPage)) {
                    case 1: {
                        this.oggStreamState.init(this.oggPage.serialno());
                        this.oggStreamState.reset();
                        this.orbisInfo.init();
                        this.orbisComment.init();
                        if (this.oggStreamState.pagein(this.oggPage) == -1) {
                            return "Error on header page";
                        }
                        if (this.oggStreamState.packetout(this.oggPacket) != 1) {
                            return "Error on first packet";
                        }
                        if (this.orbisInfo.synthesis_headerin(this.orbisComment, this.oggPacket) < 0) {
                            return "Non-vorbis data found";
                        }
                        packet = 1;
                        continue block8;
                    }
                    case 0: {
                        input = this.getInput();
                        if (input == null) continue block8;
                        return input;
                    }
                }
                return "Error reading first page";
            }
            block9: while (packet < 3) {
                switch (this.oggStreamState.packetout(this.oggPacket)) {
                    case 1: {
                        this.orbisInfo.synthesis_headerin(this.orbisComment, this.oggPacket);
                        ++packet;
                        continue block9;
                    }
                    case 0: {
                        input = this.getPage();
                        if (input == null) continue block9;
                        return input;
                    }
                }
                return "Error in header packet " + packet;
            }
            this.orbisDspState.synthesis_init(this.orbisInfo);
            this.orbisBlock.init(this.orbisDspState);
            return null;
        }

        private String getInput() {
            int count = -1;
            try {
                int idx = this.oggSyncState.buffer(4096);
                count = this.inputStream.read(this.oggSyncState.data, idx, 4096);
            }
            catch (IOException e) {
                return e.getMessage();
            }
            if (count > 0) {
                this.oggSyncState.wrote(count);
            }
            return count > 0 ? null : EOS;
        }

        private String getPage() {
            block4: while (true) {
                switch (this.oggSyncState.pageout(this.oggPage)) {
                    case 0: {
                        String input;
                        if ((input = this.getInput()) == null) continue block4;
                        return input;
                    }
                    case 1: {
                        this.oggStreamState.pagein(this.oggPage);
                        return null;
                    }
                }
                break;
            }
            return "Bogus page";
        }

        /*
         * Unable to fully structure code
         */
        public int getBody(InputStream is) {
            packet = 3;
            this.pcmi = new int[this.orbisInfo.channels];
            this.pcmData = new float[1][][];
            block4: while (true) {
                switch (this.oggStreamState.packetout(this.oggPacket)) {
                    case 1: {
                        if (this.orbisBlock.synthesis(this.oggPacket) == 0) {
                            this.orbisDspState.synthesis_blockin(this.orbisBlock);
                        }
                        if ((n = this.orbisDspState.synthesis_pcmout(this.pcmData, this.pcmi)) > 0) {
                            this.orbisDspState.synthesis_read(n);
                            return 2 * this.orbisInfo.channels * this.decodePacket(n);
                        }
                        ++packet;
                        continue block4;
                    }
                    case 0: {
                        err = this.getPage();
                        if (err != null) ** break;
                        continue block4;
                        return "End-of-stream".equals(err) != false ? 0 : -1;
                    }
                }
                break;
            }
            return -1;
        }

        private int decodePacket(int samples) {
            int range = samples < this.convBuf.length ? samples : this.convBuf.length;
            for (int i = 0; i < this.orbisInfo.channels; ++i) {
                int sampleIndex = i * 2;
                for (int j = 0; j < range; ++j) {
                    int value = (int)(this.pcmData[0][i][this.pcmi[i] + j] * 32767.0f);
                    if (value > Short.MAX_VALUE) {
                        value = Short.MAX_VALUE;
                    } else if (value < Short.MIN_VALUE) {
                        value = Short.MIN_VALUE;
                    }
                    this.convBuf[sampleIndex] = (byte)value;
                    this.convBuf[sampleIndex + 1] = (byte)(value >>> 8);
                    sampleIndex += 2 * this.orbisInfo.channels;
                }
            }
            return range;
        }
    }
}

