/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.util;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.aesh.utils.Config;

public class LoggerUtil {
    private static Handler logHandler;
    private static boolean doLog;

    private static void createLogHandler(String log) {
        try {
            File logFile = new File(log);
            LoggerUtil.createLogHandlerToFile(logFile);
            if (logFile.isDirectory()) {
                logFile = new File(logFile.getAbsolutePath() + Config.getPathSeparator() + "aesh.log");
            }
            LoggerUtil.createLogHandler(new FileHandler(logFile.getAbsolutePath()));
        }
        catch (IOException e) {
            LoggerUtil.createLogHandler(new ConsoleHandler());
        }
    }

    private static void createLogHandlerToFile(File logFile) {
        if (LoggerUtil.isCreateANewHandler(logFile)) {
            LoggerUtil.createLogHandler(new ConsoleHandler());
        }
    }

    private static boolean isCreateANewHandler(File logFile) {
        return logFile.getParentFile() != null && !logFile.getParentFile().isDirectory() && !logFile.getParentFile().mkdirs();
    }

    private static void createLogHandler(StreamHandler handler) {
        logHandler = handler;
        logHandler.setFormatter(new SimpleFormatter());
    }

    public static synchronized Logger getLogger(Class clazz) {
        return LoggerUtil.getLogger(clazz.getName());
    }

    public static synchronized Logger getLogger(String name) {
        if (!doLog) {
            Logger log = Logger.getLogger(name);
            return log;
        }
        if (logHandler == null) {
            LoggerUtil.createLogHandler(Config.getTmpDir() + Config.getPathSeparator() + "aesh.log");
        }
        if (logHandler == null) {
            return Logger.getLogger(name);
        }
        Logger log = Logger.getLogger(name);
        log.setUseParentHandlers(false);
        log.addHandler(logHandler);
        return log;
    }

    public static synchronized void doLog() {
        if (!doLog) {
            doLog = true;
            LoggerUtil.createLogHandler(Config.getTmpDir() + Config.getPathSeparator() + "aesh.log");
            Enumeration<String> loggerEnum = LogManager.getLogManager().getLoggerNames();
            while (loggerEnum.hasMoreElements()) {
                Logger logger = LogManager.getLogManager().getLogger(loggerEnum.nextElement());
                if (logger == null) continue;
                LoggerUtil.removeAllHandlers(logger);
                logger.addHandler(logHandler);
            }
        }
    }

    private static void removeAllHandlers(Logger logger) {
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
    }

    static {
        doLog = false;
    }
}

