/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Consumer;
import org.aesh.command.CommandDefinition;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.installation.AbstractInstallationCommand;
import org.jboss.galleon.diff.FsDiff;

@CommandDefinition(name="get-changes", description="Display the files modified, added or removed from an installation")
public class GetChangesCommand
extends AbstractInstallationCommand {
    @Override
    protected void runCommand(final PmCommandInvocation invoc) throws CommandExecutionException {
        try {
            ProvisioningManager mgr = this.getManager(invoc.getPmSession());
            FsDiff diff = mgr.getFsDiff();
            if (diff.isEmpty()) {
                invoc.println("No changes detected");
            } else {
                final Path workingDir = Paths.get(invoc.getConfiguration().getAeshContext().getCurrentWorkingDirectory().getAbsolutePath(), new String[0]);
                final Path installation = mgr.getInstallationHome();
                FsDiff.PathResolver resolver = new FsDiff.PathResolver(){

                    @Override
                    public String resolve(String relativePath) {
                        Path absPath = Paths.get(installation.toString(), relativePath);
                        return workingDir.relativize(absPath).toString();
                    }
                };
                FsDiff.log(diff, new Consumer<String>(){

                    @Override
                    public void accept(String msg) {
                        invoc.println(msg);
                    }
                }, resolver);
            }
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(ex.getMessage());
        }
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.PROVISIONING;
    }
}

