/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.mvn;

import java.io.IOException;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.cli.config.mvn.MavenRemoteRepository;

@CommandDefinition(name="add-repository", description="Add a maven repository")
public class MavenAddRepository
extends PmSessionCommand {
    @Option(description="Maven remote repository URL", required=true)
    private String url;
    @Option(description="Maven remote repository type, \"default\" by default", required=false, defaultValue={"default"})
    private String type;
    @Option(description="Maven remote repository name", required=true)
    private String name;
    @Option(name="release-update-policy", completer=UpdatePolicyCompleter.class, description="Maven release update policy. Update policies are 'always', 'daily', 'never', 'interval:<minutes>'. NB: Interval is expressed in minutes", required=false)
    private String releaseUpdatePolicy;
    @Option(name="snapshot-update-policy", completer=UpdatePolicyCompleter.class, description="Maven snapshot update policy. Update policies are 'always', 'daily', 'never', 'interval:<minutes>'. NB: Interval is expressed in minutes", required=false)
    private String snapshotUpdatePolicy;
    @Option(hasValue=true, name="enable-snapshot", description="Enable or disable 'snapshot' artifacts resolution. If not set relies on default resolution")
    private Boolean enableSnapshot;
    @Option(hasValue=true, name="enable-release", description="Enable or disable 'release' artifacts resolution. If not set relies on default resolution")
    private Boolean enableRelease;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        try {
            session.getPmSession().getPmConfiguration().getMavenConfig().addRemoteRepository(new MavenRemoteRepository(this.name, this.type, this.releaseUpdatePolicy, this.snapshotUpdatePolicy, this.enableRelease, this.enableSnapshot, this.url));
        }
        catch (IOException | XMLStreamException | ProvisioningException ex) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.addRepositoryFailed(), ex);
        }
    }

    public static class UpdatePolicyCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            return MavenConfig.getUpdatePolicies();
        }
    }
}

