/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.mvn;

import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.FPLocationCompleter;

@CommandDefinition(name="resolve-feature-pack", description="Download a feature pack to the local maven repository")
public class MavenResolveFeaturePack
extends PmSessionCommand {
    @Argument(completer=FPLocationCompleter.class, description="Location of feature pack to resolve")
    protected String fpl;
    @Option(hasValue=false, description="Whether or not the output should be verbose")
    private boolean verbose;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        try {
            if (this.verbose) {
                session.getPmSession().enableMavenTrace(true);
            }
            try {
                session.getPmSession().downloadFp(session.getPmSession().getResolvedLocation(null, this.fpl).getFPID());
                session.println("artifact installed in local mvn repository " + session.getPmSession().getPmConfiguration().getMavenConfig().getLocalRepository());
            }
            finally {
                session.getPmSession().enableMavenTrace(false);
            }
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.resolveFeaturePackFailed(), ex);
        }
    }
}

