/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigCustomizations;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.util.CollectionUtils;

public abstract class ConfigCustomizationsBuilder<B extends ConfigCustomizationsBuilder<B>> {
    protected Boolean inheritConfigs;
    protected boolean inheritModelOnlyConfigs = true;
    protected Set<String> includedModels = Collections.emptySet();
    protected Set<ConfigId> includedConfigs = Collections.emptySet();
    protected Map<String, Boolean> excludedModels = Collections.emptyMap();
    protected Set<ConfigId> excludedConfigs = Collections.emptySet();
    protected Map<ConfigId, ConfigModel> definedConfigs = Collections.emptyMap();
    protected boolean hasModelOnlyConfigs;

    public B initConfigs(ConfigCustomizations clone) {
        this.inheritConfigs = clone.inheritConfigs;
        this.inheritModelOnlyConfigs = clone.inheritModelOnlyConfigs;
        this.includedModels = CollectionUtils.clone(clone.includedModels);
        this.includedConfigs = CollectionUtils.clone(clone.includedConfigs);
        this.excludedModels = CollectionUtils.clone(clone.excludedModels);
        this.excludedConfigs = CollectionUtils.clone(clone.excludedConfigs);
        this.definedConfigs = CollectionUtils.clone(clone.definedConfigs);
        this.hasModelOnlyConfigs = clone.hasModelOnlyConfigs;
        return (B)this;
    }

    protected void resetConfigs() {
        this.inheritConfigs = null;
        this.inheritModelOnlyConfigs = true;
        this.includedModels = Collections.emptySet();
        this.includedConfigs = Collections.emptySet();
        this.excludedModels = Collections.emptyMap();
        this.excludedConfigs = Collections.emptySet();
        this.definedConfigs = Collections.emptyMap();
        this.hasModelOnlyConfigs = false;
    }

    public B setInheritConfigs(boolean inherit) {
        this.inheritConfigs = inherit;
        return (B)this;
    }

    public B setInheritModelOnlyConfigs(boolean inheritModelOnlyConfigs) {
        this.inheritModelOnlyConfigs = inheritModelOnlyConfigs;
        return (B)this;
    }

    public B addConfig(ConfigModel config) throws ProvisioningDescriptionException {
        ConfigId id = config.getId();
        this.definedConfigs = CollectionUtils.putLinked(this.definedConfigs, id, config);
        this.hasModelOnlyConfigs |= config.id.isModelOnly();
        return (B)this;
    }

    public boolean hasDefinedConfigs() {
        return !this.definedConfigs.isEmpty();
    }

    public Collection<ConfigModel> getDefinedConfigs() {
        return this.definedConfigs.values();
    }

    public B removeConfig(ConfigId id) throws ProvisioningDescriptionException {
        this.definedConfigs = CollectionUtils.remove(this.definedConfigs, id);
        this.hasModelOnlyConfigs = false;
        for (ConfigModel cm : this.definedConfigs.values()) {
            this.hasModelOnlyConfigs |= cm.id.isModelOnly();
        }
        return (B)this;
    }

    public B removeAllConfigs() {
        this.definedConfigs = Collections.emptyMap();
        this.hasModelOnlyConfigs = false;
        return (B)this;
    }

    public B excludeConfigModel(String model) throws ProvisioningDescriptionException {
        return this.excludeConfigModel(model, true);
    }

    public B excludeConfigModel(String model, boolean namedConfigsOnly) throws ProvisioningDescriptionException {
        if (this.includedModels.contains(model)) {
            throw new ProvisioningDescriptionException("Model " + model + " has been included");
        }
        this.excludedModels = CollectionUtils.put(this.excludedModels, model, namedConfigsOnly);
        return (B)this;
    }

    public B includeConfigModel(String name) throws ProvisioningDescriptionException {
        if (this.excludedModels.containsKey(name)) {
            throw new ProvisioningDescriptionException("Model " + name + " has been excluded");
        }
        this.includedModels = CollectionUtils.add(this.includedModels, name);
        return (B)this;
    }

    public B includeDefaultConfig(String model, String name) throws ProvisioningDescriptionException {
        return this.includeDefaultConfig(new ConfigId(model, name));
    }

    public B includeDefaultConfig(ConfigId configId) throws ProvisioningDescriptionException {
        if (this.includedConfigs.contains(configId)) {
            throw new ProvisioningDescriptionException("Config model with id " + configId + " has already been included into the configuration");
        }
        this.includedConfigs = CollectionUtils.add(this.includedConfigs, configId);
        return (B)this;
    }

    public B removeIncludedDefaultConfig(ConfigId configId) throws ProvisioningDescriptionException {
        if (!this.includedConfigs.contains(configId)) {
            throw new ProvisioningDescriptionException("Config model with id " + configId + " is not included into the configuration");
        }
        this.includedConfigs = CollectionUtils.remove(this.includedConfigs, configId);
        return (B)this;
    }

    public boolean isDefaultConfigIncluded(ConfigId configId) {
        return this.includedConfigs.contains(configId);
    }

    public B excludeDefaultConfig(String model, String name) {
        return this.excludeDefaultConfig(new ConfigId(model, name));
    }

    public B removeExcludedDefaultConfig(ConfigId configId) throws ProvisioningDescriptionException {
        if (!this.excludedConfigs.contains(configId)) {
            throw new ProvisioningDescriptionException("Config model with id " + configId + " is not excluded from the configuration");
        }
        this.excludedConfigs = CollectionUtils.remove(this.excludedConfigs, configId);
        return (B)this;
    }

    public B excludeDefaultConfig(ConfigId configId) {
        this.excludedConfigs = CollectionUtils.add(this.excludedConfigs, configId);
        return (B)this;
    }

    public boolean isDefaultConfigExcluded(ConfigId configId) {
        return this.excludedConfigs.contains(configId);
    }
}

