/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class FeaturePackUpdatePlan {
    private final boolean transitive;
    private final FeaturePackLocation installedFpl;
    private final Set<FeaturePackLocation.FPID> installedPatches;
    private FeaturePackLocation newFpl;
    private List<FeaturePackLocation.FPID> newPatches = Collections.emptyList();

    public static Request request(FeaturePackLocation installedFpl) {
        return FeaturePackUpdatePlan.request(installedFpl, Collections.emptySet(), false);
    }

    public static Request request(FeaturePackLocation installedFpl, boolean transitive) {
        return FeaturePackUpdatePlan.request(installedFpl, Collections.emptySet(), transitive);
    }

    public static Request request(FeaturePackLocation installedFpl, Set<FeaturePackLocation.FPID> installedPatches) {
        return FeaturePackUpdatePlan.request(installedFpl, installedPatches, false);
    }

    public static Request request(FeaturePackLocation installedFpl, Set<FeaturePackLocation.FPID> installedPatches, boolean transitive) {
        return new FeaturePackUpdatePlan(installedFpl, installedPatches, transitive).newRequest();
    }

    private FeaturePackUpdatePlan(FeaturePackLocation fpl, Set<FeaturePackLocation.FPID> patches, boolean transitive) {
        this.transitive = transitive;
        this.installedFpl = fpl;
        this.installedPatches = patches;
        this.newFpl = fpl;
    }

    private Request newRequest() {
        return new Request();
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public FeaturePackLocation getInstalledLocation() {
        return this.installedFpl;
    }

    public boolean hasInstalledPatches() {
        return !this.installedPatches.isEmpty();
    }

    public Set<FeaturePackLocation.FPID> getInstalledPatches() {
        return this.installedPatches;
    }

    public boolean isPatchInstalled(FeaturePackLocation.FPID patchId) {
        return this.installedPatches.contains(patchId);
    }

    public FeaturePackLocation getNewLocation() {
        return this.newFpl;
    }

    public boolean hasNewLocation() {
        return !this.installedFpl.equals(this.newFpl);
    }

    public boolean hasNewPatches() {
        return !this.newPatches.isEmpty();
    }

    public List<FeaturePackLocation.FPID> getNewPatches() {
        return this.newPatches;
    }

    public boolean isEmpty() {
        return !this.hasNewLocation() && !this.hasNewPatches();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.installedFpl == null ? 0 : this.installedFpl.hashCode());
        result = 31 * result + (this.newFpl == null ? 0 : this.newFpl.hashCode());
        result = 31 * result + (this.newPatches == null ? 0 : this.newPatches.hashCode());
        result = 31 * result + (this.transitive ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeaturePackUpdatePlan other = (FeaturePackUpdatePlan)obj;
        if (this.installedFpl == null ? other.installedFpl != null : !this.installedFpl.equals(other.installedFpl)) {
            return false;
        }
        if (this.newFpl == null ? other.newFpl != null : !this.newFpl.equals(other.newFpl)) {
            return false;
        }
        if (this.newPatches == null ? other.newPatches != null : !this.newPatches.equals(other.newPatches)) {
            return false;
        }
        return this.transitive == other.transitive;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[update ");
        if (this.transitive) {
            buf.append("transitive ");
        }
        buf.append(this.installedFpl);
        if (this.hasNewLocation()) {
            buf.append(" to ").append(this.newFpl);
        }
        if (!this.newPatches.isEmpty()) {
            buf.append(" with ");
            StringUtils.append(buf, this.newPatches);
        }
        return buf.append(']').toString();
    }

    public class Request {
        private Request() {
        }

        public FeaturePackLocation getInstalledLocation() {
            return FeaturePackUpdatePlan.this.installedFpl;
        }

        public boolean hasInstalledPatches() {
            return !FeaturePackUpdatePlan.this.installedPatches.isEmpty();
        }

        public Set<FeaturePackLocation.FPID> getInstalledPatches() {
            return FeaturePackUpdatePlan.this.installedPatches;
        }

        public boolean isPatchInstalled(FeaturePackLocation.FPID patchId) {
            return FeaturePackUpdatePlan.this.installedPatches.contains(patchId);
        }

        public Request setNewLocation(FeaturePackLocation newLocation) {
            FeaturePackUpdatePlan.this.newFpl = newLocation;
            return this;
        }

        public Request addNewPatch(FeaturePackLocation.FPID patchId) {
            FeaturePackUpdatePlan.this.newPatches = CollectionUtils.add(FeaturePackUpdatePlan.this.newPatches, patchId);
            return this;
        }

        public FeaturePackUpdatePlan buildPlan() {
            FeaturePackUpdatePlan.this.newPatches = CollectionUtils.unmodifiable(FeaturePackUpdatePlan.this.newPatches);
            return FeaturePackUpdatePlan.this;
        }
    }
}

