/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageDepsSpecBuilder;

public abstract class PackageDepsSpec {
    protected final List<PackageDependencySpec> localPkgDeps;
    protected final Map<String, List<PackageDependencySpec>> externalPkgDeps;
    protected final int requiredPkgDeps;

    protected PackageDepsSpec() {
        this.localPkgDeps = Collections.emptyList();
        this.externalPkgDeps = Collections.emptyMap();
        this.requiredPkgDeps = 0;
    }

    protected PackageDepsSpec(PackageDepsSpec src) {
        this.localPkgDeps = src.localPkgDeps;
        this.externalPkgDeps = src.externalPkgDeps;
        this.requiredPkgDeps = src.requiredPkgDeps;
    }

    protected PackageDepsSpec(PackageDepsSpecBuilder<?> builder) {
        this.localPkgDeps = builder.buildLocalPackageDeps();
        this.externalPkgDeps = builder.buildExternalPackageDeps();
        this.requiredPkgDeps = builder.requiredDeps;
    }

    public boolean hasPackageDeps() {
        return !this.localPkgDeps.isEmpty() || !this.externalPkgDeps.isEmpty();
    }

    public boolean hasLocalPackageDeps() {
        return !this.localPkgDeps.isEmpty();
    }

    public Collection<PackageDependencySpec> getLocalPackageDeps() {
        return this.localPkgDeps;
    }

    public boolean hasExternalPackageDeps() {
        return !this.externalPkgDeps.isEmpty();
    }

    public Collection<String> getPackageOrigins() {
        return this.externalPkgDeps.keySet();
    }

    public Collection<PackageDependencySpec> getExternalPackageDeps(String origin) {
        List<PackageDependencySpec> fpDeps = this.externalPkgDeps.get(origin);
        return fpDeps == null ? Collections.emptyList() : fpDeps;
    }

    public int getRequiredPackageDepsTotal() {
        return this.requiredPkgDeps;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.externalPkgDeps == null ? 0 : this.externalPkgDeps.hashCode());
        result = 31 * result + (this.localPkgDeps == null ? 0 : this.localPkgDeps.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackageDepsSpec other = (PackageDepsSpec)obj;
        if (this.externalPkgDeps == null ? other.externalPkgDeps != null : !this.externalPkgDeps.equals(other.externalPkgDeps)) {
            return false;
        }
        return !(this.localPkgDeps == null ? other.localPkgDeps != null : !this.localPkgDeps.equals(other.localPkgDeps));
    }
}

