/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jboss.galleon.util.PathsUtils;

@FunctionalInterface
public interface PathFilter {
    public static final PathFilter DEFAULT = new PathFilter(){

        @Override
        public boolean accept(Path path) {
            return true;
        }
    };

    public boolean accept(Path var1);

    public static class Builder {
        private final List<Pattern> directories = new ArrayList<Pattern>();
        private final List<Pattern> files = new ArrayList<Pattern>();

        private Builder() {
        }

        public static Builder instance() {
            return new Builder();
        }

        public Builder addDirectories(String ... directoryNames) {
            for (String directory : directoryNames) {
                this.directories.add(Builder.wildcardToJavaRegexp(directory));
            }
            return this;
        }

        public Builder addFiles(String ... fileNames) {
            for (String file : fileNames) {
                this.files.add(Builder.wildcardToJavaRegexp(file));
            }
            return this;
        }

        public static Pattern wildcardToJavaRegexp(String expr) {
            if (expr == null) {
                throw new IllegalArgumentException("expr is null");
            }
            String regex = PathsUtils.toForwardSlashSeparator(expr).replaceAll("([(){}\\[\\].+^$])", "\\\\$1");
            regex = regex.replaceAll("\\*", ".*");
            regex = regex.replaceAll("\\?", ".");
            return Pattern.compile(regex);
        }

        public PathFilter build() {
            return new PathFilterImpl(this.directories, this.files);
        }
    }

    public static class PathFilterImpl
    implements PathFilter {
        private final List<Pattern> directories;
        private final List<Pattern> files;

        private PathFilterImpl(List<Pattern> directories, List<Pattern> files) {
            this.directories = directories;
            this.files = files;
        }

        @Override
        public boolean accept(Path path) {
            boolean acceptDirectory;
            final String current = PathsUtils.toForwardSlashSeparator(path.toString());
            boolean bl = acceptDirectory = !this.directories.stream().anyMatch(new Predicate<Pattern>(){

                @Override
                public boolean test(Pattern pattern) {
                    return pattern.matcher(current).matches();
                }
            });
            if (Files.isDirectory(path, new LinkOption[0])) {
                return acceptDirectory;
            }
            final String fileName = path.getFileName().toString();
            return acceptDirectory && !this.files.stream().anyMatch(new Predicate<Pattern>(){

                @Override
                public boolean test(Pattern pattern) {
                    return pattern.matcher(fileName).matches();
                }
            });
        }
    }
}

