/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util.formatparser.formats.expr;

import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.util.formatparser.FormatContentHandler;
import org.jboss.galleon.util.formatparser.FormatErrors;
import org.jboss.galleon.util.formatparser.FormatParsingException;
import org.jboss.galleon.util.formatparser.ParsingContext;
import org.jboss.galleon.util.formatparser.ParsingFormat;
import org.jboss.galleon.util.formatparser.ParsingFormatBase;
import org.jboss.galleon.util.formatparser.formats.CollectionParsingFormat;
import org.jboss.galleon.util.formatparser.formats.CompositeParsingFormat;
import org.jboss.galleon.util.formatparser.formats.KeyValueParsingFormat;
import org.jboss.galleon.util.formatparser.formats.StringParsingFormat;
import org.jboss.galleon.util.formatparser.formats.expr.FormatExprTypeParamParsingFormat;
import org.jboss.galleon.util.formatparser.handlers.MapContentHandler;

public class FormatExprParsingFormat
extends ParsingFormatBase {
    public static final String NAME = "FormatExpr";
    public static final String COMPOSITE_TYPE_FORMAT_NAME = "CompTypeExpr";
    public static final String LIST_TYPE_FORMAT_NAME = "ListTypeExpr";
    static final FormatExprParsingFormat INSTANCE = new FormatExprParsingFormat();
    private static final CollectionParsingFormat TYPE_PARAM_EXPR = CollectionParsingFormat.list(FormatExprTypeParamParsingFormat.getInstance(), '<', '>');
    private static final CompositeParsingFormat COMPOSITE_TYPE_FORMAT = CompositeParsingFormat.newInstance("CompTypeExpr", "CompTypeExpr", KeyValueParsingFormat.newInstance(StringParsingFormat.getInstance(), ':', INSTANCE)).addElement("!name", StringParsingFormat.getInstance()).addElement("!content-type", StringParsingFormat.getInstance()).setAcceptAll(true);
    private static final ParsingFormat LIST_TYPE_FORMAT = new ParsingFormatBase("ListTypeExpr"){

        @Override
        public boolean isOpeningChar(char ch) {
            return ch == '[';
        }

        @Override
        public void pushed(ParsingContext ctx) throws FormatParsingException {
            if (ctx.charNow() != '[') {
                throw new FormatParsingException(FormatErrors.unexpectedStartingCharacter(this, '[', ctx.charNow()));
            }
        }

        @Override
        public void react(ParsingContext ctx) throws FormatParsingException {
            if (ctx.charNow() == ']') {
                ctx.end();
                return;
            }
            ctx.bounce();
        }

        @Override
        public void deal(ParsingContext ctx) throws FormatParsingException {
            if (Character.isWhitespace(ctx.charNow())) {
                return;
            }
            ctx.pushFormat(INSTANCE);
        }
    };

    public static FormatExprParsingFormat getInstance() {
        return INSTANCE;
    }

    protected FormatExprParsingFormat() {
        super(NAME);
    }

    @Override
    public boolean isOpeningChar(char ch) {
        return true;
    }

    @Override
    public void pushed(ParsingContext ctx) throws FormatParsingException {
        this.deal(ctx);
    }

    @Override
    public void deal(ParsingContext ctx) throws FormatParsingException {
        if (Character.isWhitespace(ctx.charNow())) {
            return;
        }
        switch (ctx.charNow()) {
            case '<': {
                ctx.pushFormat(TYPE_PARAM_EXPR);
                break;
            }
            case '[': {
                ctx.pushFormat(LIST_TYPE_FORMAT);
                break;
            }
            case '{': {
                ctx.pushFormat(COMPOSITE_TYPE_FORMAT);
                break;
            }
            default: {
                ctx.content();
            }
        }
    }

    public static class CompositeTypeContentHandler
    extends MapContentHandler {
        public CompositeTypeContentHandler(ParsingFormat format, int strIndex) {
            super(format, strIndex);
        }

        @Override
        public Object getContent() throws FormatParsingException {
            if (this.map.isEmpty()) {
                return Collections.singletonList(CompositeParsingFormat.getInstance());
            }
            String typeName = (String)this.map.get("!name");
            String contentType = (String)this.map.get("!content-type");
            CompositeParsingFormat format = CompositeParsingFormat.newInstance(typeName, contentType);
            for (Map.Entry entry : this.map.entrySet()) {
                String key = (String)entry.getKey();
                if (key.charAt(0) == '!') continue;
                format.addElement(key, (ParsingFormat)entry.getValue());
            }
            return Collections.singletonList(format);
        }
    }

    public static class ListTypeContentHandler
    extends FormatContentHandler {
        private ParsingFormat param;

        public ListTypeContentHandler(ParsingFormat format, int strIndex) {
            super(format, strIndex);
        }

        @Override
        public void addChild(FormatContentHandler childHandler) throws FormatParsingException {
            if (this.param != null) {
                throw new FormatParsingException("Format " + this.format + " type parameters have already been initialized");
            }
            this.param = (ParsingFormat)childHandler.getContent();
        }

        @Override
        public Object getContent() throws FormatParsingException {
            return Collections.singletonList(this.param == null ? CollectionParsingFormat.list() : CollectionParsingFormat.list(this.param));
        }
    }
}

