/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.spec.ConfigLayerDependency;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.universe.FeaturePackLocation;

public class LayersConfigBuilder {
    public static final String EXCLUDE_PREFIX = "-";
    public static final String REMOVE_EXCLUDE_PREFIX = "+";
    private final String[] layers;
    private final String config;
    private final String model;
    private final FeaturePackLocation loc;
    private final ProvisioningManager mgr;
    private final Set<String> excludedLayers = new HashSet<String>();
    private final Set<String> removeExcludedLayers = new HashSet<String>();
    private final Set<String> includedLayers = new HashSet<String>();
    private final Map<String, Set<String>> layersDeps;

    LayersConfigBuilder(ProvisioningManager mgr, PmSession session, String[] layers, String model, String config, FeaturePackLocation loc) throws ProvisioningException, IOException {
        this.mgr = mgr;
        this.layers = layers;
        this.loc = loc;
        Map<String, Map<String, Set<String>>> layersMap = LayersConfigBuilder.getAllLayers(session, loc, true);
        this.model = LayersConfigBuilder.getModel(model, layersMap);
        if (this.model == null) {
            throw new ProvisioningException(CliErrors.noLayersForModel(model));
        }
        this.layersDeps = layersMap.get(this.model);
        if (this.layersDeps == null) {
            throw new ProvisioningException(CliErrors.noLayersForModel(this.model));
        }
        Set<String> actualLayers = this.layersDeps.keySet();
        for (String l : layers) {
            String name = LayersConfigBuilder.getLayerName(l);
            if (!actualLayers.contains(name)) {
                throw new ProvisioningException(CliErrors.unknownLayer(name));
            }
            if (l.startsWith(EXCLUDE_PREFIX)) {
                this.excludedLayers.add(name);
                continue;
            }
            if (l.startsWith(REMOVE_EXCLUDE_PREFIX)) {
                this.removeExcludedLayers.add(name);
                continue;
            }
            this.includedLayers.add(name);
        }
        this.config = config == null ? this.model + ".xml" : config;
    }

    private static String getLayerName(String name) {
        if (name.startsWith(EXCLUDE_PREFIX)) {
            name = name.substring(EXCLUDE_PREFIX.length());
        } else if (name.startsWith(REMOVE_EXCLUDE_PREFIX)) {
            name = name.substring(REMOVE_EXCLUDE_PREFIX.length());
        }
        return name;
    }

    private static String getModel(String model, Map<String, Map<String, Set<String>>> layersMap) throws ProvisioningException {
        if (model == null) {
            if (layersMap.isEmpty()) {
                throw new ProvisioningException(CliErrors.noLayers());
            }
            if (layersMap.size() != 1) {
                throw new ProvisioningException(CliErrors.tooMuchModels());
            }
            model = layersMap.keySet().iterator().next();
        }
        return model;
    }

    public static Set<String> getLayerNames(PmSession session, String model, FeaturePackLocation loc, Set<String> noDependencies) throws ProvisioningException, IOException {
        Set<String> names;
        Map<String, Map<String, Set<String>>> layersMap = LayersConfigBuilder.getAllLayers(session, loc, true);
        Map<String, Set<String>> layers = layersMap.get(model = LayersConfigBuilder.getModel(model, layersMap));
        if (layers != null) {
            names = new HashSet();
            HashSet<String> allDependencies = new HashSet<String>();
            for (String string : noDependencies) {
                HashSet<String> seen = new HashSet<String>();
                LayersConfigBuilder.getDependencies(string, allDependencies, layers, seen);
            }
            for (Map.Entry entry : layers.entrySet()) {
                if (allDependencies.contains(entry.getKey()) && !noDependencies.contains(entry.getKey())) continue;
                names.add((String)entry.getKey());
            }
        } else {
            names = Collections.emptySet();
        }
        return names;
    }

    private static void getDependencies(String name, Set<String> set, Map<String, Set<String>> all, Set<String> seen) {
        if (seen.contains(name)) {
            return;
        }
        seen.add(name);
        Set<String> deps = all.get(name);
        if (deps != null) {
            set.addAll(deps);
            for (String n : deps) {
                LayersConfigBuilder.getDependencies(n, set, all, seen);
            }
        }
    }

    public static Map<String, Map<String, Set<String>>> getAllLayers(ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        return LayersConfigBuilder.getAllLayers(pLayout, true);
    }

    private static Map<String, Map<String, Set<String>>> getAllLayers(PmSession session, FeaturePackLocation loc, boolean includeDependencies) throws ProvisioningException, IOException {
        ProvisioningConfig pConfig = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(FeaturePackConfig.builder(loc).build())).build();
        try (ProvisioningLayout<FeaturePackLayout> layout = session.getLayoutFactory().newConfigLayout(pConfig);){
            Map<String, Map<String, Set<String>>> map = LayersConfigBuilder.getAllLayers(layout, includeDependencies);
            return map;
        }
    }

    private static Map<String, Map<String, Set<String>>> getAllLayers(ProvisioningLayout<FeaturePackLayout> pLayout, boolean includeDependencies) throws ProvisioningException, IOException {
        HashMap<String, Map<String, Set<String>>> layersMap = new HashMap<String, Map<String, Set<String>>>();
        for (FeaturePackLayout fp : pLayout.getOrderedFeaturePacks()) {
            for (ConfigId layer : fp.loadLayers()) {
                Set existingDependencies;
                String model = layer.getModel();
                HashMap names = (HashMap)layersMap.get(model);
                if (names == null) {
                    names = new HashMap();
                    layersMap.put(model, names);
                }
                Set<String> dependencies = new TreeSet();
                if (includeDependencies) {
                    ConfigLayerSpec spec = fp.loadConfigLayerSpec(model, layer.getName());
                    for (ConfigLayerDependency dep : spec.getLayerDeps()) {
                        dependencies.add(dep.getName());
                    }
                }
                if ((existingDependencies = (Set)names.get(layer.getName())) != null) {
                    existingDependencies.addAll(dependencies);
                    dependencies = existingDependencies;
                }
                names.put(layer.getName(), dependencies);
            }
        }
        return layersMap;
    }

    ProvisioningConfig build() throws ProvisioningException, IOException {
        ProvisioningConfig existing = this.mgr.getProvisioningConfig();
        ProvisioningConfig.Builder builder = null;
        FeaturePackConfig.Builder fpBuilder = null;
        ConfigModel.Builder configBuilder = null;
        if (existing != null) {
            builder = ProvisioningConfig.builder(existing);
            ConfigId id = new ConfigId(this.model, this.config);
            if (existing.hasDefinedConfig(id)) {
                ConfigModel cmodel = existing.getDefinedConfig(id);
                configBuilder = ConfigModel.builder(cmodel);
                this.handleLayers(configBuilder, cmodel);
                builder.removeConfig(id);
            }
            if (builder.hasFeaturePackDep(this.loc.getProducer())) {
                FeaturePackConfig fp = existing.getFeaturePackDep(this.loc.getProducer());
                fpBuilder = FeaturePackConfig.builder(fp);
                builder.removeFeaturePackDep(fp.getLocation());
            }
        }
        if (builder == null) {
            builder = ProvisioningConfig.builder();
        }
        if (configBuilder == null) {
            configBuilder = ConfigModel.builder(this.model, this.config);
            this.handleLayers(configBuilder, null);
        }
        if (fpBuilder == null) {
            fpBuilder = ((FeaturePackConfig.Builder)FeaturePackConfig.builder(this.loc).setInheritConfigs(false)).setInheritPackages(false);
        }
        builder.addConfig(configBuilder.build());
        builder.addFeaturePackDep(fpBuilder.build());
        return builder.build();
    }

    private void handleLayers(ConfigModel.Builder configBuilder, ConfigModel cmodel) throws ProvisioningException {
        if (!this.removeExcludedLayers.isEmpty()) {
            if (cmodel == null) {
                throw new ProvisioningException(CliErrors.noExcludedLayers());
            }
            for (String l : this.removeExcludedLayers) {
                if (!cmodel.getExcludedLayers().contains(l)) {
                    throw new ProvisioningException(CliErrors.notExcludedLayer(l));
                }
                configBuilder.removeExcludedLayer(l);
            }
        }
        if (!this.excludedLayers.isEmpty()) {
            for (String excludedLayer : this.excludedLayers) {
                if (cmodel == null) {
                    configBuilder.excludeLayer(excludedLayer);
                    continue;
                }
                if (cmodel.getIncludedLayers().contains(excludedLayer)) {
                    throw new ProvisioningException(CliErrors.cantExcludeLayer(excludedLayer));
                }
                if (cmodel.getExcludedLayers().contains(excludedLayer)) continue;
                configBuilder.excludeLayer(excludedLayer);
            }
        }
        for (String layer : this.includedLayers) {
            if (cmodel == null) {
                configBuilder.includeLayer(layer);
                continue;
            }
            if (cmodel.getExcludedLayers().contains(layer)) {
                configBuilder.removeExcludedLayer(layer);
            }
            if (cmodel.getIncludedLayers().contains(layer)) continue;
            configBuilder.includeLayer(layer);
        }
    }
}

