/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.spec.SpecId;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class FeatureId {
    final SpecId specId;
    final Map<String, String> params;

    public static FeatureId fromString(String str) throws ProvisioningDescriptionException {
        int equals;
        int endIndex;
        int length = str.length();
        if (length == 0) {
            FeatureId.formatException(str);
        }
        int nextIndex = 0;
        char c = str.charAt(nextIndex++);
        StringBuilder buf = new StringBuilder(length);
        String specId = null;
        while (nextIndex < length) {
            if (c == ':') {
                if (buf.length() == 0) {
                    FeatureId.formatException(str);
                }
                specId = buf.toString();
                break;
            }
            buf.append(c);
            c = str.charAt(nextIndex++);
        }
        if (specId == null) {
            FeatureId.formatException(str);
        }
        if ((endIndex = str.indexOf(44, nextIndex + 3)) < 0) {
            int equals2 = str.indexOf(61, nextIndex + 1);
            if (equals2 < 0 || equals2 == str.length() - 1) {
                FeatureId.formatException(str);
            }
            return FeatureId.create(specId.toString(), str.substring(nextIndex, equals2), str.substring(equals2 + 1));
        }
        Builder builder = FeatureId.builder(specId.toString());
        int lastComma = nextIndex - 1;
        while (endIndex > 0) {
            equals = str.indexOf(61, lastComma + 2);
            if (equals < 0 || equals == str.length() - 1) {
                FeatureId.formatException(str);
            }
            builder.setParam(str.substring(lastComma + 1, equals), str.substring(equals + 1, endIndex));
            lastComma = endIndex;
            endIndex = str.indexOf(44, endIndex + 1);
        }
        equals = str.indexOf(61, lastComma + 2);
        if (equals < 0 || equals == str.length() - 1) {
            FeatureId.formatException(str);
        }
        builder.setParam(str.substring(lastComma + 1, equals), str.substring(equals + 1));
        return builder.build();
    }

    private static void formatException(String s) throws ProvisioningDescriptionException {
        throw new ProvisioningDescriptionException('\'' + s + "' does not follow format spec_name:param_name=value(,param_name=value)*");
    }

    public static Builder builder(String specId) throws ProvisioningDescriptionException {
        return new Builder(specId);
    }

    public static FeatureId create(String specId, String name, String value) throws ProvisioningDescriptionException {
        return new FeatureId(specId, Collections.singletonMap(name, value));
    }

    public FeatureId(String specName, Map<String, String> params) throws ProvisioningDescriptionException {
        if (params.isEmpty()) {
            throw new ProvisioningDescriptionException("ID paramaters are missing");
        }
        this.specId = SpecId.fromString(specName);
        this.params = CollectionUtils.unmodifiable(params);
    }

    public SpecId getSpec() {
        return this.specId;
    }

    public Collection<String> getParamNames() {
        return this.params.keySet();
    }

    public boolean hasParam(String name) {
        return this.params.containsKey(name);
    }

    public String getParam(String name) {
        return this.params.get(name);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + (this.specId == null ? 0 : this.specId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureId other = (FeatureId)obj;
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        return !(this.specId == null ? other.specId != null : !this.specId.equals(other.specId));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.specId);
        if (!this.params.isEmpty()) {
            buf.append(':');
            StringUtils.append(buf, this.params.entrySet());
        }
        return buf.toString();
    }

    public static class Builder {
        private final String specId;
        private Map<String, String> params = Collections.emptyMap();

        private Builder(String specId) throws ProvisioningDescriptionException {
            this.specId = specId;
        }

        public Builder setParam(String name, String value) {
            this.params = CollectionUtils.put(this.params, name, value);
            return this;
        }

        public FeatureId build() throws ProvisioningDescriptionException {
            return new FeatureId(this.specId, this.params);
        }
    }
}

