/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Arrays;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.spec.FeaturePackPlugin;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.FeaturePackXmlParser20;
import org.jboss.galleon.xml.ProvisioningXmlWriter;
import org.jboss.galleon.xml.util.ElementNode;

public class FeaturePackXmlWriter
extends BaseXmlWriter<FeaturePackSpec> {
    private static final FeaturePackXmlWriter INSTANCE = new FeaturePackXmlWriter();

    public static FeaturePackXmlWriter getInstance() {
        return INSTANCE;
    }

    private FeaturePackXmlWriter() {
    }

    @Override
    protected ElementNode toElement(FeaturePackSpec fpSpec) {
        ElementNode depElement;
        ElementNode fp = FeaturePackXmlWriter.addElement(null, FeaturePackXmlParser20.Element.FEATURE_PACK);
        FeaturePackXmlWriter.addAttribute(fp, FeaturePackXmlParser20.Attribute.LOCATION, fpSpec.getFPID().toString());
        ProvisioningXmlWriter.writeUniverseSpecs(fpSpec, fp);
        if (fpSpec.isPatch()) {
            ElementNode patchFor = FeaturePackXmlWriter.addElement(fp, FeaturePackXmlParser20.Element.PATCH);
            FeaturePackXmlWriter.addAttribute(patchFor, FeaturePackXmlParser20.Attribute.FOR, fpSpec.getPatchFor().toString());
        }
        if (fpSpec.hasTransitiveDeps()) {
            ElementNode transitives = FeaturePackXmlWriter.addElement(fp, FeaturePackXmlParser20.Element.TRANSITIVE);
            for (FeaturePackConfig featurePackConfig : fpSpec.getTransitiveDeps()) {
                depElement = FeaturePackXmlWriter.addElement(transitives, FeaturePackXmlParser20.Element.DEPENDENCY);
                ProvisioningXmlWriter.writeFeaturePackConfig(depElement, fpSpec.getUserConfiguredLocation(featurePackConfig.getLocation()), featurePackConfig, fpSpec.originOf(featurePackConfig.getLocation().getProducer()));
            }
        }
        if (fpSpec.hasFeaturePackDeps()) {
            ElementNode deps = FeaturePackXmlWriter.addElement(fp, FeaturePackXmlParser20.Element.DEPENDENCIES);
            for (FeaturePackConfig featurePackConfig : fpSpec.getFeaturePackDeps()) {
                depElement = FeaturePackXmlWriter.addElement(deps, FeaturePackXmlParser20.Element.DEPENDENCY);
                ProvisioningXmlWriter.writeFeaturePackConfig(depElement, fpSpec.getUserConfiguredLocation(featurePackConfig.getLocation()), featurePackConfig, fpSpec.originOf(featurePackConfig.getLocation().getProducer()));
            }
        }
        ProvisioningXmlWriter.writeConfigCustomizations(fp, FeaturePackXmlParser20.Element.FEATURE_PACK.getNamespace(), fpSpec);
        if (fpSpec.hasDefaultPackages()) {
            ElementNode pkgs = FeaturePackXmlWriter.addElement(fp, FeaturePackXmlParser20.Element.DEFAULT_PACKAGES);
            Object[] pkgNames = fpSpec.getDefaultPackageNames().toArray(new String[0]);
            Arrays.sort(pkgNames);
            for (Object name : pkgNames) {
                FeaturePackXmlWriter.addAttribute(FeaturePackXmlWriter.addElement(pkgs, FeaturePackXmlParser20.Element.PACKAGE), FeaturePackXmlParser20.Attribute.NAME, (String)name);
            }
        }
        if (fpSpec.hasPlugins()) {
            ElementNode plugins = FeaturePackXmlWriter.addElement(fp, FeaturePackXmlParser20.Element.PLUGINS);
            for (FeaturePackPlugin featurePackPlugin : fpSpec.getPlugins().values()) {
                ElementNode pluginE = FeaturePackXmlWriter.addElement(plugins, FeaturePackXmlParser20.Element.PLUGIN);
                FeaturePackXmlWriter.addAttribute(pluginE, FeaturePackXmlParser20.Attribute.ID, featurePackPlugin.getId());
                FeaturePackXmlWriter.addAttribute(pluginE, FeaturePackXmlParser20.Attribute.LOCATION, featurePackPlugin.getLocation());
            }
        }
        return fp;
    }
}

