/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.JavaDebugAware;
import com.intellij.debugger.engine.SimplePropertyGetterProvider;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SyntheticTypeComponentProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidType;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerUtils {
    private static final Logger LOG = Logger.getInstance(DebuggerUtils.class);
    private static final Key<Method> TO_STRING_METHOD_KEY = new Key("CachedToStringMethod");
    public static final Set<String> ourPrimitiveTypeNames = ContainerUtil.set((Object[])new String[]{"byte", "short", "int", "long", "float", "double", "boolean", "char"});
    public static final int MAX_DISPLAY_LABEL_LENGTH = 5120;

    public static void cleanupAfterProcessFinish(DebugProcess debugProcess) {
        debugProcess.putUserData(TO_STRING_METHOD_KEY, null);
    }

    @NonNls
    public static String getValueAsString(EvaluationContext evaluationContext, Value value2) throws EvaluateException {
        try {
            if (value2 == null) {
                return "null";
            }
            if (value2 instanceof StringReference) {
                DebuggerUtils.ensureNotInsideObjectConstructor((ObjectReference)value2, evaluationContext);
                return ((StringReference)value2).value();
            }
            if (DebuggerUtils.isInteger(value2)) {
                return String.valueOf(((PrimitiveValue)value2).longValue());
            }
            if (value2 instanceof FloatValue) {
                return String.valueOf(((FloatValue)value2).floatValue());
            }
            if (value2 instanceof DoubleValue) {
                return String.valueOf(((DoubleValue)value2).doubleValue());
            }
            if (value2 instanceof BooleanValue) {
                return String.valueOf(((PrimitiveValue)value2).booleanValue());
            }
            if (value2 instanceof CharValue) {
                return String.valueOf(((PrimitiveValue)value2).charValue());
            }
            if (value2 instanceof ObjectReference) {
                if (value2 instanceof ArrayReference) {
                    StringJoiner joiner = new StringJoiner(",", "[", "]");
                    for (Value element : ((ArrayReference)value2).getValues()) {
                        joiner.add(DebuggerUtils.getValueAsString(evaluationContext, element));
                    }
                    return joiner.toString();
                }
                ObjectReference objRef = (ObjectReference)value2;
                DebugProcess debugProcess = evaluationContext.getDebugProcess();
                Method toStringMethod = (Method)debugProcess.getUserData(TO_STRING_METHOD_KEY);
                if (toStringMethod == null) {
                    try {
                        ReferenceType refType = DebuggerUtils.getObjectClassType(objRef.virtualMachine());
                        toStringMethod = DebuggerUtils.findMethod(refType, "toString", "()Ljava/lang/String;");
                        debugProcess.putUserData(TO_STRING_METHOD_KEY, toStringMethod);
                    }
                    catch (Exception ignored) {
                        throw EvaluateExceptionUtil.createEvaluateException(JavaDebuggerBundle.message("evaluation.error.cannot.evaluate.tostring", objRef.referenceType().name()));
                    }
                }
                if (toStringMethod == null) {
                    throw EvaluateExceptionUtil.createEvaluateException(JavaDebuggerBundle.message("evaluation.error.cannot.evaluate.tostring", objRef.referenceType().name()));
                }
                Method finalToStringMethod = toStringMethod;
                return DebuggerUtils.processCollectibleValue(() -> debugProcess.invokeInstanceMethod(evaluationContext, objRef, finalToStringMethod, Collections.emptyList(), 0), result -> {
                    if (result == null) {
                        return "null";
                    }
                    return result instanceof StringReference ? ((StringReference)result).value() : result.toString();
                });
            }
            throw EvaluateExceptionUtil.createEvaluateException(JavaDebuggerBundle.message("evaluation.error.unsupported.expression.type", new Object[0]));
        }
        catch (ObjectCollectedException ignored) {
            throw EvaluateExceptionUtil.OBJECT_WAS_COLLECTED;
        }
    }

    public static <R, T extends Value> R processCollectibleValue(@NotNull ThrowableComputable<? extends T, ? extends EvaluateException> valueComputable, @NotNull Function<? super T, ? extends R> processor) throws EvaluateException {
        if (valueComputable == null) {
            DebuggerUtils.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            DebuggerUtils.$$$reportNull$$$0(1);
        }
        int retries = 10;
        while (true) {
            Value result = (Value)valueComputable.compute();
            try {
                return processor.apply(result);
            }
            catch (ObjectCollectedException oce) {
                if (--retries >= 0) continue;
                throw oce;
            }
            break;
        }
    }

    public static void ensureNotInsideObjectConstructor(@NotNull ObjectReference reference, @NotNull EvaluationContext context) throws EvaluateException {
        Location location;
        if (reference == null) {
            DebuggerUtils.$$$reportNull$$$0(2);
        }
        if (context == null) {
            DebuggerUtils.$$$reportNull$$$0(3);
        }
        if ((location = DebuggerUtils.getInstance().getLocation(context.getSuspendContext())) != null && location.method().isConstructor() && reference.equals(context.computeThisObject())) {
            throw EvaluateExceptionUtil.createEvaluateException(JavaDebuggerBundle.message("evaluation.error.object.is.being.initialized", new Object[0]));
        }
    }

    protected abstract Location getLocation(SuspendContext var1);

    public static String convertToPresentationString(String str) {
        if (str.length() > 5120) {
            str = DebuggerUtils.translateStringValue(str.substring(0, 5120));
            StringBuilder buf = new StringBuilder();
            buf.append(str);
            if (!str.endsWith("...")) {
                buf.append("...");
            }
            return buf.toString();
        }
        return DebuggerUtils.translateStringValue(str);
    }

    @Nullable
    public static Method findMethod(@NotNull ReferenceType refType, @NonNls String methodName, @Nullable @NonNls String methodSignature) {
        Method method;
        if (refType == null) {
            DebuggerUtils.$$$reportNull$$$0(4);
        }
        if (refType instanceof ArrayType) {
            method = DebuggerUtils.findMethod(DebuggerUtils.getObjectClassType(refType.virtualMachine()), methodName, methodSignature);
            if (method != null) {
                return method;
            }
            if ("clone".equals(methodName) && "()[Ljava/lang/Object;".equals(methodSignature) && (method = DebuggerUtils.findMethod(DebuggerUtils.getObjectClassType(refType.virtualMachine()), "clone", null)) != null) {
                return method;
            }
        }
        method = null;
        if (refType instanceof ClassType) {
            method = DebuggerUtils.concreteMethodByName((ClassType)refType, methodName, methodSignature);
        }
        if (method == null) {
            method = (Method)ContainerUtil.getFirstItem(methodSignature != null ? refType.methodsByName(methodName, methodSignature) : refType.methodsByName(methodName));
        }
        return method;
    }

    @Nullable
    private static Method concreteMethodByName(@NotNull ClassType type, @NotNull String name, @Nullable String signature) {
        ReferenceType t;
        if (type == null) {
            DebuggerUtils.$$$reportNull$$$0(5);
        }
        if (name == null) {
            DebuggerUtils.$$$reportNull$$$0(6);
        }
        Processor signatureChecker = signature != null ? m -> m.signature().equals(signature) : CommonProcessors.alwaysTrue();
        LinkedList<ReferenceType> types = new LinkedList<ReferenceType>();
        while (type != null) {
            for (Method candidate : type.methods()) {
                if (!candidate.name().equals(name) || !signatureChecker.process((Object)candidate)) continue;
                return !candidate.isAbstract() ? candidate : null;
            }
            types.add(type);
            type = type.superclass();
        }
        HashSet<ReferenceType> checkedInterfaces = new HashSet<ReferenceType>();
        while ((t = (ReferenceType)types.poll()) != null) {
            if (t instanceof ClassType) {
                types.addAll(0, ((ClassType)t).interfaces());
                continue;
            }
            if (!(t instanceof InterfaceType) || !checkedInterfaces.add(t)) continue;
            for (Method candidate : t.methods()) {
                if (!candidate.name().equals(name) || !signatureChecker.process((Object)candidate) || candidate.isAbstract()) continue;
                return candidate;
            }
            types.addAll(0, ((InterfaceType)t).superinterfaces());
        }
        return null;
    }

    public static boolean isNumeric(Value value2) {
        return value2 != null && (DebuggerUtils.isInteger(value2) || value2 instanceof FloatValue || value2 instanceof DoubleValue);
    }

    public static boolean isInteger(Value value2) {
        return value2 instanceof ByteValue || value2 instanceof ShortValue || value2 instanceof LongValue || value2 instanceof IntegerValue;
    }

    public static String translateStringValue(String str) {
        int length = str.length();
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)length, (String)str, (StringBuilder)buffer);
        return buffer.toString();
    }

    @Nullable
    protected static ArrayClass getArrayClass(@NotNull String className) {
        int pos;
        if (className == null) {
            DebuggerUtils.$$$reportNull$$$0(7);
        }
        boolean searchBracket = false;
        int dims = 0;
        for (pos = className.lastIndexOf(93); pos >= 0; --pos) {
            char c = className.charAt(pos);
            if (searchBracket) {
                if (c == '[') {
                    ++dims;
                    searchBracket = false;
                    continue;
                }
                if (Character.isWhitespace(c)) continue;
                break;
            }
            if (c == ']') {
                searchBracket = true;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
        }
        if (searchBracket) {
            return null;
        }
        if (dims == 0) {
            return null;
        }
        return new ArrayClass(className.substring(0, pos + 1), dims);
    }

    public static boolean instanceOf(@NotNull String subType, @NotNull String superType, @Nullable Project project) {
        if (subType == null) {
            DebuggerUtils.$$$reportNull$$$0(8);
        }
        if (superType == null) {
            DebuggerUtils.$$$reportNull$$$0(9);
        }
        if (project == null) {
            return subType.equals(superType);
        }
        ArrayClass nodeClass = DebuggerUtils.getArrayClass(subType);
        ArrayClass rendererClass = DebuggerUtils.getArrayClass(superType);
        if (nodeClass == null || rendererClass == null) {
            return false;
        }
        if (nodeClass.dims == rendererClass.dims) {
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            PsiClass psiNodeClass = JavaPsiFacade.getInstance(project).findClass(nodeClass.className, scope);
            PsiClass psiRendererClass = JavaPsiFacade.getInstance(project).findClass(rendererClass.className, scope);
            return InheritanceUtil.isInheritorOrSelf(psiNodeClass, psiRendererClass, true);
        }
        if (nodeClass.dims > rendererClass.dims) {
            return rendererClass.className.equals("java.lang.Object");
        }
        return false;
    }

    public static boolean instanceOf(@Nullable Type subType, @NotNull String superType) {
        if (superType == null) {
            DebuggerUtils.$$$reportNull$$$0(10);
        }
        if (subType == null || subType instanceof VoidType) {
            return false;
        }
        if (subType instanceof PrimitiveType) {
            return superType.equals(subType.name());
        }
        if ("java.lang.Object".equals(superType)) {
            return true;
        }
        return DebuggerUtils.getSuperTypeInt(subType, superType) != null;
    }

    @Nullable
    public static Type getSuperType(@Nullable Type subType, @NotNull String superType) {
        if (superType == null) {
            DebuggerUtils.$$$reportNull$$$0(11);
        }
        if (subType == null || subType instanceof PrimitiveType || subType instanceof VoidType) {
            return null;
        }
        if ("java.lang.Object".equals(superType)) {
            return DebuggerUtils.getObjectClassType(subType.virtualMachine());
        }
        return DebuggerUtils.getSuperTypeInt(subType, superType);
    }

    private static ReferenceType getObjectClassType(VirtualMachine virtualMachine) {
        return (ReferenceType)ContainerUtil.getFirstItem(virtualMachine.classesByName("java.lang.Object"));
    }

    private static boolean typeEquals(@NotNull Type type, @NotNull String typeName) {
        int genericPos;
        if (type == null) {
            DebuggerUtils.$$$reportNull$$$0(12);
        }
        if (typeName == null) {
            DebuggerUtils.$$$reportNull$$$0(13);
        }
        if ((genericPos = typeName.indexOf(60)) > -1) {
            typeName = typeName.substring(0, genericPos);
        }
        return type.name().replace('$', '.').equals(typeName.replace('$', '.'));
    }

    private static Type getSuperTypeInt(@NotNull Type subType, @NotNull String superType) {
        if (subType == null) {
            DebuggerUtils.$$$reportNull$$$0(14);
        }
        if (superType == null) {
            DebuggerUtils.$$$reportNull$$$0(15);
        }
        if (DebuggerUtils.typeEquals(subType, superType)) {
            return subType;
        }
        if (subType instanceof ClassType) {
            try {
                ClassType clsType = (ClassType)subType;
                Type result = DebuggerUtils.getSuperType(clsType.superclass(), superType);
                if (result != null) {
                    return result;
                }
                for (InterfaceType iface : clsType.interfaces()) {
                    result = DebuggerUtils.getSuperType(iface, superType);
                    if (result == null) continue;
                    return result;
                }
            }
            catch (ClassNotPreparedException e) {
                LOG.info((Throwable)e);
            }
            return null;
        }
        if (subType instanceof InterfaceType) {
            try {
                for (InterfaceType iface : ((InterfaceType)subType).superinterfaces()) {
                    Type result = DebuggerUtils.getSuperType(iface, superType);
                    if (result == null) continue;
                    return result;
                }
            }
            catch (ClassNotPreparedException e) {
                LOG.info((Throwable)e);
            }
        } else if (subType instanceof ArrayType && superType.endsWith("[]")) {
            try {
                String superTypeItem = superType.substring(0, superType.length() - 2);
                Type subTypeItem = ((ArrayType)subType).componentType();
                return DebuggerUtils.instanceOf(subTypeItem, superTypeItem) ? subType : null;
            }
            catch (ClassNotLoadedException e) {
                LOG.info((Throwable)e);
            }
        }
        return null;
    }

    protected abstract PsiClass createArrayClass(Project var1, LanguageLevel var2);

    @Nullable
    public static PsiClass findClass(@NotNull String className, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (className == null) {
            DebuggerUtils.$$$reportNull$$$0(16);
        }
        if (project == null) {
            DebuggerUtils.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            DebuggerUtils.$$$reportNull$$$0(18);
        }
        return DebuggerUtils.findClass(className, project, scope, true);
    }

    @Nullable
    public static PsiClass findClass(@NotNull String className, @NotNull Project project, @NotNull GlobalSearchScope scope, boolean fallbackToAllScope) {
        if (className == null) {
            DebuggerUtils.$$$reportNull$$$0(19);
        }
        if (project == null) {
            DebuggerUtils.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            DebuggerUtils.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            GlobalSearchScope globalScope;
            if (DebuggerUtils.getArrayClass(className) != null) {
                return DebuggerUtils.getInstance().createArrayClass(project, LanguageLevelProjectExtension.getInstance(project).getLanguageLevel());
            }
            if (project.isDefault()) {
                return null;
            }
            className = StringUtil.notNullize((String)StringUtil.substringBefore((String)className, (String)"<"), (String)className);
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiClass psiClass = ClassUtil.findPsiClass(psiManager, className, null, true, scope);
            if (psiClass == null && fallbackToAllScope && (globalScope = DebuggerUtils.getInstance().getFallbackAllScope(scope, project)) != null) {
                psiClass = ClassUtil.findPsiClass(psiManager, className, null, true, globalScope);
            }
            return psiClass;
        }
        catch (IndexNotReadyException ignored) {
            return null;
        }
    }

    @Nullable
    protected abstract GlobalSearchScope getFallbackAllScope(@NotNull GlobalSearchScope var1, @NotNull Project var2);

    @Nullable
    public static PsiType getType(@NotNull String className, @NotNull Project project) {
        if (className == null) {
            DebuggerUtils.$$$reportNull$$$0(22);
        }
        if (project == null) {
            DebuggerUtils.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            if (DebuggerUtils.getArrayClass(className) != null) {
                return JavaPsiFacade.getElementFactory(project).createTypeFromText(className, null);
            }
            if (project.isDefault()) {
                return null;
            }
            PsiClass aClass = DebuggerUtils.findClass(className, project, GlobalSearchScope.allScope((Project)project));
            if (aClass != null) {
                return PsiTypesUtil.getClassType(aClass);
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
        return null;
    }

    public static void checkSyntax(PsiCodeFragment codeFragment) throws EvaluateException {
        PsiElement[] children = codeFragment.getChildren();
        if (children.length == 0) {
            throw EvaluateExceptionUtil.createEvaluateException(JavaDebuggerBundle.message("evaluation.error.empty.code.fragment", new Object[0]));
        }
        for (PsiElement child : children) {
            if (!(child instanceof PsiErrorElement)) continue;
            throw EvaluateExceptionUtil.createEvaluateException(JavaDebuggerBundle.message("evaluation.error.invalid.expression", child.getText()));
        }
    }

    public static boolean hasSideEffects(@Nullable PsiElement element) {
        return DebuggerUtils.hasSideEffectsOrReferencesMissingVars(element, null);
    }

    public static boolean hasSideEffectsOrReferencesMissingVars(@Nullable PsiElement element, final @Nullable Set<String> visibleLocalVariables) {
        if (element == null) {
            return false;
        }
        final Ref rv = new Ref((Object)Boolean.FALSE);
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitPostfixExpression(PsiPostfixExpression expression) {
                rv.set((Object)Boolean.TRUE);
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiElement psiElement = expression.resolve();
                if (psiElement instanceof PsiLocalVariable) {
                    if (visibleLocalVariables != null && !visibleLocalVariables.contains(((PsiLocalVariable)psiElement).getName())) {
                        rv.set((Object)Boolean.TRUE);
                    }
                } else if (psiElement instanceof PsiMethod) {
                    rv.set((Object)Boolean.TRUE);
                }
                if (!((Boolean)rv.get()).booleanValue()) {
                    super.visitReferenceExpression(expression);
                }
            }

            @Override
            public void visitPrefixExpression(PsiPrefixExpression expression) {
                IElementType op = expression.getOperationTokenType();
                if (JavaTokenType.PLUSPLUS.equals(op) || JavaTokenType.MINUSMINUS.equals(op)) {
                    rv.set((Object)Boolean.TRUE);
                } else {
                    super.visitPrefixExpression(expression);
                }
            }

            @Override
            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                rv.set((Object)Boolean.TRUE);
            }

            @Override
            public void visitCallExpression(PsiCallExpression callExpression) {
                rv.set((Object)Boolean.TRUE);
            }
        });
        return (Boolean)rv.get();
    }

    public abstract String findAvailableDebugAddress(boolean var1) throws ExecutionException;

    public static boolean isSynthetic(@Nullable TypeComponent typeComponent) {
        if (typeComponent == null) {
            return false;
        }
        return SyntheticTypeComponentProvider.EP_NAME.extensions().noneMatch(provider -> provider.isNotSynthetic(typeComponent)) && SyntheticTypeComponentProvider.EP_NAME.extensions().anyMatch(provider -> provider.isSynthetic(typeComponent));
    }

    public static boolean isInsideSimpleGetter(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            DebuggerUtils.$$$reportNull$$$0(24);
        }
        return SimplePropertyGetterProvider.EP_NAME.extensions().anyMatch(provider -> provider.isInsideSimpleGetter(contextElement));
    }

    public static boolean isPrimitiveType(String typeName) {
        return ourPrimitiveTypeNames.contains(typeName);
    }

    public static DebuggerUtils getInstance() {
        return (DebuggerUtils)ApplicationManager.getApplication().getService(DebuggerUtils.class);
    }

    public abstract PsiExpression substituteThis(PsiExpression var1, PsiExpression var2, Value var3, StackFrameContext var4) throws EvaluateException;

    public abstract DebuggerContext getDebuggerContext(DataContext var1);

    public abstract Element writeTextWithImports(TextWithImports var1);

    public abstract TextWithImports readTextWithImports(Element var1);

    public abstract void writeTextWithImports(Element var1, @NonNls String var2, TextWithImports var3);

    public abstract TextWithImports readTextWithImports(Element var1, @NonNls String var2);

    public abstract TextWithImports createExpressionWithImports(@NonNls String var1);

    public abstract PsiElement getContextElement(StackFrameContext var1);

    public abstract PsiClass chooseClassDialog(String var1, Project var2);

    public static boolean isBreakpointAware(@NotNull PsiFile file) {
        FileType fileType;
        if (file == null) {
            DebuggerUtils.$$$reportNull$$$0(25);
        }
        if ((fileType = file.getFileType()) instanceof LanguageFileType && ((LanguageFileType)fileType).isJVMDebuggingSupported()) {
            return true;
        }
        return JavaDebugAware.EP_NAME.extensions().anyMatch(provider -> provider.isBreakpointAware(file));
    }

    public static boolean isAndroidVM(@NotNull VirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            DebuggerUtils.$$$reportNull$$$0(26);
        }
        return StringUtil.containsIgnoreCase((String)virtualMachine.name(), (String)"dalvik");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueComputable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refType";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subType";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextElement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualMachine";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/DebuggerUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processCollectibleValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureNotInsideObjectConstructor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "concreteMethodByName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getArrayClass";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "instanceOf";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "typeEquals";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuperTypeInt";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "findClass";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideSimpleGetter";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "isBreakpointAware";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "isAndroidVM";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class ArrayClass {
        public String className;
        public int dims;

        public ArrayClass(String className, int dims) {
            this.className = className;
            this.dims = dims;
        }
    }
}

