/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ArrayCopyIndexOutOfBoundsExceptionInfo;
import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayIndexOutOfBoundsExceptionInfo
extends ExceptionInfo {
    private static final Pattern AIOOBE_MESSAGE = Pattern.compile("(?:Index )?(-?\\d{1,9})(?: out of bounds for length \\d+)?");
    @Nullable
    private final Integer myIndex;

    ArrayIndexOutOfBoundsExceptionInfo(int offset, String message) {
        super(offset, "java.lang.ArrayIndexOutOfBoundsException", message);
        Matcher matcher = AIOOBE_MESSAGE.matcher(message);
        this.myIndex = matcher.matches() ? Integer.valueOf(matcher.group(1) == null ? matcher.group(2) : matcher.group(1)) : null;
    }

    @Override
    public ExceptionInfo consumeStackLine(String line) {
        if (line.contains("java.lang.System.arraycopy")) {
            return ArrayCopyIndexOutOfBoundsExceptionInfo.tryCreate(this.getClassNameOffset(), this.getExceptionMessage());
        }
        return super.consumeStackLine(line);
    }

    @Nullable
    public Integer getIndex() {
        return this.myIndex;
    }

    @Override
    PsiElement matchSpecificExceptionElement(@NotNull PsiElement e) {
        Object value2;
        if (e == null) {
            ArrayIndexOutOfBoundsExceptionInfo.$$$reportNull$$$0(0);
        }
        if (!(e instanceof PsiJavaToken && e.textMatches((CharSequence)"[") && e.getParent() instanceof PsiArrayAccessExpression)) {
            return null;
        }
        PsiExpression indexExpression = ((PsiArrayAccessExpression)e.getParent()).getIndexExpression();
        if (indexExpression == null) {
            return null;
        }
        if (this.myIndex != null && (value2 = ConstantExpressionUtil.computeCastTo(indexExpression, (PsiType)PsiType.INT)) != null && !value2.equals(this.myIndex)) {
            return null;
        }
        return indexExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/filters/ArrayIndexOutOfBoundsExceptionInfo", "matchSpecificExceptionElement"));
    }
}

