/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionInfo;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullPointerExceptionInfo
extends ExceptionInfo {
    private static final Pattern NPE_MESSAGE = Pattern.compile("Cannot (?:invoke \"(?<invoke>.+)\\(.*\\)\"|assign field \"(?<putfield>.+)\"|read field \"(?<getfield>.+)\"|store to (?<xastore>[a-z]+) array|load from (?<xaload>[a-z]+) array|read the array (?<arraylength>length)|enter (?<monitor>synchronized) block|throw (?<athrow>exception))(?: because .+)?");
    private static final Map<String, PsiPrimitiveType> UNBOXING_METHODS = Map.of("booleanValue", PsiType.BOOLEAN, "byteValue", PsiType.BYTE, "charValue", PsiType.CHAR, "shortValue", PsiType.SHORT, "intValue", PsiType.INT, "longValue", PsiType.LONG, "floatValue", PsiType.FLOAT, "doubleValue", PsiType.DOUBLE);
    @NotNull
    private final UnaryOperator<PsiElement> myExtractor;

    NullPointerExceptionInfo(int offset, String message) {
        super(offset, "java.lang.NullPointerException", message);
        UnaryOperator<PsiElement> jep358Predicate;
        this.myExtractor = message.isEmpty() ? NullPointerExceptionInfo.getFallbackExtractor() : ((jep358Predicate = NullPointerExceptionInfo.getJep358Extractor(message)) == null ? e -> null : jep358Predicate);
    }

    private static UnaryOperator<PsiElement> getFallbackExtractor() {
        return e -> {
            PsiExpression result = NullPointerExceptionInfo.fromThrow(e);
            if (result != null) {
                return result;
            }
            result = NullPointerExceptionInfo.fromSynchronized(e);
            if (result != null) {
                return result;
            }
            result = NullPointerExceptionInfo.matchCompilerGeneratedNullCheck(e);
            if (result != null) {
                return result;
            }
            result = NullPointerExceptionInfo.fromUnboxing(e, null);
            if (result != null) {
                return result;
            }
            if (e instanceof PsiJavaToken) {
                PsiExpression arrayExpression;
                PsiArrayAccessExpression arrayAccess;
                IElementType tokenType = ((PsiJavaToken)e).getTokenType();
                if (tokenType.equals(JavaTokenType.DOT)) {
                    PsiExpression qualifier;
                    PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)e.getParent(), PsiReferenceExpression.class);
                    if (ref != null && NullPointerExceptionInfo.mayBeNull(qualifier = ref.getQualifierExpression())) {
                        return qualifier;
                    }
                } else if (tokenType.equals(JavaTokenType.LBRACKET) && (arrayAccess = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)e.getParent(), PsiArrayAccessExpression.class)) != null && NullPointerExceptionInfo.mayBeNull(arrayExpression = arrayAccess.getArrayExpression())) {
                    return arrayExpression;
                }
            }
            return null;
        };
    }

    private static PsiExpression fromThrow(PsiElement e) {
        PsiThrowStatement throwStatement;
        if (e instanceof PsiKeyword && ((PsiKeyword)e).getTokenType().equals(JavaTokenType.THROW_KEYWORD) && (throwStatement = (PsiThrowStatement)ObjectUtils.tryCast((Object)e.getParent(), PsiThrowStatement.class)) != null) {
            return throwStatement.getException();
        }
        return null;
    }

    private static PsiExpression fromUnboxing(PsiElement e, @Nullable PsiPrimitiveType type) {
        PsiType expressionType;
        PsiPrimitiveType unboxedType;
        PsiArrayAccessExpression arrayAccess;
        IElementType tokenType;
        PsiReferenceExpression ref;
        PsiExpression boxedExpression = null;
        if (e instanceof PsiIdentifier && (ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)e.getParent(), PsiReferenceExpression.class)) != null) {
            PsiExpression psiExpression = boxedExpression = ref.getParent() instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)ref.getParent() : ref;
        }
        if (e instanceof PsiJavaToken && (tokenType = ((PsiJavaToken)e).getTokenType()).equals(JavaTokenType.RBRACKET) && (arrayAccess = (PsiArrayAccessExpression)ObjectUtils.tryCast((Object)e.getParent(), PsiArrayAccessExpression.class)) != null) {
            boxedExpression = arrayAccess;
        }
        if (boxedExpression != null && (unboxedType = PsiPrimitiveType.getUnboxedType(expressionType = boxedExpression.getType())) != null && (type == null || unboxedType.equals(type))) {
            return boxedExpression;
        }
        return null;
    }

    private static PsiExpression fromSynchronized(PsiElement e) {
        PsiSynchronizedStatement synchronizedStatement;
        if (e instanceof PsiKeyword && ((PsiKeyword)e).getTokenType().equals(JavaTokenType.SYNCHRONIZED_KEYWORD) && (synchronizedStatement = (PsiSynchronizedStatement)ObjectUtils.tryCast((Object)e.getParent(), PsiSynchronizedStatement.class)) != null) {
            return synchronizedStatement.getLockExpression();
        }
        return null;
    }

    private static UnaryOperator<PsiElement> getJep358Extractor(@NonNls String message) {
        int dotPos;
        boolean arrayStore;
        String field;
        if (!message.startsWith("Cannot ")) {
            return null;
        }
        Matcher matcher = NPE_MESSAGE.matcher(message);
        if (!matcher.matches()) {
            return null;
        }
        if (matcher.group("athrow") != null) {
            return NullPointerExceptionInfo::fromThrow;
        }
        if (matcher.group("monitor") != null) {
            return NullPointerExceptionInfo::fromSynchronized;
        }
        if (matcher.group("arraylength") != null) {
            return e -> {
                PsiExpression qualifier = NullPointerExceptionInfo.getFieldReferenceQualifier(e, "length");
                return qualifier != null && qualifier.getType() instanceof PsiArrayType ? qualifier : null;
            };
        }
        String getField = matcher.group("getfield");
        String putField = matcher.group("putfield");
        String string = field = getField == null ? putField : getField;
        if (field != null) {
            return e -> {
                PsiExpression qualifier = NullPointerExceptionInfo.getFieldReferenceQualifier(e, field);
                return qualifier != null && !(qualifier.getType() instanceof PsiArrayType) && NullPointerExceptionInfo.storeMatches(e.getParent(), getField == null) ? qualifier : null;
            };
        }
        boolean arrayLoad = matcher.group("xaload") != null;
        boolean bl = arrayStore = matcher.group("xastore") != null;
        if (arrayLoad || arrayStore) {
            return e -> {
                if (!(e instanceof PsiJavaToken) || !e.textMatches((CharSequence)"[")) {
                    return null;
                }
                PsiElement parent = e.getParent();
                if (!(parent instanceof PsiArrayAccessExpression)) {
                    return null;
                }
                return NullPointerExceptionInfo.storeMatches(parent, arrayStore) ? ((PsiArrayAccessExpression)parent).getArrayExpression() : null;
            };
        }
        String method = matcher.group("invoke");
        if (method != null && (dotPos = method.lastIndexOf(46)) != -1) {
            @NonNls String methodName = method.substring(dotPos + 1);
            PsiPrimitiveType type = UNBOXING_METHODS.get(methodName);
            return e -> {
                PsiExpression result;
                if ((methodName.equals("getClass") || methodName.equals("ordinal")) && (result = NullPointerExceptionInfo.matchCompilerGeneratedNullCheck(e)) != null) {
                    return result;
                }
                if (type != null && (result = NullPointerExceptionInfo.fromUnboxing(e, type)) != null) {
                    return result;
                }
                if (!(e instanceof PsiJavaToken) || !((PsiJavaToken)e).getTokenType().equals(JavaTokenType.DOT)) {
                    return null;
                }
                PsiElement parent = e.getParent();
                if (!(parent instanceof PsiReferenceExpression)) {
                    return null;
                }
                if (!(parent.getParent() instanceof PsiMethodCallExpression)) {
                    return null;
                }
                if (!methodName.equals(((PsiReferenceExpression)parent).getReferenceName())) {
                    return null;
                }
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown(((PsiReferenceExpression)parent).getQualifierExpression());
                return NullPointerExceptionInfo.mayBeNull(qualifier) ? qualifier : null;
            };
        }
        return null;
    }

    @Nullable
    public static PsiExpression matchCompilerGeneratedNullCheck(PsiElement e) {
        PsiNewExpression newExpression;
        PsiExpression dereferenced = null;
        if (e instanceof PsiJavaToken && ((PsiJavaToken)e).getTokenType().equals(JavaTokenType.DOUBLE_COLON)) {
            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)ObjectUtils.tryCast((Object)e.getParent(), PsiMethodReferenceExpression.class);
            if (methodRef != null) {
                dereferenced = methodRef.getQualifierExpression();
            }
        } else if (e instanceof PsiKeyword && e.textMatches((CharSequence)"switch")) {
            PsiClass psiClass;
            PsiExpression selector;
            PsiSwitchBlock switchBlock = (PsiSwitchBlock)ObjectUtils.tryCast((Object)e.getParent(), PsiSwitchBlock.class);
            if (switchBlock != null && (selector = switchBlock.getExpression()) != null && (psiClass = PsiUtil.resolveClassInClassTypeOnly(selector.getType())) != null && (psiClass.isEnum() || "java.lang.String".equals(psiClass.getQualifiedName()))) {
                dereferenced = selector;
            }
        } else if (e instanceof PsiKeyword && e.textMatches((CharSequence)"new") && (newExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)e.getParent(), PsiNewExpression.class)) != null) {
            dereferenced = newExpression.getQualifier();
        }
        return NullPointerExceptionInfo.mayBeNull(dereferenced) ? dereferenced : null;
    }

    private static boolean mayBeNull(PsiExpression qualifier) {
        return qualifier != null && !(qualifier instanceof PsiNewExpression) && !(qualifier instanceof PsiLiteralExpression) && !(qualifier instanceof PsiPolyadicExpression);
    }

    @Nullable
    private static PsiExpression getFieldReferenceQualifier(PsiElement e, String fieldName) {
        if (!(e instanceof PsiJavaToken) || !((PsiJavaToken)e).getTokenType().equals(JavaTokenType.DOT)) {
            return null;
        }
        PsiElement parent = e.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return null;
        }
        if (parent.getParent() instanceof PsiMethodCallExpression) {
            return null;
        }
        PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown(((PsiReferenceExpression)parent).getQualifierExpression());
        if (!NullPointerExceptionInfo.mayBeNull(qualifier)) {
            return null;
        }
        if (!fieldName.equals(((PsiReferenceExpression)parent).getReferenceName())) {
            return null;
        }
        return qualifier;
    }

    private static boolean storeMatches(PsiElement element, boolean mustBeStore) {
        PsiElement parent = element.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            element = parent;
            parent = element.getParent();
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
            boolean isStore = assignment.getOperationTokenType().equals(JavaTokenType.EQ) && assignment.getLExpression() == element;
            return isStore == mustBeStore;
        }
        return !mustBeStore;
    }

    @Override
    PsiElement matchSpecificExceptionElement(@NotNull PsiElement e) {
        if (e == null) {
            NullPointerExceptionInfo.$$$reportNull$$$0(0);
        }
        return (PsiElement)this.myExtractor.apply(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/filters/NullPointerExceptionInfo", "matchSpecificExceptionElement"));
    }
}

