/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThrowableRunnable;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public abstract class JavaProgramPatcher {
    protected static final ExtensionPointName<JavaProgramPatcher> EP_NAME = ExtensionPointName.create((String)"com.intellij.java.programPatcher");

    public abstract void patchJavaParameters(Executor var1, RunProfile var2, JavaParameters var3);

    public static void runCustomPatchers(@NotNull JavaParameters javaParameters, @NotNull Executor executor, @NotNull RunProfile runProfile) {
        if (javaParameters == null) {
            JavaProgramPatcher.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            JavaProgramPatcher.$$$reportNull$$$0(1);
        }
        if (runProfile == null) {
            JavaProgramPatcher.$$$reportNull$$$0(2);
        }
        EP_NAME.forEachExtensionSafe(patcher -> ReadAction.run(() -> patcher.patchJavaParameters(executor, runProfile, javaParameters)));
    }

    public static boolean patchJavaCommandLineParamsUnderProgress(@NotNull Project project, ThrowableRunnable<? extends ExecutionException> patch) throws ExecutionException {
        if (project == null) {
            JavaProgramPatcher.$$$reportNull$$$0(3);
        }
        AtomicReference ex = new AtomicReference();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                patch.run();
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (ExecutionException e) {
                ex.set(e);
            }
        }, ExecutionBundle.message((String)"progress.title.patch.java.command.line.parameters", (Object[])new Object[0]), true, project)) {
            return false;
        }
        if (ex.get() != null) {
            throw (ExecutionException)((Object)ex.get());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runProfile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/runners/JavaProgramPatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runCustomPatchers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "patchJavaCommandLineParamsUnderProgress";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

