/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.elements;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.ElementInitializer;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.ExternalEntityMapping;
import com.intellij.workspaceModel.storage.MutableExternalEntityMapping;
import com.intellij.workspaceModel.storage.VersionedEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageDiffBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.BridgeModelModifiableEntitiesKt;
import com.intellij.workspaceModel.storage.bridgeEntities.CustomPackagingElementEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.PackagingElementEntity;
import com.intellij.workspaceModel.storage.impl.VersionedEntityStorageOnBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PackagingElement<S>
implements PersistentStateComponent<S> {
    private final PackagingElementType myType;
    @Nullable
    protected VersionedEntityStorage myStorage;
    protected Project myProject;
    protected Set<PackagingElement<?>> myElementsWithDiff;
    protected ElementInitializer myPackagingElementInitializer;

    protected PackagingElement(@NotNull PackagingElementType type) {
        if (type == null) {
            PackagingElement.$$$reportNull$$$0(0);
        }
        this.myType = type;
    }

    @NotNull
    public abstract PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext var1);

    @NotNull
    public final PackagingElementType getType() {
        PackagingElementType packagingElementType = this.myType;
        if (packagingElementType == null) {
            PackagingElement.$$$reportNull$$$0(1);
        }
        return packagingElementType;
    }

    public abstract boolean isEqualTo(@NotNull PackagingElement<?> var1);

    @NotNull
    public PackagingElementOutputKind getFilesKind(PackagingElementResolvingContext context) {
        PackagingElementOutputKind packagingElementOutputKind = PackagingElementOutputKind.OTHER;
        if (packagingElementOutputKind == null) {
            PackagingElement.$$$reportNull$$$0(2);
        }
        return packagingElementOutputKind;
    }

    public WorkspaceEntity getOrAddEntity(@NotNull WorkspaceEntityStorageBuilder diff, @NotNull EntitySource source, @NotNull Project project) {
        WorkspaceEntity existingEntity;
        if (diff == null) {
            PackagingElement.$$$reportNull$$$0(3);
        }
        if (source == null) {
            PackagingElement.$$$reportNull$$$0(4);
        }
        if (project == null) {
            PackagingElement.$$$reportNull$$$0(5);
        }
        if ((existingEntity = this.getExistingEntity(diff)) != null) {
            return existingEntity;
        }
        Object state = this.getState();
        String xmlTag = "";
        if (state != null) {
            xmlTag = JDOMUtil.write((Element)XmlSerializer.serialize((Object)state));
        }
        ArrayList children = new ArrayList();
        if (this instanceof CompositePackagingElement) {
            children.addAll(ContainerUtil.map(((CompositePackagingElement)this).getChildren(), o -> (PackagingElementEntity)o.getOrAddEntity(diff, source, project)));
        }
        CustomPackagingElementEntity addedEntity = BridgeModelModifiableEntitiesKt.addCustomPackagingElementEntity((WorkspaceEntityStorageDiffBuilder)diff, (String)this.getType().getId(), (String)xmlTag, children, (EntitySource)source);
        diff.getMutableExternalMapping("intellij.artifacts.packaging.elements").addMapping((WorkspaceEntity)addedEntity, (Object)this);
        return addedEntity;
    }

    @Nullable
    protected WorkspaceEntity getExistingEntity(WorkspaceEntityStorageBuilder diff) {
        ExternalEntityMapping mapping = diff.getExternalMapping("intellij.artifacts.packaging.elements");
        Optional existing = mapping.getEntities((Object)this).stream().findFirst();
        return existing.orElse(null);
    }

    public void setStorage(@NotNull VersionedEntityStorage storage, @NotNull Project project, Set<PackagingElement<?>> elementsWithDiff, @NotNull ElementInitializer initializer) {
        if (storage == null) {
            PackagingElement.$$$reportNull$$$0(6);
        }
        if (project == null) {
            PackagingElement.$$$reportNull$$$0(7);
        }
        if (initializer == null) {
            PackagingElement.$$$reportNull$$$0(8);
        }
        this.myStorage = storage;
        this.myProject = project;
        this.myElementsWithDiff = elementsWithDiff;
        this.myPackagingElementInitializer = initializer;
    }

    public boolean hasStorage() {
        return this.myStorage != null;
    }

    public boolean storageIsStore() {
        return this.myStorage != null && !(this.myStorage instanceof VersionedEntityStorageOnBuilder);
    }

    protected void update(Runnable noStorageChange, BiConsumer<? super WorkspaceEntityStorageBuilder, ? super PackagingElementEntity> changeOnBuilder) {
        this.update(() -> {
            noStorageChange.run();
            return null;
        }, (? super WorkspaceEntityStorageBuilder builder, ? super PackagingElementEntity element) -> {
            changeOnBuilder.accept((WorkspaceEntityStorageBuilder)builder, (PackagingElementEntity)element);
            return null;
        });
    }

    protected <T> T update(Supplier<? extends T> noStorageChange, BiFunction<? super WorkspaceEntityStorageBuilder, ? super PackagingElementEntity, T> changeOnBuilder) {
        if (this.myStorage == null) {
            return noStorageChange.get();
        }
        if (!(this.myStorage instanceof VersionedEntityStorageOnBuilder)) {
            noStorageChange.get();
            throw new RuntimeException();
        }
        noStorageChange.get();
        WorkspaceEntityStorageBuilder builder = ((VersionedEntityStorageOnBuilder)this.myStorage).getBase();
        MutableExternalEntityMapping mapping = builder.getMutableExternalMapping("intellij.artifacts.packaging.elements");
        PackagingElementEntity entity = (PackagingElementEntity)ContainerUtil.getFirstItem((List)mapping.getEntities((Object)this));
        if (entity == null) {
            throw new RuntimeException("Cannot find an entity");
        }
        return changeOnBuilder.apply((WorkspaceEntityStorageBuilder)builder, (PackagingElementEntity)entity);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/elements/PackagingElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diff";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/elements/PackagingElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getOrAddEntity";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setStorage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

