/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.search.searches.AnnotatedPackagesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.MergeQuery;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public final class AnnotationTargetsSearch {
    public static AnnotationTargetsSearch INSTANCE = new AnnotationTargetsSearch();

    private AnnotationTargetsSearch() {
    }

    @NotNull
    public static Query<PsiModifierListOwner> search(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        if (annotationClass == null) {
            AnnotationTargetsSearch.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            AnnotationTargetsSearch.$$$reportNull$$$0(1);
        }
        Query<PsiMember> members = AnnotatedMembersSearch.search(annotationClass, scope);
        Query<PsiPackage> packages = AnnotatedPackagesSearch.search(annotationClass, scope);
        return new MergeQuery(members, packages);
    }

    @NotNull
    public static Query<PsiModifierListOwner> search(@NotNull PsiClass annotationClass) {
        if (annotationClass == null) {
            AnnotationTargetsSearch.$$$reportNull$$$0(2);
        }
        return AnnotationTargetsSearch.search(annotationClass, (SearchScope)GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)annotationClass)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "annotationClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "scope";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/search/searches/AnnotationTargetsSearch";
        objectArray[2] = "search";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Parameters {
        private final PsiClass myAnnotationClass;
        private final SearchScope myScope;

        public Parameters(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
            if (annotationClass == null) {
                Parameters.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                Parameters.$$$reportNull$$$0(1);
            }
            this.myAnnotationClass = annotationClass;
            this.myScope = scope;
        }

        @NotNull
        public PsiClass getAnnotationClass() {
            PsiClass psiClass = this.myAnnotationClass;
            if (psiClass == null) {
                Parameters.$$$reportNull$$$0(2);
            }
            return psiClass;
        }

        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                Parameters.$$$reportNull$$$0(3);
            }
            return searchScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotationClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/searches/AnnotationTargetsSearch$Parameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/searches/AnnotationTargetsSearch$Parameters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotationClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

