/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.jarRepository.RepositoryLibraryDefinition;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.containers.ContainerUtil;
import icons.OpenapiIcons;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class RepositoryLibraryDescription {
    @NotNull
    @NonNls
    public static final String LatestVersionId = "LATEST";
    @NotNull
    @NonNls
    public static final String LatestVersionDisplayName = "Latest";
    @NotNull
    @NonNls
    public static final String ReleaseVersionId = "RELEASE";
    @NotNull
    @NonNls
    public static final String DefaultVersionId = "RELEASE";
    @NotNull
    @NonNls
    public static final String ReleaseVersionDisplayName = "Release";
    @NotNull
    @NonNls
    public static final String SnapshotVersionSuffix = "-SNAPSHOT";
    public static final Icon DEFAULT_ICON = OpenapiIcons.RepositoryLibraryLogo;
    private static volatile Map<String, RepositoryLibraryDescription> ourStaticallyDefinedLibraries;
    private final String groupId;
    private final String artifactId;
    @NlsContexts.DialogTitle
    private final String libraryName;

    protected RepositoryLibraryDescription(String groupId, String artifactId, @NlsContexts.DialogTitle String libraryName) {
        this.groupId = groupId == null ? "" : groupId;
        this.artifactId = artifactId == null ? "" : artifactId;
        this.libraryName = libraryName == null ? CodeInsightBundle.message((String)"unknown.node.text", (Object[])new Object[0]) : libraryName;
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@Nullable String groupId, @Nullable String artifactId) {
        if (ourStaticallyDefinedLibraries == null) {
            HashMap<CallSite, RepositoryLibraryDescription> map = new HashMap<CallSite, RepositoryLibraryDescription>();
            for (RepositoryLibraryDefinition def : (RepositoryLibraryDefinition[])RepositoryLibraryDefinition.EP_NAME.getExtensions()) {
                String id = def.groupId + ":" + def.artifactId;
                map.put((CallSite)((Object)id), new RepositoryLibraryDescription(def.groupId, def.artifactId, def.name));
            }
            ourStaticallyDefinedLibraries = Collections.unmodifiableMap(Collections.synchronizedMap(map));
        }
        @NlsSafe String id = groupId == null && artifactId == null ? CodeInsightBundle.message((String)"unknown.node.text", (Object[])new Object[0]) : groupId + ":" + artifactId;
        RepositoryLibraryDescription description = ourStaticallyDefinedLibraries.get(id);
        return description != null ? description : new RepositoryLibraryDescription(groupId, artifactId, id);
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@NotNull RepositoryLibraryProperties properties) {
        if (properties == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(0);
        }
        return RepositoryLibraryDescription.findDescription(properties.getGroupId(), properties.getArtifactId());
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@NotNull JpsMavenRepositoryLibraryDescriptor descriptor) {
        if (descriptor == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(1);
        }
        return RepositoryLibraryDescription.findDescription(descriptor.getGroupId(), descriptor.getArtifactId());
    }

    @NotNull
    public String getGroupId() {
        String string = this.groupId;
        if (string == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getArtifactId() {
        String string = this.artifactId;
        if (string == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NlsContexts.DialogTitle
    public String getDisplayName() {
        String string = this.libraryName;
        if (string == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = DEFAULT_ICON;
        if (icon == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(5);
        }
        return icon;
    }

    @Nullable
    public DependencyScope getSuggestedScope() {
        return null;
    }

    public int getWeight() {
        return 1000;
    }

    public RepositoryLibraryProperties createDefaultProperties() {
        return new RepositoryLibraryProperties(this.getGroupId(), this.getArtifactId(), "RELEASE", true, ContainerUtil.emptyList());
    }

    @NlsSafe
    public String getDisplayName(String version) {
        if (LatestVersionId.equals(version)) {
            version = LatestVersionDisplayName;
        } else if ("RELEASE".equals(version)) {
            version = ReleaseVersionDisplayName;
        }
        return this.getDisplayName() + (String)(version == null ? "" : ":" + version);
    }

    @NlsSafe
    public String getMavenCoordinates(String version) {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + version;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDescription";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

