/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.edt;

import java.util.concurrent.CountDownLatch;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

abstract class GuiAction
implements Runnable {
    private boolean executedInEDT;
    private Throwable caughtException;
    private CountDownLatch executionNotification;

    GuiAction() {
    }

    @Nullable
    final Throwable catchedException() {
        return this.caughtException;
    }

    final void catchedException(@Nullable Throwable catched) {
        this.caughtException = catched;
    }

    final boolean wasExecutedInEDT() {
        return this.executedInEDT;
    }

    final void clearCaughtException() {
        this.caughtException = null;
    }

    final void executionNotification(@Nonnull CountDownLatch c) {
        this.executionNotification = c;
    }

    final void notifyExecutionCompleted() {
        this.executedInEDT();
        if (this.executionNotification == null) {
            return;
        }
        this.executionNotification.countDown();
        this.executionNotification = null;
    }

    private void executedInEDT() {
        this.executedInEDT = true;
    }
}

