/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.open.GradleProjectImportUtil;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gradle/action/ImportProjectFromScriptAction;", "Lcom/intellij/openapi/externalSystem/action/ExternalSystemAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getDefaultPath", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isEnabled", "", "isVisible", "intellij.gradle.common"})
public final class ImportProjectFromScriptAction
extends ExternalSystemAction {
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isVisible(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) return false;
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"e.getData<VirtualFile>(C\u2026UAL_FILE) ?: return false");
        VirtualFile virtualFile2 = virtualFile;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) return false;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.getData<Project>(Commo\u2026.PROJECT) ?: return false");
        Project project2 = project;
        if (!GradleConstants.KNOWN_GRADLE_FILES.contains(virtualFile2.getName())) return false;
        GradleSettings gradleSettings = GradleSettings.getInstance(project2);
        VirtualFile virtualFile3 = virtualFile2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"virtualFile.parent");
        if (gradleSettings.getLinkedProjectSettings(virtualFile3.getPath()) != null) return false;
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"e.getData<VirtualFile>(C\u2026s.VIRTUAL_FILE) ?: return");
        VirtualFile virtualFile2 = virtualFile;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.getData<Project>(Commo\u2026taKeys.PROJECT) ?: return");
        Project project2 = project;
        String externalProjectPath = this.getDefaultPath(virtualFile2);
        ExternalSystemUtil.confirmLoadingUntrustedProject((Project)project2, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        GradleProjectImportUtil.linkAndRefreshGradleProject(externalProjectPath, project2);
    }

    private final String getDefaultPath(VirtualFile file) {
        String string2;
        if (file.isDirectory()) {
            String string3 = file.getPath();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.path");
        } else {
            VirtualFile virtualFile = file.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.parent");
            String string4 = virtualFile.getPath();
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"file.parent.path");
        }
        return string2;
    }
}

