/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.DuplicateMessageAware;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.build.issue.quickfix.OpenFileQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.initialization.BuildLayoutParameters;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleConsoleFilter;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleSettingsQuickFix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSystemSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JD\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/issue/GradleDaemonStartupIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "()V", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "consumeBuildOutputFailureMessage", "", "message", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "intellij.gradle.common"})
@ApiStatus.Experimental
public final class GradleDaemonStartupIssueChecker
implements GradleIssueChecker {
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Path commonGradleProperties;
        Object gradleUserHomeDir;
        Object object;
        Path projectGradleProperties;
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        Throwable rootCause = (Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first;
        String rootCauseText = rootCause.toString();
        if (!StringsKt.startsWith$default((String)rootCauseText, (String)"org.gradle.api.GradleException: Unable to start the daemon process.", (boolean)false, (int)2, null)) {
            return null;
        }
        StringBuilder quickFixDescription = new StringBuilder();
        ArrayList<Object> quickFixes = new ArrayList<Object>();
        Path path = projectGradleProperties = Paths.get(issueData.getProjectPath(), "gradle.properties");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"projectGradleProperties");
        if (PathKt.isFile((Path)path)) {
            OpenFileQuickFix openFileQuickFix = new OpenFileQuickFix(projectGradleProperties, "org.gradle.jvmargs");
            quickFixDescription.append(" - <a href=\"" + openFileQuickFix.getId() + "\">gradle.properties</a> in project root directory\n");
            quickFixes.add(openFileQuickFix);
        }
        if ((object = issueData.getBuildEnvironment()) == null || (object = object.getGradle()) == null || (object = object.getGradleUserHome()) == null) {
            object = new BuildLayoutParameters().getGradleUserHomeDir();
        }
        Object object2 = gradleUserHomeDir = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"gradleUserHomeDir");
        Path path2 = commonGradleProperties = Paths.get(((File)object2).getPath(), "gradle.properties");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"commonGradleProperties");
        if (PathKt.isFile((Path)path2)) {
            OpenFileQuickFix openFileQuickFix = new OpenFileQuickFix(commonGradleProperties, "org.gradle.jvmargs");
            quickFixDescription.append(" - <a href=\"" + openFileQuickFix.getId() + "\">gradle.properties</a> in GRADLE_USER_HOME directory\n");
            quickFixes.add(openFileQuickFix);
        }
        GradleSystemSettings gradleSystemSettings = GradleSystemSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)gradleSystemSettings, (String)"GradleSystemSettings.getInstance()");
        String gradleVmOptions = gradleSystemSettings.getGradleVmOptions();
        CharSequence charSequence = gradleVmOptions;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && Intrinsics.areEqual((Object)"AndroidStudio", (Object)PlatformUtils.getPlatformPrefix()) ^ true) {
            GradleSettingsQuickFix gradleSettingsFix2 = new GradleSettingsQuickFix(issueData.getProjectPath(), true, new BiPredicate(gradleVmOptions){
                final /* synthetic */ String $gradleVmOptions;

                public final boolean test(@NotNull GradleProjectSettings $noName_0, @NotNull GradleProjectSettings $noName_1) {
                    Intrinsics.checkNotNullParameter((Object)((Object)$noName_0), (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)((Object)$noName_1), (String)"<anonymous parameter 1>");
                    GradleSystemSettings gradleSystemSettings = GradleSystemSettings.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)gradleSystemSettings, (String)"GradleSystemSettings.getInstance()");
                    return Intrinsics.areEqual((Object)this.$gradleVmOptions, (Object)gradleSystemSettings.getGradleVmOptions()) ^ true;
                }
                {
                    this.$gradleVmOptions = string2;
                }
            }, GradleBundle.message("gradle.settings.text.vm.options", new Object[0]));
            quickFixes.add(gradleSettingsFix2);
            quickFixDescription.append(" - <a href=\"" + gradleSettingsFix2.getId() + "\">IDE Gradle VM options</a> \n");
        }
        StringBuilder issueDescription = new StringBuilder(rootCause.getMessage());
        CharSequence charSequence2 = quickFixDescription;
        bl2 = false;
        if (charSequence2.length() > 0) {
            issueDescription.append("\n-----------------------\n");
            issueDescription.append("Check the JVM arguments defined for the gradle process in:\n");
            issueDescription.append((CharSequence)quickFixDescription);
        }
        String string2 = issueDescription.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"issueDescription.toString()");
        String description = string2;
        String string3 = BuildConsoleUtils.getMessageTitle((String)description);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMessageTitle(description)");
        String title = string3;
        return new BuildIssue(title, description, quickFixes){
            @NotNull
            private final String title;
            @NotNull
            private final String description;
            @NotNull
            private final ArrayList<BuildIssueQuickFix> quickFixes;
            final /* synthetic */ String $title;
            final /* synthetic */ String $description;
            final /* synthetic */ ArrayList $quickFixes;

            @NotNull
            public String getTitle() {
                return this.title;
            }

            @NotNull
            public String getDescription() {
                return this.description;
            }

            @NotNull
            public ArrayList<BuildIssueQuickFix> getQuickFixes() {
                return this.quickFixes;
            }

            @Nullable
            public Navigatable getNavigatable(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                return null;
            }
            {
                this.$title = $captured_local_variable$0;
                this.$description = $captured_local_variable$1;
                this.$quickFixes = $captured_local_variable$2;
                this.title = $captured_local_variable$0;
                this.description = $captured_local_variable$1;
                this.quickFixes = $captured_local_variable$2;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        block9: {
            List list2;
            String string2;
            block11: {
                block10: {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
                    Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
                    Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
                    if (location == null) {
                        return false;
                    }
                    if (!Intrinsics.areEqual((Object)failureCause, (Object)"startup failed:")) break block9;
                    string2 = StringKt.nullize$default((String)StringsKt.substringAfter((String)message, (String)"> startup failed:", (String)""), (boolean)false, (int)1, null);
                    if (string2 == null) break block10;
                    String string3 = string2;
                    boolean bl = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    string2 = ((Object)StringsKt.trimStart((CharSequence)string4)).toString();
                    if (string2 != null && (string2 = StringsKt.substringBefore$default((String)string2, (String)"\n", null, (int)2, null)) != null) break block11;
                }
                return false;
            }
            String locationLine = string2;
            StringBuilder stringBuilder = new StringBuilder().append('\'');
            File file = location.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"location.file");
            String string5 = StringKt.nullize$default((String)StringsKt.substringAfter((String)locationLine, (String)stringBuilder.append(file.getPath()).append("': ").append(location.getStartLine() + 1).append(": ").toString(), (String)""), (boolean)false, (int)1, null);
            if (string5 == null || (string5 = StringsKt.substringBeforeLast$default((String)string5, (String)" @ ", null, (int)2, null)) == null) {
                return false;
            }
            String failedStartupReason = string5;
            String locationPart = StringsKt.substringAfterLast$default((String)locationLine, (String)" @ ", null, (int)2, null);
            Pattern pattern = GradleConsoleFilter.LINE_AND_COLUMN_PATTERN;
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"GradleConsoleFilter.LINE_AND_COLUMN_PATTERN");
            Pattern pattern2 = pattern;
            boolean bl = false;
            MatchResult matchResult = new Regex(pattern2).matchEntire((CharSequence)locationPart);
            Object object = matchResult;
            if (object != null && (object = object.getGroupValues()) != null && (object = CollectionsKt.drop((Iterable)((Iterable)object), (int)1)) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string6 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    void var21_24 = it;
                    boolean bl3 = false;
                    Integer n = Integer.parseInt((String)var21_24);
                    collection.add(n);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = CollectionsKt.listOf((Object[])new Integer[]{location.getStartLine() + 1, 0});
            }
            List values = list2;
            int line = ((Number)values.get(0)).intValue() - 1;
            int column = ((Number)values.get(1)).intValue();
            messageConsumer.accept((BuildEvent)new DuplicateMessageAware(parentEventId, failedStartupReason, message, location, line, column, parentEventId, MessageEvent.Kind.ERROR, null, failedStartupReason, message, new FilePosition(location.getFile(), line, column)){
                final /* synthetic */ Object $parentEventId;
                final /* synthetic */ String $failedStartupReason;
                final /* synthetic */ String $message;
                final /* synthetic */ FilePosition $location;
                final /* synthetic */ int $line;
                final /* synthetic */ int $column;
                {
                    this.$parentEventId = $captured_local_variable$0;
                    this.$failedStartupReason = $captured_local_variable$1;
                    this.$message = $captured_local_variable$2;
                    this.$location = $captured_local_variable$3;
                    this.$line = $captured_local_variable$4;
                    this.$column = $captured_local_variable$5;
                    super($super_call_param$6, $super_call_param$7, $super_call_param$8, $super_call_param$9, $super_call_param$10, $super_call_param$11);
                }
            });
            return true;
        }
        return false;
    }
}

