/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.MessageCollectorAdapter$WhenMappings;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/jps/build/MessageCollectorAdapter;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "kotlinTarget", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "(Lorg/jetbrains/jps/incremental/CompileContext;Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;)V", "hasErrors", "", "clear", "", "kind", "Lorg/jetbrains/jps/incremental/messages/BuildMessage$Kind;", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "report", "message", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSourceLocation;", "kotlin.jps-plugin"})
public final class MessageCollectorAdapter
implements MessageCollector {
    private boolean hasErrors;
    private final CompileContext context;
    private final KotlinModuleBuildTarget<?> kotlinTarget;

    public void report(@NotNull CompilerMessageSeverity severity, @Nls @NotNull String message, @Nullable CompilerMessageSourceLocation location) {
        BuildMessage.Kind kind;
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.hasErrors = this.hasErrors || severity.isError();
        String prefix = "";
        if (severity == CompilerMessageSeverity.EXCEPTION) {
            prefix = "[Internal Error] ";
        }
        if ((kind = this.kind(severity)) != null) {
            if (location != null && this.kotlinTarget != null && this.kotlinTarget.isFromIncludedSourceRoot(new File(location.getPath()))) {
                String string = this.kotlinTarget.getModule().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinTarget.module.name");
                String moduleName = string;
                prefix = prefix + '[' + moduleName + "] ";
            }
            CompilerMessageSourceLocation compilerMessageSourceLocation = location;
            CompilerMessageSourceLocation compilerMessageSourceLocation2 = location;
            CompilerMessageSourceLocation compilerMessageSourceLocation3 = location;
            this.context.processMessage((BuildMessage)new CompilerMessage("Kotlin", kind, prefix + message, compilerMessageSourceLocation != null ? compilerMessageSourceLocation.getPath() : null, -1L, -1L, -1L, compilerMessageSourceLocation2 != null ? (long)compilerMessageSourceLocation2.getLine() : -1L, compilerMessageSourceLocation3 != null ? (long)compilerMessageSourceLocation3.getColumn() : -1L));
        } else {
            String path = location != null ? location.getPath() + ':' + location.getLine() + ':' + location.getColumn() + ": " : "";
            KotlinBuilder.Companion.getLOG().debug(path + message);
        }
    }

    public void clear() {
        this.hasErrors = false;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    private final BuildMessage.Kind kind(CompilerMessageSeverity severity) {
        BuildMessage.Kind kind;
        switch (MessageCollectorAdapter$WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1: {
                kind = BuildMessage.Kind.INFO;
                break;
            }
            case 2: 
            case 3: {
                kind = BuildMessage.Kind.ERROR;
                break;
            }
            case 4: 
            case 5: {
                kind = BuildMessage.Kind.WARNING;
                break;
            }
            case 6: {
                kind = null;
                break;
            }
            default: {
                throw (Throwable)new IllegalArgumentException("Unsupported severity: " + severity);
            }
        }
        return kind;
    }

    public MessageCollectorAdapter(@NotNull CompileContext context, @Nullable KotlinModuleBuildTarget<?> kotlinTarget) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.kotlinTarget = kotlinTarget;
    }
}

